/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.HttpTransport;
import com.google.auth.TestUtils;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.CredentialAccessBoundary;
import com.google.auth.oauth2.DownscopedCredentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.GoogleCredentialsTest;
import com.google.auth.oauth2.MockStsTransport;
import com.google.auth.oauth2.OAuth2Utils;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.auth.oauth2.UserCredentials;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DownscopedCredentialsTest {
    private static final String SA_PRIVATE_KEY_PKCS8 = "-----BEGIN PRIVATE KEY-----\nMIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBALX0PQoe1igW12ikv1bN/r9lN749y2ijmbc/mFHPyS3hNTyOCjDvBbXYbDhQJzWVUikh4mvGBA07qTj79Xc3yBDfKP2IeyYQIFe0t0zkd7R9Zdn98Y2rIQC47aAbDfubtkU1U72t4zL11kHvoa0/RuFZjncvlr42X7be7lYh4p3NAgMBAAECgYASk5wDw4Az2ZkmeuN6Fk/y9H+Lcb2pskJIXjrL533vrDWGOC48LrsThMQPv8cxBky8HFSEklPpkfTF95tpD43iVwJRB/GrCtGTw65IfJ4/tI09h6zGc4yqvIo1cHX/LQ+SxKLGyir/dQM925rGt/VojxY5ryJR7GLbCzxPnJm/oQJBANwOCO6D2hy1LQYJhXh7O+RLtA/tSnT1xyMQsGT+uUCMiKS2bSKx2wxo9k7h3OegNJIu1q6nZ6AbxDK8H3+d0dUCQQDTrPSXagBxzp8PecbaCHjzNRSQE2in81qYnrAFNB4o3DpHyMMY6s5ALLeHKscEWnqP8Ur6X4PvzZecCWU9BKAZAkAutLPknAuxSCsUOvUfS1i87ex77Ot+w6POp34pEX+UWb+u5iFn2cQacDTHLV1LtE80L8jVLSbrbrlH43H0DjU5AkEAgidhycxS86dxpEljnOMCw8CKoUBd5I880IUahEiUltk7OLJYS/Ts1wbn3kPOVX3wyJs8WBDtBkFrDHW2ezth2QJADj3e1YhMVdjJW5jqwlD/VNddGjgzyunmiZg0uOXsHXbytYmsA545S8KRQFaJKFXYYFo2kOjqOiC1T2cAzMDjCQ==\n-----END PRIVATE KEY-----\n";
    private static final CredentialAccessBoundary CREDENTIAL_ACCESS_BOUNDARY = CredentialAccessBoundary.newBuilder().addRule(CredentialAccessBoundary.AccessBoundaryRule.newBuilder().setAvailableResource("//storage.googleapis.com/projects/_/buckets/bucket").addAvailablePermission("inRole:roles/storage.objectViewer").build()).build();

    @Test
    public void refreshAccessToken() throws IOException {
        MockStsTransportFactory transportFactory = new MockStsTransportFactory();
        GoogleCredentials sourceCredentials = DownscopedCredentialsTest.getServiceAccountSourceCredentials(true);
        DownscopedCredentials downscopedCredentials = DownscopedCredentials.newBuilder().setSourceCredential(sourceCredentials).setCredentialAccessBoundary(CREDENTIAL_ACCESS_BOUNDARY).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        AccessToken accessToken = downscopedCredentials.refreshAccessToken();
        Assert.assertEquals((Object)transportFactory.transport.getAccessToken(), (Object)accessToken.getTokenValue());
        Map<String, String> query = TestUtils.parseQuery(transportFactory.transport.getRequest().getContentAsString());
        Assert.assertNotNull((Object)query.get("options"));
        Assert.assertEquals((Object)CREDENTIAL_ACCESS_BOUNDARY.toJson(), (Object)query.get("options"));
        Assert.assertEquals((Object)"urn:ietf:params:oauth:token-type:access_token", (Object)query.get("requested_token_type"));
    }

    @Test
    public void refreshAccessToken_userCredentials_expectExpiresInCopied() throws IOException {
        MockStsTransportFactory transportFactory = new MockStsTransportFactory();
        transportFactory.transport.setReturnExpiresIn(false);
        GoogleCredentials sourceCredentials = DownscopedCredentialsTest.getUserSourceCredentials();
        DownscopedCredentials downscopedCredentials = DownscopedCredentials.newBuilder().setSourceCredential(sourceCredentials).setCredentialAccessBoundary(CREDENTIAL_ACCESS_BOUNDARY).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        AccessToken accessToken = downscopedCredentials.refreshAccessToken();
        Assert.assertEquals((Object)transportFactory.transport.getAccessToken(), (Object)accessToken.getTokenValue());
        Assert.assertEquals((Object)sourceCredentials.getAccessToken().getExpirationTime(), (Object)accessToken.getExpirationTime());
    }

    @Test
    public void refreshAccessToken_cantRefreshSourceCredentials_throws() throws IOException {
        MockStsTransportFactory transportFactory = new MockStsTransportFactory();
        GoogleCredentials sourceCredentials = DownscopedCredentialsTest.getServiceAccountSourceCredentials(false);
        DownscopedCredentials downscopedCredentials = DownscopedCredentials.newBuilder().setSourceCredential(sourceCredentials).setCredentialAccessBoundary(CREDENTIAL_ACCESS_BOUNDARY).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        try {
            downscopedCredentials.refreshAccessToken();
            Assert.fail((String)"Should fail as the source credential should not be able to be refreshed.");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"Unable to refresh the provided source credential.", (Object)e.getMessage());
        }
    }

    @Test
    public void builder_noSourceCredential_throws() {
        try {
            DownscopedCredentials.newBuilder().setHttpTransportFactory(OAuth2Utils.HTTP_TRANSPORT_FACTORY).setCredentialAccessBoundary(CREDENTIAL_ACCESS_BOUNDARY).build();
            Assert.fail((String)"Should fail as the source credential is null.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void builder_noCredentialAccessBoundary_throws() throws IOException {
        try {
            DownscopedCredentials.newBuilder().setHttpTransportFactory(OAuth2Utils.HTTP_TRANSPORT_FACTORY).setSourceCredential(DownscopedCredentialsTest.getServiceAccountSourceCredentials(true)).build();
            Assert.fail((String)"Should fail as no access boundary was provided.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void builder_noTransport_defaults() throws IOException {
        GoogleCredentials sourceCredentials = DownscopedCredentialsTest.getServiceAccountSourceCredentials(true);
        DownscopedCredentials credentials = DownscopedCredentials.newBuilder().setSourceCredential(sourceCredentials).setCredentialAccessBoundary(CREDENTIAL_ACCESS_BOUNDARY).build();
        GoogleCredentials scopedSourceCredentials = sourceCredentials.createScoped(new String[]{"https://www.googleapis.com/auth/cloud-platform"});
        Assert.assertEquals((Object)scopedSourceCredentials, (Object)credentials.getSourceCredentials());
        Assert.assertEquals((Object)CREDENTIAL_ACCESS_BOUNDARY, (Object)credentials.getCredentialAccessBoundary());
        Assert.assertEquals((Object)OAuth2Utils.HTTP_TRANSPORT_FACTORY, (Object)credentials.getTransportFactory());
    }

    private static GoogleCredentials getServiceAccountSourceCredentials(boolean canRefresh) throws IOException {
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        String email = "service-account@google.com";
        ServiceAccountCredentials sourceCredentials = ServiceAccountCredentials.newBuilder().setClientEmail(email).setPrivateKey(ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8)).setPrivateKeyId("privateKeyId").setProjectId("projectId").setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        transportFactory.transport.addServiceAccount(email, "accessToken");
        if (!canRefresh) {
            transportFactory.transport.setError(new IOException());
        }
        return sourceCredentials.createScoped(new String[]{"https://www.googleapis.com/auth/cloud-platform"});
    }

    private static GoogleCredentials getUserSourceCredentials() {
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient("clientId", "clientSecret");
        transportFactory.transport.addRefreshToken("refreshToken", "accessToken");
        AccessToken accessToken = new AccessToken("accessToken", new Date());
        return UserCredentials.newBuilder().setClientId("clientId").setClientSecret("clientSecret").setRefreshToken("refreshToken").setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
    }

    static class MockStsTransportFactory
    implements HttpTransportFactory {
        MockStsTransport transport = new MockStsTransport();

        MockStsTransportFactory() {
        }

        public HttpTransport create() {
            return this.transport;
        }
    }
}

