/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.json.GenericJson;
import com.google.auth.oauth2.ExecutableResponse;
import com.google.auth.oauth2.OAuth2Utils;
import com.google.auth.oauth2.PluggableAuthException;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.Instant;
import org.junit.Assert;
import org.junit.Test;

public class ExecutableResponseTest {
    private static final String TOKEN_TYPE_OIDC = "urn:ietf:params:oauth:token-type:id_token";
    private static final String TOKEN_TYPE_SAML = "urn:ietf:params:oauth:token-type:saml2";
    private static final String ID_TOKEN = "header.payload.signature";
    private static final String SAML_RESPONSE = "samlResponse";
    private static final int EXECUTABLE_SUPPORTED_MAX_VERSION = 1;
    private static final int EXPIRATION_DURATION = 3600;

    @Test
    public void constructor_successOidcResponse() throws IOException {
        ExecutableResponse response = new ExecutableResponse(ExecutableResponseTest.buildOidcResponse());
        Assert.assertTrue((boolean)response.isSuccessful());
        Assert.assertTrue((boolean)response.isValid());
        Assert.assertEquals((long)1L, (long)response.getVersion());
        Assert.assertEquals((Object)TOKEN_TYPE_OIDC, (Object)response.getTokenType());
        Assert.assertEquals((Object)ID_TOKEN, (Object)response.getSubjectToken());
        Assert.assertTrue((Instant.now().getEpochSecond() + 3600L == response.getExpirationTime() ? 1 : 0) != 0);
    }

    @Test
    public void constructor_successOidcResponseMissingExpirationTimeField_notExpired() throws IOException {
        GenericJson jsonResponse = ExecutableResponseTest.buildOidcResponse();
        jsonResponse.remove((Object)"expiration_time");
        ExecutableResponse response = new ExecutableResponse(jsonResponse);
        Assert.assertTrue((boolean)response.isSuccessful());
        Assert.assertTrue((boolean)response.isValid());
        Assert.assertFalse((boolean)response.isExpired());
        Assert.assertEquals((long)1L, (long)response.getVersion());
        Assert.assertEquals((Object)TOKEN_TYPE_OIDC, (Object)response.getTokenType());
        Assert.assertEquals((Object)ID_TOKEN, (Object)response.getSubjectToken());
        Assert.assertNull((Object)response.getExpirationTime());
    }

    @Test
    public void constructor_successSamlResponse() throws IOException {
        ExecutableResponse response = new ExecutableResponse(ExecutableResponseTest.buildSamlResponse());
        Assert.assertTrue((boolean)response.isSuccessful());
        Assert.assertTrue((boolean)response.isValid());
        Assert.assertEquals((long)1L, (long)response.getVersion());
        Assert.assertEquals((Object)TOKEN_TYPE_SAML, (Object)response.getTokenType());
        Assert.assertEquals((Object)SAML_RESPONSE, (Object)response.getSubjectToken());
        Assert.assertTrue((Instant.now().getEpochSecond() + 3600L == response.getExpirationTime() ? 1 : 0) != 0);
    }

    @Test
    public void constructor_successSamlResponseMissingExpirationTimeField_notExpired() throws IOException {
        GenericJson jsonResponse = ExecutableResponseTest.buildSamlResponse();
        jsonResponse.remove((Object)"expiration_time");
        ExecutableResponse response = new ExecutableResponse(jsonResponse);
        Assert.assertTrue((boolean)response.isSuccessful());
        Assert.assertTrue((boolean)response.isValid());
        Assert.assertFalse((boolean)response.isExpired());
        Assert.assertEquals((long)1L, (long)response.getVersion());
        Assert.assertEquals((Object)TOKEN_TYPE_SAML, (Object)response.getTokenType());
        Assert.assertEquals((Object)SAML_RESPONSE, (Object)response.getSubjectToken());
        Assert.assertNull((Object)response.getExpirationTime());
    }

    @Test
    public void constructor_validErrorResponse() throws IOException {
        ExecutableResponse response = new ExecutableResponse(ExecutableResponseTest.buildErrorResponse());
        Assert.assertFalse((boolean)response.isSuccessful());
        Assert.assertFalse((boolean)response.isValid());
        Assert.assertFalse((boolean)response.isExpired());
        Assert.assertNull((Object)response.getSubjectToken());
        Assert.assertNull((Object)response.getTokenType());
        Assert.assertNull((Object)response.getExpirationTime());
        Assert.assertEquals((long)1L, (long)response.getVersion());
        Assert.assertEquals((Object)"401", (Object)response.getErrorCode());
        Assert.assertEquals((Object)"Caller not authorized.", (Object)response.getErrorMessage());
    }

    @Test
    public void constructor_errorResponseMissingCode_throws() throws IOException {
        Object[] values;
        GenericJson jsonResponse = ExecutableResponseTest.buildErrorResponse();
        for (Object value : values = new Object[]{null, ""}) {
            jsonResponse.put("code", value);
            try {
                new ExecutableResponse(jsonResponse);
                Assert.fail((String)"Should not be able to continue without exception.");
            }
            catch (PluggableAuthException exception) {
                Assert.assertEquals((Object)"Error code INVALID_EXECUTABLE_RESPONSE: The executable response must contain `error` and `message` fields when unsuccessful.", (Object)exception.getMessage());
            }
        }
    }

    @Test
    public void constructor_errorResponseMissingMessage_throws() throws IOException {
        Object[] values;
        GenericJson jsonResponse = ExecutableResponseTest.buildErrorResponse();
        for (Object value : values = new Object[]{null, ""}) {
            jsonResponse.put("message", value);
            try {
                new ExecutableResponse(jsonResponse);
                Assert.fail((String)"Should not be able to continue without exception.");
            }
            catch (PluggableAuthException exception) {
                Assert.assertEquals((Object)"Error code INVALID_EXECUTABLE_RESPONSE: The executable response must contain `error` and `message` fields when unsuccessful.", (Object)exception.getMessage());
            }
        }
    }

    @Test
    public void constructor_successResponseMissingVersionField_throws() throws IOException {
        GenericJson jsonResponse = ExecutableResponseTest.buildOidcResponse();
        jsonResponse.remove((Object)"version");
        try {
            new ExecutableResponse(jsonResponse);
            Assert.fail((String)"Should not be able to continue without exception.");
        }
        catch (PluggableAuthException exception) {
            Assert.assertEquals((Object)"Error code INVALID_EXECUTABLE_RESPONSE: The executable response is missing the `version` field.", (Object)exception.getMessage());
        }
    }

    @Test
    public void constructor_successResponseMissingSuccessField_throws() throws Exception {
        GenericJson jsonResponse = ExecutableResponseTest.buildOidcResponse();
        jsonResponse.remove((Object)"success");
        try {
            new ExecutableResponse(jsonResponse);
            Assert.fail((String)"Should not be able to continue without exception.");
        }
        catch (PluggableAuthException exception) {
            Assert.assertEquals((Object)"Error code INVALID_EXECUTABLE_RESPONSE: The executable response is missing the `success` field.", (Object)exception.getMessage());
        }
    }

    @Test
    public void constructor_successResponseMissingTokenTypeField_throws() throws IOException {
        GenericJson jsonResponse = ExecutableResponseTest.buildOidcResponse();
        jsonResponse.remove((Object)"token_type");
        try {
            new ExecutableResponse(jsonResponse);
            Assert.fail((String)"Should not be able to continue without exception.");
        }
        catch (PluggableAuthException exception) {
            Assert.assertEquals((Object)"Error code INVALID_EXECUTABLE_RESPONSE: The executable response is missing the `token_type` field.", (Object)exception.getMessage());
        }
    }

    @Test
    public void constructor_samlResponseMissingSubjectToken_throws() throws IOException {
        Object[] values;
        GenericJson jsonResponse = ExecutableResponseTest.buildSamlResponse();
        for (Object value : values = new Object[]{null, ""}) {
            jsonResponse.put("saml_response", value);
            try {
                new ExecutableResponse(jsonResponse);
                Assert.fail((String)"Should not be able to continue without exception.");
            }
            catch (PluggableAuthException exception) {
                Assert.assertEquals((Object)"Error code INVALID_EXECUTABLE_RESPONSE: The executable response does not contain a valid token.", (Object)exception.getMessage());
            }
        }
    }

    @Test
    public void constructor_oidcResponseMissingSubjectToken_throws() throws IOException {
        Object[] values;
        GenericJson jsonResponse = ExecutableResponseTest.buildOidcResponse();
        for (Object value : values = new Object[]{null, ""}) {
            jsonResponse.put("id_token", value);
            try {
                new ExecutableResponse(jsonResponse);
                Assert.fail((String)"Should not be able to continue without exception.");
            }
            catch (PluggableAuthException exception) {
                Assert.assertEquals((Object)"Error code INVALID_EXECUTABLE_RESPONSE: The executable response does not contain a valid token.", (Object)exception.getMessage());
            }
        }
    }

    @Test
    public void isExpired() throws IOException {
        GenericJson jsonResponse = ExecutableResponseTest.buildOidcResponse();
        BigDecimal[] values = new BigDecimal[]{BigDecimal.valueOf(Instant.now().getEpochSecond() - 1000L), BigDecimal.valueOf(Instant.now().getEpochSecond() + 1000L)};
        boolean[] expectedResults = new boolean[]{true, false};
        for (int i = 0; i < values.length; ++i) {
            jsonResponse.put("expiration_time", (Object)values[i]);
            ExecutableResponse response = new ExecutableResponse(jsonResponse);
            Assert.assertEquals((Object)expectedResults[i], (Object)response.isExpired());
        }
    }

    private static GenericJson buildOidcResponse() {
        GenericJson json = new GenericJson();
        json.setFactory(OAuth2Utils.JSON_FACTORY);
        json.put("version", (Object)1);
        json.put("success", (Object)true);
        json.put("token_type", (Object)TOKEN_TYPE_OIDC);
        json.put("id_token", (Object)ID_TOKEN);
        json.put("expiration_time", (Object)(Instant.now().getEpochSecond() + 3600L));
        return json;
    }

    private static GenericJson buildSamlResponse() {
        GenericJson json = new GenericJson();
        json.setFactory(OAuth2Utils.JSON_FACTORY);
        json.put("version", (Object)1);
        json.put("success", (Object)true);
        json.put("token_type", (Object)TOKEN_TYPE_SAML);
        json.put("saml_response", (Object)SAML_RESPONSE);
        json.put("expiration_time", (Object)(Instant.now().getEpochSecond() + 3600L));
        return json;
    }

    private static GenericJson buildErrorResponse() {
        GenericJson json = new GenericJson();
        json.setFactory(OAuth2Utils.JSON_FACTORY);
        json.put("version", (Object)1);
        json.put("success", (Object)false);
        json.put("code", (Object)"401");
        json.put("message", (Object)"Caller not authorized.");
        return json;
    }
}

