/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.GenericJson;
import com.google.auth.TestUtils;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.AwsCredentials;
import com.google.auth.oauth2.CredentialFormatException;
import com.google.auth.oauth2.ExternalAccountCredentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.IdentityPoolCredentials;
import com.google.auth.oauth2.IdentityPoolCredentialsTest;
import com.google.auth.oauth2.ImpersonatedCredentials;
import com.google.auth.oauth2.MockExternalAccountCredentialsTransport;
import com.google.auth.oauth2.OAuth2Utils;
import com.google.auth.oauth2.OAuthException;
import com.google.auth.oauth2.PluggableAuthCredentials;
import com.google.auth.oauth2.StsTokenExchangeRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ExternalAccountCredentialsTest {
    private static final String STS_URL = "https://sts.googleapis.com";
    private static final Map<String, Object> FILE_CREDENTIAL_SOURCE_MAP = new HashMap<String, Object>(){
        {
            this.put("file", "file");
        }
    };
    private MockExternalAccountCredentialsTransportFactory transportFactory;

    @Before
    public void setup() {
        this.transportFactory = new MockExternalAccountCredentialsTransportFactory();
    }

    @Test
    public void fromStream_identityPoolCredentials() throws IOException {
        GenericJson json = this.buildJsonIdentityPoolCredential();
        ExternalAccountCredentials credential = ExternalAccountCredentials.fromStream((InputStream)TestUtils.jsonToInputStream(json));
        Assert.assertTrue((boolean)(credential instanceof IdentityPoolCredentials));
    }

    @Test
    public void fromStream_awsCredentials() throws IOException {
        GenericJson json = this.buildJsonAwsCredential();
        ExternalAccountCredentials credential = ExternalAccountCredentials.fromStream((InputStream)TestUtils.jsonToInputStream(json));
        Assert.assertTrue((boolean)(credential instanceof AwsCredentials));
    }

    @Test
    public void fromStream_pluggableAuthCredentials() throws IOException {
        GenericJson json = this.buildJsonPluggableAuthCredential();
        ExternalAccountCredentials credential = ExternalAccountCredentials.fromStream((InputStream)TestUtils.jsonToInputStream(json));
        Assert.assertTrue((boolean)(credential instanceof PluggableAuthCredentials));
    }

    @Test
    public void fromStream_invalidStream_throws() throws IOException {
        GenericJson json = this.buildJsonAwsCredential();
        json.put("audience", new HashMap());
        try {
            ExternalAccountCredentials.fromStream((InputStream)TestUtils.jsonToInputStream(json));
            Assert.fail((String)"Should fail.");
        }
        catch (CredentialFormatException e) {
            Assert.assertEquals((Object)"An invalid input stream was provided.", (Object)e.getMessage());
        }
    }

    @Test
    public void fromStream_nullTransport_throws() throws IOException {
        try {
            ExternalAccountCredentials.fromStream((InputStream)new ByteArrayInputStream("foo".getBytes()), null);
            Assert.fail((String)"NullPointerException should be thrown.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void fromStream_nullStream_throws() throws IOException {
        try {
            ExternalAccountCredentials.fromStream(null, (HttpTransportFactory)OAuth2Utils.HTTP_TRANSPORT_FACTORY);
            Assert.fail((String)"NullPointerException should be thrown.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void fromStream_invalidWorkloadAudience_throws() throws IOException {
        try {
            GenericJson json = this.buildJsonIdentityPoolWorkforceCredential();
            json.put("audience", (Object)"invalidAudience");
            ExternalAccountCredentials credential = ExternalAccountCredentials.fromStream((InputStream)TestUtils.jsonToInputStream(json));
            Assert.fail((String)"CredentialFormatException should be thrown.");
        }
        catch (CredentialFormatException e) {
            Assert.assertEquals((Object)"An invalid input stream was provided.", (Object)e.getMessage());
        }
    }

    @Test
    public void fromJson_identityPoolCredentialsWorkload() {
        ExternalAccountCredentials credential = ExternalAccountCredentials.fromJson((Map)this.buildJsonIdentityPoolCredential(), (HttpTransportFactory)OAuth2Utils.HTTP_TRANSPORT_FACTORY);
        Assert.assertTrue((boolean)(credential instanceof IdentityPoolCredentials));
        Assert.assertEquals((Object)"//iam.googleapis.com/projects/123/locations/global/workloadIdentityPools/pool/providers/provider", (Object)credential.getAudience());
        Assert.assertEquals((Object)"subjectTokenType", (Object)credential.getSubjectTokenType());
        Assert.assertEquals((Object)STS_URL, (Object)credential.getTokenUrl());
        Assert.assertEquals((Object)"tokenInfoUrl", (Object)credential.getTokenInfoUrl());
        Assert.assertNotNull((Object)credential.getCredentialSource());
    }

    @Test
    public void fromJson_identityPoolCredentialsWorkforce() {
        ExternalAccountCredentials credential = ExternalAccountCredentials.fromJson((Map)this.buildJsonIdentityPoolWorkforceCredential(), (HttpTransportFactory)OAuth2Utils.HTTP_TRANSPORT_FACTORY);
        Assert.assertTrue((boolean)(credential instanceof IdentityPoolCredentials));
        Assert.assertEquals((Object)"//iam.googleapis.com/locations/global/workforcePools/pool/providers/provider", (Object)credential.getAudience());
        Assert.assertEquals((Object)"subjectTokenType", (Object)credential.getSubjectTokenType());
        Assert.assertEquals((Object)STS_URL, (Object)credential.getTokenUrl());
        Assert.assertEquals((Object)"tokenInfoUrl", (Object)credential.getTokenInfoUrl());
        Assert.assertEquals((Object)"userProject", (Object)credential.getWorkforcePoolUserProject());
        Assert.assertNotNull((Object)credential.getCredentialSource());
    }

    @Test
    public void fromJson_identityPoolCredentialsWithServiceAccountImpersonationOptions() {
        GenericJson identityPoolCredentialJson = this.buildJsonIdentityPoolCredential();
        identityPoolCredentialJson.set("service_account_impersonation", ExternalAccountCredentialsTest.buildServiceAccountImpersonationOptions(2800));
        ExternalAccountCredentials credential = ExternalAccountCredentials.fromJson((Map)identityPoolCredentialJson, (HttpTransportFactory)OAuth2Utils.HTTP_TRANSPORT_FACTORY);
        Assert.assertTrue((boolean)(credential instanceof IdentityPoolCredentials));
        Assert.assertEquals((Object)"//iam.googleapis.com/projects/123/locations/global/workloadIdentityPools/pool/providers/provider", (Object)credential.getAudience());
        Assert.assertEquals((Object)"subjectTokenType", (Object)credential.getSubjectTokenType());
        Assert.assertEquals((Object)STS_URL, (Object)credential.getTokenUrl());
        Assert.assertEquals((Object)"tokenInfoUrl", (Object)credential.getTokenInfoUrl());
        Assert.assertNotNull((Object)credential.getCredentialSource());
        Assert.assertEquals((long)2800L, (long)credential.getServiceAccountImpersonationOptions().getLifetime());
    }

    @Test
    public void fromJson_awsCredentials() throws IOException {
        ExternalAccountCredentials credential = ExternalAccountCredentials.fromJson((Map)this.buildJsonAwsCredential(), (HttpTransportFactory)OAuth2Utils.HTTP_TRANSPORT_FACTORY);
        Assert.assertTrue((boolean)(credential instanceof AwsCredentials));
        Assert.assertEquals((Object)"audience", (Object)credential.getAudience());
        Assert.assertEquals((Object)"subjectTokenType", (Object)credential.getSubjectTokenType());
        Assert.assertEquals((Object)STS_URL, (Object)credential.getTokenUrl());
        Assert.assertEquals((Object)"tokenInfoUrl", (Object)credential.getTokenInfoUrl());
        Assert.assertNotNull((Object)credential.getCredentialSource());
    }

    @Test
    public void fromJson_awsCredentialsWithServiceAccountImpersonationOptions() throws IOException {
        GenericJson awsCredentialJson = this.buildJsonAwsCredential();
        awsCredentialJson.set("service_account_impersonation", ExternalAccountCredentialsTest.buildServiceAccountImpersonationOptions(2800));
        ExternalAccountCredentials credential = ExternalAccountCredentials.fromJson((Map)awsCredentialJson, (HttpTransportFactory)OAuth2Utils.HTTP_TRANSPORT_FACTORY);
        Assert.assertTrue((boolean)(credential instanceof AwsCredentials));
        Assert.assertEquals((Object)"audience", (Object)credential.getAudience());
        Assert.assertEquals((Object)"subjectTokenType", (Object)credential.getSubjectTokenType());
        Assert.assertEquals((Object)STS_URL, (Object)credential.getTokenUrl());
        Assert.assertEquals((Object)"tokenInfoUrl", (Object)credential.getTokenInfoUrl());
        Assert.assertNotNull((Object)credential.getCredentialSource());
        Assert.assertEquals((long)2800L, (long)credential.getServiceAccountImpersonationOptions().getLifetime());
    }

    @Test
    public void fromJson_pluggableAuthCredentials() {
        ExternalAccountCredentials credential = ExternalAccountCredentials.fromJson((Map)this.buildJsonPluggableAuthCredential(), (HttpTransportFactory)OAuth2Utils.HTTP_TRANSPORT_FACTORY);
        Assert.assertTrue((boolean)(credential instanceof PluggableAuthCredentials));
        Assert.assertEquals((Object)"audience", (Object)credential.getAudience());
        Assert.assertEquals((Object)"subjectTokenType", (Object)credential.getSubjectTokenType());
        Assert.assertEquals((Object)STS_URL, (Object)credential.getTokenUrl());
        Assert.assertEquals((Object)"tokenInfoUrl", (Object)credential.getTokenInfoUrl());
        Assert.assertNotNull((Object)credential.getCredentialSource());
        PluggableAuthCredentials.PluggableAuthCredentialSource source = (PluggableAuthCredentials.PluggableAuthCredentialSource)credential.getCredentialSource();
        Assert.assertEquals((Object)"command", (Object)source.getCommand());
        Assert.assertEquals((long)30000L, (long)source.getTimeoutMs());
        Assert.assertNull((Object)source.getOutputFilePath());
    }

    @Test
    public void fromJson_pluggableAuthCredentialsWorkforce() {
        ExternalAccountCredentials credential = ExternalAccountCredentials.fromJson((Map)this.buildJsonPluggableAuthWorkforceCredential(), (HttpTransportFactory)OAuth2Utils.HTTP_TRANSPORT_FACTORY);
        Assert.assertTrue((boolean)(credential instanceof PluggableAuthCredentials));
        Assert.assertEquals((Object)"//iam.googleapis.com/locations/global/workforcePools/pool/providers/provider", (Object)credential.getAudience());
        Assert.assertEquals((Object)"subjectTokenType", (Object)credential.getSubjectTokenType());
        Assert.assertEquals((Object)STS_URL, (Object)credential.getTokenUrl());
        Assert.assertEquals((Object)"tokenInfoUrl", (Object)credential.getTokenInfoUrl());
        Assert.assertEquals((Object)"userProject", (Object)credential.getWorkforcePoolUserProject());
        Assert.assertNotNull((Object)credential.getCredentialSource());
        PluggableAuthCredentials.PluggableAuthCredentialSource source = (PluggableAuthCredentials.PluggableAuthCredentialSource)credential.getCredentialSource();
        Assert.assertEquals((Object)"command", (Object)source.getCommand());
        Assert.assertEquals((long)30000L, (long)source.getTimeoutMs());
        Assert.assertNull((Object)source.getOutputFilePath());
    }

    @Test
    public void fromJson_pluggableAuthCredentials_allExecutableOptionsSet() {
        GenericJson json = this.buildJsonPluggableAuthCredential();
        Map credentialSourceMap = (Map)json.get((Object)"credential_source");
        Map executableConfig = (Map)credentialSourceMap.get("executable");
        executableConfig.put("timeout_millis", 5000);
        executableConfig.put("output_file", "path/to/output/file");
        ExternalAccountCredentials credential = ExternalAccountCredentials.fromJson((Map)json, (HttpTransportFactory)OAuth2Utils.HTTP_TRANSPORT_FACTORY);
        Assert.assertTrue((boolean)(credential instanceof PluggableAuthCredentials));
        Assert.assertEquals((Object)"audience", (Object)credential.getAudience());
        Assert.assertEquals((Object)"subjectTokenType", (Object)credential.getSubjectTokenType());
        Assert.assertEquals((Object)STS_URL, (Object)credential.getTokenUrl());
        Assert.assertEquals((Object)"tokenInfoUrl", (Object)credential.getTokenInfoUrl());
        Assert.assertNotNull((Object)credential.getCredentialSource());
        PluggableAuthCredentials.PluggableAuthCredentialSource source = (PluggableAuthCredentials.PluggableAuthCredentialSource)credential.getCredentialSource();
        Assert.assertEquals((Object)"command", (Object)source.getCommand());
        Assert.assertEquals((Object)"path/to/output/file", (Object)source.getOutputFilePath());
        Assert.assertEquals((long)5000L, (long)source.getTimeoutMs());
    }

    @Test
    public void fromJson_pluggableAuthCredentialsWithServiceAccountImpersonationOptions() {
        GenericJson pluggableAuthCredentialJson = this.buildJsonPluggableAuthCredential();
        pluggableAuthCredentialJson.set("service_account_impersonation", ExternalAccountCredentialsTest.buildServiceAccountImpersonationOptions(2800));
        ExternalAccountCredentials credential = ExternalAccountCredentials.fromJson((Map)pluggableAuthCredentialJson, (HttpTransportFactory)OAuth2Utils.HTTP_TRANSPORT_FACTORY);
        Assert.assertTrue((boolean)(credential instanceof PluggableAuthCredentials));
        Assert.assertEquals((Object)"audience", (Object)credential.getAudience());
        Assert.assertEquals((Object)"subjectTokenType", (Object)credential.getSubjectTokenType());
        Assert.assertEquals((Object)STS_URL, (Object)credential.getTokenUrl());
        Assert.assertEquals((Object)"tokenInfoUrl", (Object)credential.getTokenInfoUrl());
        Assert.assertNotNull((Object)credential.getCredentialSource());
        Assert.assertEquals((long)2800L, (long)credential.getServiceAccountImpersonationOptions().getLifetime());
        PluggableAuthCredentials.PluggableAuthCredentialSource source = (PluggableAuthCredentials.PluggableAuthCredentialSource)credential.getCredentialSource();
        Assert.assertEquals((Object)"command", (Object)source.getCommand());
        Assert.assertEquals((long)30000L, (long)source.getTimeoutMs());
        Assert.assertNull((Object)source.getOutputFilePath());
    }

    @Test
    public void fromJson_nullJson_throws() {
        try {
            ExternalAccountCredentials.fromJson(null, (HttpTransportFactory)OAuth2Utils.HTTP_TRANSPORT_FACTORY);
            Assert.fail((String)"Exception should be thrown.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void fromJson_invalidServiceAccountImpersonationUrl_throws() {
        GenericJson json = this.buildJsonIdentityPoolCredential();
        json.put("service_account_impersonation_url", (Object)"https://iamcredentials.googleapis.com");
        try {
            ExternalAccountCredentials.fromJson((Map)json, (HttpTransportFactory)OAuth2Utils.HTTP_TRANSPORT_FACTORY);
            Assert.fail((String)"Exception should be thrown.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Unable to determine target principal from service account impersonation URL.", (Object)e.getMessage());
        }
    }

    @Test
    public void fromJson_nullTransport_throws() {
        try {
            ExternalAccountCredentials.fromJson(new HashMap(), null);
            Assert.fail((String)"Exception should be thrown.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void fromJson_invalidWorkforceAudiences_throws() {
        List<String> invalidAudiences = Arrays.asList("//iam.googleapis.com/locations/global/workloadIdentityPools/pool/providers/provider", "//iam.googleapis.com/locations/global/workforcepools/pool/providers/provider", "//iam.googleapis.com/locations/global/workforcePools/providers/provider", "//iam.googleapis.com/locations/global/workforcePools/providers", "//iam.googleapis.com/locations/global/workforcePools/", "//iam.googleapis.com/locations//workforcePools/providers", "//iam.googleapis.com/notlocations/global/workforcePools/providers", "//iam.googleapis.com/locations/global/workforce/providers");
        for (String audience : invalidAudiences) {
            try {
                GenericJson json = this.buildJsonIdentityPoolCredential();
                json.put("audience", (Object)audience);
                json.put("workforce_pool_user_project", (Object)"userProject");
                ExternalAccountCredentials.fromJson((Map)json, (HttpTransportFactory)OAuth2Utils.HTTP_TRANSPORT_FACTORY);
                Assert.fail((String)"Exception should be thrown.");
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((Object)"The workforce_pool_user_project parameter should only be provided for a Workforce Pool configuration.", (Object)e.getMessage());
            }
        }
    }

    @Test
    public void constructor_builder() {
        HashMap<String, Object> credentialSource = new HashMap<String, Object>();
        credentialSource.put("file", "file");
        ExternalAccountCredentials credentials = IdentityPoolCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)this.transportFactory).setAudience("//iam.googleapis.com/locations/global/workforcePools/pool/providers/provider").setSubjectTokenType("subjectTokenType").setTokenUrl(STS_URL).setTokenInfoUrl("https://tokeninfo.com").setServiceAccountImpersonationUrl("https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/testn@test.iam.gserviceaccount.com:generateAccessToken").setCredentialSource((ExternalAccountCredentials.CredentialSource)new TestExternalAccountCredentials.TestCredentialSource(credentialSource)).setScopes(Arrays.asList("scope1", "scope2")).setQuotaProjectId("projectId").setClientId("clientId").setClientSecret("clientSecret").setWorkforcePoolUserProject("workforcePoolUserProject").build();
        Assert.assertEquals((Object)"//iam.googleapis.com/locations/global/workforcePools/pool/providers/provider", (Object)credentials.getAudience());
        Assert.assertEquals((Object)"subjectTokenType", (Object)credentials.getSubjectTokenType());
        Assert.assertEquals((Object)STS_URL, (Object)credentials.getTokenUrl());
        Assert.assertEquals((Object)"https://tokeninfo.com", (Object)credentials.getTokenInfoUrl());
        Assert.assertEquals((Object)"https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/testn@test.iam.gserviceaccount.com:generateAccessToken", (Object)credentials.getServiceAccountImpersonationUrl());
        Assert.assertEquals(Arrays.asList("scope1", "scope2"), (Object)credentials.getScopes());
        Assert.assertEquals((Object)"projectId", (Object)credentials.getQuotaProjectId());
        Assert.assertEquals((Object)"clientId", (Object)credentials.getClientId());
        Assert.assertEquals((Object)"clientSecret", (Object)credentials.getClientSecret());
        Assert.assertEquals((Object)"workforcePoolUserProject", (Object)credentials.getWorkforcePoolUserProject());
        Assert.assertNotNull((Object)credentials.getCredentialSource());
    }

    @Test
    public void constructor_builder_invalidTokenUrl() {
        try {
            ExternalAccountCredentials.Builder builder = TestExternalAccountCredentials.newBuilder().setHttpTransportFactory(this.transportFactory).setAudience("audience").setSubjectTokenType("subjectTokenType").setTokenUrl("tokenUrl").setCredentialSource((ExternalAccountCredentials.CredentialSource)new TestExternalAccountCredentials.TestCredentialSource(FILE_CREDENTIAL_SOURCE_MAP));
            new TestExternalAccountCredentials(builder);
            Assert.fail((String)"Should not be able to continue without exception.");
        }
        catch (IllegalArgumentException exception) {
            Assert.assertEquals((Object)"The provided token URL is invalid.", (Object)exception.getMessage());
        }
    }

    @Test
    public void constructor_builder_invalidServiceAccountImpersonationUrl() {
        try {
            ExternalAccountCredentials.Builder builder = TestExternalAccountCredentials.newBuilder().setHttpTransportFactory(this.transportFactory).setAudience("audience").setSubjectTokenType("subjectTokenType").setTokenUrl("tokenUrl").setCredentialSource((ExternalAccountCredentials.CredentialSource)new TestExternalAccountCredentials.TestCredentialSource(FILE_CREDENTIAL_SOURCE_MAP)).setServiceAccountImpersonationUrl("serviceAccountImpersonationUrl");
            new TestExternalAccountCredentials(builder);
            Assert.fail((String)"Should not be able to continue without exception.");
        }
        catch (IllegalArgumentException exception) {
            Assert.assertEquals((Object)"The provided token URL is invalid.", (Object)exception.getMessage());
        }
    }

    @Test
    public void constructor_builderWithInvalidWorkforceAudiences_throws() {
        List<String> invalidAudiences = Arrays.asList("", "//iam.googleapis.com/projects/x23/locations/global/workloadIdentityPools/pool/providers/provider", "//iam.googleapis.com/locations/global/workforcepools/pool/providers/provider", "//iam.googleapis.com/locations/global/workforcePools/providers/provider", "//iam.googleapis.com/locations/global/workforcePools/providers", "//iam.googleapis.com/locations/global/workforcePools/", "//iam.googleapis.com/locations//workforcePools/providers", "//iam.googleapis.com/notlocations/global/workforcePools/providers", "//iam.googleapis.com/locations/global/workforce/providers");
        HashMap<String, Object> credentialSource = new HashMap<String, Object>();
        credentialSource.put("file", "file");
        for (String audience : invalidAudiences) {
            try {
                TestExternalAccountCredentials.newBuilder().setWorkforcePoolUserProject("workforcePoolUserProject").setHttpTransportFactory(OAuth2Utils.HTTP_TRANSPORT_FACTORY).setAudience(audience).setSubjectTokenType("subjectTokenType").setTokenUrl(STS_URL).setCredentialSource((ExternalAccountCredentials.CredentialSource)new TestExternalAccountCredentials.TestCredentialSource(credentialSource)).build();
                Assert.fail((String)"Should not be able to continue without exception.");
            }
            catch (IllegalArgumentException exception) {
                Assert.assertEquals((Object)"The workforce_pool_user_project parameter should only be provided for a Workforce Pool configuration.", (Object)exception.getMessage());
            }
        }
    }

    @Test
    public void constructor_builderWithEmptyWorkforceUserProjectAndWorkforceAudience() {
        HashMap<String, Object> credentialSource = new HashMap<String, Object>();
        credentialSource.put("file", "file");
        TestExternalAccountCredentials.newBuilder().setWorkforcePoolUserProject("").setHttpTransportFactory(OAuth2Utils.HTTP_TRANSPORT_FACTORY).setAudience("//iam.googleapis.com/locations/global/workforcePools/pool/providers/provider").setSubjectTokenType("subjectTokenType").setTokenUrl(STS_URL).setCredentialSource((ExternalAccountCredentials.CredentialSource)new TestExternalAccountCredentials.TestCredentialSource(credentialSource)).build();
    }

    @Test
    public void constructor_builder_invalidTokenLifetime_throws() {
        HashMap<String, String> invalidOptionsMap = new HashMap<String, String>();
        invalidOptionsMap.put("token_lifetime_seconds", "thisIsAString");
        try {
            IdentityPoolCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)this.transportFactory).setAudience("//iam.googleapis.com/locations/global/workforcePools/pool/providers/provider").setSubjectTokenType("subjectTokenType").setTokenUrl(STS_URL).setTokenInfoUrl("https://tokeninfo.com").setServiceAccountImpersonationUrl("https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/testn@test.iam.gserviceaccount.com:generateAccessToken").setCredentialSource((ExternalAccountCredentials.CredentialSource)new TestExternalAccountCredentials.TestCredentialSource(FILE_CREDENTIAL_SOURCE_MAP)).setScopes(Arrays.asList("scope1", "scope2")).setQuotaProjectId("projectId").setClientId("clientId").setClientSecret("clientSecret").setWorkforcePoolUserProject("workforcePoolUserProject").setServiceAccountImpersonationOptions(invalidOptionsMap).build();
            Assert.fail((String)"Should not be able to continue without exception.");
        }
        catch (IllegalArgumentException exception) {
            Assert.assertEquals((Object)"Value of \"token_lifetime_seconds\" field could not be parsed into an integer.", (Object)exception.getMessage());
            Assert.assertEquals(NumberFormatException.class, exception.getCause().getClass());
        }
    }

    @Test
    public void constructor_builder_stringTokenLifetime() {
        HashMap<String, String> optionsMap = new HashMap<String, String>();
        optionsMap.put("token_lifetime_seconds", "2800");
        ExternalAccountCredentials credentials = IdentityPoolCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)this.transportFactory).setAudience("//iam.googleapis.com/locations/global/workforcePools/pool/providers/provider").setSubjectTokenType("subjectTokenType").setTokenUrl(STS_URL).setTokenInfoUrl("https://tokeninfo.com").setServiceAccountImpersonationUrl("https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/testn@test.iam.gserviceaccount.com:generateAccessToken").setCredentialSource((ExternalAccountCredentials.CredentialSource)new TestExternalAccountCredentials.TestCredentialSource(FILE_CREDENTIAL_SOURCE_MAP)).setScopes(Arrays.asList("scope1", "scope2")).setQuotaProjectId("projectId").setClientId("clientId").setClientSecret("clientSecret").setWorkforcePoolUserProject("workforcePoolUserProject").setServiceAccountImpersonationOptions(optionsMap).build();
        Assert.assertEquals((long)2800L, (long)credentials.getServiceAccountImpersonationOptions().getLifetime());
    }

    @Test
    public void constructor_builder_bigDecimalTokenLifetime() {
        HashMap<String, BigDecimal> optionsMap = new HashMap<String, BigDecimal>();
        optionsMap.put("token_lifetime_seconds", new BigDecimal("2800"));
        ExternalAccountCredentials credentials = IdentityPoolCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)this.transportFactory).setAudience("//iam.googleapis.com/locations/global/workforcePools/pool/providers/provider").setSubjectTokenType("subjectTokenType").setTokenUrl(STS_URL).setTokenInfoUrl("https://tokeninfo.com").setServiceAccountImpersonationUrl("https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/testn@test.iam.gserviceaccount.com:generateAccessToken").setCredentialSource((ExternalAccountCredentials.CredentialSource)new TestExternalAccountCredentials.TestCredentialSource(FILE_CREDENTIAL_SOURCE_MAP)).setScopes(Arrays.asList("scope1", "scope2")).setQuotaProjectId("projectId").setClientId("clientId").setClientSecret("clientSecret").setWorkforcePoolUserProject("workforcePoolUserProject").setServiceAccountImpersonationOptions(optionsMap).build();
        Assert.assertEquals((long)2800L, (long)credentials.getServiceAccountImpersonationOptions().getLifetime());
    }

    @Test
    public void constructor_builder_integerTokenLifetime() {
        HashMap<String, Integer> optionsMap = new HashMap<String, Integer>();
        optionsMap.put("token_lifetime_seconds", 2800);
        ExternalAccountCredentials credentials = IdentityPoolCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)this.transportFactory).setAudience("//iam.googleapis.com/locations/global/workforcePools/pool/providers/provider").setSubjectTokenType("subjectTokenType").setTokenUrl(STS_URL).setTokenInfoUrl("https://tokeninfo.com").setServiceAccountImpersonationUrl("https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/testn@test.iam.gserviceaccount.com:generateAccessToken").setCredentialSource((ExternalAccountCredentials.CredentialSource)new TestExternalAccountCredentials.TestCredentialSource(FILE_CREDENTIAL_SOURCE_MAP)).setScopes(Arrays.asList("scope1", "scope2")).setQuotaProjectId("projectId").setClientId("clientId").setClientSecret("clientSecret").setWorkforcePoolUserProject("workforcePoolUserProject").setServiceAccountImpersonationOptions(optionsMap).build();
        Assert.assertEquals((long)2800L, (long)credentials.getServiceAccountImpersonationOptions().getLifetime());
    }

    @Test
    public void constructor_builder_lowTokenLifetime_throws() {
        HashMap<String, Integer> optionsMap = new HashMap<String, Integer>();
        optionsMap.put("token_lifetime_seconds", 599);
        try {
            ExternalAccountCredentials externalAccountCredentials = IdentityPoolCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)this.transportFactory).setAudience("//iam.googleapis.com/locations/global/workforcePools/pool/providers/provider").setSubjectTokenType("subjectTokenType").setTokenUrl(STS_URL).setTokenInfoUrl("https://tokeninfo.com").setServiceAccountImpersonationUrl("https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/testn@test.iam.gserviceaccount.com:generateAccessToken").setCredentialSource((ExternalAccountCredentials.CredentialSource)new TestExternalAccountCredentials.TestCredentialSource(FILE_CREDENTIAL_SOURCE_MAP)).setScopes(Arrays.asList("scope1", "scope2")).setQuotaProjectId("projectId").setClientId("clientId").setClientSecret("clientSecret").setWorkforcePoolUserProject("workforcePoolUserProject").setServiceAccountImpersonationOptions(optionsMap).build();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"The \"token_lifetime_seconds\" field must be between 600 and 43200 seconds.", (Object)e.getMessage());
        }
    }

    @Test
    public void constructor_builder_highTokenLifetime_throws() {
        HashMap<String, Integer> optionsMap = new HashMap<String, Integer>();
        optionsMap.put("token_lifetime_seconds", 43201);
        try {
            ExternalAccountCredentials externalAccountCredentials = IdentityPoolCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)this.transportFactory).setAudience("//iam.googleapis.com/locations/global/workforcePools/pool/providers/provider").setSubjectTokenType("subjectTokenType").setTokenUrl(STS_URL).setTokenInfoUrl("https://tokeninfo.com").setServiceAccountImpersonationUrl("https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/testn@test.iam.gserviceaccount.com:generateAccessToken").setCredentialSource((ExternalAccountCredentials.CredentialSource)new TestExternalAccountCredentials.TestCredentialSource(FILE_CREDENTIAL_SOURCE_MAP)).setScopes(Arrays.asList("scope1", "scope2")).setQuotaProjectId("projectId").setClientId("clientId").setClientSecret("clientSecret").setWorkforcePoolUserProject("workforcePoolUserProject").setServiceAccountImpersonationOptions(optionsMap).build();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"The \"token_lifetime_seconds\" field must be between 600 and 43200 seconds.", (Object)e.getMessage());
        }
    }

    @Test
    public void exchangeExternalCredentialForAccessToken() throws IOException {
        ExternalAccountCredentials credential = ExternalAccountCredentials.fromJson((Map)this.buildJsonIdentityPoolCredential(), (HttpTransportFactory)this.transportFactory);
        StsTokenExchangeRequest stsTokenExchangeRequest = StsTokenExchangeRequest.newBuilder((String)"credential", (String)"subjectTokenType").build();
        AccessToken accessToken = credential.exchangeExternalCredentialForAccessToken(stsTokenExchangeRequest);
        Assert.assertEquals((Object)this.transportFactory.transport.getAccessToken(), (Object)accessToken.getTokenValue());
        Map<String, String> query = TestUtils.parseQuery(this.transportFactory.transport.getLastRequest().getContentAsString());
        Assert.assertNull((Object)query.get("options"));
    }

    @Test
    public void exchangeExternalCredentialForAccessToken_withInternalOptions() throws IOException {
        ExternalAccountCredentials credential = ExternalAccountCredentials.fromJson((Map)this.buildJsonIdentityPoolCredential(), (HttpTransportFactory)this.transportFactory);
        GenericJson internalOptions = new GenericJson();
        internalOptions.setFactory(OAuth2Utils.JSON_FACTORY);
        internalOptions.put("key", (Object)"value");
        StsTokenExchangeRequest stsTokenExchangeRequest = StsTokenExchangeRequest.newBuilder((String)"credential", (String)"subjectTokenType").setInternalOptions(internalOptions.toString()).build();
        AccessToken accessToken = credential.exchangeExternalCredentialForAccessToken(stsTokenExchangeRequest);
        Assert.assertEquals((Object)this.transportFactory.transport.getAccessToken(), (Object)accessToken.getTokenValue());
        Map<String, String> query = TestUtils.parseQuery(this.transportFactory.transport.getLastRequest().getContentAsString());
        Assert.assertNotNull((Object)query.get("options"));
        Assert.assertEquals((Object)internalOptions.toString(), (Object)query.get("options"));
    }

    @Test
    public void exchangeExternalCredentialForAccessToken_workforceCred_expectUserProjectPassedToSts() throws IOException {
        ExternalAccountCredentials identityPoolCredential = ExternalAccountCredentials.fromJson((Map)this.buildJsonIdentityPoolWorkforceCredential(), (HttpTransportFactory)this.transportFactory);
        ExternalAccountCredentials pluggableAuthCredential = ExternalAccountCredentials.fromJson((Map)this.buildJsonPluggableAuthWorkforceCredential(), (HttpTransportFactory)this.transportFactory);
        List<ExternalAccountCredentials> credentials = Arrays.asList(identityPoolCredential, pluggableAuthCredential);
        for (int i = 0; i < credentials.size(); ++i) {
            StsTokenExchangeRequest stsTokenExchangeRequest = StsTokenExchangeRequest.newBuilder((String)"credential", (String)"subjectTokenType").build();
            AccessToken accessToken = credentials.get(i).exchangeExternalCredentialForAccessToken(stsTokenExchangeRequest);
            Assert.assertEquals((Object)this.transportFactory.transport.getAccessToken(), (Object)accessToken.getTokenValue());
            Map<String, String> query = TestUtils.parseQuery(this.transportFactory.transport.getLastRequest().getContentAsString());
            GenericJson internalOptions = new GenericJson();
            internalOptions.setFactory(OAuth2Utils.JSON_FACTORY);
            internalOptions.put("userProject", (Object)"userProject");
            Assert.assertEquals((Object)internalOptions.toString(), (Object)query.get("options"));
            Assert.assertEquals((long)(i + 1), (long)this.transportFactory.transport.getRequests().size());
        }
    }

    @Test
    public void exchangeExternalCredentialForAccessToken_workforceCredWithInternalOptions_expectOverridden() throws IOException {
        ExternalAccountCredentials credential = ExternalAccountCredentials.fromJson((Map)this.buildJsonIdentityPoolWorkforceCredential(), (HttpTransportFactory)this.transportFactory);
        GenericJson internalOptions = new GenericJson();
        internalOptions.put("key", (Object)"value");
        StsTokenExchangeRequest stsTokenExchangeRequest = StsTokenExchangeRequest.newBuilder((String)"credential", (String)"subjectTokenType").setInternalOptions(internalOptions.toString()).build();
        AccessToken accessToken = credential.exchangeExternalCredentialForAccessToken(stsTokenExchangeRequest);
        Assert.assertEquals((Object)this.transportFactory.transport.getAccessToken(), (Object)accessToken.getTokenValue());
        Map<String, String> query = TestUtils.parseQuery(this.transportFactory.transport.getLastRequest().getContentAsString());
        Assert.assertNotNull((Object)query.get("options"));
        Assert.assertEquals((Object)internalOptions.toString(), (Object)query.get("options"));
    }

    @Test
    public void exchangeExternalCredentialForAccessToken_withServiceAccountImpersonation() throws IOException {
        this.transportFactory.transport.setExpireTime(TestUtils.getDefaultExpireTime());
        ExternalAccountCredentials credential = ExternalAccountCredentials.fromStream((InputStream)IdentityPoolCredentialsTest.writeIdentityPoolCredentialsStream(this.transportFactory.transport.getStsUrl(), this.transportFactory.transport.getMetadataUrl(), this.transportFactory.transport.getServiceAccountImpersonationUrl(), null), (HttpTransportFactory)this.transportFactory);
        StsTokenExchangeRequest stsTokenExchangeRequest = StsTokenExchangeRequest.newBuilder((String)"credential", (String)"subjectTokenType").build();
        AccessToken returnedToken = credential.exchangeExternalCredentialForAccessToken(stsTokenExchangeRequest);
        Assert.assertEquals((Object)this.transportFactory.transport.getServiceAccountAccessToken(), (Object)returnedToken.getTokenValue());
        GenericJson query = (GenericJson)OAuth2Utils.JSON_FACTORY.createJsonParser(this.transportFactory.transport.getLastRequest().getContentAsString()).parseAndClose(GenericJson.class);
        Assert.assertEquals((Object)"3600s", (Object)query.get((Object)"lifetime"));
    }

    @Test
    public void exchangeExternalCredentialForAccessToken_withServiceAccountImpersonationOptions() throws IOException {
        this.transportFactory.transport.setExpireTime(TestUtils.getDefaultExpireTime());
        ExternalAccountCredentials credential = ExternalAccountCredentials.fromStream((InputStream)IdentityPoolCredentialsTest.writeIdentityPoolCredentialsStream(this.transportFactory.transport.getStsUrl(), this.transportFactory.transport.getMetadataUrl(), this.transportFactory.transport.getServiceAccountImpersonationUrl(), ExternalAccountCredentialsTest.buildServiceAccountImpersonationOptions(2800)), (HttpTransportFactory)this.transportFactory);
        StsTokenExchangeRequest stsTokenExchangeRequest = StsTokenExchangeRequest.newBuilder((String)"credential", (String)"subjectTokenType").build();
        AccessToken returnedToken = credential.exchangeExternalCredentialForAccessToken(stsTokenExchangeRequest);
        Assert.assertEquals((Object)this.transportFactory.transport.getServiceAccountAccessToken(), (Object)returnedToken.getTokenValue());
        GenericJson query = (GenericJson)OAuth2Utils.JSON_FACTORY.createJsonParser(this.transportFactory.transport.getLastRequest().getContentAsString()).parseAndClose(GenericJson.class);
        Assert.assertEquals((Object)"2800s", (Object)query.get((Object)"lifetime"));
    }

    @Test
    public void exchangeExternalCredentialForAccessToken_withServiceAccountImpersonationOverride() throws IOException {
        this.transportFactory.transport.setExpireTime(TestUtils.getDefaultExpireTime());
        String serviceAccountEmail = "different@different.iam.gserviceaccount.com";
        ExternalAccountCredentials credential = ExternalAccountCredentials.fromStream((InputStream)IdentityPoolCredentialsTest.writeIdentityPoolCredentialsStream(this.transportFactory.transport.getStsUrl(), this.transportFactory.transport.getMetadataUrl(), this.transportFactory.transport.getServiceAccountImpersonationUrl(), null), (HttpTransportFactory)this.transportFactory);
        ExternalAccountCredentials sourceCredentials = IdentityPoolCredentials.newBuilder((IdentityPoolCredentials)((IdentityPoolCredentials)credential)).setServiceAccountImpersonationUrl(null).build();
        credential.overrideImpersonatedCredentials(new ImpersonatedCredentials.Builder((GoogleCredentials)sourceCredentials, serviceAccountEmail).setScopes(new ArrayList(sourceCredentials.getScopes())).setHttpTransportFactory((HttpTransportFactory)this.transportFactory).build());
        credential.exchangeExternalCredentialForAccessToken(StsTokenExchangeRequest.newBuilder((String)"credential", (String)"subjectTokenType").build());
        Assert.assertTrue((boolean)this.transportFactory.transport.getRequests().get(2).getUrl().contains(serviceAccountEmail));
    }

    @Test
    public void exchangeExternalCredentialForAccessToken_throws() throws IOException {
        ExternalAccountCredentials credential = ExternalAccountCredentials.fromJson((Map)this.buildJsonIdentityPoolCredential(), (HttpTransportFactory)this.transportFactory);
        String errorCode = "invalidRequest";
        String errorDescription = "errorDescription";
        String errorUri = "errorUri";
        this.transportFactory.transport.addResponseErrorSequence(new IOException[]{TestUtils.buildHttpResponseException(errorCode, errorDescription, errorUri)});
        StsTokenExchangeRequest stsTokenExchangeRequest = StsTokenExchangeRequest.newBuilder((String)"credential", (String)"subjectTokenType").build();
        try {
            credential.exchangeExternalCredentialForAccessToken(stsTokenExchangeRequest);
            Assert.fail((String)"Exception should be thrown.");
        }
        catch (OAuthException e) {
            Assert.assertEquals((Object)errorCode, (Object)e.getErrorCode());
            Assert.assertEquals((Object)errorDescription, (Object)e.getErrorDescription());
            Assert.assertEquals((Object)errorUri, (Object)e.getErrorUri());
        }
    }

    @Test
    public void getRequestMetadata_withQuotaProjectId() throws IOException {
        TestExternalAccountCredentials testCredentials = (TestExternalAccountCredentials)TestExternalAccountCredentials.newBuilder().setHttpTransportFactory(this.transportFactory).setAudience("audience").setSubjectTokenType("subjectTokenType").setTokenUrl(STS_URL).setCredentialSource((ExternalAccountCredentials.CredentialSource)new TestExternalAccountCredentials.TestCredentialSource(FILE_CREDENTIAL_SOURCE_MAP)).setQuotaProjectId("quotaProjectId").build();
        Map requestMetadata = testCredentials.getRequestMetadata(URI.create("http://googleapis.com/foo/bar"));
        Assert.assertEquals((Object)"quotaProjectId", ((List)requestMetadata.get("x-goog-user-project")).get(0));
    }

    @Test
    public void validateTokenUrl_validUrls() {
        List<String> validUrls = Arrays.asList(STS_URL, "https://us-east-1.sts.googleapis.com", "https://US-EAST-1.sts.googleapis.com", "https://sts.us-east-1.googleapis.com", "https://sts.US-WEST-1.googleapis.com", "https://us-east-1-sts.googleapis.com", "https://US-WEST-1-sts.googleapis.com", "https://us-west-1-sts.googleapis.com/path?query");
        for (String url : validUrls) {
            ExternalAccountCredentials.validateTokenUrl((String)url);
            ExternalAccountCredentials.validateTokenUrl((String)url.toUpperCase(Locale.US));
        }
    }

    @Test
    public void validateTokenUrl_invalidUrls() {
        List<String> invalidUrls = Arrays.asList("https://iamcredentials.googleapis.com", "sts.googleapis.com", "https://", "http://sts.googleapis.com", "https://st.s.googleapis.com", "https://us-eas\\t-1.sts.googleapis.com", "https:/us-east-1.sts.googleapis.com", "https://US-WE/ST-1-sts.googleapis.com", "https://sts-us-east-1.googleapis.com", "https://sts-US-WEST-1.googleapis.com", "testhttps://us-east-1.sts.googleapis.com", "https://us-east-1.sts.googleapis.comevil.com", "https://us-east-1.us-east-1.sts.googleapis.com", "https://us-ea.s.t.sts.googleapis.com", "https://sts.googleapis.comevil.com", "hhttps://us-east-1.sts.googleapis.com", "https://us- -1.sts.googleapis.com", "https://-sts.googleapis.com", "https://us-east-1.sts.googleapis.com.evil.com");
        for (String url : invalidUrls) {
            try {
                ExternalAccountCredentials.validateTokenUrl((String)url);
                Assert.fail((String)"Should have failed since an invalid URL was passed.");
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((Object)"The provided token URL is invalid.", (Object)e.getMessage());
            }
        }
    }

    @Test
    public void validateServiceAccountImpersonationUrls_validUrls() {
        List<String> validUrls = Arrays.asList("https://iamcredentials.googleapis.com", "https://us-east-1.iamcredentials.googleapis.com", "https://US-EAST-1.iamcredentials.googleapis.com", "https://iamcredentials.us-east-1.googleapis.com", "https://iamcredentials.US-WEST-1.googleapis.com", "https://us-east-1-iamcredentials.googleapis.com", "https://US-WEST-1-iamcredentials.googleapis.com", "https://us-west-1-iamcredentials.googleapis.com/path?query");
        for (String url : validUrls) {
            ExternalAccountCredentials.validateServiceAccountImpersonationInfoUrl((String)url);
            ExternalAccountCredentials.validateServiceAccountImpersonationInfoUrl((String)url.toUpperCase(Locale.US));
        }
    }

    @Test
    public void validateServiceAccountImpersonationUrls_invalidUrls() {
        List<String> invalidUrls = Arrays.asList(STS_URL, "iamcredentials.googleapis.com", "https://", "http://iamcredentials.googleapis.com", "https://iamcre.dentials.googleapis.com", "https://us-eas\t-1.iamcredentials.googleapis.com", "https:/us-east-1.iamcredentials.googleapis.com", "https://US-WE/ST-1-iamcredentials.googleapis.com", "https://iamcredentials-us-east-1.googleapis.com", "https://iamcredentials-US-WEST-1.googleapis.com", "testhttps://us-east-1.iamcredentials.googleapis.com", "https://us-east-1.iamcredentials.googleapis.comevil.com", "https://us-east-1.us-east-1.iamcredentials.googleapis.com", "https://us-ea.s.t.iamcredentials.googleapis.com", "https://iamcredentials.googleapis.comevil.com", "hhttps://us-east-1.iamcredentials.googleapis.com", "https://us- -1.iamcredentials.googleapis.com", "https://-iamcredentials.googleapis.com", "https://us-east-1.iamcredentials.googleapis.com.evil.com");
        for (String url : invalidUrls) {
            try {
                ExternalAccountCredentials.validateServiceAccountImpersonationInfoUrl((String)url);
                Assert.fail((String)"Should have failed since an invalid URL was passed.");
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((Object)"The provided service account impersonation URL is invalid.", (Object)e.getMessage());
            }
        }
    }

    private GenericJson buildJsonIdentityPoolCredential() {
        GenericJson json = new GenericJson();
        json.put("audience", (Object)"//iam.googleapis.com/projects/123/locations/global/workloadIdentityPools/pool/providers/provider");
        json.put("subject_token_type", (Object)"subjectTokenType");
        json.put("token_url", (Object)STS_URL);
        json.put("token_info_url", (Object)"tokenInfoUrl");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("file", "file");
        json.put("credential_source", map);
        return json;
    }

    private GenericJson buildJsonIdentityPoolWorkforceCredential() {
        GenericJson json = this.buildJsonIdentityPoolCredential();
        json.put("audience", (Object)"//iam.googleapis.com/locations/global/workforcePools/pool/providers/provider");
        json.put("workforce_pool_user_project", (Object)"userProject");
        return json;
    }

    private GenericJson buildJsonAwsCredential() {
        GenericJson json = new GenericJson();
        json.put("audience", (Object)"audience");
        json.put("subject_token_type", (Object)"subjectTokenType");
        json.put("token_url", (Object)STS_URL);
        json.put("token_info_url", (Object)"tokenInfoUrl");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("environment_id", "aws1");
        map.put("region_url", "regionUrl");
        map.put("url", "url");
        map.put("regional_cred_verification_url", "regionalCredVerificationUrl");
        json.put("credential_source", map);
        return json;
    }

    private GenericJson buildJsonPluggableAuthCredential() {
        GenericJson json = new GenericJson();
        json.put("audience", (Object)"audience");
        json.put("subject_token_type", (Object)"subjectTokenType");
        json.put("token_url", (Object)STS_URL);
        json.put("token_info_url", (Object)"tokenInfoUrl");
        HashMap credentialSource = new HashMap();
        HashMap<String, String> executableConfig = new HashMap<String, String>();
        executableConfig.put("command", "command");
        credentialSource.put("executable", executableConfig);
        json.put("credential_source", credentialSource);
        return json;
    }

    private GenericJson buildJsonPluggableAuthWorkforceCredential() {
        GenericJson json = this.buildJsonPluggableAuthCredential();
        json.put("audience", (Object)"//iam.googleapis.com/locations/global/workforcePools/pool/providers/provider");
        json.put("workforce_pool_user_project", (Object)"userProject");
        return json;
    }

    static Map<String, Object> buildServiceAccountImpersonationOptions(Integer lifetime) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("token_lifetime_seconds", lifetime);
        return map;
    }

    static class TestExternalAccountCredentials
    extends ExternalAccountCredentials {
        public static Builder newBuilder() {
            return new Builder();
        }

        protected TestExternalAccountCredentials(ExternalAccountCredentials.Builder builder) {
            super(builder);
        }

        public AccessToken refreshAccessToken() {
            return new AccessToken("accessToken", new Date());
        }

        public String retrieveSubjectToken() {
            return "subjectToken";
        }

        static class Builder
        extends ExternalAccountCredentials.Builder {
            Builder() {
            }

            public TestExternalAccountCredentials build() {
                return new TestExternalAccountCredentials(this);
            }
        }

        static class TestCredentialSource
        extends IdentityPoolCredentials.IdentityPoolCredentialSource {
            protected TestCredentialSource(Map<String, Object> credentialSourceMap) {
                super(credentialSourceMap);
            }
        }
    }

    static class MockExternalAccountCredentialsTransportFactory
    implements HttpTransportFactory {
        MockExternalAccountCredentialsTransport transport = new MockExternalAccountCredentialsTransport();

        MockExternalAccountCredentialsTransportFactory() {
        }

        public HttpTransport create() {
            return this.transport;
        }
    }
}

