/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.ObjectParser;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.CredentialAccessBoundary;
import com.google.auth.oauth2.DownscopedCredentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.OAuth2CredentialsWithRefresh;
import com.google.auth.oauth2.ServiceAccountCredentials;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public final class ITDownscopingTest {
    private static final String GCS_BUCKET_NAME = "cab-int-bucket-cbi3qrv5";
    private static final String GCS_OBJECT_NAME_WITH_PERMISSION = "cab-first-cbi3qrv5.txt";
    private static final String GCS_OBJECT_NAME_WITHOUT_PERMISSION = "cab-second-cbi3qrv5.txt";
    private static final CredentialAccessBoundary CREDENTIAL_ACCESS_BOUNDARY = CredentialAccessBoundary.newBuilder().addRule(CredentialAccessBoundary.AccessBoundaryRule.newBuilder().setAvailableResource(String.format("//storage.googleapis.com/projects/_/buckets/%s", "cab-int-bucket-cbi3qrv5")).addAvailablePermission("inRole:roles/storage.objectViewer").setAvailabilityCondition(CredentialAccessBoundary.AccessBoundaryRule.AvailabilityCondition.newBuilder().setExpression(String.format("resource.name.startsWith('projects/_/buckets/%s/objects/%s')", "cab-int-bucket-cbi3qrv5", "cab-first-cbi3qrv5.txt")).build()).build()).build();

    @Test
    public void downscoping_serviceAccountSourceWithRefresh() throws IOException {
        OAuth2CredentialsWithRefresh.OAuth2RefreshHandler refreshHandler = new OAuth2CredentialsWithRefresh.OAuth2RefreshHandler(){

            public AccessToken refreshAccessToken() throws IOException {
                ServiceAccountCredentials credentials = (ServiceAccountCredentials)GoogleCredentials.getApplicationDefault().createScoped(new String[]{"https://www.googleapis.com/auth/cloud-platform"});
                DownscopedCredentials downscopedCredentials = DownscopedCredentials.newBuilder().setSourceCredential((GoogleCredentials)credentials).setCredentialAccessBoundary(CREDENTIAL_ACCESS_BOUNDARY).build();
                return downscopedCredentials.refreshAccessToken();
            }
        };
        OAuth2CredentialsWithRefresh credentials = OAuth2CredentialsWithRefresh.newBuilder().setRefreshHandler(refreshHandler).build();
        this.retrieveObjectFromGcs((Credentials)credentials, GCS_OBJECT_NAME_WITH_PERMISSION);
        try {
            this.retrieveObjectFromGcs((Credentials)credentials, GCS_OBJECT_NAME_WITHOUT_PERMISSION);
            Assert.fail((String)"Call to GCS should have failed.");
        }
        catch (HttpResponseException e) {
            Assert.assertEquals((long)403L, (long)e.getStatusCode());
        }
    }

    private void retrieveObjectFromGcs(Credentials credentials, String objectName) throws IOException {
        String url = String.format("https://storage.googleapis.com/storage/v1/b/%s/o/%s", GCS_BUCKET_NAME, objectName);
        HttpCredentialsAdapter credentialsAdapter = new HttpCredentialsAdapter(credentials);
        HttpRequestFactory requestFactory = new NetHttpTransport().createRequestFactory((HttpRequestInitializer)credentialsAdapter);
        HttpRequest request = requestFactory.buildGetRequest(new GenericUrl(url));
        JsonObjectParser parser = new JsonObjectParser((JsonFactory)GsonFactory.getDefaultInstance());
        request.setParser((ObjectParser)parser);
        HttpResponse response = request.execute();
        Assert.assertTrue((boolean)response.isSuccessStatusCode());
    }
}

