/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.ObjectParser;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AwsCredentials;
import com.google.auth.oauth2.EnvironmentProvider;
import com.google.auth.oauth2.ExternalAccountCredentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.IdentityPoolCredentials;
import com.google.auth.oauth2.OAuth2Utils;
import com.google.auth.oauth2.PluggableAuthCredentials;
import com.google.auth.oauth2.TestEnvironmentProvider;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class ITWorkloadIdentityFederationTest {
    private static final String AUDIENCE_PREFIX = "//iam.googleapis.com/projects/1016721519174/locations/global/workloadIdentityPools/pool-1/providers/";
    private static final String AWS_ROLE_NAME = "ci-java-test";
    private static final String AWS_ROLE_ARN = "arn:aws:iam::027472800722:role/ci-java-test";
    private static final String AWS_AUDIENCE = "//iam.googleapis.com/projects/1016721519174/locations/global/workloadIdentityPools/pool-1/providers/aws-1";
    private static final String OIDC_AUDIENCE = "//iam.googleapis.com/projects/1016721519174/locations/global/workloadIdentityPools/pool-1/providers/oidc-1";
    private String clientEmail;

    @Before
    public void setup() throws IOException {
        GenericJson keys = this.getServiceAccountKeyFileAsJson();
        this.clientEmail = (String)keys.get((Object)"client_email");
    }

    @Test
    public void identityPoolCredentials() throws IOException {
        IdentityPoolCredentials identityPoolCredentials = (IdentityPoolCredentials)ExternalAccountCredentials.fromJson((Map)this.buildIdentityPoolCredentialConfig(), (HttpTransportFactory)OAuth2Utils.HTTP_TRANSPORT_FACTORY);
        this.callGcs((GoogleCredentials)identityPoolCredentials);
    }

    @Test
    public void awsCredentials() throws Exception {
        String idToken = this.generateGoogleIdToken(AWS_AUDIENCE);
        String url = String.format("https://sts.amazonaws.com/?Action=AssumeRoleWithWebIdentity&Version=2011-06-15&DurationSeconds=3600&RoleSessionName=%s&RoleArn=%s&WebIdentityToken=%s", AWS_ROLE_NAME, AWS_ROLE_ARN, idToken);
        HttpRequestFactory requestFactory = new NetHttpTransport().createRequestFactory();
        HttpRequest request = requestFactory.buildGetRequest(new GenericUrl(url));
        JsonObjectParser parser = new JsonObjectParser((JsonFactory)GsonFactory.getDefaultInstance());
        request.setParser((ObjectParser)parser);
        HttpResponse response = request.execute();
        String rawXml = response.parseAsString();
        String awsAccessKeyId = this.getXmlValueByTagName(rawXml, "AccessKeyId");
        String awsSecretAccessKey = this.getXmlValueByTagName(rawXml, "SecretAccessKey");
        String awsSessionToken = this.getXmlValueByTagName(rawXml, "SessionToken");
        AwsCredentials awsCredentialWithoutEnvProvider = (AwsCredentials)AwsCredentials.fromJson((Map)this.buildAwsCredentialConfig(), (HttpTransportFactory)OAuth2Utils.HTTP_TRANSPORT_FACTORY);
        TestEnvironmentProvider testEnvironmentProvider = new TestEnvironmentProvider();
        testEnvironmentProvider.setEnv("AWS_ACCESS_KEY_ID", awsAccessKeyId).setEnv("AWS_SECRET_ACCESS_KEY", awsSecretAccessKey).setEnv("AWS_SESSION_TOKEN", awsSessionToken).setEnv("AWS_REGION", "us-east-2");
        AwsCredentials awsCredential = (AwsCredentials)AwsCredentials.newBuilder((AwsCredentials)awsCredentialWithoutEnvProvider).setEnvironmentProvider((EnvironmentProvider)testEnvironmentProvider).build();
        this.callGcs((GoogleCredentials)awsCredential);
    }

    @Test
    public void pluggableAuthCredentials() throws IOException {
        PluggableAuthCredentials pluggableAuthCredentials = (PluggableAuthCredentials)ExternalAccountCredentials.fromJson((Map)this.buildPluggableCredentialConfig(), (HttpTransportFactory)OAuth2Utils.HTTP_TRANSPORT_FACTORY);
        this.callGcs((GoogleCredentials)pluggableAuthCredentials);
    }

    @Test
    public void identityPoolCredentials_withServiceAccountImpersonationOptions() throws IOException {
        GenericJson identityPoolCredentialConfig = this.buildIdentityPoolCredentialConfig();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("token_lifetime_seconds", 2800);
        identityPoolCredentialConfig.put("service_account_impersonation", map);
        IdentityPoolCredentials identityPoolCredentials = (IdentityPoolCredentials)ExternalAccountCredentials.fromJson((Map)identityPoolCredentialConfig, (HttpTransportFactory)OAuth2Utils.HTTP_TRANSPORT_FACTORY);
        long maxExpirationTime = Instant.now().plusSeconds(2805L).toEpochMilli();
        long minExpirationtime = Instant.now().plusSeconds(2795L).toEpochMilli();
        this.callGcs((GoogleCredentials)identityPoolCredentials);
        long tokenExpiry = identityPoolCredentials.getAccessToken().getExpirationTimeMillis();
        Assert.assertTrue((minExpirationtime <= tokenExpiry && tokenExpiry <= maxExpirationTime ? 1 : 0) != 0);
    }

    private GenericJson buildIdentityPoolCredentialConfig() throws IOException {
        String idToken = this.generateGoogleIdToken(OIDC_AUDIENCE);
        File file = File.createTempFile("ITWorkloadIdentityFederation", null, null);
        file.deleteOnExit();
        OAuth2Utils.writeInputStreamToFile((InputStream)new ByteArrayInputStream(idToken.getBytes(StandardCharsets.UTF_8)), (String)file.getAbsolutePath());
        GenericJson config = new GenericJson();
        config.put("type", (Object)"external_account");
        config.put("audience", (Object)OIDC_AUDIENCE);
        config.put("subject_token_type", (Object)"urn:ietf:params:oauth:token-type:jwt");
        config.put("token_url", (Object)"https://sts.googleapis.com/v1/token");
        config.put("service_account_impersonation_url", (Object)String.format("https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/%s:generateAccessToken", this.clientEmail));
        GenericJson credentialSource = new GenericJson();
        credentialSource.put("file", (Object)file.getAbsolutePath());
        config.put("credential_source", (Object)credentialSource);
        return config;
    }

    private GenericJson buildPluggableCredentialConfig() throws IOException {
        String idToken = this.generateGoogleIdToken(OIDC_AUDIENCE);
        Instant expiration_time = Instant.now().plusSeconds(3600L);
        GenericJson executableJson = new GenericJson();
        executableJson.setFactory(OAuth2Utils.JSON_FACTORY);
        executableJson.put("success", (Object)true);
        executableJson.put("version", (Object)1);
        executableJson.put("expiration_time", (Object)expiration_time.toEpochMilli());
        executableJson.put("token_type", (Object)"urn:ietf:params:oauth:token-type:jwt");
        executableJson.put("id_token", (Object)idToken);
        String fileContents = "#!/bin/bash\necho \"" + executableJson.toPrettyString().replace("\"", "\\\"") + "\"\n";
        File file = File.createTempFile("ITWorkloadIdentityFederation", null, null);
        file.deleteOnExit();
        if (!file.setExecutable(true, true)) {
            throw new IOException("Unable to make script executable");
        }
        OAuth2Utils.writeInputStreamToFile((InputStream)new ByteArrayInputStream(fileContents.getBytes(StandardCharsets.UTF_8)), (String)file.getAbsolutePath());
        GenericJson config = new GenericJson();
        config.put("type", (Object)"external_account");
        config.put("audience", (Object)OIDC_AUDIENCE);
        config.put("subject_token_type", (Object)"urn:ietf:params:oauth:token-type:jwt");
        config.put("token_url", (Object)"https://sts.googleapis.com/v1/token");
        config.put("service_account_impersonation_url", (Object)String.format("https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/%s:generateAccessToken", this.clientEmail));
        GenericJson credentialSource = new GenericJson();
        config.put("credential_source", (Object)credentialSource);
        GenericJson executableConfig = new GenericJson();
        credentialSource.put("executable", (Object)executableConfig);
        executableConfig.put("command", (Object)file.getAbsolutePath());
        return config;
    }

    private GenericJson buildAwsCredentialConfig() {
        GenericJson config = new GenericJson();
        config.put("type", (Object)"external_account");
        config.put("audience", (Object)AWS_AUDIENCE);
        config.put("subject_token_type", (Object)"urn:ietf:params:aws:token-type:aws4_request");
        config.put("token_url", (Object)"https://sts.googleapis.com/v1/token");
        config.put("service_account_impersonation_url", (Object)String.format("https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/%s:generateAccessToken", this.clientEmail));
        GenericJson credentialSource = new GenericJson();
        credentialSource.put("environment_id", (Object)"aws1");
        credentialSource.put("regional_cred_verification_url", (Object)"https://sts.{region}.amazonaws.com?Action=GetCallerIdentity&Version=2011-06-15");
        config.put("credential_source", (Object)credentialSource);
        return config;
    }

    private void callGcs(GoogleCredentials credentials) throws IOException {
        String bucketName = System.getenv("GCS_BUCKET");
        if (bucketName == null) {
            Assert.fail((String)"GCS bucket name not set through GCS_BUCKET env variable.");
        }
        String url = "https://storage.googleapis.com/storage/v1/b/" + bucketName;
        HttpCredentialsAdapter credentialsAdapter = new HttpCredentialsAdapter((Credentials)credentials);
        HttpRequestFactory requestFactory = new NetHttpTransport().createRequestFactory((HttpRequestInitializer)credentialsAdapter);
        HttpRequest request = requestFactory.buildGetRequest(new GenericUrl(url));
        JsonObjectParser parser = new JsonObjectParser((JsonFactory)GsonFactory.getDefaultInstance());
        request.setParser((ObjectParser)parser);
        HttpResponse response = request.execute();
        Assert.assertTrue((boolean)response.isSuccessStatusCode());
    }

    private String generateGoogleIdToken(String audience) throws IOException {
        GoogleCredentials googleCredentials = GoogleCredentials.getApplicationDefault().createScoped(new String[]{"https://www.googleapis.com/auth/cloud-platform"});
        HttpCredentialsAdapter credentialsAdapter = new HttpCredentialsAdapter((Credentials)googleCredentials);
        HttpRequestFactory requestFactory = new NetHttpTransport().createRequestFactory((HttpRequestInitializer)credentialsAdapter);
        String url = String.format("https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/%s:generateIdToken", this.clientEmail);
        GenericData data = new GenericData();
        data.set("audience", (Object)audience);
        data.set("includeEmail", (Object)true);
        UrlEncodedContent content = new UrlEncodedContent((Object)data);
        HttpRequest request = requestFactory.buildPostRequest(new GenericUrl(url), (HttpContent)content);
        JsonObjectParser parser = new JsonObjectParser((JsonFactory)GsonFactory.getDefaultInstance());
        request.setParser((ObjectParser)parser);
        HttpResponse response = request.execute();
        GenericData responseData = (GenericData)response.parseAs(GenericData.class);
        return (String)responseData.get((Object)"token");
    }

    private GenericJson getServiceAccountKeyFileAsJson() throws IOException {
        String credentialsPath = System.getenv("GOOGLE_APPLICATION_CREDENTIALS");
        JsonFactory jsonFactory = OAuth2Utils.JSON_FACTORY;
        JsonObjectParser parser = new JsonObjectParser(jsonFactory);
        return (GenericJson)parser.parseAndClose((InputStream)new FileInputStream(credentialsPath), StandardCharsets.UTF_8, GenericJson.class);
    }

    private String getXmlValueByTagName(String rawXml, String tagName) {
        int startIndex = rawXml.indexOf("<" + tagName + ">");
        int endIndex = rawXml.indexOf("</" + tagName + ">", startIndex);
        if (startIndex >= 0 && endIndex > startIndex) {
            return rawXml.substring(startIndex + tagName.length() + 2, endIndex);
        }
        return null;
    }
}

