/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.auth.oauth2.BaseSerializationTest;
import com.google.auth.oauth2.IdToken;
import java.io.IOException;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IdTokenTest
extends BaseSerializationTest {
    private static final String TOKEN_1 = "eyJhbGciOiJSUzI1NiIsImtpZCI6IjM0OTRiMWU3ODZjZGFkMDkyZTQyMzc2NmJiZTM3ZjU0ZWQ4N2IyMmQiLCJ0eXAiOiJKV1QifQ.eyJpc3MiOiJodHRwczovL2FjY291bnRzLmdvb2dsZS5jb20iLCJhdWQiOiJodHRwczovL2Zvby5iYXIiLCJhenAiOiJzdmMtMi00MjlAbWluZXJhbC1taW51dGlhLTgyMC5pYW0uZ3NlcnZpY2VhY2NvdW50LmNvbSIsInN1YiI6IjEwMDE0NzEwNjk5Njc2NDQ3OTA4NSIsImVtYWlsIjoic3ZjLTItNDI5QG1pbmVyYWwtbWludXRpYS04MjAuaWFtLmdzZXJ2aWNlYWNjb3VudC5jb20iLCJlbWFpbF92ZXJpZmllZCI6dHJ1ZSwiaWF0IjoxNTY1Mzg3NTM4LCJleHAiOjE1NjUzOTExMzh9.foo";
    private static final String TOKEN_2 = "eyJhbGciOiJSUzI1NiIsImtpZCI6IjM0OTRiMWU3ODZjZGFkMDkyZTQyMzc2NmJiZTM3ZjU0ZWQ4N2IyMmQiLCJ0eXAiOiJKV1QifQ.eyJpc3MiOiJodHRwczovL2FjY291bnRzLmdvb2dsZS5jb20iLCJhdWQiOiJodHRwczovL2Jhci5mb28iLCJhenAiOiJzdmMtMi00MjlAbWluZXJhbC1taW51dGlhLTgyMC5pYW0uZ3NlcnZpY2VhY2NvdW50LmNvbSIsInN1YiI6IjEwMDE0NzEwNjk5Njc2NDQ3OTA4NSIsImVtYWlsIjoic3ZjLTItNDI5QG1pbmVyYWwtbWludXRpYS04MjAuaWFtLmdzZXJ2aWNlYWNjb3VudC5jb20iLCJlbWFpbF92ZXJpZmllZCI6dHJ1ZSwiaWF0IjoxNTY1Mzg4NjM0LCJleHAiOjE1NjUzOTIyMzR9.foo";
    private static final String TOKEN_WITH_0x20 = "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJPbmxpbmUgSldUIEJ1aWxkZXIiLCJpYXQiOjE2NjAxNjMxNjAsImV4cCI6MTY5MTY5OTE2MCwiYXVkIjoid3d3LmV4YW1wbGUuY29tIiwic3ViIjoianJvY2tldEBleGFtcGxlLmNvbSIsIkdpdmVuTmFtZSI6ImFibTHag3M0x20ifQ.foo";
    private static final Date EXPIRATION_DATE = new Date(1565391138000L);

    @Test
    public void constructor() throws IOException {
        IdToken idToken = IdToken.create((String)TOKEN_1);
        Assert.assertEquals((Object)TOKEN_1, (Object)idToken.getTokenValue());
        Assert.assertEquals((Object)EXPIRATION_DATE, (Object)idToken.getExpirationTime());
    }

    @Test
    public void equals_true() throws IOException {
        IdToken accessToken = IdToken.create((String)TOKEN_1);
        IdToken otherAccessToken = IdToken.create((String)TOKEN_1);
        Assert.assertTrue((boolean)accessToken.equals((Object)otherAccessToken));
        Assert.assertTrue((boolean)otherAccessToken.equals((Object)accessToken));
    }

    @Test
    public void equals_false_token() throws IOException {
        IdToken accessToken = IdToken.create((String)TOKEN_1);
        IdToken otherAccessToken = IdToken.create((String)TOKEN_2);
        Assert.assertFalse((boolean)accessToken.equals((Object)otherAccessToken));
        Assert.assertFalse((boolean)otherAccessToken.equals((Object)accessToken));
    }

    @Test
    public void toString_test() throws IOException {
        IdToken accessToken = IdToken.create((String)TOKEN_1);
        String expectedToString = String.format("IdToken{tokenValue=%s, JsonWebSignature=JsonWebSignature{header={\"alg\":\"RS256\",\"kid\":\"3494b1e786cdad092e423766bbe37f54ed87b22d\",\"typ\":\"JWT\"}, payload={\"aud\":\"https://foo.bar\",\"exp\":1565391138,\"iat\":1565387538,\"iss\":\"https://accounts.google.com\",\"sub\":\"100147106996764479085\",\"azp\":\"svc-2-429@mineral-minutia-820.iam.gserviceaccount.com\",\"email\":\"svc-2-429@mineral-minutia-820.iam.gserviceaccount.com\",\"email_verified\":true}}}", TOKEN_1);
        Assert.assertEquals((Object)expectedToString, (Object)accessToken.toString());
    }

    @Test
    public void hashCode_equals() throws IOException {
        IdToken accessToken = IdToken.create((String)TOKEN_1);
        IdToken otherAccessToken = IdToken.create((String)TOKEN_1);
        Assert.assertEquals((long)accessToken.hashCode(), (long)otherAccessToken.hashCode());
    }

    @Test
    public void serialize() throws IOException, ClassNotFoundException {
        IdToken accessToken = IdToken.create((String)TOKEN_1);
        IdToken deserializedAccessToken = this.serializeAndDeserialize(accessToken);
        Assert.assertEquals((Object)accessToken, (Object)deserializedAccessToken);
        Assert.assertEquals((long)accessToken.hashCode(), (long)deserializedAccessToken.hashCode());
        Assert.assertEquals((Object)accessToken.toString(), (Object)deserializedAccessToken.toString());
    }

    @Test
    public void token_with_0x20() throws IOException {
        IdToken accessToken = IdToken.create((String)TOKEN_WITH_0x20);
        Assert.assertEquals((Object)TOKEN_WITH_0x20, (Object)accessToken.getTokenValue());
    }
}

