/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.GenericJson;
import com.google.auth.TestUtils;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.ExternalAccountCredentials;
import com.google.auth.oauth2.ExternalAccountCredentialsTest;
import com.google.auth.oauth2.IdentityPoolCredentials;
import com.google.auth.oauth2.MockExternalAccountCredentialsTransport;
import com.google.auth.oauth2.OAuth2Utils;
import com.google.auth.oauth2.SystemEnvironmentProvider;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IdentityPoolCredentialsTest {
    private static final String STS_URL = "https://sts.googleapis.com";
    private static final Map<String, Object> FILE_CREDENTIAL_SOURCE_MAP = new HashMap<String, Object>(){
        {
            this.put("file", "file");
        }
    };
    private static final IdentityPoolCredentials.IdentityPoolCredentialSource FILE_CREDENTIAL_SOURCE = new IdentityPoolCredentials.IdentityPoolCredentialSource(FILE_CREDENTIAL_SOURCE_MAP);
    private static final IdentityPoolCredentials FILE_SOURCED_CREDENTIAL = (IdentityPoolCredentials)IdentityPoolCredentials.newBuilder().setHttpTransportFactory(OAuth2Utils.HTTP_TRANSPORT_FACTORY).setAudience("//iam.googleapis.com/projects/123/locations/global/workloadIdentityPools/pool/providers/provider").setSubjectTokenType("subjectTokenType").setTokenUrl("https://sts.googleapis.com").setTokenInfoUrl("tokenInfoUrl").setCredentialSource((ExternalAccountCredentials.CredentialSource)FILE_CREDENTIAL_SOURCE).build();

    @Test
    public void createdScoped_clonedCredentialWithAddedScopes() {
        IdentityPoolCredentials credentials = (IdentityPoolCredentials)IdentityPoolCredentials.newBuilder((IdentityPoolCredentials)FILE_SOURCED_CREDENTIAL).setServiceAccountImpersonationUrl("https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/testn@test.iam.gserviceaccount.com:generateAccessToken").setQuotaProjectId("quotaProjectId").setClientId("clientId").setClientSecret("clientSecret").build();
        List<String> newScopes = Arrays.asList("scope1", "scope2");
        IdentityPoolCredentials newCredentials = credentials.createScoped(newScopes);
        Assert.assertEquals((Object)credentials.getAudience(), (Object)newCredentials.getAudience());
        Assert.assertEquals((Object)credentials.getSubjectTokenType(), (Object)newCredentials.getSubjectTokenType());
        Assert.assertEquals((Object)credentials.getTokenUrl(), (Object)newCredentials.getTokenUrl());
        Assert.assertEquals((Object)credentials.getTokenInfoUrl(), (Object)newCredentials.getTokenInfoUrl());
        Assert.assertEquals((Object)credentials.getServiceAccountImpersonationUrl(), (Object)newCredentials.getServiceAccountImpersonationUrl());
        Assert.assertEquals((Object)credentials.getCredentialSource(), (Object)newCredentials.getCredentialSource());
        Assert.assertEquals(newScopes, (Object)newCredentials.getScopes());
        Assert.assertEquals((Object)credentials.getQuotaProjectId(), (Object)newCredentials.getQuotaProjectId());
        Assert.assertEquals((Object)credentials.getClientId(), (Object)newCredentials.getClientId());
        Assert.assertEquals((Object)credentials.getClientSecret(), (Object)newCredentials.getClientSecret());
    }

    @Test
    public void retrieveSubjectToken_fileSourced() throws IOException {
        File file = File.createTempFile("RETRIEVE_SUBJECT_TOKEN", null, null);
        file.deleteOnExit();
        String credential = "credential";
        OAuth2Utils.writeInputStreamToFile((InputStream)new ByteArrayInputStream(credential.getBytes(StandardCharsets.UTF_8)), (String)file.getAbsolutePath());
        HashMap<String, String> credentialSourceMap = new HashMap<String, String>();
        credentialSourceMap.put("file", file.getAbsolutePath());
        IdentityPoolCredentials.IdentityPoolCredentialSource credentialSource = new IdentityPoolCredentials.IdentityPoolCredentialSource(credentialSourceMap);
        IdentityPoolCredentials credentials = (IdentityPoolCredentials)IdentityPoolCredentials.newBuilder((IdentityPoolCredentials)FILE_SOURCED_CREDENTIAL).setCredentialSource((ExternalAccountCredentials.CredentialSource)credentialSource).build();
        String subjectToken = credentials.retrieveSubjectToken();
        Assert.assertEquals((Object)credential, (Object)subjectToken);
    }

    @Test
    public void retrieveSubjectToken_fileSourcedWithJsonFormat() throws IOException {
        File file = File.createTempFile("RETRIEVE_SUBJECT_TOKEN", null, null);
        file.deleteOnExit();
        MockExternalAccountCredentialsTransportFactory transportFactory = new MockExternalAccountCredentialsTransportFactory();
        transportFactory.transport.setMetadataServerContentType("json");
        HashMap<String, Object> credentialSourceMap = new HashMap<String, Object>();
        HashMap<String, String> formatMap = new HashMap<String, String>();
        formatMap.put("type", "json");
        formatMap.put("subject_token_field_name", "subjectToken");
        credentialSourceMap.put("file", file.getAbsolutePath());
        credentialSourceMap.put("format", formatMap);
        IdentityPoolCredentials.IdentityPoolCredentialSource credentialSource = new IdentityPoolCredentials.IdentityPoolCredentialSource(credentialSourceMap);
        GenericJson response = new GenericJson();
        response.setFactory(OAuth2Utils.JSON_FACTORY);
        response.put("subjectToken", (Object)"subjectToken");
        OAuth2Utils.writeInputStreamToFile((InputStream)new ByteArrayInputStream(response.toString().getBytes(StandardCharsets.UTF_8)), (String)file.getAbsolutePath());
        IdentityPoolCredentials credential = (IdentityPoolCredentials)IdentityPoolCredentials.newBuilder((IdentityPoolCredentials)FILE_SOURCED_CREDENTIAL).setHttpTransportFactory((HttpTransportFactory)transportFactory).setCredentialSource((ExternalAccountCredentials.CredentialSource)credentialSource).build();
        String subjectToken = credential.retrieveSubjectToken();
        Assert.assertEquals((Object)"subjectToken", (Object)subjectToken);
    }

    @Test
    public void retrieveSubjectToken_fileSourcedWithNullFormat_throws() throws IOException {
        File file = File.createTempFile("RETRIEVE_SUBJECT_TOKEN", null, null);
        file.deleteOnExit();
        HashMap<String, Object> credentialSourceMap = new HashMap<String, Object>();
        HashMap<String, Object> formatMap = new HashMap<String, Object>();
        formatMap.put("type", null);
        credentialSourceMap.put("file", file.getAbsolutePath());
        credentialSourceMap.put("format", formatMap);
        try {
            new IdentityPoolCredentials.IdentityPoolCredentialSource(credentialSourceMap);
            Assert.fail((String)"Exception should be thrown due to null format.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Invalid credential source format type: null.", (Object)e.getMessage());
        }
    }

    @Test
    public void retrieveSubjectToken_noFile_throws() {
        HashMap<String, String> credentialSourceMap = new HashMap<String, String>();
        String path = "badPath";
        credentialSourceMap.put("file", path);
        IdentityPoolCredentials.IdentityPoolCredentialSource credentialSource = new IdentityPoolCredentials.IdentityPoolCredentialSource(credentialSourceMap);
        IdentityPoolCredentials credentials = (IdentityPoolCredentials)IdentityPoolCredentials.newBuilder((IdentityPoolCredentials)FILE_SOURCED_CREDENTIAL).setCredentialSource((ExternalAccountCredentials.CredentialSource)credentialSource).build();
        try {
            credentials.retrieveSubjectToken();
            Assert.fail((String)"Exception should be thrown.");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)String.format("Invalid credential location. The file at %s does not exist.", path), (Object)e.getMessage());
        }
    }

    @Test
    public void retrieveSubjectToken_urlSourced() throws IOException {
        MockExternalAccountCredentialsTransportFactory transportFactory = new MockExternalAccountCredentialsTransportFactory();
        IdentityPoolCredentials credential = (IdentityPoolCredentials)IdentityPoolCredentials.newBuilder((IdentityPoolCredentials)FILE_SOURCED_CREDENTIAL).setHttpTransportFactory((HttpTransportFactory)transportFactory).setCredentialSource((ExternalAccountCredentials.CredentialSource)IdentityPoolCredentialsTest.buildUrlBasedCredentialSource(transportFactory.transport.getMetadataUrl())).build();
        String subjectToken = credential.retrieveSubjectToken();
        Assert.assertEquals((Object)transportFactory.transport.getSubjectToken(), (Object)subjectToken);
    }

    @Test
    public void retrieveSubjectToken_urlSourcedWithJsonFormat() throws IOException {
        MockExternalAccountCredentialsTransportFactory transportFactory = new MockExternalAccountCredentialsTransportFactory();
        transportFactory.transport.setMetadataServerContentType("json");
        HashMap<String, String> formatMap = new HashMap<String, String>();
        formatMap.put("type", "json");
        formatMap.put("subject_token_field_name", "subjectToken");
        IdentityPoolCredentials.IdentityPoolCredentialSource credentialSource = IdentityPoolCredentialsTest.buildUrlBasedCredentialSource(transportFactory.transport.getMetadataUrl(), formatMap);
        IdentityPoolCredentials credential = (IdentityPoolCredentials)IdentityPoolCredentials.newBuilder((IdentityPoolCredentials)FILE_SOURCED_CREDENTIAL).setHttpTransportFactory((HttpTransportFactory)transportFactory).setCredentialSource((ExternalAccountCredentials.CredentialSource)credentialSource).build();
        String subjectToken = credential.retrieveSubjectToken();
        Assert.assertEquals((Object)transportFactory.transport.getSubjectToken(), (Object)subjectToken);
    }

    @Test
    public void retrieveSubjectToken_urlSourcedCredential_throws() {
        MockExternalAccountCredentialsTransportFactory transportFactory = new MockExternalAccountCredentialsTransportFactory();
        IOException response = new IOException();
        transportFactory.transport.addResponseErrorSequence(response);
        IdentityPoolCredentials credential = (IdentityPoolCredentials)IdentityPoolCredentials.newBuilder((IdentityPoolCredentials)FILE_SOURCED_CREDENTIAL).setHttpTransportFactory((HttpTransportFactory)transportFactory).setCredentialSource((ExternalAccountCredentials.CredentialSource)IdentityPoolCredentialsTest.buildUrlBasedCredentialSource(transportFactory.transport.getMetadataUrl())).build();
        try {
            credential.retrieveSubjectToken();
            Assert.fail((String)"Exception should be thrown.");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)String.format("Error getting subject token from metadata server: %s", response.getMessage()), (Object)e.getMessage());
        }
    }

    @Test
    public void refreshAccessToken_withoutServiceAccountImpersonation() throws IOException {
        MockExternalAccountCredentialsTransportFactory transportFactory = new MockExternalAccountCredentialsTransportFactory();
        IdentityPoolCredentials credential = (IdentityPoolCredentials)IdentityPoolCredentials.newBuilder((IdentityPoolCredentials)FILE_SOURCED_CREDENTIAL).setTokenUrl(transportFactory.transport.getStsUrl()).setHttpTransportFactory((HttpTransportFactory)transportFactory).setCredentialSource((ExternalAccountCredentials.CredentialSource)IdentityPoolCredentialsTest.buildUrlBasedCredentialSource(transportFactory.transport.getMetadataUrl())).build();
        AccessToken accessToken = credential.refreshAccessToken();
        Assert.assertEquals((Object)transportFactory.transport.getAccessToken(), (Object)accessToken.getTokenValue());
    }

    @Test
    public void refreshAccessToken_internalOptionsSet() throws IOException {
        MockExternalAccountCredentialsTransportFactory transportFactory = new MockExternalAccountCredentialsTransportFactory();
        IdentityPoolCredentials credential = (IdentityPoolCredentials)IdentityPoolCredentials.newBuilder((IdentityPoolCredentials)FILE_SOURCED_CREDENTIAL).setWorkforcePoolUserProject("userProject").setAudience("//iam.googleapis.com/locations/global/workforcePools/pool/providers/provider").setTokenUrl(transportFactory.transport.getStsUrl()).setHttpTransportFactory((HttpTransportFactory)transportFactory).setCredentialSource((ExternalAccountCredentials.CredentialSource)IdentityPoolCredentialsTest.buildUrlBasedCredentialSource(transportFactory.transport.getMetadataUrl())).build();
        AccessToken accessToken = credential.refreshAccessToken();
        Assert.assertEquals((Object)transportFactory.transport.getAccessToken(), (Object)accessToken.getTokenValue());
        Map<String, String> query = TestUtils.parseQuery(transportFactory.transport.getLastRequest().getContentAsString());
        Assert.assertNotNull((Object)query.get("options"));
        GenericJson expectedInternalOptions = new GenericJson();
        expectedInternalOptions.setFactory(OAuth2Utils.JSON_FACTORY);
        expectedInternalOptions.put("userProject", (Object)"userProject");
        Assert.assertEquals((Object)expectedInternalOptions.toString(), (Object)query.get("options"));
    }

    @Test
    public void refreshAccessToken_withServiceAccountImpersonation() throws IOException {
        MockExternalAccountCredentialsTransportFactory transportFactory = new MockExternalAccountCredentialsTransportFactory();
        transportFactory.transport.setExpireTime(TestUtils.getDefaultExpireTime());
        IdentityPoolCredentials credential = (IdentityPoolCredentials)IdentityPoolCredentials.newBuilder((IdentityPoolCredentials)FILE_SOURCED_CREDENTIAL).setTokenUrl(transportFactory.transport.getStsUrl()).setServiceAccountImpersonationUrl(transportFactory.transport.getServiceAccountImpersonationUrl()).setHttpTransportFactory((HttpTransportFactory)transportFactory).setCredentialSource((ExternalAccountCredentials.CredentialSource)IdentityPoolCredentialsTest.buildUrlBasedCredentialSource(transportFactory.transport.getMetadataUrl())).build();
        AccessToken accessToken = credential.refreshAccessToken();
        Assert.assertEquals((Object)transportFactory.transport.getServiceAccountAccessToken(), (Object)accessToken.getTokenValue());
    }

    @Test
    public void refreshAccessToken_withServiceAccountImpersonationOptions() throws IOException {
        MockExternalAccountCredentialsTransportFactory transportFactory = new MockExternalAccountCredentialsTransportFactory();
        transportFactory.transport.setExpireTime(TestUtils.getDefaultExpireTime());
        IdentityPoolCredentials credential = (IdentityPoolCredentials)IdentityPoolCredentials.newBuilder((IdentityPoolCredentials)FILE_SOURCED_CREDENTIAL).setTokenUrl(transportFactory.transport.getStsUrl()).setServiceAccountImpersonationUrl(transportFactory.transport.getServiceAccountImpersonationUrl()).setHttpTransportFactory((HttpTransportFactory)transportFactory).setCredentialSource((ExternalAccountCredentials.CredentialSource)IdentityPoolCredentialsTest.buildUrlBasedCredentialSource(transportFactory.transport.getMetadataUrl())).setServiceAccountImpersonationOptions(ExternalAccountCredentialsTest.buildServiceAccountImpersonationOptions(2800)).build();
        AccessToken accessToken = credential.refreshAccessToken();
        Assert.assertEquals((Object)transportFactory.transport.getServiceAccountAccessToken(), (Object)accessToken.getTokenValue());
        GenericJson query = (GenericJson)OAuth2Utils.JSON_FACTORY.createJsonParser(transportFactory.transport.getLastRequest().getContentAsString()).parseAndClose(GenericJson.class);
        Assert.assertEquals((Object)"2800s", (Object)query.get((Object)"lifetime"));
    }

    @Test
    public void refreshAccessToken_workforceWithServiceAccountImpersonation() throws IOException {
        MockExternalAccountCredentialsTransportFactory transportFactory = new MockExternalAccountCredentialsTransportFactory();
        transportFactory.transport.setExpireTime(TestUtils.getDefaultExpireTime());
        IdentityPoolCredentials credential = (IdentityPoolCredentials)IdentityPoolCredentials.newBuilder((IdentityPoolCredentials)FILE_SOURCED_CREDENTIAL).setAudience("//iam.googleapis.com/locations/global/workforcePools/pool/providers/provider").setTokenUrl(transportFactory.transport.getStsUrl()).setServiceAccountImpersonationUrl(transportFactory.transport.getServiceAccountImpersonationUrl()).setHttpTransportFactory((HttpTransportFactory)transportFactory).setCredentialSource((ExternalAccountCredentials.CredentialSource)IdentityPoolCredentialsTest.buildUrlBasedCredentialSource(transportFactory.transport.getMetadataUrl())).setWorkforcePoolUserProject("userProject").build();
        AccessToken accessToken = credential.refreshAccessToken();
        Assert.assertEquals((Object)transportFactory.transport.getServiceAccountAccessToken(), (Object)accessToken.getTokenValue());
        Map<String, String> query = TestUtils.parseQuery(transportFactory.transport.getStsContent());
        GenericJson expectedInternalOptions = new GenericJson();
        expectedInternalOptions.setFactory(OAuth2Utils.JSON_FACTORY);
        expectedInternalOptions.put("userProject", (Object)"userProject");
        Assert.assertNotNull((Object)query.get("options"));
        Assert.assertEquals((Object)expectedInternalOptions.toString(), (Object)query.get("options"));
    }

    @Test
    public void refreshAccessToken_workforceWithServiceAccountImpersonationOptions() throws IOException {
        MockExternalAccountCredentialsTransportFactory transportFactory = new MockExternalAccountCredentialsTransportFactory();
        transportFactory.transport.setExpireTime(TestUtils.getDefaultExpireTime());
        IdentityPoolCredentials credential = (IdentityPoolCredentials)IdentityPoolCredentials.newBuilder((IdentityPoolCredentials)FILE_SOURCED_CREDENTIAL).setAudience("//iam.googleapis.com/locations/global/workforcePools/pool/providers/provider").setTokenUrl(transportFactory.transport.getStsUrl()).setServiceAccountImpersonationUrl(transportFactory.transport.getServiceAccountImpersonationUrl()).setHttpTransportFactory((HttpTransportFactory)transportFactory).setCredentialSource((ExternalAccountCredentials.CredentialSource)IdentityPoolCredentialsTest.buildUrlBasedCredentialSource(transportFactory.transport.getMetadataUrl())).setWorkforcePoolUserProject("userProject").setServiceAccountImpersonationOptions(ExternalAccountCredentialsTest.buildServiceAccountImpersonationOptions(2800)).build();
        AccessToken accessToken = credential.refreshAccessToken();
        Assert.assertEquals((Object)transportFactory.transport.getServiceAccountAccessToken(), (Object)accessToken.getTokenValue());
        GenericJson query = (GenericJson)OAuth2Utils.JSON_FACTORY.createJsonParser(transportFactory.transport.getLastRequest().getContentAsString()).parseAndClose(GenericJson.class);
        Assert.assertEquals((Object)"2800s", (Object)query.get((Object)"lifetime"));
    }

    @Test
    public void identityPoolCredentialSource_validFormats() {
        HashMap<String, Object> credentialSourceMapWithFileTextSource = new HashMap<String, Object>();
        HashMap<String, Object> credentialSourceMapWithFileJsonTextSource = new HashMap<String, Object>();
        HashMap<String, Object> credentialSourceMapWithUrlTextSource = new HashMap<String, Object>();
        HashMap<String, Object> credentialSourceMapWithUrlJsonTextSource = new HashMap<String, Object>();
        credentialSourceMapWithFileTextSource.put("file", "/path/to/file");
        credentialSourceMapWithFileJsonTextSource.put("file", "/path/to/file");
        credentialSourceMapWithUrlTextSource.put("url", "https://google.com");
        credentialSourceMapWithUrlJsonTextSource.put("url", "https://google.com");
        HashMap<String, String> headersMap = new HashMap<String, String>();
        headersMap.put("header1", "value1");
        headersMap.put("header2", "value2");
        credentialSourceMapWithUrlTextSource.put("headers", headersMap);
        credentialSourceMapWithUrlJsonTextSource.put("headers", headersMap);
        HashMap<String, String> textFormat = new HashMap<String, String>();
        textFormat.put("type", "text");
        HashMap<String, String> jsonTextFormat = new HashMap<String, String>();
        jsonTextFormat.put("type", "json");
        jsonTextFormat.put("subject_token_field_name", "access_token");
        credentialSourceMapWithFileTextSource.put("format", textFormat);
        credentialSourceMapWithFileJsonTextSource.put("format", jsonTextFormat);
        credentialSourceMapWithUrlTextSource.put("format", textFormat);
        credentialSourceMapWithUrlJsonTextSource.put("format", jsonTextFormat);
        List<Map> sources = Arrays.asList(credentialSourceMapWithFileTextSource, credentialSourceMapWithFileJsonTextSource, credentialSourceMapWithUrlTextSource, credentialSourceMapWithUrlJsonTextSource);
        for (Map source : sources) {
            new IdentityPoolCredentials.IdentityPoolCredentialSource(source);
        }
    }

    @Test
    public void identityPoolCredentialSource_caseInsensitive() {
        HashMap<String, Object> credentialSourceMapWithFileTextSource = new HashMap<String, Object>();
        HashMap<String, Object> credentialSourceMapWithFileJsonTextSource = new HashMap<String, Object>();
        HashMap<String, Object> credentialSourceMapWithUrlTextSource = new HashMap<String, Object>();
        HashMap<String, Object> credentialSourceMapWithUrlJsonTextSource = new HashMap<String, Object>();
        credentialSourceMapWithFileTextSource.put("file", "/path/to/file");
        credentialSourceMapWithFileJsonTextSource.put("file", "/path/to/file");
        credentialSourceMapWithUrlTextSource.put("url", "https://google.com");
        credentialSourceMapWithUrlJsonTextSource.put("url", "https://google.com");
        HashMap<String, String> headersMap = new HashMap<String, String>();
        headersMap.put("HeaDer1", "Value1");
        headersMap.put("HeaDer2", "Value2");
        credentialSourceMapWithUrlTextSource.put("headers", headersMap);
        credentialSourceMapWithUrlJsonTextSource.put("headers", headersMap);
        HashMap<String, String> textFormat = new HashMap<String, String>();
        textFormat.put("type", "TEXT");
        HashMap<String, String> jsonTextFormat = new HashMap<String, String>();
        jsonTextFormat.put("type", "JSON");
        jsonTextFormat.put("subject_token_field_name", "access_token");
        credentialSourceMapWithFileTextSource.put("format", textFormat);
        credentialSourceMapWithFileJsonTextSource.put("format", jsonTextFormat);
        credentialSourceMapWithUrlTextSource.put("format", textFormat);
        credentialSourceMapWithUrlJsonTextSource.put("format", jsonTextFormat);
        List<Map> sources = Arrays.asList(credentialSourceMapWithFileTextSource, credentialSourceMapWithFileJsonTextSource, credentialSourceMapWithUrlTextSource, credentialSourceMapWithUrlJsonTextSource);
        for (Map source : sources) {
            new IdentityPoolCredentials.IdentityPoolCredentialSource(source);
        }
    }

    @Test
    public void identityPoolCredentialSource_invalidSourceType() {
        try {
            new IdentityPoolCredentials.IdentityPoolCredentialSource(new HashMap());
            Assert.fail((String)"Should not be able to continue without exception.");
        }
        catch (IllegalArgumentException exception) {
            Assert.assertEquals((Object)"Missing credential source file location or URL. At least one must be specified.", (Object)exception.getMessage());
        }
    }

    @Test
    public void identityPoolCredentialSource_invalidFormatType() {
        HashMap<String, Object> credentialSourceMap = new HashMap<String, Object>();
        credentialSourceMap.put("url", "url");
        HashMap<String, String> format = new HashMap<String, String>();
        format.put("type", "unsupportedType");
        credentialSourceMap.put("format", format);
        try {
            new IdentityPoolCredentials.IdentityPoolCredentialSource(credentialSourceMap);
            Assert.fail((String)"Exception should be thrown.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Invalid credential source format type: unsupportedType.", (Object)e.getMessage());
        }
    }

    @Test
    public void identityPoolCredentialSource_nullFormatType() {
        HashMap<String, Object> credentialSourceMap = new HashMap<String, Object>();
        credentialSourceMap.put("url", "url");
        HashMap<String, Object> format = new HashMap<String, Object>();
        format.put("type", null);
        credentialSourceMap.put("format", format);
        try {
            new IdentityPoolCredentials.IdentityPoolCredentialSource(credentialSourceMap);
            Assert.fail((String)"Exception should be thrown.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Invalid credential source format type: null.", (Object)e.getMessage());
        }
    }

    @Test
    public void identityPoolCredentialSource_subjectTokenFieldNameUnset() {
        HashMap<String, Object> credentialSourceMap = new HashMap<String, Object>();
        credentialSourceMap.put("url", "url");
        HashMap<String, String> format = new HashMap<String, String>();
        format.put("type", "json");
        credentialSourceMap.put("format", format);
        try {
            new IdentityPoolCredentials.IdentityPoolCredentialSource(credentialSourceMap);
            Assert.fail((String)"Exception should be thrown.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"When specifying a JSON credential type, the subject_token_field_name must be set.", (Object)e.getMessage());
        }
    }

    @Test
    public void builder() {
        List<String> scopes = Arrays.asList("scope1", "scope2");
        IdentityPoolCredentials credentials = (IdentityPoolCredentials)IdentityPoolCredentials.newBuilder().setHttpTransportFactory(OAuth2Utils.HTTP_TRANSPORT_FACTORY).setAudience("audience").setSubjectTokenType("subjectTokenType").setTokenUrl(STS_URL).setTokenInfoUrl("tokenInfoUrl").setCredentialSource((ExternalAccountCredentials.CredentialSource)FILE_CREDENTIAL_SOURCE).setServiceAccountImpersonationUrl("https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/testn@test.iam.gserviceaccount.com:generateAccessToken").setQuotaProjectId("quotaProjectId").setClientId("clientId").setClientSecret("clientSecret").setScopes(scopes).build();
        Assert.assertEquals((Object)"audience", (Object)credentials.getAudience());
        Assert.assertEquals((Object)"subjectTokenType", (Object)credentials.getSubjectTokenType());
        Assert.assertEquals((Object)credentials.getTokenUrl(), (Object)STS_URL);
        Assert.assertEquals((Object)credentials.getTokenInfoUrl(), (Object)"tokenInfoUrl");
        Assert.assertEquals((Object)credentials.getServiceAccountImpersonationUrl(), (Object)"https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/testn@test.iam.gserviceaccount.com:generateAccessToken");
        Assert.assertEquals((Object)credentials.getCredentialSource(), (Object)FILE_CREDENTIAL_SOURCE);
        Assert.assertEquals((Object)credentials.getQuotaProjectId(), (Object)"quotaProjectId");
        Assert.assertEquals((Object)credentials.getClientId(), (Object)"clientId");
        Assert.assertEquals((Object)credentials.getClientSecret(), (Object)"clientSecret");
        Assert.assertEquals((Object)credentials.getScopes(), scopes);
        Assert.assertEquals((Object)credentials.getEnvironmentProvider(), (Object)SystemEnvironmentProvider.getInstance());
    }

    @Test
    public void builder_invalidWorkforceAudiences_throws() {
        List<String> invalidAudiences = Arrays.asList("", "//iam.googleapis.com/projects/x23/locations/global/workloadIdentityPools/pool/providers/provider", "//iam.googleapis.com/locations/global/workforcepools/pool/providers/provider", "//iam.googleapis.com/locations/global/workforcePools/providers/provider", "//iam.googleapis.com/locations/global/workforcePools/providers", "//iam.googleapis.com/locations/global/workforcePools/", "//iam.googleapis.com/locations//workforcePools/providers", "//iam.googleapis.com/notlocations/global/workforcePools/providers", "//iam.googleapis.com/locations/global/workforce/providers");
        for (String audience : invalidAudiences) {
            try {
                IdentityPoolCredentials.newBuilder().setWorkforcePoolUserProject("workforcePoolUserProject").setHttpTransportFactory(OAuth2Utils.HTTP_TRANSPORT_FACTORY).setAudience(audience).setSubjectTokenType("subjectTokenType").setTokenUrl(STS_URL).setTokenInfoUrl("tokenInfoUrl").setCredentialSource((ExternalAccountCredentials.CredentialSource)FILE_CREDENTIAL_SOURCE).setQuotaProjectId("quotaProjectId").build();
                Assert.fail((String)"Exception should be thrown.");
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((Object)"The workforce_pool_user_project parameter should only be provided for a Workforce Pool configuration.", (Object)e.getMessage());
            }
        }
    }

    @Test
    public void builder_emptyWorkforceUserProjectWithWorkforceAudience() {
        IdentityPoolCredentials credentials = (IdentityPoolCredentials)IdentityPoolCredentials.newBuilder().setWorkforcePoolUserProject("").setHttpTransportFactory(OAuth2Utils.HTTP_TRANSPORT_FACTORY).setAudience("//iam.googleapis.com/locations/global/workforcePools/pool/providers/provider").setSubjectTokenType("subjectTokenType").setTokenUrl(STS_URL).setTokenInfoUrl("tokenInfoUrl").setCredentialSource((ExternalAccountCredentials.CredentialSource)FILE_CREDENTIAL_SOURCE).setQuotaProjectId("quotaProjectId").build();
        Assert.assertTrue((boolean)credentials.isWorkforcePoolConfiguration());
    }

    static InputStream writeIdentityPoolCredentialsStream(String tokenUrl, String url, @Nullable String serviceAccountImpersonationUrl, @Nullable Map<String, Object> serviceAccountImpersonationOptionsMap) throws IOException {
        GenericJson json = new GenericJson();
        json.put("audience", (Object)"audience");
        json.put("subject_token_type", (Object)"subjectTokenType");
        json.put("token_url", (Object)tokenUrl);
        json.put("token_info_url", (Object)"tokenInfoUrl");
        json.put("type", (Object)"external_account");
        if (serviceAccountImpersonationUrl != null) {
            json.put("service_account_impersonation_url", (Object)serviceAccountImpersonationUrl);
        }
        if (serviceAccountImpersonationOptionsMap != null) {
            json.put("service_account_impersonation", serviceAccountImpersonationOptionsMap);
        }
        GenericJson credentialSource = new GenericJson();
        GenericJson headers = new GenericJson();
        headers.put("Metadata-Flavor", (Object)"Google");
        credentialSource.put("url", (Object)url);
        credentialSource.put("headers", (Object)headers);
        json.put("credential_source", (Object)credentialSource);
        return TestUtils.jsonToInputStream(json);
    }

    private static IdentityPoolCredentials.IdentityPoolCredentialSource buildUrlBasedCredentialSource(String url) {
        return IdentityPoolCredentialsTest.buildUrlBasedCredentialSource(url, null);
    }

    private static IdentityPoolCredentials.IdentityPoolCredentialSource buildUrlBasedCredentialSource(String url, Map<String, String> formatMap) {
        HashMap<String, Object> credentialSourceMap = new HashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Metadata-Flavor", "Google");
        credentialSourceMap.put("url", url);
        credentialSourceMap.put("headers", headers);
        credentialSourceMap.put("format", formatMap);
        return new IdentityPoolCredentials.IdentityPoolCredentialSource(credentialSourceMap);
    }

    static class MockExternalAccountCredentialsTransportFactory
    implements HttpTransportFactory {
        MockExternalAccountCredentialsTransport transport = new MockExternalAccountCredentialsTransport();

        MockExternalAccountCredentialsTransportFactory() {
        }

        public HttpTransport create() {
            return this.transport;
        }
    }
}

