/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.auth.oauth2.JwtClaims;
import java.util.Collections;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class JwtClaimsTest {
    @Test
    public void testMergeOverwritesFields() {
        JwtClaims claims1 = JwtClaims.newBuilder().setAudience("audience-1").setIssuer("issuer-1").setSubject("subject-1").build();
        JwtClaims claims2 = JwtClaims.newBuilder().setAudience("audience-2").setIssuer("issuer-2").setSubject("subject-2").build();
        JwtClaims merged = claims1.merge(claims2);
        Assert.assertEquals((Object)"audience-2", (Object)merged.getAudience());
        Assert.assertEquals((Object)"issuer-2", (Object)merged.getIssuer());
        Assert.assertEquals((Object)"subject-2", (Object)merged.getSubject());
    }

    @Test
    public void testMergeDefaultValues() {
        JwtClaims claims1 = JwtClaims.newBuilder().setAudience("audience-1").setIssuer("issuer-1").setSubject("subject-1").build();
        JwtClaims claims2 = JwtClaims.newBuilder().setAudience("audience-2").build();
        JwtClaims merged = claims1.merge(claims2);
        Assert.assertEquals((Object)"audience-2", (Object)merged.getAudience());
        Assert.assertEquals((Object)"issuer-1", (Object)merged.getIssuer());
        Assert.assertEquals((Object)"subject-1", (Object)merged.getSubject());
    }

    @Test
    public void testMergeNull() {
        JwtClaims claims1 = JwtClaims.newBuilder().build();
        JwtClaims claims2 = JwtClaims.newBuilder().build();
        JwtClaims merged = claims1.merge(claims2);
        Assert.assertNull((Object)merged.getAudience());
        Assert.assertNull((Object)merged.getIssuer());
        Assert.assertNull((Object)merged.getSubject());
        Assert.assertNotNull((Object)merged.getAdditionalClaims());
        Assert.assertTrue((boolean)merged.getAdditionalClaims().isEmpty());
    }

    @Test
    public void testEquals() {
        JwtClaims claims1 = JwtClaims.newBuilder().setAudience("audience-1").setIssuer("issuer-1").setSubject("subject-1").build();
        JwtClaims claims2 = JwtClaims.newBuilder().setAudience("audience-1").setIssuer("issuer-1").setSubject("subject-1").build();
        Assert.assertEquals((Object)claims1, (Object)claims2);
    }

    @Test
    public void testAdditionalClaimsDefaults() {
        JwtClaims claims = JwtClaims.newBuilder().build();
        Assert.assertNotNull((Object)claims.getAdditionalClaims());
        Assert.assertTrue((boolean)claims.getAdditionalClaims().isEmpty());
    }

    @Test
    public void testMergeAdditionalClaims() {
        JwtClaims claims1 = JwtClaims.newBuilder().setAdditionalClaims(Collections.singletonMap("foo", "bar")).build();
        JwtClaims claims2 = JwtClaims.newBuilder().setAdditionalClaims(Collections.singletonMap("asdf", "qwer")).build();
        JwtClaims merged = claims1.merge(claims2);
        Assert.assertNull((Object)merged.getAudience());
        Assert.assertNull((Object)merged.getIssuer());
        Assert.assertNull((Object)merged.getSubject());
        Map mergedAdditionalClaims = merged.getAdditionalClaims();
        Assert.assertNotNull((Object)mergedAdditionalClaims);
        Assert.assertEquals((long)2L, (long)mergedAdditionalClaims.size());
        Assert.assertEquals((Object)"bar", mergedAdditionalClaims.get("foo"));
        Assert.assertEquals((Object)"qwer", mergedAdditionalClaims.get("asdf"));
    }

    @Test
    public void testIsComplete() {
        JwtClaims claims = JwtClaims.newBuilder().setIssuer("issuer-1").setSubject("subject-1").setAdditionalClaims(Collections.singletonMap("scope", "foo")).build();
        Assert.assertTrue((boolean)claims.isComplete());
    }
}

