/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.auth.TestUtils;
import cz.o2.proxima.internal.shaded.com.google.common.base.Joiner;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.junit.Assert;

public final class MockStsTransport
extends MockHttpTransport {
    private static final String EXPECTED_GRANT_TYPE = "urn:ietf:params:oauth:grant-type:token-exchange";
    private static final String ISSUED_TOKEN_TYPE = "urn:ietf:params:oauth:token-type:access_token";
    private static final String STS_URL = "https://sts.googleapis.com/v1/token";
    private static final String ACCESS_TOKEN = "accessToken";
    private static final String TOKEN_TYPE = "Bearer";
    private static final Long EXPIRES_IN = 3600L;
    private final Queue<IOException> responseErrorSequence = new ArrayDeque<IOException>();
    private final Queue<List<String>> scopeSequence = new ArrayDeque<List<String>>();
    private final Queue<String> refreshTokenSequence = new ArrayDeque<String>();
    private boolean returnExpiresIn = true;
    private MockLowLevelHttpRequest request;

    public void addResponseErrorSequence(IOException ... errors) {
        Collections.addAll(this.responseErrorSequence, errors);
    }

    public void addRefreshTokenSequence(String ... refreshTokens) {
        Collections.addAll(this.refreshTokenSequence, refreshTokens);
    }

    public void addScopeSequence(List<String> scopes) {
        Collections.addAll(this.scopeSequence, scopes);
    }

    public LowLevelHttpRequest buildRequest(String method, final String url) {
        this.request = new MockLowLevelHttpRequest(url){

            public LowLevelHttpResponse execute() throws IOException {
                if (!MockStsTransport.STS_URL.equals(url)) {
                    return MockStsTransport.this.makeErrorResponse();
                }
                if (!MockStsTransport.this.responseErrorSequence.isEmpty()) {
                    throw (IOException)MockStsTransport.this.responseErrorSequence.poll();
                }
                Map<String, String> query = TestUtils.parseQuery(this.getContentAsString());
                Assert.assertEquals((Object)MockStsTransport.EXPECTED_GRANT_TYPE, (Object)query.get("grant_type"));
                Assert.assertNotNull((Object)query.get("subject_token_type"));
                Assert.assertNotNull((Object)query.get("subject_token"));
                GenericJson response = new GenericJson();
                response.setFactory((JsonFactory)new GsonFactory());
                response.put("token_type", (Object)MockStsTransport.TOKEN_TYPE);
                response.put("access_token", (Object)MockStsTransport.ACCESS_TOKEN);
                response.put("issued_token_type", (Object)MockStsTransport.ISSUED_TOKEN_TYPE);
                if (MockStsTransport.this.returnExpiresIn) {
                    response.put("expires_in", (Object)EXPIRES_IN);
                }
                if (!MockStsTransport.this.refreshTokenSequence.isEmpty()) {
                    response.put("refresh_token", MockStsTransport.this.refreshTokenSequence.poll());
                }
                if (!MockStsTransport.this.scopeSequence.isEmpty()) {
                    response.put("scope", (Object)Joiner.on((char)' ').join((Iterable)MockStsTransport.this.scopeSequence.poll()));
                }
                return new MockLowLevelHttpResponse().setContentType("application/json; charset=UTF-8").setContent(response.toPrettyString());
            }
        };
        return this.request;
    }

    private MockLowLevelHttpResponse makeErrorResponse() {
        MockLowLevelHttpResponse errorResponse = new MockLowLevelHttpResponse();
        errorResponse.setStatusCode(400);
        errorResponse.setContentType("application/json; charset=UTF-8");
        errorResponse.setContent("{\"error\":\"error\"}");
        return errorResponse;
    }

    public MockLowLevelHttpRequest getRequest() {
        return this.request;
    }

    public String getAccessToken() {
        return ACCESS_TOKEN;
    }

    public String getTokenType() {
        return TOKEN_TYPE;
    }

    public String getIssuedTokenType() {
        return ISSUED_TOKEN_TYPE;
    }

    public Long getExpiresIn() {
        return EXPIRES_IN;
    }

    public void setReturnExpiresIn(boolean returnExpiresIn) {
        this.returnExpiresIn = returnExpiresIn;
    }
}

