/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.auth.TestUtils;
import com.google.auth.oauth2.OAuth2Utils;
import cz.o2.proxima.internal.shaded.com.google.common.util.concurrent.Futures;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class MockTokenServerTransport
extends MockHttpTransport {
    public static final String REFRESH_TOKEN_WITH_USER_SCOPE = "refresh_token_with_user.email_scope";
    static final String EXPECTED_GRANT_TYPE = "urn:ietf:params:oauth:grant-type:jwt-bearer";
    static final JsonFactory JSON_FACTORY = new GsonFactory();
    int buildRequestCount;
    final Map<String, String> clients = new HashMap<String, String>();
    final Map<String, String> refreshTokens = new HashMap<String, String>();
    final Map<String, String> serviceAccounts = new HashMap<String, String>();
    final Map<String, String> codes = new HashMap<String, String>();
    URI tokenServerUri = OAuth2Utils.TOKEN_SERVER_URI;
    private IOException error;
    private final Queue<Future<LowLevelHttpResponse>> responseSequence = new ArrayDeque<Future<LowLevelHttpResponse>>();
    private int expiresInSeconds = 3600;

    public URI getTokenServerUri() {
        return this.tokenServerUri;
    }

    public void setTokenServerUri(URI tokenServerUri) {
        this.tokenServerUri = tokenServerUri;
    }

    public void addAuthorizationCode(String code, String refreshToken, String accessToken) {
        this.codes.put(code, refreshToken);
        this.refreshTokens.put(refreshToken, accessToken);
    }

    public void addClient(String clientId, String clientSecret) {
        this.clients.put(clientId, clientSecret);
    }

    public void addRefreshToken(String refreshToken, String accessTokenToReturn) {
        this.refreshTokens.put(refreshToken, accessTokenToReturn);
    }

    public void addServiceAccount(String email, String accessToken) {
        this.serviceAccounts.put(email, accessToken);
    }

    public String getAccessToken(String refreshToken) {
        return this.refreshTokens.get(refreshToken);
    }

    public void setError(IOException error) {
        this.error = error;
    }

    public void addResponseErrorSequence(IOException ... errors) {
        for (IOException error : errors) {
            this.responseSequence.add((Future<LowLevelHttpResponse>)Futures.immediateFailedFuture((Throwable)error));
        }
    }

    public void addResponseSequence(LowLevelHttpResponse ... responses) {
        for (LowLevelHttpResponse response : responses) {
            this.responseSequence.add((Future<LowLevelHttpResponse>)Futures.immediateFuture((Object)response));
        }
    }

    public void addResponseSequence(Future<LowLevelHttpResponse> response) {
        this.responseSequence.add(response);
    }

    public void setExpiresInSeconds(int expiresInSeconds) {
        this.expiresInSeconds = expiresInSeconds;
    }

    public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
        String query;
        ++this.buildRequestCount;
        if (this.error != null) {
            throw this.error;
        }
        int questionMarkPos = url.indexOf(63);
        String urlWithoutQuery = questionMarkPos > 0 ? url.substring(0, questionMarkPos) : url;
        String string = query = questionMarkPos > 0 ? url.substring(questionMarkPos + 1) : "";
        if (!this.responseSequence.isEmpty()) {
            return new MockLowLevelHttpRequest(url){

                public LowLevelHttpResponse execute() throws IOException {
                    try {
                        return (LowLevelHttpResponse)((Future)MockTokenServerTransport.this.responseSequence.poll()).get();
                    }
                    catch (ExecutionException e) {
                        Throwable cause = e.getCause();
                        throw (IOException)cause;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException("Unexpectedly interrupted");
                    }
                }
            };
        }
        if (urlWithoutQuery.equals(this.tokenServerUri.toString())) {
            return new MockLowLevelHttpRequest(url){

                public LowLevelHttpResponse execute() throws IOException {
                    String accessToken;
                    if (!MockTokenServerTransport.this.responseSequence.isEmpty()) {
                        try {
                            return (LowLevelHttpResponse)((Future)MockTokenServerTransport.this.responseSequence.poll()).get();
                        }
                        catch (ExecutionException e) {
                            Throwable cause = e.getCause();
                            throw (IOException)cause;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new RuntimeException("Unexpectedly interrupted");
                        }
                    }
                    String content = this.getContentAsString();
                    Map<String, String> query = TestUtils.parseQuery(content);
                    String refreshToken = null;
                    boolean generateAccessToken = true;
                    String foundId = query.get("client_id");
                    boolean isUserEmailScope = false;
                    if (foundId != null) {
                        if (!MockTokenServerTransport.this.clients.containsKey(foundId)) {
                            throw new IOException("Client ID not found.");
                        }
                        String foundSecret = query.get("client_secret");
                        String expectedSecret = MockTokenServerTransport.this.clients.get(foundId);
                        if (foundSecret == null || !foundSecret.equals(expectedSecret)) {
                            throw new IOException("Client secret not found.");
                        }
                        String grantType = query.get("grant_type");
                        if (grantType != null && grantType.equals("authorization_code")) {
                            String foundCode = query.get("code");
                            if (!MockTokenServerTransport.this.codes.containsKey(foundCode)) {
                                throw new IOException("Authorization code not found");
                            }
                            refreshToken = MockTokenServerTransport.this.codes.get(foundCode);
                        } else {
                            refreshToken = query.get("refresh_token");
                        }
                        if (!MockTokenServerTransport.this.refreshTokens.containsKey(refreshToken)) {
                            throw new IOException("Refresh Token not found.");
                        }
                        if (refreshToken.equals(MockTokenServerTransport.REFRESH_TOKEN_WITH_USER_SCOPE)) {
                            isUserEmailScope = true;
                        }
                        accessToken = MockTokenServerTransport.this.refreshTokens.get(refreshToken);
                    } else if (query.containsKey("grant_type")) {
                        String grantType = query.get("grant_type");
                        if (!MockTokenServerTransport.EXPECTED_GRANT_TYPE.equals(grantType)) {
                            throw new IOException("Unexpected Grant Type.");
                        }
                        String assertion = query.get("assertion");
                        JsonWebSignature signature = JsonWebSignature.parse((JsonFactory)JSON_FACTORY, (String)assertion);
                        String foundEmail = signature.getPayload().getIssuer();
                        if (!MockTokenServerTransport.this.serviceAccounts.containsKey(foundEmail)) {
                            throw new IOException("Service Account Email not found as issuer.");
                        }
                        accessToken = MockTokenServerTransport.this.serviceAccounts.get(foundEmail);
                        String foundTargetAudience = (String)signature.getPayload().get((Object)"target_audience");
                        String foundScopes = (String)signature.getPayload().get((Object)"scope");
                        if (!(foundScopes != null && foundScopes.length() != 0 || foundTargetAudience != null && foundTargetAudience.length() != 0)) {
                            throw new IOException("Either target_audience or scopes must be specified.");
                        }
                        if (foundScopes != null && foundTargetAudience != null) {
                            throw new IOException("Only one of target_audience or scopes must be specified.");
                        }
                        if (foundTargetAudience != null) {
                            generateAccessToken = false;
                        }
                    } else {
                        throw new IOException("Unknown token type.");
                    }
                    GenericJson responseContents = new GenericJson();
                    responseContents.setFactory(JSON_FACTORY);
                    responseContents.put("token_type", (Object)"Bearer");
                    responseContents.put("expires_in", (Object)MockTokenServerTransport.this.expiresInSeconds);
                    if (generateAccessToken) {
                        responseContents.put("access_token", (Object)accessToken);
                        if (refreshToken != null) {
                            responseContents.put("refresh_token", (Object)refreshToken);
                        }
                    }
                    if (isUserEmailScope || !generateAccessToken) {
                        responseContents.put("id_token", (Object)"eyJhbGciOiJSUzI1NiIsImtpZCI6ImRmMzc1ODkwOGI3OTIyOTNhZDk3N2EwYjk5MWQ5OGE3N2Y0ZWVlY2QiLCJ0eXAiOiJKV1QifQ.eyJhdWQiOiJodHRwczovL2Zvby5iYXIiLCJhenAiOiIxMDIxMDE1NTA4MzQyMDA3MDg1NjgiLCJleHAiOjE1NjQ0NzUwNTEsImlhdCI6MTU2NDQ3MTQ1MSwiaXNzIjoiaHR0cHM6Ly9hY2NvdW50cy5nb29nbGUuY29tIiwic3ViIjoiMTAyMTAxNTUwODM0MjAwNzA4NTY4In0.redacted");
                    }
                    String refreshText = responseContents.toPrettyString();
                    return new MockLowLevelHttpResponse().setContentType("application/json; charset=UTF-8").setContent(refreshText);
                }
            };
        }
        if (urlWithoutQuery.equals(OAuth2Utils.TOKEN_REVOKE_URI.toString())) {
            return new MockLowLevelHttpRequest(url){

                public LowLevelHttpResponse execute() throws IOException {
                    Map<String, String> parameters = TestUtils.parseQuery(this.getContentAsString());
                    String token = parameters.get("token");
                    if (token == null) {
                        throw new IOException("Token to revoke not found.");
                    }
                    MockTokenServerTransport.this.refreshTokens.values().removeAll(Collections.singleton(token));
                    MockTokenServerTransport.this.refreshTokens.remove(token);
                    return new MockLowLevelHttpResponse().setContentType("application/json; charset=UTF-8");
                }
            };
        }
        return super.buildRequest(method, url);
    }
}

