/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.util.Clock;
import com.google.auth.RequestMetadataCallback;
import com.google.auth.TestClock;
import com.google.auth.TestUtils;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.BaseSerializationTest;
import com.google.auth.oauth2.GoogleCredentialsTest;
import com.google.auth.oauth2.MockExecutor;
import com.google.auth.oauth2.MockRequestMetadataCallback;
import com.google.auth.oauth2.OAuth2Credentials;
import com.google.auth.oauth2.UserCredentials;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableList;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableMap;
import cz.o2.proxima.internal.shaded.com.google.common.util.concurrent.ListenableFutureTask;
import cz.o2.proxima.internal.shaded.com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class OAuth2CredentialsTest
extends BaseSerializationTest {
    private static final String CLIENT_SECRET = "jakuaL9YyieakhECKL2SwZcu";
    private static final String CLIENT_ID = "ya29.1.AADtN_UtlxN3PuGAxrN2XQnZTVRvDyVWnYq4I6dws";
    private static final String REFRESH_TOKEN = "1/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY";
    private static final String ACCESS_TOKEN = "aashpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY";
    private static final URI CALL_URI = URI.create("http://googleapis.com/testapi/v1/foo");
    private ExecutorService realExecutor;

    @Before
    public void setUp() {
        this.realExecutor = Executors.newCachedThreadPool();
    }

    @After
    public void tearDown() {
        this.realExecutor.shutdown();
    }

    @Test
    public void constructor_storesAccessToken() {
        OAuth2Credentials credentials = OAuth2Credentials.newBuilder().setAccessToken(new AccessToken(ACCESS_TOKEN, null)).build();
        Assert.assertEquals((Object)credentials.getAccessToken().getTokenValue(), (Object)ACCESS_TOKEN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void constructor_overrideMargin() throws Throwable {
        Duration staleMargin = Duration.ofMinutes(3L);
        Duration expirationMargin = Duration.ofMinutes(2L);
        Instant actualExpiration = Instant.now();
        Instant clientStale = actualExpiration.minus(staleMargin);
        Instant clientExpired = actualExpiration.minus(expirationMargin);
        AccessToken initialToken = new AccessToken(ACCESS_TOKEN, Date.from(actualExpiration));
        final AtomicInteger refreshCount = new AtomicInteger();
        final AtomicReference<AccessToken> currentToken = new AtomicReference<AccessToken>(initialToken);
        OAuth2Credentials credentials = new OAuth2Credentials(currentToken.get(), Duration.ofMinutes(3L), Duration.ofMinutes(2L)){

            public AccessToken refreshAccessToken() throws IOException {
                refreshCount.incrementAndGet();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
                return (AccessToken)currentToken.get();
            }
        };
        TestClock clock = new TestClock();
        credentials.clock = clock;
        clock.setCurrentTime(clientStale.toEpochMilli() - 1L);
        MockRequestMetadataCallback callback = new MockRequestMetadataCallback();
        credentials.getRequestMetadata(CALL_URI, (Executor)this.realExecutor, (RequestMetadataCallback)callback);
        Object object = credentials.lock;
        synchronized (object) {
            Assert.assertNull((Object)credentials.refreshTask);
        }
        Assert.assertEquals((long)0L, (long)refreshCount.get());
        Map lastMetadata = credentials.getRequestMetadata(CALL_URI);
        clock.setCurrentTime(clientStale.toEpochMilli());
        currentToken.set(new AccessToken("aashpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY-1", Date.from(actualExpiration)));
        callback.reset();
        credentials.getRequestMetadata(CALL_URI, (Executor)this.realExecutor, (RequestMetadataCallback)callback);
        Assert.assertEquals((Object)lastMetadata, callback.awaitResult());
        this.waitForRefreshTaskCompletion(credentials);
        Assert.assertEquals((long)1L, (long)refreshCount.get());
        lastMetadata = credentials.getRequestMetadata(CALL_URI);
        refreshCount.set(0);
        clock.setCurrentTime(clientExpired.toEpochMilli() - 1L);
        currentToken.set(new AccessToken("aashpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY-2", Date.from(actualExpiration)));
        callback.reset();
        credentials.getRequestMetadata(CALL_URI, (Executor)this.realExecutor, (RequestMetadataCallback)callback);
        Assert.assertEquals((Object)lastMetadata, callback.awaitResult());
        this.waitForRefreshTaskCompletion(credentials);
        Assert.assertEquals((long)1L, (long)refreshCount.get());
        lastMetadata = credentials.getRequestMetadata();
        refreshCount.set(0);
        clock.setCurrentTime(clientExpired.toEpochMilli());
        AccessToken newToken = new AccessToken("aashpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY-3", Date.from(actualExpiration));
        currentToken.set(newToken);
        callback.reset();
        credentials.getRequestMetadata(CALL_URI, (Executor)this.realExecutor, (RequestMetadataCallback)callback);
        TestUtils.assertContainsBearerToken(callback.awaitResult(), newToken.getTokenValue());
        Assert.assertEquals((long)1L, (long)refreshCount.get());
        this.waitForRefreshTaskCompletion(credentials);
        lastMetadata = credentials.getRequestMetadata();
    }

    @Test
    public void getAuthenticationType_returnsOAuth2() {
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).build();
        Assert.assertEquals((Object)credentials.getAuthenticationType(), (Object)"OAuth2");
    }

    @Test
    public void hasRequestMetadata_returnsTrue() {
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).build();
        Assert.assertTrue((boolean)credentials.hasRequestMetadata());
    }

    @Test
    public void hasRequestMetadataOnly_returnsTrue() {
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).build();
        Assert.assertTrue((boolean)credentials.hasRequestMetadata());
    }

    @Test
    public void addChangeListener_notifiesOnRefresh() throws IOException {
        String accessToken1 = "1/MkSJoj1xsli0AccessToken_NKPY2";
        String accessToken2 = "2/MkSJoj1xsli0AccessToken_NKPY2";
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, "1/MkSJoj1xsli0AccessToken_NKPY2");
        UserCredentials userCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        userCredentials.clock = new TestClock();
        TestChangeListener listener = new TestChangeListener();
        userCredentials.addChangeListener((OAuth2Credentials.CredentialsChangedListener)listener);
        Assert.assertEquals((long)0L, (long)listener.callCount);
        Map metadata = userCredentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, "1/MkSJoj1xsli0AccessToken_NKPY2");
        Assert.assertEquals((Object)"1/MkSJoj1xsli0AccessToken_NKPY2", (Object)listener.accessToken.getTokenValue());
        Assert.assertEquals((long)1L, (long)listener.callCount);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, "2/MkSJoj1xsli0AccessToken_NKPY2");
        userCredentials.refresh();
        metadata = userCredentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, "2/MkSJoj1xsli0AccessToken_NKPY2");
        Assert.assertEquals((Object)"2/MkSJoj1xsli0AccessToken_NKPY2", (Object)listener.accessToken.getTokenValue());
        Assert.assertEquals((long)2L, (long)listener.callCount);
    }

    @Test
    public void removeChangeListener_unregisters_observer() throws IOException {
        String accessToken1 = "1/MkSJoj1xsli0AccessToken_NKPY2";
        String accessToken2 = "2/MkSJoj1xsli0AccessToken_NKPY2";
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, "1/MkSJoj1xsli0AccessToken_NKPY2");
        UserCredentials userCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        userCredentials.clock = new TestClock();
        TestChangeListener listener = new TestChangeListener();
        userCredentials.addChangeListener((OAuth2Credentials.CredentialsChangedListener)listener);
        Assert.assertEquals((long)0L, (long)listener.callCount);
        userCredentials.getRequestMetadata(CALL_URI);
        Assert.assertEquals((long)1L, (long)listener.callCount);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, "2/MkSJoj1xsli0AccessToken_NKPY2");
        userCredentials.refresh();
        Assert.assertEquals((long)2L, (long)listener.callCount);
        userCredentials.removeChangeListener((OAuth2Credentials.CredentialsChangedListener)listener);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, "2/MkSJoj1xsli0AccessToken_NKPY2");
        userCredentials.refresh();
        Assert.assertEquals((long)2L, (long)listener.callCount);
    }

    @Test
    public void getRequestMetadata_blocking_cachesExpiringToken() throws IOException {
        String accessToken1 = "1/MkSJoj1xsli0AccessToken_NKPY2";
        String accessToken2 = "2/MkSJoj1xsli0AccessToken_NKPY2";
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, "1/MkSJoj1xsli0AccessToken_NKPY2");
        TestClock clock = new TestClock();
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        credentials.clock = clock;
        Assert.assertEquals((long)0L, (long)transportFactory.transport.buildRequestCount);
        Map metadata = credentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, "1/MkSJoj1xsli0AccessToken_NKPY2");
        Assert.assertEquals((long)1L, (long)transportFactory.transport.buildRequestCount--);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, "2/MkSJoj1xsli0AccessToken_NKPY2");
        IOException error = new IOException("error");
        transportFactory.transport.setError(error);
        clock.addToCurrentTime(300000L);
        metadata = credentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, "1/MkSJoj1xsli0AccessToken_NKPY2");
        clock.addToCurrentTime(3600000L);
        Assert.assertEquals((long)0L, (long)transportFactory.transport.buildRequestCount);
        try {
            credentials.getRequestMetadata(CALL_URI);
            Assert.fail((String)"Should throw");
        }
        catch (IOException e) {
            Assert.assertSame((Object)error, (Object)e.getCause());
            Assert.assertEquals((long)1L, (long)transportFactory.transport.buildRequestCount--);
        }
        transportFactory.transport.setError(null);
        metadata = credentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, "2/MkSJoj1xsli0AccessToken_NKPY2");
        Assert.assertEquals((long)1L, (long)transportFactory.transport.buildRequestCount--);
    }

    @Test
    public void getRequestMetadata_async() throws IOException {
        String accessToken1 = "1/MkSJoj1xsli0AccessToken_NKPY2";
        String accessToken2 = "2/MkSJoj1xsli0AccessToken_NKPY2";
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, "1/MkSJoj1xsli0AccessToken_NKPY2");
        TestClock clock = new TestClock();
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        credentials.clock = clock;
        MockExecutor executor = new MockExecutor();
        MockRequestMetadataCallback callback = new MockRequestMetadataCallback();
        credentials.getRequestMetadata(CALL_URI, (Executor)executor, (RequestMetadataCallback)callback);
        Assert.assertEquals((long)0L, (long)transportFactory.transport.buildRequestCount);
        Assert.assertNull(callback.metadata);
        Assert.assertEquals((long)1L, (long)executor.runTasksExhaustively());
        Assert.assertNotNull(callback.metadata);
        TestUtils.assertContainsBearerToken(callback.metadata, "1/MkSJoj1xsli0AccessToken_NKPY2");
        Assert.assertEquals((long)1L, (long)transportFactory.transport.buildRequestCount--);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, "2/MkSJoj1xsli0AccessToken_NKPY2");
        IOException error = new IOException("error");
        transportFactory.transport.setError(error);
        callback.reset();
        clock.addToCurrentTime(300000L);
        Assert.assertNull(callback.metadata);
        credentials.getRequestMetadata(CALL_URI, (Executor)executor, (RequestMetadataCallback)callback);
        Assert.assertNotNull(callback.metadata);
        Assert.assertEquals((long)0L, (long)executor.numTasks());
        TestUtils.assertContainsBearerToken(callback.metadata, "1/MkSJoj1xsli0AccessToken_NKPY2");
        callback.reset();
        clock.addToCurrentTime(3600000L);
        credentials.getRequestMetadata(CALL_URI, (Executor)executor, (RequestMetadataCallback)callback);
        Assert.assertEquals((long)0L, (long)transportFactory.transport.buildRequestCount);
        Assert.assertNull((Object)callback.exception);
        Assert.assertEquals((long)1L, (long)executor.runTasksExhaustively());
        Assert.assertSame((Object)error, (Object)callback.exception.getCause());
        Assert.assertEquals((long)1L, (long)transportFactory.transport.buildRequestCount--);
        transportFactory.transport.setError(null);
        callback.reset();
        credentials.getRequestMetadata(CALL_URI, (Executor)executor, (RequestMetadataCallback)callback);
        Assert.assertEquals((long)0L, (long)transportFactory.transport.buildRequestCount);
        Assert.assertNull(callback.metadata);
        Assert.assertEquals((long)1L, (long)executor.runTasksExhaustively());
        Assert.assertNotNull(callback.metadata);
        TestUtils.assertContainsBearerToken(callback.metadata, "2/MkSJoj1xsli0AccessToken_NKPY2");
        Assert.assertEquals((long)1L, (long)transportFactory.transport.buildRequestCount--);
    }

    @Test
    public void getRequestMetadata_async_refreshRace() throws ExecutionException, InterruptedException {
        String accessToken1 = "1/MkSJoj1xsli0AccessToken_NKPY2";
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, "1/MkSJoj1xsli0AccessToken_NKPY2");
        TestClock clock = new TestClock();
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        credentials.clock = clock;
        MockExecutor executor = new MockExecutor();
        MockRequestMetadataCallback callback = new MockRequestMetadataCallback();
        credentials.getRequestMetadata(CALL_URI, (Executor)executor, (RequestMetadataCallback)callback);
        Assert.assertEquals((long)0L, (long)transportFactory.transport.buildRequestCount);
        Assert.assertNull(callback.metadata);
        Assert.assertEquals((long)1L, (long)executor.numTasks());
        ExecutorService testExecutor = Executors.newFixedThreadPool(1);
        FutureTask<Map<String, List<String>>> blockingTask = new FutureTask<Map<String, List<String>>>(new Callable<Map<String, List<String>>>((OAuth2Credentials)credentials){
            final /* synthetic */ OAuth2Credentials val$credentials;
            {
                this.val$credentials = oAuth2Credentials;
            }

            @Override
            public Map<String, List<String>> call() throws Exception {
                return this.val$credentials.getRequestMetadata(CALL_URI);
            }
        });
        Future<?> ignored = testExecutor.submit(blockingTask);
        testExecutor.shutdown();
        for (int i = 0; i < 10; ++i) {
            Thread.yield();
        }
        Assert.assertFalse((boolean)blockingTask.isDone());
        Assert.assertEquals((long)0L, (long)transportFactory.transport.buildRequestCount);
        Assert.assertEquals((long)1L, (long)executor.runTasksExhaustively());
        Assert.assertEquals((long)1L, (long)transportFactory.transport.buildRequestCount--);
        Map<String, List<String>> metadata = blockingTask.get();
        Assert.assertEquals((long)0L, (long)transportFactory.transport.buildRequestCount);
        Assert.assertEquals(metadata, callback.metadata);
    }

    @Test
    public void getRequestMetadata_temporaryToken_hasToken() throws IOException {
        OAuth2Credentials credentials = OAuth2Credentials.newBuilder().setAccessToken(new AccessToken(ACCESS_TOKEN, null)).build();
        Map metadata = credentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, ACCESS_TOKEN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getRequestMetadata_staleTemporaryToken() throws IOException, InterruptedException {
        Map requestMetadata;
        String s;
        Instant actualExpiration = Instant.now();
        Instant clientStale = actualExpiration.minus(OAuth2Credentials.DEFAULT_REFRESH_MARGIN);
        TestClock testClock = new TestClock();
        testClock.setCurrentTime(clientStale.toEpochMilli());
        final SettableFuture refreshedTokenFuture = SettableFuture.create();
        OAuth2Credentials creds = new OAuth2Credentials(new AccessToken(ACCESS_TOKEN, Date.from(actualExpiration))){

            public AccessToken refreshAccessToken() {
                try {
                    return (AccessToken)refreshedTokenFuture.get();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        creds.clock = testClock;
        Object object = creds.lock;
        synchronized (object) {
            Assert.assertNull((Object)creds.refreshTask);
        }
        MockRequestMetadataCallback callback = new MockRequestMetadataCallback();
        creds.getRequestMetadata(CALL_URI, (Executor)this.realExecutor, (RequestMetadataCallback)callback);
        TestUtils.assertContainsBearerToken(callback.metadata, ACCESS_TOKEN);
        TestUtils.assertContainsBearerToken(creds.getRequestMetadata(CALL_URI), ACCESS_TOKEN);
        Object object2 = creds.lock;
        synchronized (object2) {
            Assert.assertNotNull((Object)creds.refreshTask);
        }
        AccessToken refreshedToken = new AccessToken("2/MkSJoj1xsli0AccessToken_NKPY2", new Date(testClock.currentTimeMillis() + TimeUnit.HOURS.toMillis(1L)));
        refreshedTokenFuture.set((Object)refreshedToken);
        for (int i = 0; i < 600 && !(s = (String)((List)(requestMetadata = creds.getRequestMetadata(CALL_URI)).get("Authorization")).get(0)).contains(refreshedToken.getTokenValue()); ++i) {
            Thread.sleep(100L);
        }
        callback = new MockRequestMetadataCallback();
        creds.getRequestMetadata(CALL_URI, (Executor)this.realExecutor, (RequestMetadataCallback)callback);
        TestUtils.assertContainsBearerToken(callback.metadata, refreshedToken.getTokenValue());
        TestUtils.assertContainsBearerToken(creds.getRequestMetadata(CALL_URI), refreshedToken.getTokenValue());
        Object object3 = creds.lock;
        synchronized (object3) {
            Assert.assertNull((Object)creds.refreshTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getRequestMetadata_staleTemporaryToken_expirationWaits() throws Throwable {
        Instant actualExpiration = Instant.now();
        Instant clientStale = actualExpiration.minus(OAuth2Credentials.DEFAULT_REFRESH_MARGIN);
        Instant clientExpired = actualExpiration.minus(OAuth2Credentials.DEFAULT_EXPIRATION_MARGIN);
        TestClock testClock = new TestClock();
        final SettableFuture refreshedTokenFuture = SettableFuture.create();
        OAuth2Credentials creds = new OAuth2Credentials(new AccessToken(ACCESS_TOKEN, Date.from(actualExpiration))){

            public AccessToken refreshAccessToken() {
                try {
                    return (AccessToken)refreshedTokenFuture.get();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        creds.clock = testClock;
        Object object = creds.lock;
        synchronized (object) {
            Assert.assertNull((Object)creds.refreshTask);
        }
        testClock.setCurrentTime(clientStale.toEpochMilli());
        MockRequestMetadataCallback callback = new MockRequestMetadataCallback();
        creds.getRequestMetadata(CALL_URI, (Executor)this.realExecutor, (RequestMetadataCallback)callback);
        TestUtils.assertContainsBearerToken(callback.metadata, ACCESS_TOKEN);
        Assert.assertNotNull((Object)creds.refreshTask);
        ListenableFutureTask refreshTask = creds.refreshTask;
        testClock.setCurrentTime(clientExpired.toEpochMilli());
        for (int i = 0; i < 10; ++i) {
            Thread.sleep(10L);
            callback = new MockRequestMetadataCallback();
            creds.getRequestMetadata(CALL_URI, (Executor)this.realExecutor, (RequestMetadataCallback)callback);
            Assert.assertNull(callback.metadata);
        }
        Object i = creds.lock;
        synchronized (i) {
            Assert.assertSame((Object)refreshTask, (Object)creds.refreshTask);
        }
        AccessToken refreshedToken = new AccessToken("2/MkSJoj1xsli0AccessToken_NKPY2", new Date(testClock.currentTimeMillis() + TimeUnit.HOURS.toMillis(1L)));
        refreshedTokenFuture.set((Object)refreshedToken);
        TestUtils.assertContainsBearerToken(creds.getRequestMetadata(CALL_URI), refreshedToken.getTokenValue());
        callback = new MockRequestMetadataCallback();
        creds.getRequestMetadata(CALL_URI, (Executor)this.realExecutor, (RequestMetadataCallback)callback);
        TestUtils.assertContainsBearerToken(callback.awaitResult(), refreshedToken.getTokenValue());
        Object object2 = creds.lock;
        synchronized (object2) {
            Assert.assertNull((Object)creds.refreshTask);
        }
    }

    @Test
    public void getRequestMetadata_singleFlightErrorSharing() {
        Instant actualExpiration = Instant.now();
        Instant clientStale = actualExpiration.minus(OAuth2Credentials.DEFAULT_REFRESH_MARGIN);
        Instant clientExpired = actualExpiration.minus(OAuth2Credentials.DEFAULT_EXPIRATION_MARGIN);
        TestClock testClock = new TestClock();
        testClock.setCurrentTime(clientStale.toEpochMilli());
        final SettableFuture refreshErrorFuture = SettableFuture.create();
        final OAuth2Credentials creds = new OAuth2Credentials(new AccessToken(ACCESS_TOKEN, Date.from(clientExpired))){

            public AccessToken refreshAccessToken() {
                RuntimeException injectedError;
                try {
                    injectedError = (RuntimeException)refreshErrorFuture.get();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Unexpected error fetching injected error");
                }
                throw injectedError;
            }
        };
        creds.clock = testClock;
        final MockRequestMetadataCallback callback1 = new MockRequestMetadataCallback();
        creds.getRequestMetadata(CALL_URI, (Executor)this.realExecutor, (RequestMetadataCallback)callback1);
        final Future<Map<String, List<String>>> blockingCall = this.realExecutor.submit(new Callable<Map<String, List<String>>>(){

            @Override
            public Map<String, List<String>> call() throws Exception {
                return creds.getRequestMetadata(CALL_URI);
            }
        });
        RuntimeException error = new RuntimeException("fake error");
        refreshErrorFuture.set((Object)error);
        Throwable actualBlockingError = ((ExecutionException)Assert.assertThrows(ExecutionException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                blockingCall.get();
            }
        })).getCause();
        Assert.assertEquals((Object)error, (Object)actualBlockingError);
        RuntimeException actualAsyncError = (RuntimeException)Assert.assertThrows(RuntimeException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                callback1.awaitResult();
            }
        });
        Assert.assertEquals((Object)error, (Object)actualAsyncError);
    }

    @Test
    public void getRequestMetadata_syncErrorsIncludeCallingStackframe() {
        OAuth2Credentials creds = new OAuth2Credentials(){

            public AccessToken refreshAccessToken() {
                throw new RuntimeException("fake error");
            }
        };
        List<StackTraceElement> expectedStacktrace = new ArrayList<StackTraceElement>(Arrays.asList(new Exception().getStackTrace()));
        expectedStacktrace = expectedStacktrace.subList(1, expectedStacktrace.size());
        AtomicReference<Exception> actualError = new AtomicReference<Exception>();
        try {
            creds.getRequestMetadata(CALL_URI);
            Assert.fail((String)"Should not be able to use credential without exception.");
        }
        catch (Exception refreshError) {
            actualError.set(refreshError);
        }
        List<StackTraceElement> actualStacktrace = Arrays.asList(((Exception)actualError.get()).getStackTrace());
        actualStacktrace = actualStacktrace.subList(actualStacktrace.size() - expectedStacktrace.size(), actualStacktrace.size());
        Assert.assertEquals(expectedStacktrace, actualStacktrace);
    }

    @Test
    public void refresh_refreshesToken() throws IOException {
        String accessToken1 = "1/MkSJoj1xsli0AccessToken_NKPY2";
        String accessToken2 = "2/MkSJoj1xsli0AccessToken_NKPY2";
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, "1/MkSJoj1xsli0AccessToken_NKPY2");
        UserCredentials userCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        userCredentials.clock = new TestClock();
        Map metadata = userCredentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, "1/MkSJoj1xsli0AccessToken_NKPY2");
        Assert.assertEquals((long)1L, (long)transportFactory.transport.buildRequestCount--);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, "2/MkSJoj1xsli0AccessToken_NKPY2");
        TestUtils.assertContainsBearerToken(metadata, "1/MkSJoj1xsli0AccessToken_NKPY2");
        Assert.assertEquals((long)0L, (long)transportFactory.transport.buildRequestCount);
        userCredentials.refresh();
        metadata = userCredentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, "2/MkSJoj1xsli0AccessToken_NKPY2");
        Assert.assertEquals((long)1L, (long)transportFactory.transport.buildRequestCount--);
    }

    @Test
    public void refreshIfExpired_refreshesToken() throws IOException {
        String accessToken1 = "1/MkSJoj1xsli0AccessToken_NKPY2";
        String accessToken2 = "2/MkSJoj1xsli0AccessToken_NKPY2";
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, "1/MkSJoj1xsli0AccessToken_NKPY2");
        UserCredentials userCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        TestClock mockClock = new TestClock();
        userCredentials.clock = mockClock;
        Map metadata = userCredentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, "1/MkSJoj1xsli0AccessToken_NKPY2");
        Assert.assertEquals((long)1L, (long)transportFactory.transport.buildRequestCount--);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, "2/MkSJoj1xsli0AccessToken_NKPY2");
        TestUtils.assertContainsBearerToken(metadata, "1/MkSJoj1xsli0AccessToken_NKPY2");
        Assert.assertEquals((long)0L, (long)transportFactory.transport.buildRequestCount);
        userCredentials.refreshIfExpired();
        metadata = userCredentials.getRequestMetadata(CALL_URI);
        TestUtils.assertNotContainsBearerToken(metadata, "2/MkSJoj1xsli0AccessToken_NKPY2");
        mockClock.addToCurrentTime(3600000L);
        userCredentials.refreshIfExpired();
        metadata = userCredentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, "2/MkSJoj1xsli0AccessToken_NKPY2");
        Assert.assertEquals((long)1L, (long)transportFactory.transport.buildRequestCount--);
    }

    @Test(expected=IllegalStateException.class)
    public void refresh_temporaryToken_throws() throws IOException {
        OAuth2Credentials credentials = OAuth2Credentials.newBuilder().setAccessToken(new AccessToken(ACCESS_TOKEN, null)).build();
        credentials.refresh();
    }

    @Test
    public void equals_true() throws IOException {
        String accessToken1 = "1/MkSJoj1xsli0AccessToken_NKPY2";
        OAuth2Credentials credentials = OAuth2Credentials.newBuilder().setAccessToken(new AccessToken("1/MkSJoj1xsli0AccessToken_NKPY2", null)).build();
        OAuth2Credentials otherCredentials = OAuth2Credentials.newBuilder().setAccessToken(new AccessToken("1/MkSJoj1xsli0AccessToken_NKPY2", null)).build();
        Assert.assertTrue((boolean)credentials.equals((Object)otherCredentials));
        Assert.assertTrue((boolean)otherCredentials.equals((Object)credentials));
    }

    @Test
    public void equals_false_accessToken() throws IOException {
        String accessToken1 = "1/MkSJoj1xsli0AccessToken_NKPY2";
        String accessToken2 = "2/MkSJoj1xsli0AccessToken_NKPY2";
        OAuth2Credentials credentials = OAuth2Credentials.newBuilder().setAccessToken(new AccessToken("1/MkSJoj1xsli0AccessToken_NKPY2", null)).build();
        OAuth2Credentials otherCredentials = OAuth2Credentials.newBuilder().setAccessToken(new AccessToken("2/MkSJoj1xsli0AccessToken_NKPY2", null)).build();
        Assert.assertFalse((boolean)credentials.equals((Object)otherCredentials));
        Assert.assertFalse((boolean)otherCredentials.equals((Object)credentials));
    }

    @Test
    public void toString_containsFields() throws IOException {
        AccessToken accessToken = new AccessToken("1/MkSJoj1xsli0AccessToken_NKPY2", null);
        OAuth2Credentials credentials = OAuth2Credentials.newBuilder().setAccessToken(accessToken).build();
        String expectedToString = String.format("OAuth2Credentials{requestMetadata=%s, temporaryAccess=%s}", ImmutableMap.of((Object)"Authorization", (Object)ImmutableList.of((Object)("Bearer " + accessToken.getTokenValue()))), accessToken.toString());
        Assert.assertEquals((Object)expectedToString, (Object)credentials.toString());
    }

    @Test
    public void hashCode_equals() throws IOException {
        String accessToken = "1/MkSJoj1xsli0AccessToken_NKPY2";
        OAuth2Credentials credentials = OAuth2Credentials.newBuilder().setAccessToken(new AccessToken("1/MkSJoj1xsli0AccessToken_NKPY2", null)).build();
        OAuth2Credentials otherCredentials = OAuth2Credentials.create((AccessToken)new AccessToken("1/MkSJoj1xsli0AccessToken_NKPY2", null));
        Assert.assertEquals((long)credentials.hashCode(), (long)otherCredentials.hashCode());
    }

    @Test
    public void serialize() throws IOException, ClassNotFoundException {
        String accessToken = "1/MkSJoj1xsli0AccessToken_NKPY2";
        OAuth2Credentials credentials = OAuth2Credentials.newBuilder().setAccessToken(new AccessToken("1/MkSJoj1xsli0AccessToken_NKPY2", null)).build();
        OAuth2Credentials deserializedCredentials = this.serializeAndDeserialize(credentials);
        Assert.assertEquals((Object)credentials, (Object)deserializedCredentials);
        Assert.assertEquals((long)credentials.hashCode(), (long)deserializedCredentials.hashCode());
        Assert.assertEquals((Object)credentials.toString(), (Object)deserializedCredentials.toString());
        Assert.assertSame((Object)deserializedCredentials.clock, (Object)Clock.SYSTEM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForRefreshTaskCompletion(OAuth2Credentials credentials) throws TimeoutException, InterruptedException {
        for (int i = 0; i < 100; ++i) {
            Object object = credentials.lock;
            synchronized (object) {
                if (credentials.refreshTask == null) {
                    return;
                }
            }
            Thread.sleep(100L);
        }
        throw new TimeoutException("timed out waiting for refresh task to finish");
    }

    private static class TestChangeListener
    implements OAuth2Credentials.CredentialsChangedListener {
        public AccessToken accessToken = null;
        public int callCount = 0;

        private TestChangeListener() {
        }

        public void onChanged(OAuth2Credentials credentials) throws IOException {
            this.accessToken = credentials.getAccessToken();
            ++this.callCount;
        }
    }
}

