/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.OAuth2CredentialsWithRefresh;
import java.io.IOException;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class OAuth2CredentialsWithRefreshTest {
    private static final AccessToken ACCESS_TOKEN = new AccessToken("accessToken", new Date());

    @Test
    public void builder() {
        OAuth2CredentialsWithRefresh.OAuth2RefreshHandler refreshHandler = new OAuth2CredentialsWithRefresh.OAuth2RefreshHandler(){

            public AccessToken refreshAccessToken() {
                return null;
            }
        };
        OAuth2CredentialsWithRefresh credential = OAuth2CredentialsWithRefresh.newBuilder().setAccessToken(ACCESS_TOKEN).setRefreshHandler(refreshHandler).build();
        Assert.assertEquals((Object)ACCESS_TOKEN, (Object)credential.getAccessToken());
        Assert.assertEquals((Object)refreshHandler, (Object)credential.getRefreshHandler());
    }

    @Test
    public void builder_noAccessToken() {
        OAuth2CredentialsWithRefresh.newBuilder().setRefreshHandler(new OAuth2CredentialsWithRefresh.OAuth2RefreshHandler(){

            public AccessToken refreshAccessToken() {
                return null;
            }
        }).build();
    }

    @Test
    public void builder_noRefreshHandler_throws() {
        try {
            OAuth2CredentialsWithRefresh.newBuilder().setAccessToken(ACCESS_TOKEN).build();
            Assert.fail((String)"Should fail as a refresh handler must be provided.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void builder_noExpirationTimeInAccessToken_throws() {
        try {
            OAuth2CredentialsWithRefresh.newBuilder().setAccessToken(new AccessToken("accessToken", null)).build();
            Assert.fail((String)"Should fail as a refresh handler must be provided.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void refreshAccessToken_delegateToRefreshHandler() throws IOException {
        final AccessToken refreshedToken = new AccessToken("refreshedAccessToken", new Date());
        OAuth2CredentialsWithRefresh credentials = OAuth2CredentialsWithRefresh.newBuilder().setAccessToken(ACCESS_TOKEN).setRefreshHandler(new OAuth2CredentialsWithRefresh.OAuth2RefreshHandler(){

            public AccessToken refreshAccessToken() {
                return refreshedToken;
            }
        }).build();
        AccessToken accessToken = credentials.refreshAccessToken();
        Assert.assertEquals((Object)refreshedToken, (Object)accessToken);
    }
}

