/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.auth.oauth2.OAuthException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class OAuthExceptionTest {
    private static final String FULL_MESSAGE_FORMAT = "Error code %s: %s - %s";
    private static final String ERROR_DESCRIPTION_FORMAT = "Error code %s: %s";
    private static final String BASE_MESSAGE_FORMAT = "Error code %s";

    @Test
    public void getMessage_fullFormat() {
        OAuthException e = new OAuthException("errorCode", "errorDescription", "errorUri");
        Assert.assertEquals((Object)"errorCode", (Object)e.getErrorCode());
        Assert.assertEquals((Object)"errorDescription", (Object)e.getErrorDescription());
        Assert.assertEquals((Object)"errorUri", (Object)e.getErrorUri());
        String expectedMessage = String.format(FULL_MESSAGE_FORMAT, "errorCode", "errorDescription", "errorUri");
        Assert.assertEquals((Object)expectedMessage, (Object)e.getMessage());
    }

    @Test
    public void getMessage_descriptionFormat() {
        OAuthException e = new OAuthException("errorCode", "errorDescription", null);
        Assert.assertEquals((Object)"errorCode", (Object)e.getErrorCode());
        Assert.assertEquals((Object)"errorDescription", (Object)e.getErrorDescription());
        Assert.assertNull((Object)e.getErrorUri());
        String expectedMessage = String.format(ERROR_DESCRIPTION_FORMAT, "errorCode", "errorDescription");
        Assert.assertEquals((Object)expectedMessage, (Object)e.getMessage());
    }

    @Test
    public void getMessage_baseFormat() {
        OAuthException e = new OAuthException("errorCode", null, null);
        Assert.assertEquals((Object)"errorCode", (Object)e.getErrorCode());
        Assert.assertNull((Object)e.getErrorDescription());
        Assert.assertNull((Object)e.getErrorUri());
        String expectedMessage = String.format(BASE_MESSAGE_FORMAT, "errorCode");
        Assert.assertEquals((Object)expectedMessage, (Object)e.getMessage());
    }
}

