/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.GenericJson;
import com.google.auth.TestUtils;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.ExecutableHandler;
import com.google.auth.oauth2.ExternalAccountCredentials;
import com.google.auth.oauth2.ExternalAccountCredentialsTest;
import com.google.auth.oauth2.MockExternalAccountCredentialsTransport;
import com.google.auth.oauth2.OAuth2Utils;
import com.google.auth.oauth2.PluggableAuthCredentials;
import com.google.auth.oauth2.SystemEnvironmentProvider;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.junit.Assert;
import org.junit.Test;

public class PluggableAuthCredentialsTest {
    private static final int DEFAULT_EXECUTABLE_TIMEOUT_MS = 30000;
    private static final int MINIMUM_EXECUTABLE_TIMEOUT_MS = 5000;
    private static final int MAXIMUM_EXECUTABLE_TIMEOUT_MS = 120000;
    private static final String STS_URL = "https://sts.googleapis.com";
    private static final PluggableAuthCredentials CREDENTIAL = (PluggableAuthCredentials)PluggableAuthCredentials.newBuilder().setHttpTransportFactory(OAuth2Utils.HTTP_TRANSPORT_FACTORY).setAudience("//iam.googleapis.com/projects/123/locations/global/workloadIdentityPools/pool/providers/provider").setSubjectTokenType("subjectTokenType").setTokenUrl("https://sts.googleapis.com").setTokenInfoUrl("tokenInfoUrl").setCredentialSource(PluggableAuthCredentialsTest.buildCredentialSource()).build();

    @Test
    public void retrieveSubjectToken_shouldDelegateToHandler() throws IOException {
        PluggableAuthCredentials credential = PluggableAuthCredentials.newBuilder((PluggableAuthCredentials)CREDENTIAL).setExecutableHandler(options -> "pluggableAuthToken").build();
        String subjectToken = credential.retrieveSubjectToken();
        Assert.assertEquals((Object)subjectToken, (Object)"pluggableAuthToken");
    }

    @Test
    public void retrieveSubjectToken_shouldPassAllOptionsToHandler() throws IOException {
        String command = "/path/to/executable";
        String timeout = "5000";
        String outputFile = "/path/to/output/file";
        ExecutableHandler.ExecutableOptions[] providedOptions = new ExecutableHandler.ExecutableOptions[]{null};
        ExecutableHandler executableHandler = options -> {
            providedOptions[0] = options;
            return "pluggableAuthToken";
        };
        PluggableAuthCredentials credential = (PluggableAuthCredentials)PluggableAuthCredentials.newBuilder((PluggableAuthCredentials)CREDENTIAL).setExecutableHandler(executableHandler).setCredentialSource(PluggableAuthCredentialsTest.buildCredentialSource(command, timeout, outputFile)).setServiceAccountImpersonationUrl("https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/testn@test.iam.gserviceaccount.com:generateAccessToken").build();
        String subjectToken = credential.retrieveSubjectToken();
        Assert.assertEquals((Object)subjectToken, (Object)"pluggableAuthToken");
        ExecutableHandler.ExecutableOptions options2 = providedOptions[0];
        Assert.assertEquals((Object)options2.getExecutableCommand(), (Object)command);
        Assert.assertEquals((long)options2.getExecutableTimeoutMs(), (long)Integer.parseInt(timeout));
        Assert.assertEquals((Object)options2.getOutputFilePath(), (Object)outputFile);
        Map envMap = options2.getEnvironmentMap();
        Assert.assertEquals((long)envMap.size(), (long)5L);
        Assert.assertEquals(envMap.get("GOOGLE_EXTERNAL_ACCOUNT_AUDIENCE"), (Object)credential.getAudience());
        Assert.assertEquals(envMap.get("GOOGLE_EXTERNAL_ACCOUNT_TOKEN_TYPE"), (Object)credential.getSubjectTokenType());
        Assert.assertEquals(envMap.get("GOOGLE_EXTERNAL_ACCOUNT_INTERACTIVE"), (Object)"0");
        Assert.assertEquals(envMap.get("GOOGLE_EXTERNAL_ACCOUNT_IMPERSONATED_EMAIL"), (Object)credential.getServiceAccountEmail());
        Assert.assertEquals(envMap.get("GOOGLE_EXTERNAL_ACCOUNT_OUTPUT_FILE"), (Object)outputFile);
    }

    @Test
    public void retrieveSubjectToken_shouldPassMinimalOptionsToHandler() throws IOException {
        String command = "/path/to/executable";
        ExecutableHandler.ExecutableOptions[] providedOptions = new ExecutableHandler.ExecutableOptions[]{null};
        ExecutableHandler executableHandler = options -> {
            providedOptions[0] = options;
            return "pluggableAuthToken";
        };
        PluggableAuthCredentials credential = (PluggableAuthCredentials)PluggableAuthCredentials.newBuilder((PluggableAuthCredentials)CREDENTIAL).setExecutableHandler(executableHandler).setCredentialSource(PluggableAuthCredentialsTest.buildCredentialSource(command, null, null)).build();
        String subjectToken = credential.retrieveSubjectToken();
        Assert.assertEquals((Object)subjectToken, (Object)"pluggableAuthToken");
        ExecutableHandler.ExecutableOptions options2 = providedOptions[0];
        Assert.assertEquals((Object)options2.getExecutableCommand(), (Object)command);
        Assert.assertEquals((long)options2.getExecutableTimeoutMs(), (long)30000L);
        Assert.assertNull((Object)options2.getOutputFilePath());
        Map envMap = options2.getEnvironmentMap();
        Assert.assertEquals((long)envMap.size(), (long)3L);
        Assert.assertEquals(envMap.get("GOOGLE_EXTERNAL_ACCOUNT_AUDIENCE"), (Object)credential.getAudience());
        Assert.assertEquals(envMap.get("GOOGLE_EXTERNAL_ACCOUNT_TOKEN_TYPE"), (Object)credential.getSubjectTokenType());
        Assert.assertEquals(envMap.get("GOOGLE_EXTERNAL_ACCOUNT_INTERACTIVE"), (Object)"0");
        Assert.assertNull(envMap.get("GOOGLE_EXTERNAL_ACCOUNT_IMPERSONATED_EMAIL"));
        Assert.assertNull(envMap.get("GOOGLE_EXTERNAL_ACCOUNT_OUTPUT_FILE"));
    }

    @Test
    public void refreshAccessToken_withoutServiceAccountImpersonation() throws IOException {
        MockExternalAccountCredentialsTransportFactory transportFactory = new MockExternalAccountCredentialsTransportFactory();
        transportFactory.transport.setExpireTime(TestUtils.getDefaultExpireTime());
        PluggableAuthCredentials credential = (PluggableAuthCredentials)PluggableAuthCredentials.newBuilder((PluggableAuthCredentials)CREDENTIAL).setExecutableHandler(options -> "pluggableAuthToken").setTokenUrl(transportFactory.transport.getStsUrl()).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        AccessToken accessToken = credential.refreshAccessToken();
        Assert.assertEquals((Object)transportFactory.transport.getAccessToken(), (Object)accessToken.getTokenValue());
        Map<String, String> query = TestUtils.parseQuery(transportFactory.transport.getRequests().get(0).getContentAsString());
        Assert.assertEquals((Object)query.get("subject_token"), (Object)"pluggableAuthToken");
    }

    @Test
    public void refreshAccessToken_withServiceAccountImpersonation() throws IOException {
        MockExternalAccountCredentialsTransportFactory transportFactory = new MockExternalAccountCredentialsTransportFactory();
        transportFactory.transport.setExpireTime(TestUtils.getDefaultExpireTime());
        PluggableAuthCredentials credential = (PluggableAuthCredentials)PluggableAuthCredentials.newBuilder((PluggableAuthCredentials)CREDENTIAL).setExecutableHandler(options -> "pluggableAuthToken").setTokenUrl(transportFactory.transport.getStsUrl()).setServiceAccountImpersonationUrl(transportFactory.transport.getServiceAccountImpersonationUrl()).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        AccessToken accessToken = credential.refreshAccessToken();
        Assert.assertEquals((Object)transportFactory.transport.getServiceAccountAccessToken(), (Object)accessToken.getTokenValue());
        Map<String, String> query = TestUtils.parseQuery(transportFactory.transport.getRequests().get(0).getContentAsString());
        Assert.assertEquals((Object)query.get("subject_token"), (Object)"pluggableAuthToken");
    }

    @Test
    public void refreshAccessToken_withServiceAccountImpersonationOptions() throws IOException {
        MockExternalAccountCredentialsTransportFactory transportFactory = new MockExternalAccountCredentialsTransportFactory();
        transportFactory.transport.setExpireTime(TestUtils.getDefaultExpireTime());
        PluggableAuthCredentials credential = (PluggableAuthCredentials)PluggableAuthCredentials.newBuilder((PluggableAuthCredentials)CREDENTIAL).setExecutableHandler(options -> "pluggableAuthToken").setTokenUrl(transportFactory.transport.getStsUrl()).setServiceAccountImpersonationUrl(transportFactory.transport.getServiceAccountImpersonationUrl()).setHttpTransportFactory((HttpTransportFactory)transportFactory).setServiceAccountImpersonationOptions(ExternalAccountCredentialsTest.buildServiceAccountImpersonationOptions(2800)).build();
        AccessToken accessToken = credential.refreshAccessToken();
        Assert.assertEquals((Object)transportFactory.transport.getServiceAccountAccessToken(), (Object)accessToken.getTokenValue());
        GenericJson query = (GenericJson)OAuth2Utils.JSON_FACTORY.createJsonParser(transportFactory.transport.getLastRequest().getContentAsString()).parseAndClose(GenericJson.class);
        Assert.assertEquals((Object)"2800s", (Object)query.get((Object)"lifetime"));
    }

    @Test
    public void pluggableAuthCredentialSource_allFields() {
        HashMap source = new HashMap();
        HashMap<String, String> executable = new HashMap<String, String>();
        source.put("executable", executable);
        executable.put("command", "/path/to/executable");
        executable.put("timeout_millis", "10000");
        executable.put("output_file", "/path/to/output/file");
        PluggableAuthCredentials.PluggableAuthCredentialSource credentialSource = new PluggableAuthCredentials.PluggableAuthCredentialSource(source);
        Assert.assertEquals((Object)credentialSource.getCommand(), (Object)"/path/to/executable");
        Assert.assertEquals((long)credentialSource.getTimeoutMs(), (long)10000L);
        Assert.assertEquals((Object)credentialSource.getOutputFilePath(), (Object)"/path/to/output/file");
    }

    @Test
    public void pluggableAuthCredentialSource_noTimeoutProvided_setToDefault() {
        HashMap source = new HashMap();
        HashMap<String, String> executable = new HashMap<String, String>();
        source.put("executable", executable);
        executable.put("command", "command");
        PluggableAuthCredentials.PluggableAuthCredentialSource credentialSource = new PluggableAuthCredentials.PluggableAuthCredentialSource(source);
        Assert.assertEquals((Object)credentialSource.getCommand(), (Object)"command");
        Assert.assertEquals((long)credentialSource.getTimeoutMs(), (long)30000L);
        Assert.assertNull((Object)credentialSource.getOutputFilePath());
    }

    @Test
    public void pluggableAuthCredentialSource_timeoutProvidedOutOfRange_throws() {
        int[] possibleOutOfRangeValues;
        HashMap source = new HashMap();
        HashMap<String, Object> executable = new HashMap<String, Object>();
        source.put("executable", executable);
        executable.put("command", "command");
        for (int value : possibleOutOfRangeValues = new int[]{0, 4000, 121000}) {
            executable.put("timeout_millis", value);
            try {
                new PluggableAuthCredentials.PluggableAuthCredentialSource(source);
                Assert.fail((String)"Should not be able to continue without exception.");
            }
            catch (IllegalArgumentException exception) {
                Assert.assertEquals((Object)String.format("The executable timeout must be between %s and %s milliseconds.", 5000, 120000), (Object)exception.getMessage());
            }
        }
    }

    @Test
    public void pluggableAuthCredentialSource_validTimeoutProvided() {
        Object[] possibleValues;
        HashMap source = new HashMap();
        HashMap<String, Object> executable = new HashMap<String, Object>();
        source.put("executable", executable);
        executable.put("command", "command");
        for (Object value : possibleValues = new Object[]{"10000", 10000, BigDecimal.valueOf(10000L)}) {
            executable.put("timeout_millis", value);
            PluggableAuthCredentials.PluggableAuthCredentialSource credentialSource = new PluggableAuthCredentials.PluggableAuthCredentialSource(source);
            Assert.assertEquals((Object)credentialSource.getCommand(), (Object)"command");
            Assert.assertEquals((long)credentialSource.getTimeoutMs(), (long)10000L);
            Assert.assertNull((Object)credentialSource.getOutputFilePath());
        }
    }

    @Test
    public void pluggableAuthCredentialSource_missingExecutableField_throws() {
        try {
            new PluggableAuthCredentials.PluggableAuthCredentialSource(new HashMap());
            Assert.fail((String)"Should not be able to continue without exception.");
        }
        catch (IllegalArgumentException exception) {
            Assert.assertEquals((Object)"Invalid credential source for PluggableAuth credentials.", (Object)exception.getMessage());
        }
    }

    @Test
    public void pluggableAuthCredentialSource_missingExecutableCommandField_throws() {
        HashMap source = new HashMap();
        HashMap executable = new HashMap();
        source.put("executable", executable);
        try {
            new PluggableAuthCredentials.PluggableAuthCredentialSource(source);
            Assert.fail((String)"Should not be able to continue without exception.");
        }
        catch (IllegalArgumentException exception) {
            Assert.assertEquals((Object)"The PluggableAuthCredentialSource is missing the required 'command' field.", (Object)exception.getMessage());
        }
    }

    @Test
    public void builder_allFields() {
        List<String> scopes = Arrays.asList("scope1", "scope2");
        ExternalAccountCredentials.CredentialSource source = PluggableAuthCredentialsTest.buildCredentialSource();
        ExecutableHandler handler = options -> "Token";
        PluggableAuthCredentials credentials = (PluggableAuthCredentials)PluggableAuthCredentials.newBuilder().setExecutableHandler(handler).setHttpTransportFactory(OAuth2Utils.HTTP_TRANSPORT_FACTORY).setAudience("audience").setSubjectTokenType("subjectTokenType").setTokenUrl(STS_URL).setTokenInfoUrl("tokenInfoUrl").setCredentialSource(source).setServiceAccountImpersonationUrl("https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/testn@test.iam.gserviceaccount.com:generateAccessToken").setQuotaProjectId("quotaProjectId").setClientId("clientId").setClientSecret("clientSecret").setScopes(scopes).build();
        Assert.assertEquals((Object)credentials.getExecutableHandler(), (Object)handler);
        Assert.assertEquals((Object)"audience", (Object)credentials.getAudience());
        Assert.assertEquals((Object)"subjectTokenType", (Object)credentials.getSubjectTokenType());
        Assert.assertEquals((Object)credentials.getTokenUrl(), (Object)STS_URL);
        Assert.assertEquals((Object)credentials.getTokenInfoUrl(), (Object)"tokenInfoUrl");
        Assert.assertEquals((Object)credentials.getServiceAccountImpersonationUrl(), (Object)"https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/testn@test.iam.gserviceaccount.com:generateAccessToken");
        Assert.assertEquals((Object)credentials.getCredentialSource(), (Object)source);
        Assert.assertEquals((Object)credentials.getQuotaProjectId(), (Object)"quotaProjectId");
        Assert.assertEquals((Object)credentials.getClientId(), (Object)"clientId");
        Assert.assertEquals((Object)credentials.getClientSecret(), (Object)"clientSecret");
        Assert.assertEquals((Object)credentials.getScopes(), scopes);
        Assert.assertEquals((Object)credentials.getEnvironmentProvider(), (Object)SystemEnvironmentProvider.getInstance());
    }

    @Test
    public void createdScoped_clonedCredentialWithAddedScopes() {
        PluggableAuthCredentials credentials = (PluggableAuthCredentials)PluggableAuthCredentials.newBuilder((PluggableAuthCredentials)CREDENTIAL).setExecutableHandler(options -> "pluggableAuthToken").setServiceAccountImpersonationUrl("https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/testn@test.iam.gserviceaccount.com:generateAccessToken").setQuotaProjectId("quotaProjectId").setClientId("clientId").setClientSecret("clientSecret").build();
        List<String> newScopes = Arrays.asList("scope1", "scope2");
        PluggableAuthCredentials newCredentials = credentials.createScoped(newScopes);
        Assert.assertEquals((Object)credentials.getAudience(), (Object)newCredentials.getAudience());
        Assert.assertEquals((Object)credentials.getSubjectTokenType(), (Object)newCredentials.getSubjectTokenType());
        Assert.assertEquals((Object)credentials.getTokenUrl(), (Object)newCredentials.getTokenUrl());
        Assert.assertEquals((Object)credentials.getTokenInfoUrl(), (Object)newCredentials.getTokenInfoUrl());
        Assert.assertEquals((Object)credentials.getServiceAccountImpersonationUrl(), (Object)newCredentials.getServiceAccountImpersonationUrl());
        Assert.assertEquals((Object)credentials.getCredentialSource(), (Object)newCredentials.getCredentialSource());
        Assert.assertEquals(newScopes, (Object)newCredentials.getScopes());
        Assert.assertEquals((Object)credentials.getQuotaProjectId(), (Object)newCredentials.getQuotaProjectId());
        Assert.assertEquals((Object)credentials.getClientId(), (Object)newCredentials.getClientId());
        Assert.assertEquals((Object)credentials.getClientSecret(), (Object)newCredentials.getClientSecret());
        Assert.assertEquals((Object)credentials.getExecutableHandler(), (Object)newCredentials.getExecutableHandler());
    }

    private static ExternalAccountCredentials.CredentialSource buildCredentialSource() {
        return PluggableAuthCredentialsTest.buildCredentialSource("command", null, null);
    }

    private static ExternalAccountCredentials.CredentialSource buildCredentialSource(String command, @Nullable String timeoutMs, @Nullable String outputFile) {
        HashMap source = new HashMap();
        HashMap<String, String> executable = new HashMap<String, String>();
        source.put("executable", executable);
        executable.put("command", command);
        if (timeoutMs != null) {
            executable.put("timeout_millis", timeoutMs);
        }
        if (outputFile != null) {
            executable.put("output_file", outputFile);
        }
        return new PluggableAuthCredentials.PluggableAuthCredentialSource(source);
    }

    static InputStream writeCredentialsStream(String tokenUrl) throws IOException {
        GenericJson json = new GenericJson();
        json.put("audience", (Object)"audience");
        json.put("subject_token_type", (Object)"subjectTokenType");
        json.put("token_url", (Object)tokenUrl);
        json.put("token_info_url", (Object)"tokenInfoUrl");
        json.put("type", (Object)"external_account");
        GenericJson credentialSource = new GenericJson();
        GenericJson executable = new GenericJson();
        executable.put("command", (Object)"/path/to/executable");
        credentialSource.put("executable", (Object)executable);
        json.put("credential_source", (Object)credentialSource);
        return TestUtils.jsonToInputStream(json);
    }

    static class MockExternalAccountCredentialsTransportFactory
    implements HttpTransportFactory {
        MockExternalAccountCredentialsTransport transport = new MockExternalAccountCredentialsTransport();

        MockExternalAccountCredentialsTransportFactory() {
        }

        public HttpTransport create() {
            return this.transport;
        }
    }
}

