/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.auth.oauth2.PluggableAuthException;
import org.junit.Assert;
import org.junit.Test;

public class PluggableAuthExceptionTest {
    private static final String MESSAGE_FORMAT = "Error code %s: %s";

    @Test
    public void constructor() {
        PluggableAuthException e = new PluggableAuthException("errorCode", "errorDescription");
        Assert.assertEquals((Object)"errorCode", (Object)e.getErrorCode());
        Assert.assertEquals((Object)"errorDescription", (Object)e.getErrorDescription());
    }

    @Test(expected=NullPointerException.class)
    public void constructor_nullErrorCode_throws() {
        new PluggableAuthException(null, "errorDescription");
    }

    @Test(expected=NullPointerException.class)
    public void constructor_nullErrorDescription_throws() {
        new PluggableAuthException("errorCode", null);
    }

    @Test
    public void getMessage() {
        PluggableAuthException e = new PluggableAuthException("errorCode", "errorDescription");
        String expectedMessage = String.format(MESSAGE_FORMAT, "errorCode", "errorDescription");
        Assert.assertEquals((Object)expectedMessage, (Object)e.getMessage());
    }
}

