/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.json.GenericJson;
import com.google.auth.oauth2.EnvironmentProvider;
import com.google.auth.oauth2.ExecutableHandler;
import com.google.auth.oauth2.ExecutableResponse;
import com.google.auth.oauth2.OAuth2Utils;
import com.google.auth.oauth2.PluggableAuthException;
import com.google.auth.oauth2.PluggableAuthHandler;
import com.google.auth.oauth2.TestEnvironmentProvider;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class PluggableAuthHandlerTest {
    private static final String TOKEN_TYPE_OIDC = "urn:ietf:params:oauth:token-type:id_token";
    private static final String TOKEN_TYPE_SAML = "urn:ietf:params:oauth:token-type:saml2";
    private static final String ID_TOKEN = "header.payload.signature";
    private static final String SAML_RESPONSE = "samlResponse";
    private static final int EXECUTABLE_SUPPORTED_MAX_VERSION = 1;
    private static final int EXPIRATION_DURATION = 3600;
    private static final int EXIT_CODE_SUCCESS = 0;
    private static final int EXIT_CODE_FAIL = 1;
    private static final ExecutableHandler.ExecutableOptions DEFAULT_OPTIONS = new ExecutableHandler.ExecutableOptions(){

        public String getExecutableCommand() {
            return "/path/to/executable";
        }

        public Map<String, String> getEnvironmentMap() {
            return ImmutableMap.of((Object)"optionKey1", (Object)"optionValue1", (Object)"optionValue2", (Object)"optionValue2");
        }

        public int getExecutableTimeoutMs() {
            return 30000;
        }

        @Nullable
        public String getOutputFilePath() {
            return null;
        }
    };

    @Test
    public void retrieveTokenFromExecutable_oidcResponse() throws IOException, InterruptedException {
        TestEnvironmentProvider environmentProvider = new TestEnvironmentProvider();
        environmentProvider.setEnv("GOOGLE_EXTERNAL_ACCOUNT_ALLOW_EXECUTABLES", "1");
        HashMap<String, String> currentEnv = new HashMap<String, String>();
        currentEnv.put("currentEnvKey1", "currentEnvValue1");
        currentEnv.put("currentEnvKey2", "currentEnvValue2");
        HashMap<String, String> expectedMap = new HashMap<String, String>();
        expectedMap.putAll(DEFAULT_OPTIONS.getEnvironmentMap());
        expectedMap.putAll(currentEnv);
        Process mockProcess = (Process)Mockito.mock(Process.class);
        Mockito.when((Object)mockProcess.waitFor(ArgumentMatchers.anyLong(), (TimeUnit)((Object)Mockito.any(TimeUnit.class)))).thenReturn((Object)true);
        Mockito.when((Object)mockProcess.exitValue()).thenReturn((Object)0);
        Mockito.when((Object)mockProcess.getInputStream()).thenReturn((Object)new ByteArrayInputStream(PluggableAuthHandlerTest.buildOidcResponse().toString().getBytes(StandardCharsets.UTF_8)));
        PluggableAuthHandler.InternalProcessBuilder processBuilder = PluggableAuthHandlerTest.buildInternalProcessBuilder(currentEnv, mockProcess, DEFAULT_OPTIONS.getExecutableCommand());
        PluggableAuthHandler handler = new PluggableAuthHandler((EnvironmentProvider)environmentProvider, processBuilder);
        String token = handler.retrieveTokenFromExecutable(DEFAULT_OPTIONS);
        ((Process)Mockito.verify((Object)mockProcess, (VerificationMode)Mockito.times((int)1))).destroy();
        ((Process)Mockito.verify((Object)mockProcess, (VerificationMode)Mockito.times((int)1))).waitFor((Long)ArgumentMatchers.eq((Object)DEFAULT_OPTIONS.getExecutableTimeoutMs()), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        Assert.assertEquals((Object)ID_TOKEN, (Object)token);
        Assert.assertEquals((long)4L, (long)currentEnv.size());
        Assert.assertEquals(expectedMap, currentEnv);
    }

    @Test
    public void retrieveTokenFromExecutable_samlResponse() throws IOException, InterruptedException {
        TestEnvironmentProvider environmentProvider = new TestEnvironmentProvider();
        environmentProvider.setEnv("GOOGLE_EXTERNAL_ACCOUNT_ALLOW_EXECUTABLES", "1");
        HashMap<String, String> currentEnv = new HashMap<String, String>();
        currentEnv.put("currentEnvKey1", "currentEnvValue1");
        currentEnv.put("currentEnvKey2", "currentEnvValue2");
        HashMap<String, String> expectedMap = new HashMap<String, String>();
        expectedMap.putAll(DEFAULT_OPTIONS.getEnvironmentMap());
        expectedMap.putAll(currentEnv);
        Process mockProcess = (Process)Mockito.mock(Process.class);
        Mockito.when((Object)mockProcess.waitFor(ArgumentMatchers.anyLong(), (TimeUnit)((Object)Mockito.any(TimeUnit.class)))).thenReturn((Object)true);
        Mockito.when((Object)mockProcess.exitValue()).thenReturn((Object)0);
        Mockito.when((Object)mockProcess.getInputStream()).thenReturn((Object)new ByteArrayInputStream(PluggableAuthHandlerTest.buildSamlResponse().toString().getBytes(StandardCharsets.UTF_8)));
        PluggableAuthHandler.InternalProcessBuilder processBuilder = PluggableAuthHandlerTest.buildInternalProcessBuilder(currentEnv, mockProcess, DEFAULT_OPTIONS.getExecutableCommand());
        PluggableAuthHandler handler = new PluggableAuthHandler((EnvironmentProvider)environmentProvider, processBuilder);
        String token = handler.retrieveTokenFromExecutable(DEFAULT_OPTIONS);
        ((Process)Mockito.verify((Object)mockProcess, (VerificationMode)Mockito.times((int)1))).destroy();
        ((Process)Mockito.verify((Object)mockProcess, (VerificationMode)Mockito.times((int)1))).waitFor((Long)ArgumentMatchers.eq((Object)DEFAULT_OPTIONS.getExecutableTimeoutMs()), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        Assert.assertEquals((Object)SAML_RESPONSE, (Object)token);
        Assert.assertEquals((long)4L, (long)currentEnv.size());
        Assert.assertEquals(expectedMap, currentEnv);
    }

    @Test
    public void retrieveTokenFromExecutable_errorResponse_throws() throws InterruptedException, IOException {
        TestEnvironmentProvider environmentProvider = new TestEnvironmentProvider();
        environmentProvider.setEnv("GOOGLE_EXTERNAL_ACCOUNT_ALLOW_EXECUTABLES", "1");
        Process mockProcess = (Process)Mockito.mock(Process.class);
        Mockito.when((Object)mockProcess.waitFor(ArgumentMatchers.anyLong(), (TimeUnit)((Object)Mockito.any(TimeUnit.class)))).thenReturn((Object)true);
        Mockito.when((Object)mockProcess.exitValue()).thenReturn((Object)0);
        Mockito.when((Object)mockProcess.getInputStream()).thenReturn((Object)new ByteArrayInputStream(PluggableAuthHandlerTest.buildErrorResponse().toString().getBytes(StandardCharsets.UTF_8)));
        PluggableAuthHandler.InternalProcessBuilder processBuilder = PluggableAuthHandlerTest.buildInternalProcessBuilder(new HashMap<String, String>(), mockProcess, DEFAULT_OPTIONS.getExecutableCommand());
        PluggableAuthHandler handler = new PluggableAuthHandler((EnvironmentProvider)environmentProvider, processBuilder);
        try {
            handler.retrieveTokenFromExecutable(DEFAULT_OPTIONS);
            Assert.fail((String)"Should not be able to continue without exception.");
        }
        catch (PluggableAuthException e) {
            Assert.assertEquals((Object)"401", (Object)e.getErrorCode());
            Assert.assertEquals((Object)"Caller not authorized.", (Object)e.getErrorDescription());
        }
    }

    @Test
    public void retrieveTokenFromExecutable_successResponseWithoutExpirationTimeField() throws InterruptedException, IOException {
        TestEnvironmentProvider environmentProvider = new TestEnvironmentProvider();
        environmentProvider.setEnv("GOOGLE_EXTERNAL_ACCOUNT_ALLOW_EXECUTABLES", "1");
        HashMap expectedMap = new HashMap();
        expectedMap.putAll(DEFAULT_OPTIONS.getEnvironmentMap());
        HashMap<String, String> currentEnv = new HashMap<String, String>();
        Process mockProcess = (Process)Mockito.mock(Process.class);
        Mockito.when((Object)mockProcess.waitFor(ArgumentMatchers.anyLong(), (TimeUnit)((Object)Mockito.any(TimeUnit.class)))).thenReturn((Object)true);
        Mockito.when((Object)mockProcess.exitValue()).thenReturn((Object)0);
        GenericJson oidcResponse = PluggableAuthHandlerTest.buildOidcResponse();
        oidcResponse.remove((Object)"expiration_time");
        GenericJson samlResponse = PluggableAuthHandlerTest.buildSamlResponse();
        samlResponse.remove((Object)"expiration_time");
        List<GenericJson> responses = Arrays.asList(oidcResponse, samlResponse);
        for (int i = 0; i < responses.size(); ++i) {
            Mockito.when((Object)mockProcess.getInputStream()).thenReturn((Object)new ByteArrayInputStream(responses.get(i).toString().getBytes(StandardCharsets.UTF_8)));
            PluggableAuthHandler.InternalProcessBuilder processBuilder = PluggableAuthHandlerTest.buildInternalProcessBuilder(currentEnv, mockProcess, DEFAULT_OPTIONS.getExecutableCommand());
            PluggableAuthHandler handler = new PluggableAuthHandler((EnvironmentProvider)environmentProvider, processBuilder);
            String token = handler.retrieveTokenFromExecutable(DEFAULT_OPTIONS);
            ((Process)Mockito.verify((Object)mockProcess, (VerificationMode)Mockito.times((int)(i + 1)))).destroy();
            ((Process)Mockito.verify((Object)mockProcess, (VerificationMode)Mockito.times((int)(i + 1)))).waitFor((Long)ArgumentMatchers.eq((Object)DEFAULT_OPTIONS.getExecutableTimeoutMs()), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
            if (responses.get(i).equals((Object)oidcResponse)) {
                Assert.assertEquals((Object)ID_TOKEN, (Object)token);
            } else {
                Assert.assertEquals((Object)SAML_RESPONSE, (Object)token);
            }
            Assert.assertEquals((long)2L, (long)currentEnv.size());
            Assert.assertEquals(expectedMap, currentEnv);
        }
    }

    @Test
    public void retrieveTokenFromExecutable_successResponseWithoutExpirationTimeFieldWithOutputFileSpecified_throws() throws InterruptedException, IOException {
        TestEnvironmentProvider environmentProvider = new TestEnvironmentProvider();
        environmentProvider.setEnv("GOOGLE_EXTERNAL_ACCOUNT_ALLOW_EXECUTABLES", "1");
        ExecutableHandler.ExecutableOptions options = new ExecutableHandler.ExecutableOptions(){

            public String getExecutableCommand() {
                return "/path/to/executable";
            }

            public Map<String, String> getEnvironmentMap() {
                return ImmutableMap.of();
            }

            public int getExecutableTimeoutMs() {
                return 30000;
            }

            public String getOutputFilePath() {
                return "/path/to/output/file";
            }
        };
        Process mockProcess = (Process)Mockito.mock(Process.class);
        Mockito.when((Object)mockProcess.waitFor(ArgumentMatchers.anyLong(), (TimeUnit)((Object)Mockito.any(TimeUnit.class)))).thenReturn((Object)true);
        Mockito.when((Object)mockProcess.exitValue()).thenReturn((Object)0);
        GenericJson oidcResponse = PluggableAuthHandlerTest.buildOidcResponse();
        oidcResponse.remove((Object)"expiration_time");
        GenericJson samlResponse = PluggableAuthHandlerTest.buildSamlResponse();
        samlResponse.remove((Object)"expiration_time");
        List<GenericJson> responses = Arrays.asList(oidcResponse, samlResponse);
        for (int i = 0; i < responses.size(); ++i) {
            Mockito.when((Object)mockProcess.getInputStream()).thenReturn((Object)new ByteArrayInputStream(responses.get(i).toString().getBytes(StandardCharsets.UTF_8)));
            PluggableAuthHandler.InternalProcessBuilder processBuilder = PluggableAuthHandlerTest.buildInternalProcessBuilder(new HashMap<String, String>(), mockProcess, options.getExecutableCommand());
            PluggableAuthHandler handler = new PluggableAuthHandler((EnvironmentProvider)environmentProvider, processBuilder);
            try {
                handler.retrieveTokenFromExecutable(options);
                Assert.fail((String)"Should not be able to continue without exception.");
            }
            catch (PluggableAuthException exception) {
                Assert.assertEquals((Object)"Error code INVALID_EXECUTABLE_RESPONSE: The executable response must contain the `expiration_time` field for successful responses when an output_file has been specified in the configuration.", (Object)exception.getMessage());
            }
            ((Process)Mockito.verify((Object)mockProcess, (VerificationMode)Mockito.times((int)(i + 1)))).destroy();
            ((Process)Mockito.verify((Object)mockProcess, (VerificationMode)Mockito.times((int)(i + 1)))).waitFor((Long)ArgumentMatchers.eq((Object)options.getExecutableTimeoutMs()), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        }
    }

    @Test
    public void retrieveTokenFromExecutable_successResponseInOutputFileMissingExpirationTimeField_throws() throws InterruptedException, IOException {
        TestEnvironmentProvider environmentProvider = new TestEnvironmentProvider();
        environmentProvider.setEnv("GOOGLE_EXTERNAL_ACCOUNT_ALLOW_EXECUTABLES", "1");
        final File file = File.createTempFile("output_file", null, null);
        file.deleteOnExit();
        ExecutableHandler.ExecutableOptions options = new ExecutableHandler.ExecutableOptions(){

            public String getExecutableCommand() {
                return "/path/to/executable";
            }

            public Map<String, String> getEnvironmentMap() {
                return ImmutableMap.of();
            }

            public int getExecutableTimeoutMs() {
                return 30000;
            }

            public String getOutputFilePath() {
                return file.getAbsolutePath();
            }
        };
        Process mockProcess = (Process)Mockito.mock(Process.class);
        PluggableAuthHandler.InternalProcessBuilder processBuilder = PluggableAuthHandlerTest.buildInternalProcessBuilder(new HashMap<String, String>(), mockProcess, options.getExecutableCommand());
        GenericJson oidcResponse = PluggableAuthHandlerTest.buildOidcResponse();
        oidcResponse.remove((Object)"expiration_time");
        GenericJson samlResponse = PluggableAuthHandlerTest.buildSamlResponse();
        samlResponse.remove((Object)"expiration_time");
        List<GenericJson> responses = Arrays.asList(oidcResponse, samlResponse);
        for (GenericJson json : responses) {
            OAuth2Utils.writeInputStreamToFile((InputStream)new ByteArrayInputStream(json.toString().getBytes(StandardCharsets.UTF_8)), (String)file.getAbsolutePath());
            PluggableAuthHandler handler = new PluggableAuthHandler((EnvironmentProvider)environmentProvider, processBuilder);
            try {
                handler.retrieveTokenFromExecutable(options);
                Assert.fail((String)"Should not be able to continue without exception.");
            }
            catch (PluggableAuthException exception) {
                Assert.assertEquals((Object)"Error code INVALID_EXECUTABLE_RESPONSE: The executable response must contain the `expiration_time` field for successful responses when an output_file has been specified in the configuration.", (Object)exception.getMessage());
            }
            ((Process)Mockito.verify((Object)mockProcess, (VerificationMode)Mockito.times((int)0))).destroyForcibly();
            ((Process)Mockito.verify((Object)mockProcess, (VerificationMode)Mockito.times((int)0))).waitFor((Long)ArgumentMatchers.eq((Object)options.getExecutableTimeoutMs()), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        }
    }

    @Test
    public void retrieveTokenFromExecutable_withOutputFile_usesCachedResponse() throws IOException, InterruptedException {
        TestEnvironmentProvider environmentProvider = new TestEnvironmentProvider();
        environmentProvider.setEnv("GOOGLE_EXTERNAL_ACCOUNT_ALLOW_EXECUTABLES", "1");
        final File file = File.createTempFile("output_file", null, null);
        file.deleteOnExit();
        OAuth2Utils.writeInputStreamToFile((InputStream)new ByteArrayInputStream(PluggableAuthHandlerTest.buildOidcResponse().toString().getBytes(StandardCharsets.UTF_8)), (String)file.getAbsolutePath());
        ExecutableHandler.ExecutableOptions options = new ExecutableHandler.ExecutableOptions(){

            public String getExecutableCommand() {
                return "/path/to/executable";
            }

            public Map<String, String> getEnvironmentMap() {
                return ImmutableMap.of();
            }

            public int getExecutableTimeoutMs() {
                return 30000;
            }

            public String getOutputFilePath() {
                return file.getAbsolutePath();
            }
        };
        Process mockProcess = (Process)Mockito.mock(Process.class);
        PluggableAuthHandler.InternalProcessBuilder processBuilder = PluggableAuthHandlerTest.buildInternalProcessBuilder(new HashMap<String, String>(), mockProcess, options.getExecutableCommand());
        PluggableAuthHandler handler = new PluggableAuthHandler((EnvironmentProvider)environmentProvider, processBuilder);
        String token = handler.retrieveTokenFromExecutable(options);
        ((Process)Mockito.verify((Object)mockProcess, (VerificationMode)Mockito.times((int)0))).destroyForcibly();
        ((Process)Mockito.verify((Object)mockProcess, (VerificationMode)Mockito.times((int)0))).waitFor((Long)ArgumentMatchers.eq((Object)options.getExecutableTimeoutMs()), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        Assert.assertEquals((Object)ID_TOKEN, (Object)token);
    }

    @Test
    public void retrieveTokenFromExecutable_withInvalidOutputFile_throws() throws IOException, InterruptedException {
        TestEnvironmentProvider environmentProvider = new TestEnvironmentProvider();
        environmentProvider.setEnv("GOOGLE_EXTERNAL_ACCOUNT_ALLOW_EXECUTABLES", "1");
        final File file = File.createTempFile("output_file", null, null);
        file.deleteOnExit();
        OAuth2Utils.writeInputStreamToFile((InputStream)new ByteArrayInputStream("Bad response.".getBytes(StandardCharsets.UTF_8)), (String)file.getAbsolutePath());
        ExecutableHandler.ExecutableOptions options = new ExecutableHandler.ExecutableOptions(){

            public String getExecutableCommand() {
                return "/path/to/executable";
            }

            public Map<String, String> getEnvironmentMap() {
                return ImmutableMap.of();
            }

            public int getExecutableTimeoutMs() {
                return 30000;
            }

            public String getOutputFilePath() {
                return file.getAbsolutePath();
            }
        };
        Process mockProcess = (Process)Mockito.mock(Process.class);
        PluggableAuthHandler.InternalProcessBuilder processBuilder = PluggableAuthHandlerTest.buildInternalProcessBuilder(new HashMap<String, String>(), mockProcess, options.getExecutableCommand());
        PluggableAuthHandler handler = new PluggableAuthHandler((EnvironmentProvider)environmentProvider, processBuilder);
        try {
            handler.retrieveTokenFromExecutable(options);
            Assert.fail((String)"Should not be able to continue without exception.");
        }
        catch (PluggableAuthException e) {
            Assert.assertEquals((Object)"INVALID_OUTPUT_FILE", (Object)e.getErrorCode());
        }
    }

    @Test
    public void retrieveTokenFromExecutable_expiredOutputFileResponse_callsExecutable() throws IOException, InterruptedException {
        TestEnvironmentProvider environmentProvider = new TestEnvironmentProvider();
        environmentProvider.setEnv("GOOGLE_EXTERNAL_ACCOUNT_ALLOW_EXECUTABLES", "1");
        final File file = File.createTempFile("output_file", null, null);
        file.deleteOnExit();
        GenericJson json = PluggableAuthHandlerTest.buildOidcResponse();
        json.put("expiration_time", (Object)(Instant.now().getEpochSecond() - 1L));
        OAuth2Utils.writeInputStreamToFile((InputStream)new ByteArrayInputStream(json.toString().getBytes(StandardCharsets.UTF_8)), (String)file.getAbsolutePath());
        ExecutableHandler.ExecutableOptions options = new ExecutableHandler.ExecutableOptions(){

            public String getExecutableCommand() {
                return "/path/to/executable";
            }

            public Map<String, String> getEnvironmentMap() {
                return ImmutableMap.of();
            }

            public int getExecutableTimeoutMs() {
                return 30000;
            }

            public String getOutputFilePath() {
                return file.getAbsolutePath();
            }
        };
        Process mockProcess = (Process)Mockito.mock(Process.class);
        Mockito.when((Object)mockProcess.waitFor(ArgumentMatchers.anyLong(), (TimeUnit)((Object)Mockito.any(TimeUnit.class)))).thenReturn((Object)true);
        Mockito.when((Object)mockProcess.exitValue()).thenReturn((Object)0);
        Mockito.when((Object)mockProcess.getInputStream()).thenReturn((Object)new ByteArrayInputStream(PluggableAuthHandlerTest.buildOidcResponse().toString().getBytes(StandardCharsets.UTF_8)));
        PluggableAuthHandler.InternalProcessBuilder processBuilder = PluggableAuthHandlerTest.buildInternalProcessBuilder(new HashMap<String, String>(), mockProcess, options.getExecutableCommand());
        PluggableAuthHandler handler = new PluggableAuthHandler((EnvironmentProvider)environmentProvider, processBuilder);
        String token = handler.retrieveTokenFromExecutable(options);
        ((Process)Mockito.verify((Object)mockProcess, (VerificationMode)Mockito.times((int)1))).destroy();
        ((Process)Mockito.verify((Object)mockProcess, (VerificationMode)Mockito.times((int)1))).waitFor((Long)ArgumentMatchers.eq((Object)options.getExecutableTimeoutMs()), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        Assert.assertEquals((Object)ID_TOKEN, (Object)token);
    }

    @Test
    public void retrieveTokenFromExecutable_expiredResponse_throws() throws InterruptedException, IOException {
        TestEnvironmentProvider environmentProvider = new TestEnvironmentProvider();
        environmentProvider.setEnv("GOOGLE_EXTERNAL_ACCOUNT_ALLOW_EXECUTABLES", "1");
        GenericJson json = PluggableAuthHandlerTest.buildOidcResponse();
        json.put("expiration_time", (Object)(Instant.now().getEpochSecond() - 1L));
        Process mockProcess = (Process)Mockito.mock(Process.class);
        Mockito.when((Object)mockProcess.waitFor(ArgumentMatchers.anyLong(), (TimeUnit)((Object)Mockito.any(TimeUnit.class)))).thenReturn((Object)true);
        Mockito.when((Object)mockProcess.exitValue()).thenReturn((Object)0);
        Mockito.when((Object)mockProcess.getInputStream()).thenReturn((Object)new ByteArrayInputStream(json.toString().getBytes(StandardCharsets.UTF_8)));
        PluggableAuthHandler.InternalProcessBuilder processBuilder = PluggableAuthHandlerTest.buildInternalProcessBuilder(new HashMap<String, String>(), mockProcess, DEFAULT_OPTIONS.getExecutableCommand());
        PluggableAuthHandler handler = new PluggableAuthHandler((EnvironmentProvider)environmentProvider, processBuilder);
        try {
            handler.retrieveTokenFromExecutable(DEFAULT_OPTIONS);
            Assert.fail((String)"Should not be able to continue without exception.");
        }
        catch (PluggableAuthException e) {
            Assert.assertEquals((Object)"INVALID_RESPONSE", (Object)e.getErrorCode());
            Assert.assertEquals((Object)"The executable response is expired.", (Object)e.getErrorDescription());
        }
    }

    @Test
    public void retrieveTokenFromExecutable_invalidVersion_throws() throws InterruptedException, IOException {
        TestEnvironmentProvider environmentProvider = new TestEnvironmentProvider();
        environmentProvider.setEnv("GOOGLE_EXTERNAL_ACCOUNT_ALLOW_EXECUTABLES", "1");
        Process mockProcess = (Process)Mockito.mock(Process.class);
        Mockito.when((Object)mockProcess.waitFor(ArgumentMatchers.anyLong(), (TimeUnit)((Object)Mockito.any(TimeUnit.class)))).thenReturn((Object)true);
        Mockito.when((Object)mockProcess.exitValue()).thenReturn((Object)0);
        GenericJson json = PluggableAuthHandlerTest.buildSamlResponse();
        json.put("version", (Object)2);
        Mockito.when((Object)mockProcess.getInputStream()).thenReturn((Object)new ByteArrayInputStream(json.toString().getBytes(StandardCharsets.UTF_8)));
        PluggableAuthHandler.InternalProcessBuilder processBuilder = PluggableAuthHandlerTest.buildInternalProcessBuilder(new HashMap<String, String>(), mockProcess, DEFAULT_OPTIONS.getExecutableCommand());
        PluggableAuthHandler handler = new PluggableAuthHandler((EnvironmentProvider)environmentProvider, processBuilder);
        try {
            handler.retrieveTokenFromExecutable(DEFAULT_OPTIONS);
            Assert.fail((String)"Should not be able to continue without exception.");
        }
        catch (PluggableAuthException e) {
            Assert.assertEquals((Object)"UNSUPPORTED_VERSION", (Object)e.getErrorCode());
            Assert.assertEquals((Object)("The version of the executable response is not supported. " + String.format("The maximum version currently supported is %s.", 1)), (Object)e.getErrorDescription());
        }
    }

    @Test
    public void retrieveTokenFromExecutable_allowExecutablesDisabled_throws() throws IOException {
        TestEnvironmentProvider environmentProvider = new TestEnvironmentProvider();
        environmentProvider.setEnv("GOOGLE_EXTERNAL_ACCOUNT_ALLOW_EXECUTABLES", "0");
        PluggableAuthHandler handler = new PluggableAuthHandler((EnvironmentProvider)environmentProvider);
        try {
            handler.retrieveTokenFromExecutable(DEFAULT_OPTIONS);
            Assert.fail((String)"Should not be able to continue without exception.");
        }
        catch (PluggableAuthException e) {
            Assert.assertEquals((Object)"PLUGGABLE_AUTH_DISABLED", (Object)e.getErrorCode());
            Assert.assertEquals((Object)"Pluggable Auth executables need to be explicitly allowed to run by setting the GOOGLE_EXTERNAL_ACCOUNT_ALLOW_EXECUTABLES environment variable to 1.", (Object)e.getErrorDescription());
        }
    }

    @Test
    public void getExecutableResponse_oidcResponse() throws IOException, InterruptedException {
        TestEnvironmentProvider environmentProvider = new TestEnvironmentProvider();
        environmentProvider.setEnv("GOOGLE_EXTERNAL_ACCOUNT_ALLOW_EXECUTABLES", "1");
        HashMap<String, String> currentEnv = new HashMap<String, String>();
        currentEnv.put("currentEnvKey1", "currentEnvValue1");
        currentEnv.put("currentEnvKey2", "currentEnvValue2");
        HashMap<String, String> expectedMap = new HashMap<String, String>();
        expectedMap.putAll(DEFAULT_OPTIONS.getEnvironmentMap());
        expectedMap.putAll(currentEnv);
        Process mockProcess = (Process)Mockito.mock(Process.class);
        Mockito.when((Object)mockProcess.waitFor(ArgumentMatchers.anyLong(), (TimeUnit)((Object)Mockito.any(TimeUnit.class)))).thenReturn((Object)true);
        Mockito.when((Object)mockProcess.exitValue()).thenReturn((Object)0);
        Mockito.when((Object)mockProcess.getInputStream()).thenReturn((Object)new ByteArrayInputStream(PluggableAuthHandlerTest.buildOidcResponse().toString().getBytes(StandardCharsets.UTF_8)));
        PluggableAuthHandler.InternalProcessBuilder processBuilder = PluggableAuthHandlerTest.buildInternalProcessBuilder(currentEnv, mockProcess, DEFAULT_OPTIONS.getExecutableCommand());
        PluggableAuthHandler handler = new PluggableAuthHandler((EnvironmentProvider)environmentProvider, processBuilder);
        ExecutableResponse response = handler.getExecutableResponse(DEFAULT_OPTIONS);
        ((Process)Mockito.verify((Object)mockProcess, (VerificationMode)Mockito.times((int)1))).destroy();
        ((Process)Mockito.verify((Object)mockProcess, (VerificationMode)Mockito.times((int)1))).waitFor((Long)ArgumentMatchers.eq((Object)DEFAULT_OPTIONS.getExecutableTimeoutMs()), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        Assert.assertEquals((long)1L, (long)response.getVersion());
        Assert.assertTrue((boolean)response.isSuccessful());
        Assert.assertEquals((Object)TOKEN_TYPE_OIDC, (Object)response.getTokenType());
        Assert.assertEquals((Object)ID_TOKEN, (Object)response.getSubjectToken());
        Assert.assertTrue((Instant.now().getEpochSecond() + 3600L == response.getExpirationTime() ? 1 : 0) != 0);
        Assert.assertEquals((long)4L, (long)currentEnv.size());
        Assert.assertEquals(expectedMap, currentEnv);
    }

    @Test
    public void getExecutableResponse_samlResponse() throws IOException, InterruptedException {
        TestEnvironmentProvider environmentProvider = new TestEnvironmentProvider();
        environmentProvider.setEnv("GOOGLE_EXTERNAL_ACCOUNT_ALLOW_EXECUTABLES", "1");
        HashMap<String, String> currentEnv = new HashMap<String, String>();
        currentEnv.put("currentEnvKey1", "currentEnvValue1");
        currentEnv.put("currentEnvKey2", "currentEnvValue2");
        HashMap<String, String> expectedMap = new HashMap<String, String>();
        expectedMap.putAll(DEFAULT_OPTIONS.getEnvironmentMap());
        expectedMap.putAll(currentEnv);
        Process mockProcess = (Process)Mockito.mock(Process.class);
        Mockito.when((Object)mockProcess.waitFor(ArgumentMatchers.anyLong(), (TimeUnit)((Object)Mockito.any(TimeUnit.class)))).thenReturn((Object)true);
        Mockito.when((Object)mockProcess.exitValue()).thenReturn((Object)0);
        Mockito.when((Object)mockProcess.getInputStream()).thenReturn((Object)new ByteArrayInputStream(PluggableAuthHandlerTest.buildSamlResponse().toString().getBytes(StandardCharsets.UTF_8)));
        PluggableAuthHandler.InternalProcessBuilder processBuilder = PluggableAuthHandlerTest.buildInternalProcessBuilder(currentEnv, mockProcess, DEFAULT_OPTIONS.getExecutableCommand());
        PluggableAuthHandler handler = new PluggableAuthHandler((EnvironmentProvider)environmentProvider, processBuilder);
        ExecutableResponse response = handler.getExecutableResponse(DEFAULT_OPTIONS);
        ((Process)Mockito.verify((Object)mockProcess, (VerificationMode)Mockito.times((int)1))).destroy();
        ((Process)Mockito.verify((Object)mockProcess, (VerificationMode)Mockito.times((int)1))).waitFor((Long)ArgumentMatchers.eq((Object)DEFAULT_OPTIONS.getExecutableTimeoutMs()), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        Assert.assertEquals((long)1L, (long)response.getVersion());
        Assert.assertTrue((boolean)response.isSuccessful());
        Assert.assertEquals((Object)TOKEN_TYPE_SAML, (Object)response.getTokenType());
        Assert.assertEquals((Object)SAML_RESPONSE, (Object)response.getSubjectToken());
        Assert.assertTrue((Instant.now().getEpochSecond() + 3600L == response.getExpirationTime() ? 1 : 0) != 0);
        Assert.assertEquals((long)4L, (long)currentEnv.size());
        Assert.assertEquals(expectedMap, currentEnv);
        ((Process)Mockito.verify((Object)mockProcess, (VerificationMode)Mockito.times((int)1))).destroy();
    }

    @Test
    public void getExecutableResponse_errorResponse() throws IOException, InterruptedException {
        TestEnvironmentProvider environmentProvider = new TestEnvironmentProvider();
        environmentProvider.setEnv("GOOGLE_EXTERNAL_ACCOUNT_ALLOW_EXECUTABLES", "1");
        HashMap<String, String> currentEnv = new HashMap<String, String>();
        currentEnv.put("currentEnvKey1", "currentEnvValue1");
        currentEnv.put("currentEnvKey2", "currentEnvValue2");
        HashMap<String, String> expectedMap = new HashMap<String, String>();
        expectedMap.putAll(DEFAULT_OPTIONS.getEnvironmentMap());
        expectedMap.putAll(currentEnv);
        Process mockProcess = (Process)Mockito.mock(Process.class);
        Mockito.when((Object)mockProcess.waitFor(ArgumentMatchers.anyLong(), (TimeUnit)((Object)Mockito.any(TimeUnit.class)))).thenReturn((Object)true);
        Mockito.when((Object)mockProcess.exitValue()).thenReturn((Object)0);
        Mockito.when((Object)mockProcess.getInputStream()).thenReturn((Object)new ByteArrayInputStream(PluggableAuthHandlerTest.buildErrorResponse().toString().getBytes(StandardCharsets.UTF_8)));
        PluggableAuthHandler.InternalProcessBuilder processBuilder = PluggableAuthHandlerTest.buildInternalProcessBuilder(currentEnv, mockProcess, DEFAULT_OPTIONS.getExecutableCommand());
        PluggableAuthHandler handler = new PluggableAuthHandler((EnvironmentProvider)environmentProvider, processBuilder);
        ExecutableResponse response = handler.getExecutableResponse(DEFAULT_OPTIONS);
        ((Process)Mockito.verify((Object)mockProcess, (VerificationMode)Mockito.times((int)1))).destroy();
        ((Process)Mockito.verify((Object)mockProcess, (VerificationMode)Mockito.times((int)1))).waitFor((Long)ArgumentMatchers.eq((Object)DEFAULT_OPTIONS.getExecutableTimeoutMs()), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        Assert.assertEquals((long)1L, (long)response.getVersion());
        Assert.assertFalse((boolean)response.isSuccessful());
        Assert.assertEquals((Object)"401", (Object)response.getErrorCode());
        Assert.assertEquals((Object)"Caller not authorized.", (Object)response.getErrorMessage());
        Assert.assertEquals((long)4L, (long)currentEnv.size());
        Assert.assertEquals(expectedMap, currentEnv);
    }

    @Test
    public void getExecutableResponse_timeoutExceeded_throws() throws InterruptedException, IOException {
        TestEnvironmentProvider environmentProvider = new TestEnvironmentProvider();
        environmentProvider.setEnv("GOOGLE_EXTERNAL_ACCOUNT_ALLOW_EXECUTABLES", "1");
        Process mockProcess = (Process)Mockito.mock(Process.class);
        Mockito.when((Object)mockProcess.waitFor(ArgumentMatchers.anyLong(), (TimeUnit)((Object)Mockito.any(TimeUnit.class)))).thenReturn((Object)false);
        PluggableAuthHandler.InternalProcessBuilder processBuilder = PluggableAuthHandlerTest.buildInternalProcessBuilder(new HashMap<String, String>(), mockProcess, DEFAULT_OPTIONS.getExecutableCommand());
        PluggableAuthHandler handler = new PluggableAuthHandler((EnvironmentProvider)environmentProvider, processBuilder);
        try {
            handler.getExecutableResponse(DEFAULT_OPTIONS);
            Assert.fail((String)"Should not be able to continue without exception.");
        }
        catch (PluggableAuthException e) {
            Assert.assertEquals((Object)"TIMEOUT_EXCEEDED", (Object)e.getErrorCode());
            Assert.assertEquals((Object)"The executable failed to finish within the timeout specified.", (Object)e.getErrorDescription());
        }
        ((Process)Mockito.verify((Object)mockProcess, (VerificationMode)Mockito.times((int)1))).waitFor((Long)ArgumentMatchers.eq((Object)DEFAULT_OPTIONS.getExecutableTimeoutMs()), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        ((Process)Mockito.verify((Object)mockProcess, (VerificationMode)Mockito.times((int)1))).destroy();
    }

    @Test
    public void getExecutableResponse_nonZeroExitCode_throws() throws InterruptedException, IOException {
        TestEnvironmentProvider environmentProvider = new TestEnvironmentProvider();
        environmentProvider.setEnv("GOOGLE_EXTERNAL_ACCOUNT_ALLOW_EXECUTABLES", "1");
        Process mockProcess = (Process)Mockito.mock(Process.class);
        Mockito.when((Object)mockProcess.waitFor(ArgumentMatchers.anyLong(), (TimeUnit)((Object)Mockito.any(TimeUnit.class)))).thenReturn((Object)true);
        Mockito.when((Object)mockProcess.exitValue()).thenReturn((Object)1);
        PluggableAuthHandler.InternalProcessBuilder processBuilder = PluggableAuthHandlerTest.buildInternalProcessBuilder(new HashMap<String, String>(), mockProcess, DEFAULT_OPTIONS.getExecutableCommand());
        PluggableAuthHandler handler = new PluggableAuthHandler((EnvironmentProvider)environmentProvider, processBuilder);
        try {
            handler.getExecutableResponse(DEFAULT_OPTIONS);
            Assert.fail((String)"Should not be able to continue without exception.");
        }
        catch (PluggableAuthException e) {
            Assert.assertEquals((Object)"EXIT_CODE", (Object)e.getErrorCode());
            Assert.assertEquals((Object)String.format("The executable failed with exit code %s.", 1), (Object)e.getErrorDescription());
        }
        ((Process)Mockito.verify((Object)mockProcess, (VerificationMode)Mockito.times((int)1))).waitFor((Long)ArgumentMatchers.eq((Object)DEFAULT_OPTIONS.getExecutableTimeoutMs()), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        ((Process)Mockito.verify((Object)mockProcess, (VerificationMode)Mockito.times((int)1))).destroy();
    }

    @Test
    public void getExecutableResponse_processInterrupted_throws() throws InterruptedException, IOException {
        TestEnvironmentProvider environmentProvider = new TestEnvironmentProvider();
        environmentProvider.setEnv("GOOGLE_EXTERNAL_ACCOUNT_ALLOW_EXECUTABLES", "1");
        Process mockProcess = (Process)Mockito.mock(Process.class);
        Mockito.when((Object)mockProcess.waitFor(ArgumentMatchers.anyLong(), (TimeUnit)((Object)Mockito.any(TimeUnit.class)))).thenThrow(new Throwable[]{new InterruptedException()});
        PluggableAuthHandler.InternalProcessBuilder processBuilder = PluggableAuthHandlerTest.buildInternalProcessBuilder(new HashMap<String, String>(), mockProcess, DEFAULT_OPTIONS.getExecutableCommand());
        PluggableAuthHandler handler = new PluggableAuthHandler((EnvironmentProvider)environmentProvider, processBuilder);
        try {
            handler.getExecutableResponse(DEFAULT_OPTIONS);
            Assert.fail((String)"Should not be able to continue without exception.");
        }
        catch (PluggableAuthException e) {
            Assert.assertEquals((Object)"INTERRUPTED", (Object)e.getErrorCode());
            Assert.assertEquals((Object)String.format("The execution was interrupted: %s.", new InterruptedException()), (Object)e.getErrorDescription());
        }
        ((Process)Mockito.verify((Object)mockProcess, (VerificationMode)Mockito.times((int)1))).waitFor((Long)ArgumentMatchers.eq((Object)DEFAULT_OPTIONS.getExecutableTimeoutMs()), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        ((Process)Mockito.verify((Object)mockProcess, (VerificationMode)Mockito.times((int)1))).destroy();
    }

    @Test
    public void getExecutableResponse_invalidResponse_throws() throws InterruptedException, IOException {
        TestEnvironmentProvider environmentProvider = new TestEnvironmentProvider();
        environmentProvider.setEnv("GOOGLE_EXTERNAL_ACCOUNT_ALLOW_EXECUTABLES", "1");
        Process mockProcess = (Process)Mockito.mock(Process.class);
        Mockito.when((Object)mockProcess.waitFor(ArgumentMatchers.anyLong(), (TimeUnit)((Object)Mockito.any(TimeUnit.class)))).thenReturn((Object)true);
        Mockito.when((Object)mockProcess.exitValue()).thenReturn((Object)0);
        String badResponse = "badResponse";
        Mockito.when((Object)mockProcess.getInputStream()).thenReturn((Object)new ByteArrayInputStream(badResponse.getBytes(StandardCharsets.UTF_8)));
        PluggableAuthHandler.InternalProcessBuilder processBuilder = PluggableAuthHandlerTest.buildInternalProcessBuilder(new HashMap<String, String>(), mockProcess, DEFAULT_OPTIONS.getExecutableCommand());
        PluggableAuthHandler handler = new PluggableAuthHandler((EnvironmentProvider)environmentProvider, processBuilder);
        try {
            handler.getExecutableResponse(DEFAULT_OPTIONS);
            Assert.fail((String)"Should not be able to continue without exception.");
        }
        catch (PluggableAuthException e) {
            Assert.assertEquals((Object)"INVALID_RESPONSE", (Object)e.getErrorCode());
            Assert.assertEquals((Object)String.format("The executable returned an invalid response: %s.", badResponse), (Object)e.getErrorDescription());
        }
        ((Process)Mockito.verify((Object)mockProcess, (VerificationMode)Mockito.times((int)1))).waitFor((Long)ArgumentMatchers.eq((Object)DEFAULT_OPTIONS.getExecutableTimeoutMs()), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        ((Process)Mockito.verify((Object)mockProcess, (VerificationMode)Mockito.times((int)1))).destroy();
    }

    private static GenericJson buildOidcResponse() {
        GenericJson json = new GenericJson();
        json.setFactory(OAuth2Utils.JSON_FACTORY);
        json.put("version", (Object)1);
        json.put("success", (Object)true);
        json.put("token_type", (Object)TOKEN_TYPE_OIDC);
        json.put("id_token", (Object)ID_TOKEN);
        json.put("expiration_time", (Object)(Instant.now().getEpochSecond() + 3600L));
        return json;
    }

    private static GenericJson buildSamlResponse() {
        GenericJson json = new GenericJson();
        json.setFactory(OAuth2Utils.JSON_FACTORY);
        json.put("version", (Object)1);
        json.put("success", (Object)true);
        json.put("token_type", (Object)TOKEN_TYPE_SAML);
        json.put("saml_response", (Object)SAML_RESPONSE);
        json.put("expiration_time", (Object)(Instant.now().getEpochSecond() + 3600L));
        return json;
    }

    private static GenericJson buildErrorResponse() {
        GenericJson json = new GenericJson();
        json.setFactory(OAuth2Utils.JSON_FACTORY);
        json.put("version", (Object)1);
        json.put("success", (Object)false);
        json.put("code", (Object)"401");
        json.put("message", (Object)"Caller not authorized.");
        return json;
    }

    private static PluggableAuthHandler.InternalProcessBuilder buildInternalProcessBuilder(final Map<String, String> currentEnv, final Process process, String command) {
        return new PluggableAuthHandler.InternalProcessBuilder(){

            Map<String, String> environment() {
                return currentEnv;
            }

            PluggableAuthHandler.InternalProcessBuilder redirectErrorStream(boolean redirectErrorStream) {
                return this;
            }

            Process start() {
                return process;
            }
        };
    }
}

