/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.api.client.util.Clock;
import com.google.auth.RequestMetadataCallback;
import com.google.auth.TestClock;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.BaseSerializationTest;
import com.google.auth.oauth2.GoogleCredentialsTest;
import com.google.auth.oauth2.JwtClaims;
import com.google.auth.oauth2.JwtCredentials;
import com.google.auth.oauth2.MockExecutor;
import com.google.auth.oauth2.MockRequestMetadataCallback;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.auth.oauth2.ServiceAccountCredentialsTest;
import com.google.auth.oauth2.ServiceAccountJwtAccessCredentials;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ServiceAccountJwtAccessCredentialsTest
extends BaseSerializationTest {
    private static final String SA_CLIENT_EMAIL = "36680232662-vrd7ji19qe3nelgchd0ah2csanun6bnr@developer.gserviceaccount.com";
    private static final String SA_CLIENT_ID = "36680232662-vrd7ji19qe3nelgchd0ah2csanun6bnr.apps.googleusercontent.com";
    private static final String SA_PRIVATE_KEY_ID = "d84a4fefcf50791d4a90f2d7af17469d6282df9d";
    private static final String SA_PRIVATE_KEY_PKCS8 = "-----BEGIN PRIVATE KEY-----\nMIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBALX0PQoe1igW12ikv1bN/r9lN749y2ijmbc/mFHPyS3hNTyOCjDvBbXYbDhQJzWVUikh4mvGBA07qTj79Xc3yBDfKP2IeyYQIFe0t0zkd7R9Zdn98Y2rIQC47aAbDfubtkU1U72t4zL11kHvoa0/RuFZjncvlr42X7be7lYh4p3NAgMBAAECgYASk5wDw4Az2ZkmeuN6Fk/y9H+Lcb2pskJIXjrL533vrDWGOC48LrsThMQPv8cxBky8HFSEklPpkfTF95tpD43iVwJRB/GrCtGTw65IfJ4/tI09h6zGc4yqvIo1cHX/LQ+SxKLGyir/dQM925rGt/VojxY5ryJR7GLbCzxPnJm/oQJBANwOCO6D2hy1LQYJhXh7O+RLtA/tSnT1xyMQsGT+uUCMiKS2bSKx2wxo9k7h3OegNJIu1q6nZ6AbxDK8H3+d0dUCQQDTrPSXagBxzp8PecbaCHjzNRSQE2in81qYnrAFNB4o3DpHyMMY6s5ALLeHKscEWnqP8Ur6X4PvzZecCWU9BKAZAkAutLPknAuxSCsUOvUfS1i87ex77Ot+w6POp34pEX+UWb+u5iFn2cQacDTHLV1LtE80L8jVLSbrbrlH43H0DjU5AkEAgidhycxS86dxpEljnOMCw8CKoUBd5I880IUahEiUltk7OLJYS/Ts1wbn3kPOVX3wyJs8WBDtBkFrDHW2ezth2QJADj3e1YhMVdjJW5jqwlD/VNddGjgzyunmiZg0uOXsHXbytYmsA545S8KRQFaJKFXYYFo2kOjqOiC1T2cAzMDjCQ==\n-----END PRIVATE KEY-----\n";
    private static final String JWT_ACCESS_PREFIX = "Bearer ";
    private static final URI CALL_URI = URI.create("http://googleapis.com/testapi/v1/foo");
    private static final JsonFactory JSON_FACTORY = GsonFactory.getDefaultInstance();
    private static final String QUOTA_PROJECT = "sample-quota-project-id";

    @Test
    public void constructor_allParameters_constructs() throws IOException {
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).setQuotaProjectId(QUOTA_PROJECT).build();
        Assert.assertEquals((Object)SA_CLIENT_ID, (Object)credentials.getClientId());
        Assert.assertEquals((Object)SA_CLIENT_EMAIL, (Object)credentials.getClientEmail());
        Assert.assertEquals((Object)privateKey, (Object)credentials.getPrivateKey());
        Assert.assertEquals((Object)SA_PRIVATE_KEY_ID, (Object)credentials.getPrivateKeyId());
        Assert.assertEquals((Object)QUOTA_PROJECT, (Object)credentials.getQuotaProjectId());
    }

    @Test
    public void constructor_noClientId_constructs() throws IOException {
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        ServiceAccountJwtAccessCredentials.newBuilder().setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).build();
    }

    @Test
    public void constructor_noPrivateKeyId_constructs() throws IOException {
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).build();
    }

    @Test
    public void constructor_noEmail_throws() throws IOException {
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        try {
            ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).build();
            Assert.fail((String)"exception expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void constructor_noPrivateKey_throws() {
        try {
            ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKeyId(SA_PRIVATE_KEY_ID).build();
            Assert.fail((String)"exception expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void getAuthenticationType_returnsJwtAccess() throws IOException {
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.fromPkcs8((String)SA_CLIENT_ID, (String)SA_CLIENT_EMAIL, (String)SA_PRIVATE_KEY_PKCS8, (String)SA_PRIVATE_KEY_ID);
        Assert.assertEquals((Object)credentials.getAuthenticationType(), (Object)"JWTAccess");
    }

    @Test
    public void hasRequestMetadata_returnsTrue() throws IOException {
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.fromPkcs8((String)SA_CLIENT_ID, (String)SA_CLIENT_EMAIL, (String)SA_PRIVATE_KEY_PKCS8, (String)SA_PRIVATE_KEY_ID);
        Assert.assertTrue((boolean)credentials.hasRequestMetadata());
    }

    @Test
    public void hasRequestMetadataOnly_returnsTrue() throws IOException {
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.fromPkcs8((String)SA_CLIENT_ID, (String)SA_CLIENT_EMAIL, (String)SA_PRIVATE_KEY_PKCS8, (String)SA_PRIVATE_KEY_ID);
        Assert.assertTrue((boolean)credentials.hasRequestMetadataOnly());
    }

    @Test
    public void getRequestMetadata_blocking_hasJwtAccess() throws IOException {
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).build();
        Map metadata = credentials.getRequestMetadata(CALL_URI);
        this.verifyJwtAccess(metadata, SA_CLIENT_EMAIL, CALL_URI, SA_PRIVATE_KEY_ID);
    }

    @Test
    public void getRequestMetadata_blocking_defaultURI_hasJwtAccess() throws IOException {
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).setDefaultAudience(CALL_URI).build();
        Map metadata = credentials.getRequestMetadata();
        this.verifyJwtAccess(metadata, SA_CLIENT_EMAIL, CALL_URI, SA_PRIVATE_KEY_ID);
    }

    @Test
    public void getRequestMetadata_blocking_noURI_throws() throws IOException {
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).build();
        try {
            credentials.getRequestMetadata();
            Assert.fail((String)"exception expected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void getRequestMetadata_blocking_cached() throws IOException {
        TestClock testClock = new TestClock();
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).build();
        credentials.clock = testClock;
        Map metadata1 = credentials.getRequestMetadata(CALL_URI);
        long lifeSpanMs = TimeUnit.SECONDS.toMillis(10L);
        testClock.setCurrentTime(lifeSpanMs);
        Map metadata2 = credentials.getRequestMetadata(CALL_URI);
        Assert.assertEquals((Object)metadata1, (Object)metadata2);
    }

    @Test
    public void getRequestMetadata_blocking_cache_expired() throws IOException {
        TestClock testClock = new TestClock();
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).build();
        credentials.clock = testClock;
        Map metadata1 = credentials.getRequestMetadata(CALL_URI);
        long lifeSpanMs = TimeUnit.SECONDS.toMillis(ServiceAccountJwtAccessCredentials.LIFE_SPAN_SECS);
        testClock.setCurrentTime(lifeSpanMs);
        Map metadata2 = credentials.getRequestMetadata(CALL_URI);
        Assert.assertNotEquals((Object)metadata1, (Object)metadata2);
    }

    @Test
    public void getRequestMetadata_async_hasJwtAccess() throws IOException {
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).build();
        MockExecutor executor = new MockExecutor();
        MockRequestMetadataCallback callback = new MockRequestMetadataCallback();
        credentials.getRequestMetadata(CALL_URI, (Executor)executor, (RequestMetadataCallback)callback);
        Assert.assertEquals((long)0L, (long)executor.numTasks());
        Assert.assertNotNull(callback.metadata);
        this.verifyJwtAccess(callback.metadata, SA_CLIENT_EMAIL, CALL_URI, SA_PRIVATE_KEY_ID);
    }

    @Test
    public void getRequestMetadata_async_defaultURI_hasJwtAccess() throws IOException {
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).setDefaultAudience(CALL_URI).build();
        MockExecutor executor = new MockExecutor();
        MockRequestMetadataCallback callback = new MockRequestMetadataCallback();
        credentials.getRequestMetadata(null, (Executor)executor, (RequestMetadataCallback)callback);
        Assert.assertEquals((long)0L, (long)executor.numTasks());
        Assert.assertNotNull(callback.metadata);
        this.verifyJwtAccess(callback.metadata, SA_CLIENT_EMAIL, CALL_URI, SA_PRIVATE_KEY_ID);
    }

    @Test
    public void getRequestMetadata_async_noURI_exception() throws IOException {
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).build();
        MockExecutor executor = new MockExecutor();
        MockRequestMetadataCallback callback = new MockRequestMetadataCallback();
        credentials.getRequestMetadata(null, (Executor)executor, (RequestMetadataCallback)callback);
        Assert.assertEquals((long)0L, (long)executor.numTasks());
        Assert.assertNotNull((Object)callback.exception);
    }

    @Test
    public void getRequestMetadata_async_cache_expired() throws IOException {
        TestClock testClock = new TestClock();
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).build();
        credentials.clock = testClock;
        MockExecutor executor = new MockExecutor();
        MockRequestMetadataCallback callback1 = new MockRequestMetadataCallback();
        credentials.getRequestMetadata(CALL_URI, (Executor)executor, (RequestMetadataCallback)callback1);
        long lifeSpanMs = TimeUnit.SECONDS.toMillis(ServiceAccountJwtAccessCredentials.LIFE_SPAN_SECS);
        testClock.setCurrentTime(lifeSpanMs);
        MockRequestMetadataCallback callback2 = new MockRequestMetadataCallback();
        credentials.getRequestMetadata(CALL_URI, (Executor)executor, (RequestMetadataCallback)callback2);
        Assert.assertNotEquals(callback1.metadata, callback2.metadata);
    }

    @Test
    public void getRequestMetadata_async_cached() throws IOException {
        TestClock testClock = new TestClock();
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).build();
        credentials.clock = testClock;
        MockExecutor executor = new MockExecutor();
        MockRequestMetadataCallback callback1 = new MockRequestMetadataCallback();
        credentials.getRequestMetadata(CALL_URI, (Executor)executor, (RequestMetadataCallback)callback1);
        long lifeSpanMs = TimeUnit.SECONDS.toMillis(10L);
        testClock.setCurrentTime(lifeSpanMs);
        MockRequestMetadataCallback callback2 = new MockRequestMetadataCallback();
        credentials.getRequestMetadata(CALL_URI, (Executor)executor, (RequestMetadataCallback)callback2);
        Assert.assertEquals(callback1.metadata, callback2.metadata);
    }

    @Test
    public void getRequestMetadata_contains_quotaProjectId() throws IOException {
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).setDefaultAudience(CALL_URI).setQuotaProjectId(QUOTA_PROJECT).build();
        Map metadata = credentials.getRequestMetadata(CALL_URI);
        Assert.assertTrue((boolean)metadata.containsKey("x-goog-user-project"));
        Assert.assertEquals(metadata.get("x-goog-user-project"), Collections.singletonList(QUOTA_PROJECT));
    }

    @Test
    public void getAccount_sameAs() throws IOException {
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).build();
        Assert.assertEquals((Object)SA_CLIENT_EMAIL, (Object)credentials.getAccount());
    }

    @Test
    public void sign_sameAs() throws IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        byte[] toSign = new byte[]{13, 14, 10, 13};
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).build();
        byte[] signedBytes = credentials.sign(toSign);
        Signature signature = Signature.getInstance("SHA256withRSA");
        signature.initSign(credentials.getPrivateKey());
        signature.update(toSign);
        Assert.assertArrayEquals((byte[])signature.sign(), (byte[])signedBytes);
    }

    @Test
    public void equals_true() throws IOException {
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).setDefaultAudience(CALL_URI).build();
        ServiceAccountJwtAccessCredentials otherCredentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).setDefaultAudience(CALL_URI).build();
        Assert.assertTrue((boolean)credentials.equals((Object)otherCredentials));
        Assert.assertTrue((boolean)otherCredentials.equals((Object)credentials));
    }

    @Test
    public void equals_false_clientId() throws IOException {
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).setDefaultAudience(CALL_URI).build();
        ServiceAccountJwtAccessCredentials otherCredentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId("otherClientId").setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).setDefaultAudience(CALL_URI).build();
        Assert.assertFalse((boolean)credentials.equals((Object)otherCredentials));
        Assert.assertFalse((boolean)otherCredentials.equals((Object)credentials));
    }

    @Test
    public void equals_false_email() throws IOException {
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).setDefaultAudience(CALL_URI).build();
        ServiceAccountJwtAccessCredentials otherCredentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail("otherClientEmail").setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).setDefaultAudience(CALL_URI).build();
        Assert.assertFalse((boolean)credentials.equals((Object)otherCredentials));
        Assert.assertFalse((boolean)otherCredentials.equals((Object)credentials));
    }

    @Test
    public void equals_false_keyId() throws IOException {
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).setDefaultAudience(CALL_URI).build();
        ServiceAccountJwtAccessCredentials otherCredentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId("otherKeyId").setDefaultAudience(CALL_URI).build();
        Assert.assertFalse((boolean)credentials.equals((Object)otherCredentials));
        Assert.assertFalse((boolean)otherCredentials.equals((Object)credentials));
    }

    @Test
    public void equals_false_callUri() throws IOException {
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        URI otherCallUri = URI.create("https://foo.com/bar");
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).setDefaultAudience(CALL_URI).build();
        ServiceAccountJwtAccessCredentials otherCredentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).setDefaultAudience(otherCallUri).build();
        Assert.assertFalse((boolean)credentials.equals((Object)otherCredentials));
        Assert.assertFalse((boolean)otherCredentials.equals((Object)credentials));
    }

    @Test
    public void toString_containsFields() throws IOException {
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).setDefaultAudience(CALL_URI).setQuotaProjectId(QUOTA_PROJECT).build();
        String expectedToString = String.format("ServiceAccountJwtAccessCredentials{clientId=%s, clientEmail=%s, privateKeyId=%s, defaultAudience=%s, quotaProjectId=%s}", SA_CLIENT_ID, SA_CLIENT_EMAIL, SA_PRIVATE_KEY_ID, CALL_URI, QUOTA_PROJECT);
        Assert.assertEquals((Object)expectedToString, (Object)credentials.toString());
    }

    @Test
    public void hashCode_equals() throws IOException {
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).setDefaultAudience(CALL_URI).build();
        ServiceAccountJwtAccessCredentials otherCredentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).setDefaultAudience(CALL_URI).build();
        Assert.assertEquals((long)credentials.hashCode(), (long)otherCredentials.hashCode());
    }

    @Test
    public void serialize() throws IOException, ClassNotFoundException {
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).setDefaultAudience(CALL_URI).build();
        ServiceAccountJwtAccessCredentials deserializedCredentials = this.serializeAndDeserialize(credentials);
        this.verifyJwtAccess(deserializedCredentials.getRequestMetadata(), SA_CLIENT_EMAIL, CALL_URI, SA_PRIVATE_KEY_ID);
        Assert.assertEquals((Object)credentials, (Object)deserializedCredentials);
        Assert.assertEquals((long)credentials.hashCode(), (long)deserializedCredentials.hashCode());
        Assert.assertEquals((Object)credentials.toString(), (Object)deserializedCredentials.toString());
        Assert.assertSame((Object)deserializedCredentials.clock, (Object)Clock.SYSTEM);
    }

    @Test
    public void fromStream_nullStream_throws() throws IOException {
        GoogleCredentialsTest.MockHttpTransportFactory transportFactory = new GoogleCredentialsTest.MockHttpTransportFactory();
        try {
            ServiceAccountCredentials.fromStream(null, (HttpTransportFactory)transportFactory);
            Assert.fail((String)"Should throw if InputStream is null");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void fromStream_hasJwtAccess() throws IOException {
        InputStream serviceAccountStream = ServiceAccountCredentialsTest.writeServiceAccountStream(SA_CLIENT_ID, SA_CLIENT_EMAIL, SA_PRIVATE_KEY_PKCS8, SA_PRIVATE_KEY_ID);
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.fromStream((InputStream)serviceAccountStream);
        Assert.assertNotNull((Object)credentials);
        Map metadata = credentials.getRequestMetadata(CALL_URI);
        this.verifyJwtAccess(metadata, SA_CLIENT_EMAIL, CALL_URI, SA_PRIVATE_KEY_ID);
    }

    @Test
    public void fromStream_defaultURI_hasJwtAccess() throws IOException {
        InputStream serviceAccountStream = ServiceAccountCredentialsTest.writeServiceAccountStream(SA_CLIENT_ID, SA_CLIENT_EMAIL, SA_PRIVATE_KEY_PKCS8, SA_PRIVATE_KEY_ID);
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.fromStream((InputStream)serviceAccountStream, (URI)CALL_URI);
        Assert.assertNotNull((Object)credentials);
        Map metadata = credentials.getRequestMetadata(null);
        this.verifyJwtAccess(metadata, SA_CLIENT_EMAIL, CALL_URI, SA_PRIVATE_KEY_ID);
    }

    @Test
    public void fromStream_noClientId_throws() throws IOException {
        InputStream serviceAccountStream = ServiceAccountCredentialsTest.writeServiceAccountStream(null, SA_CLIENT_EMAIL, SA_PRIVATE_KEY_PKCS8, SA_PRIVATE_KEY_ID);
        ServiceAccountJwtAccessCredentialsTest.testFromStreamException(serviceAccountStream, "client_id");
    }

    @Test
    public void fromStream_noClientEmail_throws() throws IOException {
        InputStream serviceAccountStream = ServiceAccountCredentialsTest.writeServiceAccountStream(SA_CLIENT_ID, null, SA_PRIVATE_KEY_PKCS8, SA_PRIVATE_KEY_ID);
        ServiceAccountJwtAccessCredentialsTest.testFromStreamException(serviceAccountStream, "client_email");
    }

    @Test
    public void fromStream_noPrivateKey_throws() throws IOException {
        InputStream serviceAccountStream = ServiceAccountCredentialsTest.writeServiceAccountStream(SA_CLIENT_ID, SA_CLIENT_EMAIL, null, SA_PRIVATE_KEY_ID);
        ServiceAccountJwtAccessCredentialsTest.testFromStreamException(serviceAccountStream, "private_key");
    }

    @Test
    public void fromStream_noPrivateKeyId_throws() throws IOException {
        InputStream serviceAccountStream = ServiceAccountCredentialsTest.writeServiceAccountStream(SA_CLIENT_ID, SA_CLIENT_EMAIL, SA_PRIVATE_KEY_PKCS8, null);
        ServiceAccountJwtAccessCredentialsTest.testFromStreamException(serviceAccountStream, "private_key_id");
    }

    @Test
    public void jwtWithClaims_overrideAudience() throws IOException {
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).build();
        JwtCredentials withAudience = credentials.jwtWithClaims(JwtClaims.newBuilder().setAudience("new-audience").build());
        Map metadata = withAudience.getRequestMetadata(CALL_URI);
        this.verifyJwtAccess(metadata, SA_CLIENT_EMAIL, URI.create("new-audience"), SA_PRIVATE_KEY_ID);
    }

    @Test
    public void jwtWithClaims_noAudience() throws IOException {
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).build();
        try {
            credentials.jwtWithClaims(JwtClaims.newBuilder().build());
            Assert.fail((String)"Expected to throw exception for missing audience");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void jwtWithClaims_defaultAudience() throws IOException {
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).setDefaultAudience(URI.create("default-audience")).build();
        JwtCredentials withAudience = credentials.jwtWithClaims(JwtClaims.newBuilder().build());
        Map metadata = withAudience.getRequestMetadata(CALL_URI);
        this.verifyJwtAccess(metadata, SA_CLIENT_EMAIL, URI.create("default-audience"), SA_PRIVATE_KEY_ID);
    }

    @Test
    public void getRequestMetadataSetsQuotaProjectId() throws IOException {
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).setQuotaProjectId("my-quota-project-id").setDefaultAudience(URI.create("default-audience")).build();
        Map metadata = credentials.getRequestMetadata();
        Assert.assertTrue((boolean)metadata.containsKey("x-goog-user-project"));
        List headerValues = (List)metadata.get("x-goog-user-project");
        Assert.assertEquals((long)1L, (long)headerValues.size());
        Assert.assertEquals((Object)"my-quota-project-id", headerValues.get(0));
    }

    @Test
    public void getRequestMetadataNoQuotaProjectId() throws IOException {
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).setDefaultAudience(URI.create("default-audience")).build();
        Map metadata = credentials.getRequestMetadata();
        Assert.assertFalse((boolean)metadata.containsKey("x-goog-user-project"));
    }

    @Test
    public void getRequestMetadataWithCallback() throws IOException {
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8((String)SA_PRIVATE_KEY_PKCS8);
        ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientId(SA_CLIENT_ID).setClientEmail(SA_CLIENT_EMAIL).setPrivateKey(privateKey).setPrivateKeyId(SA_PRIVATE_KEY_ID).setQuotaProjectId("my-quota-project-id").setDefaultAudience(URI.create("default-audience")).build();
        final Map plainMetadata = credentials.getRequestMetadata();
        final AtomicBoolean success = new AtomicBoolean(false);
        credentials.getRequestMetadata(null, null, new RequestMetadataCallback(){

            public void onSuccess(Map<String, List<String>> metadata) {
                Assert.assertEquals((Object)plainMetadata, metadata);
                success.set(true);
            }

            public void onFailure(Throwable exception) {
                Assert.fail((String)"Should not throw a failure.");
            }
        });
        Assert.assertTrue((String)"Should have run onSuccess() callback", (boolean)success.get());
    }

    private void verifyJwtAccess(Map<String, List<String>> metadata, String expectedEmail, URI expectedAudience, String expectedKeyId) throws IOException {
        Assert.assertNotNull(metadata);
        List<String> authorizations = metadata.get("Authorization");
        Assert.assertNotNull((String)"Authorization headers not found", authorizations);
        String assertion = null;
        for (String authorization : authorizations) {
            if (!authorization.startsWith(JWT_ACCESS_PREFIX)) continue;
            Assert.assertNull((String)"Multiple bearer assertions found", assertion);
            assertion = authorization.substring(JWT_ACCESS_PREFIX.length());
        }
        Assert.assertNotNull((String)"Bearer assertion not found", assertion);
        JsonWebSignature signature = JsonWebSignature.parse((JsonFactory)JSON_FACTORY, assertion);
        Assert.assertEquals((Object)expectedEmail, (Object)signature.getPayload().getIssuer());
        Assert.assertEquals((Object)expectedEmail, (Object)signature.getPayload().getSubject());
        Assert.assertEquals((Object)expectedAudience.toString(), (Object)signature.getPayload().getAudience());
        Assert.assertEquals((Object)expectedKeyId, (Object)signature.getHeader().getKeyId());
    }

    private static void testFromStreamException(InputStream stream, String expectedMessageContent) {
        try {
            ServiceAccountJwtAccessCredentials.fromStream((InputStream)stream, (URI)CALL_URI);
            Assert.fail((String)String.format("Should throw exception with message containing '%s'", expectedMessageContent));
        }
        catch (IOException expected) {
            Assert.assertTrue((boolean)expected.getMessage().contains(expectedMessageContent));
        }
    }
}

