/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.util.GenericData;
import com.google.auth.TestUtils;
import com.google.auth.oauth2.ActingParty;
import com.google.auth.oauth2.MockStsTransport;
import com.google.auth.oauth2.OAuthException;
import com.google.auth.oauth2.StsRequestHandler;
import com.google.auth.oauth2.StsTokenExchangeRequest;
import com.google.auth.oauth2.StsTokenExchangeResponse;
import cz.o2.proxima.internal.shaded.com.google.common.base.Joiner;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class StsRequestHandlerTest {
    private static final String TOKEN_EXCHANGE_GRANT_TYPE = "urn:ietf:params:oauth:grant-type:token-exchange";
    private static final String CLOUD_PLATFORM_SCOPE = "https://www.googleapis.com/auth/cloud-platform";
    private static final String DEFAULT_REQUESTED_TOKEN_TYPE = "urn:ietf:params:oauth:token-type:access_token";
    private static final String TOKEN_URL = "https://sts.googleapis.com/v1/token";
    private MockStsTransport transport;

    @Before
    public void setup() {
        this.transport = new MockStsTransport();
    }

    @Test
    public void exchangeToken() throws IOException {
        StsTokenExchangeRequest stsTokenExchangeRequest = StsTokenExchangeRequest.newBuilder((String)"credential", (String)"subjectTokenType").setScopes(Arrays.asList(CLOUD_PLATFORM_SCOPE)).build();
        StsRequestHandler requestHandler = StsRequestHandler.newBuilder((String)TOKEN_URL, (StsTokenExchangeRequest)stsTokenExchangeRequest, (HttpRequestFactory)this.transport.createRequestFactory()).build();
        StsTokenExchangeResponse response = requestHandler.exchangeToken();
        Assert.assertEquals((Object)this.transport.getAccessToken(), (Object)response.getAccessToken().getTokenValue());
        Assert.assertEquals((Object)this.transport.getTokenType(), (Object)response.getTokenType());
        Assert.assertEquals((Object)this.transport.getIssuedTokenType(), (Object)response.getIssuedTokenType());
        Assert.assertEquals((Object)this.transport.getExpiresIn(), (Object)response.getExpiresInSeconds());
        GenericData expectedRequestContent = new GenericData().set("grant_type", (Object)TOKEN_EXCHANGE_GRANT_TYPE).set("scope", (Object)CLOUD_PLATFORM_SCOPE).set("requested_token_type", (Object)DEFAULT_REQUESTED_TOKEN_TYPE).set("subject_token_type", (Object)stsTokenExchangeRequest.getSubjectTokenType()).set("subject_token", (Object)stsTokenExchangeRequest.getSubjectToken());
        MockLowLevelHttpRequest request = this.transport.getRequest();
        Map<String, String> actualRequestContent = TestUtils.parseQuery(request.getContentAsString());
        Assert.assertEquals((Object)expectedRequestContent.getUnknownKeys(), actualRequestContent);
    }

    @Test
    public void exchangeToken_withOptionalParams() throws IOException {
        this.transport.addScopeSequence(Arrays.asList("scope1", "scope2", "scope3"));
        this.transport.addRefreshTokenSequence("refreshToken");
        StsTokenExchangeRequest stsTokenExchangeRequest = StsTokenExchangeRequest.newBuilder((String)"credential", (String)"subjectTokenType").setAudience("audience").setResource("resource").setActingParty(new ActingParty("actorToken", "actorTokenType")).setRequestTokenType("requestedTokenType").setScopes(Arrays.asList("scope1", "scope2", "scope3")).build();
        HttpHeaders httpHeaders = new HttpHeaders().setContentType("application/x-www-form-urlencoded").setAcceptEncoding("gzip").set("custom_header_key", (Object)"custom_header_value");
        StsRequestHandler requestHandler = StsRequestHandler.newBuilder((String)TOKEN_URL, (StsTokenExchangeRequest)stsTokenExchangeRequest, (HttpRequestFactory)this.transport.createRequestFactory()).setHeaders(httpHeaders).setInternalOptions("internalOptions").build();
        StsTokenExchangeResponse response = requestHandler.exchangeToken();
        Assert.assertEquals((Object)this.transport.getAccessToken(), (Object)response.getAccessToken().getTokenValue());
        Assert.assertEquals((Object)this.transport.getTokenType(), (Object)response.getTokenType());
        Assert.assertEquals((Object)this.transport.getIssuedTokenType(), (Object)response.getIssuedTokenType());
        Assert.assertEquals((Object)this.transport.getExpiresIn(), (Object)response.getExpiresInSeconds());
        Assert.assertEquals(Arrays.asList("scope1", "scope2", "scope3"), (Object)response.getScopes());
        Assert.assertEquals((Object)"refreshToken", (Object)response.getRefreshToken());
        MockLowLevelHttpRequest request = this.transport.getRequest();
        Map requestHeaders = request.getHeaders();
        Assert.assertEquals((Object)"application/x-www-form-urlencoded", ((List)requestHeaders.get("content-type")).get(0));
        Assert.assertEquals((Object)"gzip", ((List)requestHeaders.get("accept-encoding")).get(0));
        Assert.assertEquals((Object)"custom_header_value", ((List)requestHeaders.get("custom_header_key")).get(0));
        GenericData expectedRequestContent = new GenericData().set("grant_type", (Object)TOKEN_EXCHANGE_GRANT_TYPE).set("scope", (Object)Joiner.on((char)' ').join(Arrays.asList("scope1", "scope2", "scope3"))).set("options", (Object)"internalOptions").set("subject_token_type", (Object)stsTokenExchangeRequest.getSubjectTokenType()).set("subject_token", (Object)stsTokenExchangeRequest.getSubjectToken()).set("requested_token_type", (Object)stsTokenExchangeRequest.getRequestedTokenType()).set("actor_token", (Object)stsTokenExchangeRequest.getActingParty().getActorToken()).set("actor_token_type", (Object)stsTokenExchangeRequest.getActingParty().getActorTokenType()).set("resource", (Object)stsTokenExchangeRequest.getResource()).set("audience", (Object)stsTokenExchangeRequest.getAudience());
        Map<String, String> actualRequestContent = TestUtils.parseQuery(request.getContentAsString());
        Assert.assertEquals((Object)expectedRequestContent.getUnknownKeys(), actualRequestContent);
    }

    @Test
    public void exchangeToken_throwsException() throws IOException {
        StsTokenExchangeRequest stsTokenExchangeRequest = StsTokenExchangeRequest.newBuilder((String)"credential", (String)"subjectTokenType").build();
        final StsRequestHandler requestHandler = StsRequestHandler.newBuilder((String)TOKEN_URL, (StsTokenExchangeRequest)stsTokenExchangeRequest, (HttpRequestFactory)this.transport.createRequestFactory()).build();
        this.transport.addResponseErrorSequence(new IOException[]{TestUtils.buildHttpResponseException("invalidRequest", null, null)});
        OAuthException e = (OAuthException)Assert.assertThrows(OAuthException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                requestHandler.exchangeToken();
            }
        });
        Assert.assertEquals((Object)"invalidRequest", (Object)e.getErrorCode());
        Assert.assertNull((Object)e.getErrorDescription());
        Assert.assertNull((Object)e.getErrorUri());
    }

    @Test
    public void exchangeToken_withOptionalParams_throwsException() throws IOException {
        StsTokenExchangeRequest stsTokenExchangeRequest = StsTokenExchangeRequest.newBuilder((String)"credential", (String)"subjectTokenType").build();
        final StsRequestHandler requestHandler = StsRequestHandler.newBuilder((String)TOKEN_URL, (StsTokenExchangeRequest)stsTokenExchangeRequest, (HttpRequestFactory)this.transport.createRequestFactory()).build();
        this.transport.addResponseErrorSequence(new IOException[]{TestUtils.buildHttpResponseException("invalidRequest", "errorDescription", "errorUri")});
        OAuthException e = (OAuthException)Assert.assertThrows(OAuthException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                requestHandler.exchangeToken();
            }
        });
        Assert.assertEquals((Object)"invalidRequest", (Object)e.getErrorCode());
        Assert.assertEquals((Object)"errorDescription", (Object)e.getErrorDescription());
        Assert.assertEquals((Object)"errorUri", (Object)e.getErrorUri());
    }

    @Test
    public void exchangeToken_ioException() {
        StsTokenExchangeRequest stsTokenExchangeRequest = StsTokenExchangeRequest.newBuilder((String)"credential", (String)"subjectTokenType").build();
        final StsRequestHandler requestHandler = StsRequestHandler.newBuilder((String)TOKEN_URL, (StsTokenExchangeRequest)stsTokenExchangeRequest, (HttpRequestFactory)this.transport.createRequestFactory()).build();
        IOException e = new IOException();
        this.transport.addResponseErrorSequence(e);
        IOException thrownException = (IOException)Assert.assertThrows(IOException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                requestHandler.exchangeToken();
            }
        });
        Assert.assertEquals((Object)e, (Object)thrownException);
    }

    @Test
    public void exchangeToken_noExpiresInReturned() throws IOException {
        this.transport.setReturnExpiresIn(false);
        StsTokenExchangeRequest stsTokenExchangeRequest = StsTokenExchangeRequest.newBuilder((String)"credential", (String)"subjectTokenType").setScopes(Arrays.asList(CLOUD_PLATFORM_SCOPE)).build();
        StsRequestHandler requestHandler = StsRequestHandler.newBuilder((String)TOKEN_URL, (StsTokenExchangeRequest)stsTokenExchangeRequest, (HttpRequestFactory)this.transport.createRequestFactory()).build();
        StsTokenExchangeResponse response = requestHandler.exchangeToken();
        Assert.assertEquals((Object)this.transport.getAccessToken(), (Object)response.getAccessToken().getTokenValue());
        Assert.assertNull((Object)response.getAccessToken().getExpirationTime());
        Assert.assertEquals((Object)this.transport.getTokenType(), (Object)response.getTokenType());
        Assert.assertEquals((Object)this.transport.getIssuedTokenType(), (Object)response.getIssuedTokenType());
        Assert.assertNull((Object)response.getExpiresInSeconds());
    }
}

