/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.auth.TestUtils;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.ClientId;
import com.google.auth.oauth2.GoogleCredentialsTest;
import com.google.auth.oauth2.MemoryTokensStorage;
import com.google.auth.oauth2.TokenStore;
import com.google.auth.oauth2.UserAuthorizer;
import com.google.auth.oauth2.UserCredentials;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class UserAuthorizerTest {
    private static final String CLIENT_ID_VALUE = "ya29.1.AADtN_UtlxN3PuGAxrN2XQnZTVRvDyVWnYq4I6dws";
    private static final String CLIENT_SECRET = "jakuaL9YyieakhECKL2SwZcu";
    private static final String REFRESH_TOKEN = "1/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY";
    private static final String ACCESS_TOKEN_VALUE = "1/MkSJoj1xsli0AccessToken_NKPY2";
    private static final Long EXPIRATION_TIME = 504000300L;
    private static final AccessToken ACCESS_TOKEN = new AccessToken("1/MkSJoj1xsli0AccessToken_NKPY2", new Date(EXPIRATION_TIME));
    private static final ClientId CLIENT_ID = ClientId.of((String)"ya29.1.AADtN_UtlxN3PuGAxrN2XQnZTVRvDyVWnYq4I6dws", (String)"jakuaL9YyieakhECKL2SwZcu");
    private static final String SCOPE = "dummy.scope";
    private static final Collection<String> SCOPES = Collections.singletonList("dummy.scope");
    private static final String USER_ID = "foo@bar.com";
    private static final URI CALLBACK_URI = URI.create("/testcallback");
    private static final String CODE = "thisistheend";
    private static final URI BASE_URI = URI.create("http://example.com/foo");

    @Test
    public void constructorMinimum() {
        MemoryTokensStorage store = new MemoryTokensStorage();
        UserAuthorizer authorizer = UserAuthorizer.newBuilder().setClientId(CLIENT_ID).setScopes(SCOPES).setTokenStore((TokenStore)store).build();
        Assert.assertSame((Object)CLIENT_ID, (Object)authorizer.getClientId());
        Assert.assertSame((Object)store, (Object)authorizer.getTokenStore());
        Assert.assertArrayEquals((Object[])SCOPES.toArray(), (Object[])authorizer.getScopes().toArray());
        Assert.assertEquals((Object)UserAuthorizer.DEFAULT_CALLBACK_URI, (Object)authorizer.getCallbackUri());
    }

    @Test
    public void constructorCommon() {
        MemoryTokensStorage store = new MemoryTokensStorage();
        UserAuthorizer authorizer = UserAuthorizer.newBuilder().setClientId(CLIENT_ID).setScopes(SCOPES).setTokenStore((TokenStore)store).setCallbackUri(CALLBACK_URI).build();
        Assert.assertSame((Object)CLIENT_ID, (Object)authorizer.getClientId());
        Assert.assertSame((Object)store, (Object)authorizer.getTokenStore());
        Assert.assertArrayEquals((Object[])SCOPES.toArray(), (Object[])authorizer.getScopes().toArray());
        Assert.assertEquals((Object)CALLBACK_URI, (Object)authorizer.getCallbackUri());
    }

    @Test(expected=NullPointerException.class)
    public void constructorCommon_nullClientId_throws() {
        UserAuthorizer.newBuilder().setScopes(SCOPES).setCallbackUri(CALLBACK_URI).build();
    }

    @Test(expected=NullPointerException.class)
    public void constructorCommon_nullScopes_throws() {
        UserAuthorizer.newBuilder().setClientId(CLIENT_ID).build();
    }

    @Test
    public void getCallbackUri_relativeToBase() {
        URI callbackURI = URI.create("/bar");
        URI expectedCallbackURI = URI.create("http://example.com/bar");
        UserAuthorizer authorizer = UserAuthorizer.newBuilder().setClientId(CLIENT_ID).setScopes(SCOPES).setCallbackUri(callbackURI).build();
        URI absoluteCallbackURI = authorizer.getCallbackUri(BASE_URI);
        Assert.assertEquals((Object)expectedCallbackURI, (Object)absoluteCallbackURI);
    }

    @Test
    public void getAuthorizationUrl() throws IOException {
        String CUSTOM_STATE = "custom_state";
        String PROTOCOL = "https";
        String HOST = "accounts.test.com";
        String PATH = "/o/o/oauth2/auth";
        URI AUTH_URI = URI.create("https://accounts.test.com/o/o/oauth2/auth");
        String EXPECTED_CALLBACK = "http://example.com" + CALLBACK_URI.toString();
        UserAuthorizer authorizer = UserAuthorizer.newBuilder().setClientId(CLIENT_ID).setScopes(SCOPES).setCallbackUri(CALLBACK_URI).setUserAuthUri(AUTH_URI).build();
        URL authorizationUrl = authorizer.getAuthorizationUrl(USER_ID, "custom_state", BASE_URI);
        Assert.assertEquals((Object)"https", (Object)authorizationUrl.getProtocol());
        Assert.assertEquals((long)-1L, (long)authorizationUrl.getPort());
        Assert.assertEquals((Object)"/o/o/oauth2/auth", (Object)authorizationUrl.getPath());
        Assert.assertEquals((Object)"accounts.test.com", (Object)authorizationUrl.getHost());
        String query = authorizationUrl.getQuery();
        Map<String, String> parameters = TestUtils.parseQuery(query);
        Assert.assertEquals((Object)"custom_state", (Object)parameters.get("state"));
        Assert.assertEquals((Object)USER_ID, (Object)parameters.get("login_hint"));
        Assert.assertEquals((Object)EXPECTED_CALLBACK, (Object)parameters.get("redirect_uri"));
        Assert.assertEquals((Object)CLIENT_ID_VALUE, (Object)parameters.get("client_id"));
        Assert.assertEquals((Object)SCOPE, (Object)parameters.get("scope"));
        Assert.assertEquals((Object)"code", (Object)parameters.get("response_type"));
    }

    @Test
    public void getCredentials_noCredentials_returnsNull() throws IOException {
        UserAuthorizer authorizer = UserAuthorizer.newBuilder().setClientId(CLIENT_ID).setScopes(SCOPES).setTokenStore((TokenStore)new MemoryTokensStorage()).build();
        UserCredentials credentials = authorizer.getCredentials(USER_ID);
        Assert.assertNull((Object)credentials);
    }

    @Test
    public void getCredentials_storedCredentials_returnsStored() throws IOException {
        MemoryTokensStorage tokenStore = new MemoryTokensStorage();
        UserCredentials initialCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID_VALUE).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(ACCESS_TOKEN).build();
        UserAuthorizer authorizer = UserAuthorizer.newBuilder().setClientId(CLIENT_ID).setScopes(SCOPES).setTokenStore((TokenStore)tokenStore).build();
        authorizer.storeCredentials(USER_ID, initialCredentials);
        UserCredentials credentials = authorizer.getCredentials(USER_ID);
        Assert.assertEquals((Object)REFRESH_TOKEN, (Object)credentials.getRefreshToken());
        Assert.assertEquals((Object)ACCESS_TOKEN_VALUE, (Object)credentials.getAccessToken().getTokenValue());
        Assert.assertEquals((Object)EXPIRATION_TIME, (Object)credentials.getAccessToken().getExpirationTimeMillis());
    }

    @Test(expected=NullPointerException.class)
    public void getCredentials_nullUserId_throws() throws IOException {
        MemoryTokensStorage tokenStore = new MemoryTokensStorage();
        UserAuthorizer authorizer = UserAuthorizer.newBuilder().setClientId(CLIENT_ID).setScopes(SCOPES).setTokenStore((TokenStore)tokenStore).build();
        authorizer.getCredentials(null);
    }

    @Test
    public void getCredentials_refreshedToken_stored() throws IOException {
        String accessTokenValue1 = ACCESS_TOKEN_VALUE;
        String accessTokenValue2 = "2/MkSJoj1xsli0AccessToken_NKPY2";
        AccessToken accessToken1 = new AccessToken(ACCESS_TOKEN_VALUE, new Date(EXPIRATION_TIME));
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID_VALUE, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, "2/MkSJoj1xsli0AccessToken_NKPY2");
        MemoryTokensStorage tokenStore = new MemoryTokensStorage();
        UserAuthorizer authorizer = UserAuthorizer.newBuilder().setClientId(CLIENT_ID).setScopes(SCOPES).setTokenStore((TokenStore)tokenStore).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        UserCredentials originalCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID_VALUE).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken1).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        authorizer.storeCredentials(USER_ID, originalCredentials);
        UserCredentials credentials1 = authorizer.getCredentials(USER_ID);
        Assert.assertEquals((Object)REFRESH_TOKEN, (Object)credentials1.getRefreshToken());
        Assert.assertEquals((Object)ACCESS_TOKEN_VALUE, (Object)credentials1.getAccessToken().getTokenValue());
        credentials1.refresh();
        Assert.assertEquals((Object)REFRESH_TOKEN, (Object)credentials1.getRefreshToken());
        Assert.assertEquals((Object)"2/MkSJoj1xsli0AccessToken_NKPY2", (Object)credentials1.getAccessToken().getTokenValue());
        UserCredentials credentials2 = authorizer.getCredentials(USER_ID);
        Assert.assertEquals((Object)REFRESH_TOKEN, (Object)credentials2.getRefreshToken());
        Assert.assertEquals((Object)"2/MkSJoj1xsli0AccessToken_NKPY2", (Object)credentials2.getAccessToken().getTokenValue());
    }

    @Test
    public void getCredentialsFromCode_conevertsCodeToTokens() throws IOException {
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID_VALUE, CLIENT_SECRET);
        transportFactory.transport.addAuthorizationCode(CODE, REFRESH_TOKEN, ACCESS_TOKEN_VALUE);
        MemoryTokensStorage tokenStore = new MemoryTokensStorage();
        UserAuthorizer authorizer = UserAuthorizer.newBuilder().setClientId(CLIENT_ID).setScopes(SCOPES).setTokenStore((TokenStore)tokenStore).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        UserCredentials credentials = authorizer.getCredentialsFromCode(CODE, BASE_URI);
        Assert.assertEquals((Object)REFRESH_TOKEN, (Object)credentials.getRefreshToken());
        Assert.assertEquals((Object)ACCESS_TOKEN_VALUE, (Object)credentials.getAccessToken().getTokenValue());
    }

    @Test(expected=NullPointerException.class)
    public void getCredentialsFromCode_nullCode_throws() throws IOException {
        UserAuthorizer authorizer = UserAuthorizer.newBuilder().setClientId(CLIENT_ID).setScopes(SCOPES).setTokenStore((TokenStore)new MemoryTokensStorage()).build();
        authorizer.getCredentialsFromCode(null, BASE_URI);
    }

    @Test
    public void getAndStoreCredentialsFromCode_getAndStoresCredentials() throws IOException {
        String accessTokenValue1 = ACCESS_TOKEN_VALUE;
        String accessTokenValue2 = "2/MkSJoj1xsli0AccessToken_NKPY2";
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID_VALUE, CLIENT_SECRET);
        transportFactory.transport.addAuthorizationCode(CODE, REFRESH_TOKEN, ACCESS_TOKEN_VALUE);
        MemoryTokensStorage tokenStore = new MemoryTokensStorage();
        UserAuthorizer authorizer = UserAuthorizer.newBuilder().setClientId(CLIENT_ID).setScopes(SCOPES).setTokenStore((TokenStore)tokenStore).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        UserCredentials credentials1 = authorizer.getAndStoreCredentialsFromCode(USER_ID, CODE, BASE_URI);
        Assert.assertEquals((Object)REFRESH_TOKEN, (Object)credentials1.getRefreshToken());
        Assert.assertEquals((Object)ACCESS_TOKEN_VALUE, (Object)credentials1.getAccessToken().getTokenValue());
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, "2/MkSJoj1xsli0AccessToken_NKPY2");
        credentials1.refresh();
        Assert.assertEquals((Object)REFRESH_TOKEN, (Object)credentials1.getRefreshToken());
        Assert.assertEquals((Object)"2/MkSJoj1xsli0AccessToken_NKPY2", (Object)credentials1.getAccessToken().getTokenValue());
        UserCredentials credentials2 = authorizer.getCredentials(USER_ID);
        Assert.assertEquals((Object)REFRESH_TOKEN, (Object)credentials2.getRefreshToken());
        Assert.assertEquals((Object)"2/MkSJoj1xsli0AccessToken_NKPY2", (Object)credentials2.getAccessToken().getTokenValue());
    }

    @Test(expected=NullPointerException.class)
    public void getAndStoreCredentialsFromCode_nullCode_throws() throws IOException {
        UserAuthorizer authorizer = UserAuthorizer.newBuilder().setClientId(CLIENT_ID).setScopes(SCOPES).setTokenStore((TokenStore)new MemoryTokensStorage()).build();
        authorizer.getAndStoreCredentialsFromCode(USER_ID, null, BASE_URI);
    }

    @Test(expected=NullPointerException.class)
    public void getAndStoreCredentialsFromCode_nullUserId_throws() throws IOException {
        UserAuthorizer authorizer = UserAuthorizer.newBuilder().setClientId(CLIENT_ID).setScopes(SCOPES).setTokenStore((TokenStore)new MemoryTokensStorage()).build();
        authorizer.getAndStoreCredentialsFromCode(null, CODE, BASE_URI);
    }

    @Test
    public void revokeAuthorization_revokesAndClears() throws IOException {
        MemoryTokensStorage tokenStore = new MemoryTokensStorage();
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID_VALUE, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, ACCESS_TOKEN_VALUE);
        UserCredentials initialCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID_VALUE).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(ACCESS_TOKEN).build();
        UserAuthorizer authorizer = UserAuthorizer.newBuilder().setClientId(CLIENT_ID).setScopes(SCOPES).setTokenStore((TokenStore)tokenStore).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        authorizer.storeCredentials(USER_ID, initialCredentials);
        UserCredentials credentials1 = authorizer.getCredentials(USER_ID);
        Assert.assertEquals((Object)REFRESH_TOKEN, (Object)credentials1.getRefreshToken());
        credentials1.refresh();
        Assert.assertEquals((Object)ACCESS_TOKEN_VALUE, (Object)credentials1.getAccessToken().getTokenValue());
        authorizer.revokeAuthorization(USER_ID);
        try {
            credentials1.refresh();
            Assert.fail((String)"Credentials should not refresh after revoke.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        UserCredentials credentials2 = authorizer.getCredentials(USER_ID);
        Assert.assertNull((Object)credentials2);
    }
}

