/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.json.GenericJson;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.api.client.util.Clock;
import com.google.auth.RequestMetadataCallback;
import com.google.auth.TestUtils;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.BaseSerializationTest;
import com.google.auth.oauth2.GoogleAuthException;
import com.google.auth.oauth2.GoogleCredentialsTest;
import com.google.auth.oauth2.IdTokenCredentials;
import com.google.auth.oauth2.IdTokenProvider;
import com.google.auth.oauth2.OAuth2Utils;
import com.google.auth.oauth2.UserCredentials;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableList;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class UserCredentialsTest
extends BaseSerializationTest {
    private static final String CLIENT_SECRET = "jakuaL9YyieakhECKL2SwZcu";
    private static final String CLIENT_ID = "ya29.1.AADtN_UtlxN3PuGAxrN2XQnZTVRvDyVWnYq4I6dws";
    private static final String REFRESH_TOKEN = "1/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY";
    private static final String ACCESS_TOKEN = "1/MkSJoj1xsli0AccessToken_NKPY2";
    private static final String QUOTA_PROJECT = "sample-quota-project-id";
    private static final Collection<String> SCOPES = Collections.singletonList("dummy.scope");
    private static final URI CALL_URI = URI.create("http://googleapis.com/testapi/v1/foo");
    public static final String DEFAULT_ID_TOKEN = "eyJhbGciOiJSUzI1NiIsImtpZCI6ImRmMzc1ODkwOGI3OTIyOTNhZDk3N2EwYjk5MWQ5OGE3N2Y0ZWVlY2QiLCJ0eXAiOiJKV1QifQ.eyJhdWQiOiJodHRwczovL2Zvby5iYXIiLCJhenAiOiIxMDIxMDE1NTA4MzQyMDA3MDg1NjgiLCJleHAiOjE1NjQ0NzUwNTEsImlhdCI6MTU2NDQ3MTQ1MSwiaXNzIjoiaHR0cHM6Ly9hY2NvdW50cy5nb29nbGUuY29tIiwic3ViIjoiMTAyMTAxNTUwODM0MjAwNzA4NTY4In0.redacted";

    @Test(expected=IllegalStateException.class)
    public void constructor_accessAndRefreshTokenNull_throws() {
        UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).build();
    }

    @Test
    public void constructor() {
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setQuotaProjectId(QUOTA_PROJECT).build();
        Assert.assertEquals((Object)CLIENT_ID, (Object)credentials.getClientId());
        Assert.assertEquals((Object)CLIENT_SECRET, (Object)credentials.getClientSecret());
        Assert.assertEquals((Object)REFRESH_TOKEN, (Object)credentials.getRefreshToken());
        Assert.assertEquals((Object)QUOTA_PROJECT, (Object)credentials.getQuotaProjectId());
    }

    @Test
    public void createScoped_same() {
        UserCredentials userCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).build();
        Assert.assertSame((Object)userCredentials, (Object)userCredentials.createScoped(SCOPES));
    }

    @Test
    public void createScopedRequired_false() {
        UserCredentials userCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).build();
        Assert.assertFalse((boolean)userCredentials.createScopedRequired());
    }

    @Test
    public void fromJson_hasAccessToken() throws IOException {
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, ACCESS_TOKEN);
        GenericJson json = UserCredentialsTest.writeUserJson(CLIENT_ID, CLIENT_SECRET, REFRESH_TOKEN, null);
        UserCredentials credentials = UserCredentials.fromJson((Map)json, (HttpTransportFactory)transportFactory);
        Map metadata = credentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, ACCESS_TOKEN);
    }

    @Test
    public void fromJson_hasQuotaProjectId() throws IOException {
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, ACCESS_TOKEN);
        GenericJson json = UserCredentialsTest.writeUserJson(CLIENT_ID, CLIENT_SECRET, REFRESH_TOKEN, QUOTA_PROJECT);
        UserCredentials credentials = UserCredentials.fromJson((Map)json, (HttpTransportFactory)transportFactory);
        Map metadata = credentials.getRequestMetadata(CALL_URI);
        Assert.assertTrue((boolean)metadata.containsKey("x-goog-user-project"));
        Assert.assertEquals(metadata.get("x-goog-user-project"), Collections.singletonList(QUOTA_PROJECT));
    }

    @Test
    public void getRequestMetadata_initialToken_hasAccessToken() throws IOException {
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        AccessToken accessToken = new AccessToken(ACCESS_TOKEN, null);
        UserCredentials userCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        Map metadata = userCredentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, ACCESS_TOKEN);
    }

    @Test
    public void getRequestMetadata_initialTokenRefreshed_throws() throws IOException {
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        AccessToken accessToken = new AccessToken(ACCESS_TOKEN, null);
        UserCredentials userCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        try {
            userCredentials.refresh();
            Assert.fail((String)"Should not be able to refresh without refresh token.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void getRequestMetadata_fromRefreshToken_hasAccessToken() throws IOException {
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, ACCESS_TOKEN);
        UserCredentials userCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        Map metadata = userCredentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, ACCESS_TOKEN);
    }

    @Test
    public void getRequestMetadata_customTokenServer_hasAccessToken() throws IOException {
        URI TOKEN_SERVER = URI.create("https://foo.com/bar");
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, ACCESS_TOKEN);
        transportFactory.transport.setTokenServerUri(TOKEN_SERVER);
        UserCredentials userCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setHttpTransportFactory((HttpTransportFactory)transportFactory).setTokenServerUri(TOKEN_SERVER).build();
        Map metadata = userCredentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, ACCESS_TOKEN);
    }

    @Test
    public void equals_true() throws IOException {
        URI tokenServer = URI.create("https://foo.com/bar");
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        AccessToken accessToken = new AccessToken(ACCESS_TOKEN, null);
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)transportFactory).setTokenServerUri(tokenServer).setQuotaProjectId(QUOTA_PROJECT).build();
        UserCredentials otherCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)transportFactory).setTokenServerUri(tokenServer).setQuotaProjectId(QUOTA_PROJECT).build();
        Assert.assertTrue((boolean)credentials.equals((Object)otherCredentials));
        Assert.assertTrue((boolean)otherCredentials.equals((Object)credentials));
    }

    @Test
    public void equals_false_clientId() throws IOException {
        URI tokenServer1 = URI.create("https://foo1.com/bar");
        AccessToken accessToken = new AccessToken(ACCESS_TOKEN, null);
        GoogleCredentialsTest.MockHttpTransportFactory httpTransportFactory = new GoogleCredentialsTest.MockHttpTransportFactory();
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)httpTransportFactory).setTokenServerUri(tokenServer1).build();
        UserCredentials otherCredentials = UserCredentials.newBuilder().setClientId("other client id").setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)httpTransportFactory).setTokenServerUri(tokenServer1).build();
        Assert.assertFalse((boolean)credentials.equals((Object)otherCredentials));
        Assert.assertFalse((boolean)otherCredentials.equals((Object)credentials));
    }

    @Test
    public void equals_false_clientSecret() throws IOException {
        URI tokenServer1 = URI.create("https://foo1.com/bar");
        AccessToken accessToken = new AccessToken(ACCESS_TOKEN, null);
        GoogleCredentialsTest.MockHttpTransportFactory httpTransportFactory = new GoogleCredentialsTest.MockHttpTransportFactory();
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)httpTransportFactory).setTokenServerUri(tokenServer1).build();
        UserCredentials otherCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret("other client secret").setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)httpTransportFactory).setTokenServerUri(tokenServer1).build();
        Assert.assertFalse((boolean)credentials.equals((Object)otherCredentials));
        Assert.assertFalse((boolean)otherCredentials.equals((Object)credentials));
    }

    @Test
    public void equals_false_refreshToken() throws IOException {
        URI tokenServer1 = URI.create("https://foo1.com/bar");
        AccessToken accessToken = new AccessToken(ACCESS_TOKEN, null);
        GoogleCredentialsTest.MockHttpTransportFactory httpTransportFactory = new GoogleCredentialsTest.MockHttpTransportFactory();
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)httpTransportFactory).setTokenServerUri(tokenServer1).build();
        UserCredentials otherCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken("otherRefreshToken").setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)httpTransportFactory).setTokenServerUri(tokenServer1).build();
        Assert.assertFalse((boolean)credentials.equals((Object)otherCredentials));
        Assert.assertFalse((boolean)otherCredentials.equals((Object)credentials));
    }

    @Test
    public void equals_false_accessToken() throws IOException {
        URI tokenServer1 = URI.create("https://foo1.com/bar");
        AccessToken accessToken = new AccessToken(ACCESS_TOKEN, null);
        AccessToken otherAccessToken = new AccessToken("otherAccessToken", null);
        GoogleCredentialsTest.MockHttpTransportFactory httpTransportFactory = new GoogleCredentialsTest.MockHttpTransportFactory();
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)httpTransportFactory).setTokenServerUri(tokenServer1).build();
        UserCredentials otherCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(otherAccessToken).setHttpTransportFactory((HttpTransportFactory)httpTransportFactory).setTokenServerUri(tokenServer1).build();
        Assert.assertFalse((boolean)credentials.equals((Object)otherCredentials));
        Assert.assertFalse((boolean)otherCredentials.equals((Object)credentials));
    }

    @Test
    public void equals_false_transportFactory() throws IOException {
        URI tokenServer1 = URI.create("https://foo1.com/bar");
        AccessToken accessToken = new AccessToken(ACCESS_TOKEN, null);
        GoogleCredentialsTest.MockHttpTransportFactory httpTransportFactory = new GoogleCredentialsTest.MockHttpTransportFactory();
        GoogleCredentialsTest.MockTokenServerTransportFactory serverTransportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)httpTransportFactory).setTokenServerUri(tokenServer1).build();
        UserCredentials otherCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)serverTransportFactory).setTokenServerUri(tokenServer1).build();
        Assert.assertFalse((boolean)credentials.equals((Object)otherCredentials));
        Assert.assertFalse((boolean)otherCredentials.equals((Object)credentials));
    }

    @Test
    public void equals_false_tokenServer() throws IOException {
        URI tokenServer1 = URI.create("https://foo1.com/bar");
        URI tokenServer2 = URI.create("https://foo2.com/bar");
        AccessToken accessToken = new AccessToken(ACCESS_TOKEN, null);
        GoogleCredentialsTest.MockHttpTransportFactory httpTransportFactory = new GoogleCredentialsTest.MockHttpTransportFactory();
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)httpTransportFactory).setTokenServerUri(tokenServer1).build();
        UserCredentials otherCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)httpTransportFactory).setTokenServerUri(tokenServer2).build();
        Assert.assertFalse((boolean)credentials.equals((Object)otherCredentials));
        Assert.assertFalse((boolean)otherCredentials.equals((Object)credentials));
    }

    @Test
    public void equals_false_quotaProjectId() throws IOException {
        String quotaProject1 = "sample-id-1";
        String quotaProject2 = "sample-id-2";
        AccessToken accessToken = new AccessToken(ACCESS_TOKEN, null);
        GoogleCredentialsTest.MockHttpTransportFactory httpTransportFactory = new GoogleCredentialsTest.MockHttpTransportFactory();
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)httpTransportFactory).setQuotaProjectId("sample-id-1").build();
        UserCredentials otherCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)httpTransportFactory).setQuotaProjectId("sample-id-2").build();
        Assert.assertFalse((boolean)credentials.equals((Object)otherCredentials));
        Assert.assertFalse((boolean)otherCredentials.equals((Object)credentials));
    }

    @Test
    public void toString_containsFields() throws IOException {
        AccessToken accessToken = new AccessToken(ACCESS_TOKEN, null);
        URI tokenServer = URI.create("https://foo.com/bar");
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)transportFactory).setTokenServerUri(tokenServer).setQuotaProjectId(QUOTA_PROJECT).build();
        String expectedToString = String.format("UserCredentials{requestMetadata=%s, temporaryAccess=%s, clientId=%s, refreshToken=%s, tokenServerUri=%s, transportFactoryClassName=%s, quotaProjectId=%s}", ImmutableMap.of((Object)"Authorization", (Object)ImmutableList.of((Object)("Bearer " + accessToken.getTokenValue()))), accessToken.toString(), CLIENT_ID, REFRESH_TOKEN, tokenServer, GoogleCredentialsTest.MockTokenServerTransportFactory.class.getName(), QUOTA_PROJECT);
        Assert.assertEquals((Object)expectedToString, (Object)credentials.toString());
    }

    @Test
    public void hashCode_equals() throws IOException {
        URI tokenServer = URI.create("https://foo.com/bar");
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        AccessToken accessToken = new AccessToken(ACCESS_TOKEN, null);
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)transportFactory).setTokenServerUri(tokenServer).setQuotaProjectId(QUOTA_PROJECT).build();
        UserCredentials otherCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)transportFactory).setTokenServerUri(tokenServer).setQuotaProjectId(QUOTA_PROJECT).build();
        Assert.assertEquals((long)credentials.hashCode(), (long)otherCredentials.hashCode());
    }

    @Test
    public void serialize() throws IOException, ClassNotFoundException {
        URI tokenServer = URI.create("https://foo.com/bar");
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        AccessToken accessToken = new AccessToken(ACCESS_TOKEN, null);
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)transportFactory).setTokenServerUri(tokenServer).build();
        UserCredentials deserializedCredentials = this.serializeAndDeserialize(credentials);
        Assert.assertEquals((Object)credentials, (Object)deserializedCredentials);
        Assert.assertEquals((long)credentials.hashCode(), (long)deserializedCredentials.hashCode());
        Assert.assertEquals((Object)credentials.toString(), (Object)deserializedCredentials.toString());
        Assert.assertSame((Object)deserializedCredentials.clock, (Object)Clock.SYSTEM);
    }

    @Test
    public void fromStream_nullTransport_throws() throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream("foo".getBytes());
        try {
            UserCredentials.fromStream((InputStream)stream, null);
            Assert.fail((String)"Should throw if HttpTransportFactory is null");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void fromStream_nullStream_throws() throws IOException {
        GoogleCredentialsTest.MockHttpTransportFactory transportFactory = new GoogleCredentialsTest.MockHttpTransportFactory();
        try {
            UserCredentials.fromStream(null, (HttpTransportFactory)transportFactory);
            Assert.fail((String)"Should throw if InputStream is null");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void fromStream_user_providesToken() throws IOException {
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, ACCESS_TOKEN);
        InputStream userStream = UserCredentialsTest.writeUserStream(CLIENT_ID, CLIENT_SECRET, REFRESH_TOKEN, QUOTA_PROJECT);
        UserCredentials credentials = UserCredentials.fromStream((InputStream)userStream, (HttpTransportFactory)transportFactory);
        Assert.assertNotNull((Object)credentials);
        Map metadata = credentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, ACCESS_TOKEN);
    }

    @Test
    public void fromStream_userNoClientId_throws() throws IOException {
        InputStream userStream = UserCredentialsTest.writeUserStream(null, CLIENT_SECRET, REFRESH_TOKEN, QUOTA_PROJECT);
        UserCredentialsTest.testFromStreamException(userStream, "client_id");
    }

    @Test
    public void fromStream_userNoClientSecret_throws() throws IOException {
        InputStream userStream = UserCredentialsTest.writeUserStream(CLIENT_ID, null, REFRESH_TOKEN, QUOTA_PROJECT);
        UserCredentialsTest.testFromStreamException(userStream, "client_secret");
    }

    @Test
    public void fromStream_userNoRefreshToken_throws() throws IOException {
        InputStream userStream = UserCredentialsTest.writeUserStream(CLIENT_ID, CLIENT_SECRET, null, QUOTA_PROJECT);
        UserCredentialsTest.testFromStreamException(userStream, "refresh_token");
    }

    @Test
    public void saveUserCredentials_saved_throws() throws IOException {
        UserCredentials userCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).build();
        File file = File.createTempFile("GOOGLE_APPLICATION_CREDENTIALS", null, null);
        file.deleteOnExit();
        String filePath = file.getAbsolutePath();
        userCredentials.save(filePath);
    }

    @Test
    public void saveAndRestoreUserCredential_saveAndRestored_throws() throws IOException {
        UserCredentials userCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).build();
        File file = File.createTempFile("GOOGLE_APPLICATION_CREDENTIALS", null, null);
        file.deleteOnExit();
        String filePath = file.getAbsolutePath();
        userCredentials.save(filePath);
        FileInputStream inputStream = new FileInputStream(new File(filePath));
        UserCredentials restoredCredentials = UserCredentials.fromStream((InputStream)inputStream);
        Assert.assertEquals((Object)userCredentials.getClientId(), (Object)restoredCredentials.getClientId());
        Assert.assertEquals((Object)userCredentials.getClientSecret(), (Object)restoredCredentials.getClientSecret());
        Assert.assertEquals((Object)userCredentials.getRefreshToken(), (Object)restoredCredentials.getRefreshToken());
    }

    @Test
    public void getRequestMetadataSetsQuotaProjectId() throws IOException {
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, ACCESS_TOKEN);
        UserCredentials userCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setQuotaProjectId("my-quota-project-id").setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        Map metadata = userCredentials.getRequestMetadata(CALL_URI);
        Assert.assertTrue((boolean)metadata.containsKey("x-goog-user-project"));
        List headerValues = (List)metadata.get("x-goog-user-project");
        Assert.assertEquals((long)1L, (long)headerValues.size());
        Assert.assertEquals((Object)"my-quota-project-id", headerValues.get(0));
    }

    @Test
    public void getRequestMetadataNoQuotaProjectId() throws IOException {
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, ACCESS_TOKEN);
        UserCredentials userCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        Map metadata = userCredentials.getRequestMetadata(CALL_URI);
        Assert.assertFalse((boolean)metadata.containsKey("x-goog-user-project"));
    }

    @Test
    public void getRequestMetadataWithCallback() throws IOException {
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, ACCESS_TOKEN);
        UserCredentials userCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setQuotaProjectId("my-quota-project-id").setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        final Map plainMetadata = userCredentials.getRequestMetadata(CALL_URI);
        final AtomicBoolean success = new AtomicBoolean(false);
        userCredentials.getRequestMetadata(null, null, new RequestMetadataCallback(){

            public void onSuccess(Map<String, List<String>> metadata) {
                Assert.assertEquals((Object)plainMetadata, metadata);
                success.set(true);
            }

            public void onFailure(Throwable exception) {
                Assert.fail((String)"Should not throw a failure.");
            }
        });
        Assert.assertTrue((String)"Should have run onSuccess() callback", (boolean)success.get());
    }

    @Test
    public void IdTokenCredentials_WithUserEmailScope_success() throws IOException {
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        String refreshToken = "refresh_token_with_user.email_scope";
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(refreshToken, ACCESS_TOKEN);
        InputStream userStream = UserCredentialsTest.writeUserStream(CLIENT_ID, CLIENT_SECRET, refreshToken, QUOTA_PROJECT);
        UserCredentials credentials = UserCredentials.fromStream((InputStream)userStream, (HttpTransportFactory)transportFactory);
        credentials.refresh();
        Assert.assertEquals((Object)ACCESS_TOKEN, (Object)credentials.getAccessToken().getTokenValue());
        IdTokenCredentials tokenCredential = IdTokenCredentials.newBuilder().setIdTokenProvider((IdTokenProvider)credentials).build();
        Assert.assertNull((Object)tokenCredential.getAccessToken());
        Assert.assertNull((Object)tokenCredential.getIdToken());
        tokenCredential.getRequestMetadata(CALL_URI);
        Assert.assertEquals((Object)DEFAULT_ID_TOKEN, (Object)tokenCredential.getAccessToken().getTokenValue());
        Assert.assertEquals((Object)DEFAULT_ID_TOKEN, (Object)tokenCredential.getIdToken().getTokenValue());
    }

    @Test
    public void IdTokenCredentials_NoRetry_RetryableStatus_throws() throws IOException {
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        String refreshToken = "refresh_token_with_user.email_scope";
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(refreshToken, ACCESS_TOKEN);
        InputStream userStream = UserCredentialsTest.writeUserStream(CLIENT_ID, CLIENT_SECRET, refreshToken, QUOTA_PROJECT);
        MockLowLevelHttpResponse response408 = new MockLowLevelHttpResponse().setStatusCode(408);
        MockLowLevelHttpResponse response429 = new MockLowLevelHttpResponse().setStatusCode(429);
        UserCredentials credentials = UserCredentials.fromStream((InputStream)userStream, (HttpTransportFactory)transportFactory);
        try {
            transportFactory.transport.addResponseSequence(new LowLevelHttpResponse[]{response408, response429});
            credentials.refresh();
            Assert.fail((String)"Should not be able to use credential without exception.");
        }
        catch (GoogleAuthException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("com.google.api.client.http.HttpResponseException: 408"));
            Assert.assertTrue((boolean)ex.isRetryable());
            Assert.assertEquals((long)3L, (long)ex.getRetryCount());
        }
        IdTokenCredentials tokenCredential = IdTokenCredentials.newBuilder().setIdTokenProvider((IdTokenProvider)credentials).build();
        Assert.assertNull((Object)tokenCredential.getAccessToken());
        Assert.assertNull((Object)tokenCredential.getIdToken());
        try {
            tokenCredential.getRequestMetadata(CALL_URI);
            Assert.fail((String)"Should not be able to use credential without exception.");
        }
        catch (GoogleAuthException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("com.google.api.client.http.HttpResponseException: 429"));
            Assert.assertTrue((boolean)ex.isRetryable());
            Assert.assertEquals((long)3L, (long)ex.getRetryCount());
        }
    }

    @Test
    public void refreshAccessToken_4xx_5xx_NonRetryableFails() throws IOException {
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        String refreshToken = "refresh_token_with_user.email_scope";
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(refreshToken, ACCESS_TOKEN);
        InputStream userStream = UserCredentialsTest.writeUserStream(CLIENT_ID, CLIENT_SECRET, refreshToken, QUOTA_PROJECT);
        UserCredentials credentials = UserCredentials.fromStream((InputStream)userStream, (HttpTransportFactory)transportFactory);
        for (int status = 400; status < 600; ++status) {
            if (OAuth2Utils.TOKEN_ENDPOINT_RETRYABLE_STATUS_CODES.contains(status)) continue;
            MockLowLevelHttpResponse mockResponse = new MockLowLevelHttpResponse().setStatusCode(status);
            try {
                transportFactory.transport.addResponseSequence(new LowLevelHttpResponse[]{mockResponse});
                credentials.refresh();
                Assert.fail((String)"Should not be able to use credential without exception.");
                continue;
            }
            catch (GoogleAuthException ex) {
                Assert.assertFalse((boolean)ex.isRetryable());
                Assert.assertEquals((long)3L, (long)ex.getRetryCount());
            }
        }
    }

    @Test
    public void IdTokenCredentials_NoUserEmailScope_throws() throws IOException {
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, ACCESS_TOKEN);
        InputStream userStream = UserCredentialsTest.writeUserStream(CLIENT_ID, CLIENT_SECRET, REFRESH_TOKEN, QUOTA_PROJECT);
        UserCredentials credentials = UserCredentials.fromStream((InputStream)userStream, (HttpTransportFactory)transportFactory);
        IdTokenCredentials tokenCredential = IdTokenCredentials.newBuilder().setIdTokenProvider((IdTokenProvider)credentials).build();
        String expectedMessageContent = "UserCredentials can obtain an id token only when authenticated through gcloud running 'gcloud auth login --update-adc' or 'gcloud auth application-default login'. The latter form would not work for Cloud Run, but would still generate an id token.";
        try {
            tokenCredential.refresh();
            Assert.fail((String)"Should not be able to use credential without exception.");
        }
        catch (IOException expected) {
            Assert.assertTrue((boolean)expected.getMessage().equals(expectedMessageContent));
        }
    }

    static GenericJson writeUserJson(String clientId, String clientSecret, String refreshToken, String quotaProjectId) {
        GenericJson json = new GenericJson();
        if (clientId != null) {
            json.put("client_id", (Object)clientId);
        }
        if (clientSecret != null) {
            json.put("client_secret", (Object)clientSecret);
        }
        if (refreshToken != null) {
            json.put("refresh_token", (Object)refreshToken);
        }
        if (quotaProjectId != null) {
            json.put("quota_project_id", (Object)quotaProjectId);
        }
        json.put("type", (Object)"authorized_user");
        return json;
    }

    static InputStream writeUserStream(String clientId, String clientSecret, String refreshToken, String quotaProjectId) throws IOException {
        GenericJson json = UserCredentialsTest.writeUserJson(clientId, clientSecret, refreshToken, quotaProjectId);
        return TestUtils.jsonToInputStream(json);
    }

    private static void testFromStreamException(InputStream stream, String expectedMessageContent) {
        try {
            UserCredentials.fromStream((InputStream)stream);
            Assert.fail((String)String.format("Should throw exception with message containing '%s'", expectedMessageContent));
        }
        catch (IOException expected) {
            Assert.assertTrue((boolean)expected.getMessage().contains(expectedMessageContent));
        }
    }
}

