/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2.functional;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.IdToken;
import com.google.auth.oauth2.IdTokenCredentials;
import com.google.auth.oauth2.IdTokenProvider;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public final class FTServiceAccountCredentialsTest {
    private final String cloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform";
    private final String cloudTasksUrl = "https://cloudtasks.googleapis.com/v2/projects/gcloud-devel/locations";
    private final String storageUrl = "https://storage.googleapis.com/storage/v1/b?project=gcloud-devel";
    private final String bigQueryUrl = "https://bigquery.googleapis.com/bigquery/v2/projects/gcloud-devel/datasets";
    private final String computeUrl = "https://compute.googleapis.com/compute/v1/projects/gcloud-devel/zones/us-central1-a/instances";

    @Test
    public void NoScopeNoAudienceComputeTest() throws Exception {
        HttpResponse response = this.executeRequestWithCredentialsWithoutScope("https://compute.googleapis.com/compute/v1/projects/gcloud-devel/zones/us-central1-a/instances");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
    }

    @Test
    public void NoScopeNoAudienceBigQueryTest() throws Exception {
        HttpResponse response = this.executeRequestWithCredentialsWithoutScope("https://bigquery.googleapis.com/bigquery/v2/projects/gcloud-devel/datasets");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
    }

    @Test
    public void NoScopeNoAudienceOnePlatformTest() throws Exception {
        HttpResponse response = this.executeRequestWithCredentialsWithoutScope("https://cloudtasks.googleapis.com/v2/projects/gcloud-devel/locations");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
    }

    @Test
    public void AudienceSetNoScopeTest() throws Exception {
        GoogleCredentials credentials = GoogleCredentials.getApplicationDefault();
        IdTokenCredentials tokenCredential = IdTokenCredentials.newBuilder().setIdTokenProvider((IdTokenProvider)credentials).setTargetAudience("https://cloudtasks.googleapis.com/v2/projects/gcloud-devel/locations").build();
        Assert.assertNull((Object)tokenCredential.getIdToken());
        tokenCredential.refresh();
        IdToken idToken = tokenCredential.getIdToken();
        Assert.assertNotNull((Object)idToken);
        Assert.assertTrue((idToken.getExpirationTime().getTime() > System.currentTimeMillis() ? 1 : 0) != 0);
        JsonWebSignature jws = JsonWebSignature.parse((JsonFactory)GsonFactory.getDefaultInstance(), (String)idToken.getTokenValue());
        Assert.assertEquals((Object)"https://cloudtasks.googleapis.com/v2/projects/gcloud-devel/locations", (Object)jws.getPayload().get((Object)"aud"));
        Assert.assertEquals((Object)"https://accounts.google.com", (Object)jws.getPayload().get((Object)"iss"));
    }

    @Test
    public void ScopeSetNoAudienceStorageTest() throws Exception {
        HttpResponse response = this.executeRequestWithCredentialsWithScope("https://storage.googleapis.com/storage/v1/b?project=gcloud-devel", "https://www.googleapis.com/auth/cloud-platform");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
    }

    @Test
    public void ScopeSetNoAudienceComputeTest() throws Exception {
        HttpResponse response = this.executeRequestWithCredentialsWithScope("https://compute.googleapis.com/compute/v1/projects/gcloud-devel/zones/us-central1-a/instances", "https://www.googleapis.com/auth/cloud-platform");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
    }

    @Test
    public void ScopeSetNoAudienceBigQueryTest() throws Exception {
        HttpResponse response = this.executeRequestWithCredentialsWithScope("https://bigquery.googleapis.com/bigquery/v2/projects/gcloud-devel/datasets", "https://www.googleapis.com/auth/cloud-platform");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
    }

    @Test
    public void ScopeSetNoAudienceOnePlatformTest() throws Exception {
        HttpResponse response = this.executeRequestWithCredentialsWithScope("https://cloudtasks.googleapis.com/v2/projects/gcloud-devel/locations", "https://www.googleapis.com/auth/cloud-platform");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
    }

    @Test
    public void WrongScopeComputeTest() throws Exception {
        this.executeRequestWrongScope("https://compute.googleapis.com/compute/v1/projects/gcloud-devel/zones/us-central1-a/instances");
    }

    @Test
    public void WrongScopeStorageTest() throws Exception {
        this.executeRequestWrongScope("https://storage.googleapis.com/storage/v1/b?project=gcloud-devel");
    }

    @Test
    public void WrongScopeBigQueryTest() throws Exception {
        this.executeRequestWrongScope("https://bigquery.googleapis.com/bigquery/v2/projects/gcloud-devel/datasets");
    }

    @Test
    public void WrongScopeOnePlatformTest() throws Exception {
        this.executeRequestWrongScope("https://cloudtasks.googleapis.com/v2/projects/gcloud-devel/locations");
    }

    private void executeRequestWrongScope(String serviceUri) throws FileNotFoundException, IOException {
        String expectedMessage = "403 Forbidden";
        try {
            this.executeRequestWithCredentialsWithScope(serviceUri, "https://www.googleapis.com/auth/adexchange.buyer");
            Assert.fail((String)("Should throw exception: " + expectedMessage));
        }
        catch (IOException expected) {
            Assert.assertTrue((boolean)expected.getMessage().contains(expectedMessage));
        }
    }

    private HttpResponse executeRequestWithCredentialsWithoutScope(String serviceUrl) throws IOException {
        GoogleCredentials credentials = GoogleCredentials.getApplicationDefault();
        GenericUrl genericUrl = new GenericUrl(serviceUrl);
        HttpCredentialsAdapter adapter = new HttpCredentialsAdapter((Credentials)credentials);
        NetHttpTransport transport = new NetHttpTransport();
        HttpRequest request = transport.createRequestFactory((HttpRequestInitializer)adapter).buildGetRequest(genericUrl);
        return request.execute();
    }

    private HttpResponse executeRequestWithCredentialsWithScope(String serviceUrl, String scope) throws IOException {
        GoogleCredentials credentials = GoogleCredentials.getApplicationDefault().createScoped(new String[]{scope});
        GenericUrl genericUrl = new GenericUrl(serviceUrl);
        HttpCredentialsAdapter adapter = new HttpCredentialsAdapter((Credentials)credentials);
        NetHttpTransport transport = new NetHttpTransport();
        HttpRequest request = transport.createRequestFactory((HttpRequestInitializer)adapter).buildGetRequest(genericUrl);
        return request.execute();
    }
}

