/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.Restorable;
import com.google.cloud.RestorableState;
import cz.o2.proxima.internal.shaded.com.google.common.base.MoreObjects;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseSerializationTest {
    protected abstract Serializable[] serializableObjects();

    protected abstract Restorable<?>[] restorableObjects();

    @Test
    public void testSerializableObjects() throws Exception {
        for (Serializable obj : (Serializable[])MoreObjects.firstNonNull((Object)this.serializableObjects(), (Object)new Serializable[0])) {
            Serializable copy = this.serializeAndDeserialize(obj);
            Assert.assertEquals((Object)obj, (Object)obj);
            Assert.assertEquals((Object)obj, (Object)copy);
            Assert.assertEquals((long)obj.hashCode(), (long)copy.hashCode());
            Assert.assertEquals((Object)obj.toString(), (Object)copy.toString());
            Assert.assertNotSame((Object)obj, (Object)copy);
            Assert.assertEquals((Object)copy, (Object)copy);
        }
    }

    @Test
    public void testRestorableObjects() throws Exception {
        for (Restorable restorable : (Restorable[])MoreObjects.firstNonNull(this.restorableObjects(), (Object)new Restorable[0])) {
            RestorableState state = restorable.capture();
            RestorableState deserializedState = this.serializeAndDeserialize(state);
            Assert.assertEquals((Object)state, (Object)deserializedState);
            Assert.assertEquals((long)state.hashCode(), (long)deserializedState.hashCode());
            Assert.assertEquals((Object)state.toString(), (Object)deserializedState.toString());
        }
    }

    public <T> T serializeAndDeserialize(T obj) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try (ObjectOutputStream output = new ObjectOutputStream(bytes);){
            output.writeObject(obj);
        }
        var4_4 = null;
        try (ObjectInputStream input = new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray()));){
            Object object = input.readObject();
            return (T)object;
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }
}

