/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.BaseServiceException;
import com.google.cloud.RetryHelper;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableSet;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.Set;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class BaseServiceExceptionTest {
    private static final int CODE = 1;
    private static final int CODE_NO_REASON = 2;
    private static final String MESSAGE = "some message";
    private static final String REASON = "some reason";
    private static final boolean NOT_RETRYABLE = false;
    private static final boolean RETRYABLE = true;
    private static final boolean IDEMPOTENT = true;
    private static final String DEBUG_INFO = "debugInfo";
    private static final String LOCATION = "location";

    @Test
    public void testBaseServiceException() {
        BaseServiceException serviceException = new BaseServiceException(BaseServiceException.ExceptionData.from((int)1, (String)MESSAGE, (String)REASON, (boolean)false));
        Assert.assertEquals((long)1L, (long)serviceException.getCode());
        Assert.assertEquals((Object)MESSAGE, (Object)serviceException.getMessage());
        Assert.assertEquals((Object)REASON, (Object)serviceException.getReason());
        Assert.assertFalse((boolean)serviceException.isRetryable());
        Assert.assertNull((Object)serviceException.getCause());
        RuntimeException cause = new RuntimeException();
        serviceException = new BaseServiceException(BaseServiceException.ExceptionData.from((int)1, (String)MESSAGE, (String)REASON, (boolean)false, (Throwable)cause));
        Assert.assertEquals((long)1L, (long)serviceException.getCode());
        Assert.assertEquals((Object)MESSAGE, (Object)serviceException.getMessage());
        Assert.assertEquals((Object)REASON, (Object)serviceException.getReason());
        Assert.assertFalse((boolean)serviceException.isRetryable());
        Assert.assertEquals((Object)cause, (Object)serviceException.getCause());
        serviceException = new BaseServiceException(BaseServiceException.ExceptionData.newBuilder().setMessage(MESSAGE).setCause((Throwable)cause).setCode(1).setReason(REASON).setRetryable(true).setDebugInfo(DEBUG_INFO).setLocation(LOCATION).build());
        Assert.assertEquals((long)1L, (long)serviceException.getCode());
        Assert.assertEquals((Object)MESSAGE, (Object)serviceException.getMessage());
        Assert.assertEquals((Object)REASON, (Object)serviceException.getReason());
        Assert.assertTrue((boolean)serviceException.isRetryable());
        Assert.assertEquals((Object)cause, (Object)serviceException.getCause());
        Assert.assertEquals((Object)DEBUG_INFO, (Object)serviceException.getDebugInfo());
        Assert.assertEquals((Object)LOCATION, (Object)serviceException.getLocation());
        serviceException = new CustomServiceException(1, MESSAGE, REASON, true);
        Assert.assertEquals((long)1L, (long)serviceException.getCode());
        Assert.assertEquals((Object)MESSAGE, (Object)serviceException.getMessage());
        Assert.assertEquals((Object)REASON, (Object)serviceException.getReason());
        Assert.assertTrue((boolean)serviceException.isRetryable());
        serviceException = new CustomServiceException(2, MESSAGE, null, true);
        Assert.assertEquals((long)2L, (long)serviceException.getCode());
        Assert.assertEquals((Object)MESSAGE, (Object)serviceException.getMessage());
        Assert.assertNull((Object)serviceException.getReason());
        Assert.assertTrue((boolean)serviceException.isRetryable());
        serviceException = new CustomServiceException(0, MESSAGE, REASON, true);
        Assert.assertEquals((long)0L, (long)serviceException.getCode());
        Assert.assertEquals((Object)MESSAGE, (Object)serviceException.getMessage());
        Assert.assertEquals((Object)REASON, (Object)serviceException.getReason());
        Assert.assertTrue((boolean)serviceException.isRetryable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTranslateAndThrow() throws Exception {
        BaseServiceException cause = new BaseServiceException(BaseServiceException.ExceptionData.from((int)1, (String)MESSAGE, (String)REASON, (boolean)false));
        RetryHelper.RetryHelperException exceptionMock = (RetryHelper.RetryHelperException)EasyMock.createMock(RetryHelper.RetryHelperException.class);
        EasyMock.expect((Object)exceptionMock.getCause()).andReturn((Object)cause).times(2);
        EasyMock.replay((Object[])new Object[]{exceptionMock});
        try {
            BaseServiceException.translate((RetryHelper.RetryHelperException)exceptionMock);
        }
        catch (BaseServiceException ex) {
            try {
                Assert.assertEquals((long)1L, (long)ex.getCode());
                Assert.assertEquals((Object)MESSAGE, (Object)ex.getMessage());
                Assert.assertFalse((boolean)ex.isRetryable());
            }
            catch (Throwable throwable) {
                EasyMock.verify((Object[])new Object[]{exceptionMock});
                throw throwable;
            }
            EasyMock.verify((Object[])new Object[]{exceptionMock});
        }
        EasyMock.verify((Object[])new Object[]{exceptionMock});
    }

    @Test
    public void testError_Equal() {
        BaseServiceException.Error error = new BaseServiceException.Error(Integer.valueOf(0), "reason", true);
        Truth.assertThat((Object)error).isEqualTo((Object)error);
        Truth.assertThat((Integer)error.hashCode()).isEqualTo((Object)error.hashCode());
        BaseServiceException.Error sameError = new BaseServiceException.Error(Integer.valueOf(0), "reason", true);
        Truth.assertThat((Object)error).isEqualTo((Object)sameError);
        Truth.assertThat((Integer)error.hashCode()).isEqualTo((Object)sameError.hashCode());
        BaseServiceException.Error error2 = new BaseServiceException.Error(Integer.valueOf(1), "other reason", false);
        Truth.assertThat((Object)error).isNotEqualTo((Object)error2);
        Truth.assertThat((Integer)error.hashCode()).isNotEqualTo((Object)error2.hashCode());
    }

    private static class CustomServiceException
    extends BaseServiceException {
        private static final long serialVersionUID = -195251309124875103L;
        private static final Set RETRYABLE_ERRORS = ImmutableSet.of((Object)new BaseServiceException.Error(Integer.valueOf(1), "some reason"), (Object)new BaseServiceException.Error(null, "some reason"), (Object)new BaseServiceException.Error(Integer.valueOf(2), null));

        public CustomServiceException(int code, String message, String reason, boolean idempotent) {
            super(BaseServiceException.ExceptionData.from((int)code, (String)message, (String)reason, (boolean)BaseServiceException.isRetryable((Integer)code, (String)reason, (boolean)idempotent, (Set)RETRYABLE_ERRORS)));
        }
    }
}

