/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.BaseWriteChannel;
import com.google.cloud.RestorableState;
import com.google.cloud.Service;
import com.google.cloud.ServiceFactory;
import com.google.cloud.ServiceOptions;
import com.google.cloud.WriteChannel;
import com.google.cloud.spi.ServiceRpcFactory;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import java.util.Random;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BaseWriteChannelTest {
    private static final Serializable ENTITY = Long.valueOf(42L);
    private static final String UPLOAD_ID = "uploadId";
    private static final byte[] CONTENT = new byte[]{13, 14, 10, 13};
    private static final int MIN_CHUNK_SIZE = 262144;
    private static final int DEFAULT_CHUNK_SIZE = 0xF00000;
    private static final Random RANDOM = new Random();
    private static BaseWriteChannel channel;

    @Before
    public void setUp() {
        channel = new BaseWriteChannel<CustomServiceOptions, Serializable>(null, ENTITY, UPLOAD_ID){

            public RestorableState<WriteChannel> capture() {
                return null;
            }

            protected void flushBuffer(int length, boolean last) {
            }

            protected BaseWriteChannel.BaseState.Builder<CustomServiceOptions, Serializable> stateBuilder() {
                return null;
            }
        };
    }

    @Test
    public void testConstructor() {
        Assert.assertEquals(null, (Object)channel.getOptions());
        Assert.assertEquals((Object)ENTITY, (Object)channel.getEntity());
        Assert.assertEquals((long)0L, (long)channel.getPosition());
        Assert.assertEquals((Object)UPLOAD_ID, (Object)channel.getUploadId());
        Assert.assertEquals((long)0L, (long)channel.getLimit());
        TestCase.assertTrue((boolean)channel.isOpen());
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])channel.getBuffer());
        Assert.assertEquals((long)0xF00000L, (long)channel.getChunkSize());
    }

    @Test
    public void testClose() throws IOException {
        channel.close();
        TestCase.assertFalse((boolean)channel.isOpen());
        Assert.assertNull((Object)channel.getBuffer());
    }

    @Test(expected=ClosedChannelException.class)
    public void testValidateOpen() throws IOException {
        channel.close();
        channel.write(ByteBuffer.allocate(42));
    }

    @Test
    public void testChunkSize() {
        channel.setChunkSize(42);
        Truth.assertThat((Boolean)(channel.getChunkSize() >= 262144 ? 1 : 0)).isTrue();
        Truth.assertThat((Integer)(channel.getChunkSize() % 262144)).isEqualTo((Object)0);
        channel.setChunkSize(524288);
        Truth.assertThat((Boolean)(channel.getChunkSize() >= 262144 ? 1 : 0)).isTrue();
        Truth.assertThat((Integer)(channel.getChunkSize() % 262144)).isEqualTo((Object)0);
        channel.setChunkSize(524289);
        Truth.assertThat((Boolean)(channel.getChunkSize() >= 262144 ? 1 : 0)).isTrue();
        Truth.assertThat((Integer)(channel.getChunkSize() % 262144)).isEqualTo((Object)0);
    }

    @Test
    public void testWrite() throws IOException {
        channel.write(ByteBuffer.wrap(CONTENT));
        Assert.assertEquals((long)CONTENT.length, (long)channel.getLimit());
        Assert.assertEquals((long)0xF00000L, (long)channel.getBuffer().length);
        Assert.assertArrayEquals((byte[])Arrays.copyOf(CONTENT, 0xF00000), (byte[])channel.getBuffer());
    }

    @Test
    public void testWriteAndFlush() throws IOException {
        ByteBuffer content = BaseWriteChannelTest.randomBuffer(0xF00001);
        channel.write(content);
        Assert.assertEquals((long)0xF00000L, (long)channel.getPosition());
        Assert.assertEquals((long)1L, (long)channel.getLimit());
        byte[] newContent = new byte[0xF00000];
        newContent[0] = content.get(0xF00000);
        Assert.assertArrayEquals((byte[])newContent, (byte[])channel.getBuffer());
    }

    private static ByteBuffer randomBuffer(int size) {
        byte[] byteArray = new byte[size];
        RANDOM.nextBytes(byteArray);
        return ByteBuffer.wrap(byteArray);
    }

    private static abstract class CustomServiceOptions
    extends ServiceOptions<CustomService, CustomServiceOptions> {
        private static final long serialVersionUID = 3302358029307467197L;

        protected CustomServiceOptions(Class<? extends ServiceFactory<CustomService, CustomServiceOptions>> serviceFactoryClass, Class<? extends ServiceRpcFactory<CustomServiceOptions>> rpcFactoryClass, ServiceOptions.Builder<CustomService, CustomServiceOptions, ?> builder) {
            super(serviceFactoryClass, rpcFactoryClass, builder, null);
        }
    }

    private static abstract class CustomService
    implements Service<CustomServiceOptions> {
        private CustomService() {
        }
    }
}

