/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.Date;
import cz.o2.proxima.internal.shaded.com.google.common.testing.EqualsTester;
import cz.o2.proxima.internal.shaded.com.google.common.testing.SerializableTester;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DateTest {
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    @Test
    public void parseDate() {
        this.verifyDate("2016-09-18", 2016, 9, 18);
        this.verifyDate("2000-01-01", 2000, 1, 1);
        this.verifyDate("9999-12-31", 9999, 12, 31);
        this.verifyDate("0001-01-01", 1, 1, 1);
        this.verifyDate("2000-02-29", 2000, 2, 29);
        this.verifyDate("1900-02-29", 1900, 2, 29);
        this.verifyDate("2001-02-29", 2001, 2, 29);
        this.verifyDate("2000-04-31", 2000, 4, 31);
    }

    private void verifyDate(String input, int year, int month, int day) {
        Date date = Date.parseDate((String)input);
        Truth.assertThat((Integer)date.getYear()).isEqualTo((Object)year);
        Truth.assertThat((Integer)date.getMonth()).isEqualTo((Object)month);
        Truth.assertThat((Integer)date.getDayOfMonth()).isEqualTo((Object)day);
    }

    @Test
    public void parseInvalidDates() {
        this.parseInvalidDate("2016/09/18");
        this.parseInvalidDate("2016 09 18");
        this.parseInvalidDate("2016-9-18");
        this.parseInvalidDate("2016-09-18T10:00");
        this.parseInvalidDate("");
        this.parseInvalidDate("test");
        this.parseInvalidDate("aaaa-bb-cc");
        this.parseInvalidDate("aaaa-01-01");
        this.parseInvalidDate("2019-bb-01");
        this.parseInvalidDate("2019-01-cc");
        this.parseInvalidMonth("2000-13-01");
        this.parseInvalidMonth("2000-00-01");
        this.parseInvalidDay("2000-12-32");
        this.parseInvalidDay("2000-12-00");
        this.parseInvalidDate("10000-01-01");
        this.parseInvalidYear("0000-01-01");
        this.parseInvalidYear("-001-01-01");
        this.parseInvalidMonth("0001--1-01");
        this.parseInvalidDay("0001-01--1");
    }

    private void parseInvalidDate(String input) {
        try {
            Date.parseDate((String)input);
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Invalid date");
        }
    }

    private void parseInvalidYear(String input) {
        try {
            Date.parseDate((String)input);
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Invalid year");
        }
    }

    private void parseInvalidMonth(String input) {
        try {
            Date.parseDate((String)input);
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Invalid month");
        }
    }

    private void parseInvalidDay(String input) {
        try {
            Date.parseDate((String)input);
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Invalid day");
        }
    }

    @Test
    public void testToString() {
        Date date = Date.fromYearMonthDay((int)10, (int)9, (int)5);
        Truth.assertThat((String)date.toString()).isEqualTo((Object)"0010-09-05");
        date = Date.fromYearMonthDay((int)2016, (int)12, (int)31);
        Truth.assertThat((String)date.toString()).isEqualTo((Object)"2016-12-31");
        date = Date.fromYearMonthDay((int)1, (int)1, (int)1);
        Truth.assertThat((String)date.toString()).isEqualTo((Object)"0001-01-01");
    }

    @Test
    public void equalAndHashCode() {
        Date d1 = Date.fromYearMonthDay((int)2016, (int)9, (int)18);
        Date d2 = Date.fromYearMonthDay((int)2016, (int)9, (int)18);
        Date d3 = Date.fromYearMonthDay((int)2016, (int)9, (int)19);
        new EqualsTester().addEqualityGroup(new Object[]{d1, d2}).addEqualityGroup(new Object[]{d3}).testEquals();
    }

    @Test
    public void validOrdering() {
        Date d1 = Date.fromYearMonthDay((int)2016, (int)9, (int)18);
        Date d2 = Date.fromYearMonthDay((int)2016, (int)9, (int)19);
        Date d3 = Date.fromYearMonthDay((int)2016, (int)9, (int)20);
        Date d4 = Date.fromYearMonthDay((int)2016, (int)10, (int)1);
        Date d5 = Date.fromYearMonthDay((int)2017, (int)1, (int)1);
        this.assertDescending(d5, d4, d3, d2, d1);
    }

    @Test
    public void serialization() {
        SerializableTester.reserializeAndAssert((Object)Date.fromYearMonthDay((int)2017, (int)4, (int)20));
    }

    @Test
    public void testToJavaUtilDate() throws ParseException {
        Date gcDate = Date.parseDate((String)"2016-09-18");
        java.util.Date juDate1 = SIMPLE_DATE_FORMAT.parse("2016-09-18");
        java.util.Date juDate2 = Date.toJavaUtilDate((Date)gcDate);
        Truth.assertThat((Comparable)juDate1).isEqualTo((Object)juDate2);
    }

    @Test
    public void testFromJavaUtilDate() throws ParseException {
        java.util.Date juDate = SIMPLE_DATE_FORMAT.parse("2016-09-18");
        Date gcDate = Date.fromJavaUtilDate((java.util.Date)juDate);
        Truth.assertThat((Integer)gcDate.getYear()).isEqualTo((Object)2016);
        Truth.assertThat((Integer)gcDate.getMonth()).isEqualTo((Object)9);
        Truth.assertThat((Integer)gcDate.getDayOfMonth()).isEqualTo((Object)18);
    }

    private void assertDescending(Date ... dates) {
        for (int i = 0; i < dates.length - 1; ++i) {
            Truth.assertThat((Comparable)dates[i]).isEquivalentAccordingToCompareTo((Comparable)dates[i]);
            for (int j = i + 1; j < dates.length; ++j) {
                Truth.assertThat((Comparable)dates[i]).isGreaterThan((Comparable)dates[j]);
            }
        }
    }
}

