/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.Identity;
import org.junit.Assert;
import org.junit.Test;

public class IdentityTest {
    private static final Identity ALL_USERS = Identity.allUsers();
    private static final Identity ALL_AUTH_USERS = Identity.allAuthenticatedUsers();
    private static final Identity USER = Identity.user((String)"abc@gmail.com");
    private static final Identity SERVICE_ACCOUNT = Identity.serviceAccount((String)"service-account@gmail.com");
    private static final Identity GROUP = Identity.group((String)"group@gmail.com");
    private static final Identity DOMAIN = Identity.domain((String)"google.com");
    private static final Identity PROJECT_OWNER = Identity.projectOwner((String)"my-sample-project");
    private static final Identity PROJECT_EDITOR = Identity.projectEditor((String)"my-sample-project");
    private static final Identity PROJECT_VIEWER = Identity.projectViewer((String)"my-sample-project");

    @Test
    public void testAllUsers() {
        Assert.assertEquals((Object)Identity.Type.ALL_USERS, (Object)ALL_USERS.getType());
        Assert.assertNull((Object)ALL_USERS.getValue());
    }

    @Test
    public void testAllAuthenticatedUsers() {
        Assert.assertEquals((Object)Identity.Type.ALL_AUTHENTICATED_USERS, (Object)ALL_AUTH_USERS.getType());
        Assert.assertNull((Object)ALL_AUTH_USERS.getValue());
    }

    @Test
    public void testUser() {
        Assert.assertEquals((Object)Identity.Type.USER, (Object)USER.getType());
        Assert.assertEquals((Object)"abc@gmail.com", (Object)USER.getValue());
    }

    @Test(expected=NullPointerException.class)
    public void testUserNullEmail() {
        Identity.user(null);
    }

    @Test
    public void testServiceAccount() {
        Assert.assertEquals((Object)Identity.Type.SERVICE_ACCOUNT, (Object)SERVICE_ACCOUNT.getType());
        Assert.assertEquals((Object)"service-account@gmail.com", (Object)SERVICE_ACCOUNT.getValue());
    }

    @Test(expected=NullPointerException.class)
    public void testServiceAccountNullEmail() {
        Identity.serviceAccount(null);
    }

    @Test
    public void testGroup() {
        Assert.assertEquals((Object)Identity.Type.GROUP, (Object)GROUP.getType());
        Assert.assertEquals((Object)"group@gmail.com", (Object)GROUP.getValue());
    }

    @Test(expected=NullPointerException.class)
    public void testGroupNullEmail() {
        Identity.group(null);
    }

    @Test
    public void testDomain() {
        Assert.assertEquals((Object)Identity.Type.DOMAIN, (Object)DOMAIN.getType());
        Assert.assertEquals((Object)"google.com", (Object)DOMAIN.getValue());
    }

    @Test(expected=NullPointerException.class)
    public void testDomainNullId() {
        Identity.domain(null);
    }

    @Test
    public void testProjectOwner() {
        Assert.assertEquals((Object)Identity.Type.PROJECT_OWNER, (Object)PROJECT_OWNER.getType());
        Assert.assertEquals((Object)"my-sample-project", (Object)PROJECT_OWNER.getValue());
    }

    @Test(expected=NullPointerException.class)
    public void testProjectOwnerNullId() {
        Identity.projectOwner(null);
    }

    @Test
    public void testProjectEditor() {
        Assert.assertEquals((Object)Identity.Type.PROJECT_EDITOR, (Object)PROJECT_EDITOR.getType());
        Assert.assertEquals((Object)"my-sample-project", (Object)PROJECT_EDITOR.getValue());
    }

    @Test(expected=NullPointerException.class)
    public void testProjectEditorNullId() {
        Identity.projectEditor(null);
    }

    @Test
    public void testProjectViewer() {
        Assert.assertEquals((Object)Identity.Type.PROJECT_VIEWER, (Object)PROJECT_VIEWER.getType());
        Assert.assertEquals((Object)"my-sample-project", (Object)PROJECT_VIEWER.getValue());
    }

    @Test(expected=NullPointerException.class)
    public void testProjectViewerNullId() {
        Identity.projectViewer(null);
    }

    @Test
    public void testIdentityToAndFromPb() {
        this.compareIdentities(ALL_USERS, Identity.valueOf((String)ALL_USERS.strValue()));
        this.compareIdentities(ALL_AUTH_USERS, Identity.valueOf((String)ALL_AUTH_USERS.strValue()));
        this.compareIdentities(USER, Identity.valueOf((String)USER.strValue()));
        this.compareIdentities(SERVICE_ACCOUNT, Identity.valueOf((String)SERVICE_ACCOUNT.strValue()));
        this.compareIdentities(GROUP, Identity.valueOf((String)GROUP.strValue()));
        this.compareIdentities(DOMAIN, Identity.valueOf((String)DOMAIN.strValue()));
        this.compareIdentities(PROJECT_OWNER, Identity.valueOf((String)PROJECT_OWNER.strValue()));
        this.compareIdentities(PROJECT_EDITOR, Identity.valueOf((String)PROJECT_EDITOR.strValue()));
        this.compareIdentities(PROJECT_VIEWER, Identity.valueOf((String)PROJECT_VIEWER.strValue()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValueOfEmpty() {
        Identity.valueOf((String)"");
    }

    @Test
    public void testUnrecognizedToString() {
        Assert.assertEquals((Object)"a:b", (Object)Identity.valueOf((String)"a:b").strValue());
    }

    @Test
    public void testValueOfThreePart() {
        Identity identity = Identity.valueOf((String)"a:b:c");
        Assert.assertEquals((Object)"A", (Object)identity.getType().name());
        Assert.assertEquals((Object)"b:c", (Object)identity.getValue());
    }

    private void compareIdentities(Identity expected, Identity actual) {
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertEquals((Object)expected.getType(), (Object)actual.getType());
        Assert.assertEquals((Object)expected.getValue(), (Object)actual.getValue());
    }
}

