/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.MonitoredResource;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class MonitoredResourceTest {
    private static final String TYPE = "cloudsql_database";
    private static final Map<String, String> LABELS = ImmutableMap.of((Object)"dataset-id", (Object)"myDataset", (Object)"zone", (Object)"myZone");
    private static final MonitoredResource MONITORED_RESOURCE = MonitoredResource.newBuilder((String)"cloudsql_database").setLabels(LABELS).build();

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)TYPE, (Object)MONITORED_RESOURCE.getType());
        Assert.assertEquals(LABELS, (Object)MONITORED_RESOURCE.getLabels());
        MonitoredResource monitoredResource = MonitoredResource.newBuilder((String)TYPE).addLabel("dataset-id", "myDataset").addLabel("zone", "myZone").build();
        Assert.assertEquals((Object)TYPE, (Object)monitoredResource.getType());
        Assert.assertEquals(LABELS, (Object)monitoredResource.getLabels());
        this.compareMonitoredResource(MONITORED_RESOURCE, monitoredResource);
        monitoredResource = MonitoredResource.newBuilder((String)TYPE).setType("global").addLabel("dataset-id", "myDataset").addLabel("zone", "myZone").clearLabels().build();
        Assert.assertEquals((Object)"global", (Object)monitoredResource.getType());
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)monitoredResource.getLabels());
    }

    @Test
    public void testToBuilder() {
        this.compareMonitoredResource(MONITORED_RESOURCE, MONITORED_RESOURCE.toBuilder().build());
        MonitoredResource monitoredResource = MONITORED_RESOURCE.toBuilder().setType("global").clearLabels().build();
        Assert.assertEquals((Object)"global", (Object)monitoredResource.getType());
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)monitoredResource.getLabels());
        monitoredResource = monitoredResource.toBuilder().setType(TYPE).setLabels((Map)ImmutableMap.of((Object)"dataset-id", (Object)"myDataset")).addLabel("zone", "myZone").build();
        this.compareMonitoredResource(MONITORED_RESOURCE, monitoredResource);
    }

    @Test
    public void testOf() {
        MonitoredResource monitoredResource = MonitoredResource.of((String)TYPE, LABELS);
        Assert.assertEquals((Object)TYPE, (Object)monitoredResource.getType());
        Assert.assertEquals(LABELS, (Object)monitoredResource.getLabels());
        this.compareMonitoredResource(MONITORED_RESOURCE, monitoredResource);
    }

    @Test
    public void testToAndFromPb() {
        this.compareMonitoredResource(MONITORED_RESOURCE, MonitoredResource.fromPb((com.google.api.MonitoredResource)MONITORED_RESOURCE.toPb()));
        MonitoredResource monitoredResource = MonitoredResource.of((String)TYPE, (Map)ImmutableMap.of());
        this.compareMonitoredResource(monitoredResource, MonitoredResource.fromPb((com.google.api.MonitoredResource)monitoredResource.toPb()));
    }

    private void compareMonitoredResource(MonitoredResource expected, MonitoredResource value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getType(), (Object)value.getType());
        Assert.assertEquals((Object)expected.getLabels(), (Object)value.getLabels());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

