/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.Identity;
import com.google.cloud.Policy;
import com.google.cloud.Role;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableMap;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class PolicyTest {
    private static final Identity ALL_USERS = Identity.allUsers();
    private static final Identity ALL_AUTH_USERS = Identity.allAuthenticatedUsers();
    private static final Identity USER = Identity.user((String)"abc@gmail.com");
    private static final Identity SERVICE_ACCOUNT = Identity.serviceAccount((String)"service-account@gmail.com");
    private static final Identity GROUP = Identity.group((String)"group@gmail.com");
    private static final Identity DOMAIN = Identity.domain((String)"google.com");
    private static final Role VIEWER = Role.viewer();
    private static final Role EDITOR = Role.editor();
    private static final Role OWNER = Role.owner();
    private static final Map<Role, ImmutableSet<Identity>> BINDINGS = ImmutableMap.of((Object)VIEWER, (Object)ImmutableSet.of((Object)USER, (Object)SERVICE_ACCOUNT, (Object)ALL_USERS), (Object)EDITOR, (Object)ImmutableSet.of((Object)ALL_AUTH_USERS, (Object)GROUP, (Object)DOMAIN));
    private static final Policy SIMPLE_POLICY = Policy.newBuilder().addIdentity(VIEWER, USER, new Identity[]{SERVICE_ACCOUNT, ALL_USERS}).addIdentity(EDITOR, ALL_AUTH_USERS, new Identity[]{GROUP, DOMAIN}).build();
    private static final Policy FULL_POLICY = Policy.newBuilder().setBindings(SIMPLE_POLICY.getBindings()).setEtag("etag").setVersion(1).build();

    @Test
    public void testBuilder() {
        Assert.assertEquals(BINDINGS, (Object)SIMPLE_POLICY.getBindings());
        Assert.assertEquals(null, (Object)SIMPLE_POLICY.getEtag());
        Assert.assertEquals((long)0L, (long)SIMPLE_POLICY.getVersion());
        Assert.assertEquals(BINDINGS, (Object)FULL_POLICY.getBindings());
        Assert.assertEquals((Object)"etag", (Object)FULL_POLICY.getEtag());
        Assert.assertEquals((long)1L, (long)FULL_POLICY.getVersion());
        ImmutableMap editorBinding = ImmutableMap.builder().put((Object)EDITOR, BINDINGS.get(EDITOR)).build();
        Policy policy = FULL_POLICY.toBuilder().setBindings((Map)editorBinding).build();
        Assert.assertEquals((Object)editorBinding, (Object)policy.getBindings());
        Assert.assertEquals((Object)"etag", (Object)policy.getEtag());
        Assert.assertEquals((long)1L, (long)policy.getVersion());
        policy = SIMPLE_POLICY.toBuilder().removeRole(EDITOR).build();
        Assert.assertEquals((Object)ImmutableMap.of((Object)VIEWER, BINDINGS.get(VIEWER)), (Object)policy.getBindings());
        Assert.assertNull((Object)policy.getEtag());
        Assert.assertEquals((long)0L, (long)policy.getVersion());
        policy = policy.toBuilder().removeIdentity(VIEWER, USER, new Identity[]{ALL_USERS}).addIdentity(VIEWER, DOMAIN, new Identity[]{GROUP}).build();
        Assert.assertEquals((Object)ImmutableMap.of((Object)VIEWER, (Object)ImmutableSet.of((Object)SERVICE_ACCOUNT, (Object)DOMAIN, (Object)GROUP)), (Object)policy.getBindings());
        Assert.assertNull((Object)policy.getEtag());
        Assert.assertEquals((long)0L, (long)policy.getVersion());
        policy = Policy.newBuilder().removeIdentity(VIEWER, USER, new Identity[0]).addIdentity(OWNER, USER, new Identity[]{SERVICE_ACCOUNT}).addIdentity(EDITOR, GROUP, new Identity[0]).removeIdentity(EDITOR, GROUP, new Identity[0]).build();
        Assert.assertEquals((Object)ImmutableMap.of((Object)OWNER, (Object)ImmutableSet.of((Object)USER, (Object)SERVICE_ACCOUNT)), (Object)policy.getBindings());
        Assert.assertNull((Object)policy.getEtag());
        Assert.assertEquals((long)0L, (long)policy.getVersion());
    }

    @Test
    public void testPolicyOrderShouldNotMatter() {
        Role role1 = Role.of((String)"role1");
        Identity identity1 = Identity.user((String)"user1@example.com");
        Role role2 = Role.of((String)"role2");
        Identity identity2 = Identity.user((String)"user2@example.com");
        Policy policy1 = Policy.newBuilder().addIdentity(role1, identity1, new Identity[0]).addIdentity(role2, identity2, new Identity[0]).build();
        Policy policy2 = Policy.newBuilder().addIdentity(role2, identity2, new Identity[0]).addIdentity(role1, identity1, new Identity[0]).build();
        Assert.assertEquals((Object)policy1, (Object)policy2);
    }

    @Test
    public void testPolicyMultipleAddIdentitiesShouldNotMatter() {
        Role role1 = Role.of((String)"role1");
        Identity identity1 = Identity.user((String)"user1@example.com");
        Role role2 = Role.of((String)"role2");
        Identity identity2 = Identity.user((String)"user2@example.com");
        Policy policy1 = Policy.newBuilder().addIdentity(role1, identity1, new Identity[0]).addIdentity(role2, identity2, new Identity[0]).addIdentity(role2, identity2, new Identity[0]).build();
        Policy policy2 = Policy.newBuilder().addIdentity(role2, identity2, new Identity[0]).addIdentity(role1, identity1, new Identity[0]).build();
        Assert.assertEquals((Object)policy1, (Object)policy2);
    }

    @Test
    public void testIllegalPolicies() {
        HashMap bindings;
        try {
            Policy.newBuilder().addIdentity(null, USER, new Identity[0]);
            Assert.fail((String)"Null role should cause exception.");
        }
        catch (NullPointerException ex) {
            Assert.assertEquals((Object)"The role cannot be null.", (Object)ex.getMessage());
        }
        try {
            Policy.newBuilder().addIdentity(VIEWER, null, new Identity[]{USER});
            Assert.fail((String)"Null identity should cause exception.");
        }
        catch (NullPointerException ex) {
            Assert.assertEquals((Object)"Null identities are not permitted.", (Object)ex.getMessage());
        }
        try {
            Policy.newBuilder().addIdentity(VIEWER, USER, (Identity[])null);
            Assert.fail((String)"Null identity should cause exception.");
        }
        catch (NullPointerException ex) {
            Assert.assertEquals((Object)"Null identities are not permitted.", (Object)ex.getMessage());
        }
        try {
            Policy.newBuilder().setBindings((Map)null);
            Assert.fail((String)"Null bindings map should cause exception.");
        }
        catch (NullPointerException ex) {
            Assert.assertEquals((Object)"The provided map of bindings cannot be null.", (Object)ex.getMessage());
        }
        try {
            bindings = new HashMap();
            bindings.put(VIEWER, null);
            Policy.newBuilder().setBindings(bindings);
            Assert.fail((String)"Null set of identities should cause exception.");
        }
        catch (NullPointerException ex) {
            Assert.assertEquals((Object)"A role cannot be assigned to a null set of identities.", (Object)ex.getMessage());
        }
        try {
            bindings = new HashMap();
            HashSet<Object> identities = new HashSet<Object>();
            identities.add(null);
            bindings.put(VIEWER, identities);
            Policy.newBuilder().setBindings(bindings);
            Assert.fail((String)"Null identity should cause exception.");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"Null identities are not permitted.", (Object)ex.getMessage());
        }
    }

    @Test
    public void testEqualsHashCode() {
        Assert.assertNotNull((Object)FULL_POLICY);
        Policy emptyPolicy = Policy.newBuilder().build();
        Policy anotherPolicy = Policy.newBuilder().build();
        Assert.assertEquals((Object)emptyPolicy, (Object)anotherPolicy);
        Assert.assertEquals((long)emptyPolicy.hashCode(), (long)anotherPolicy.hashCode());
        Assert.assertNotEquals((Object)FULL_POLICY, (Object)SIMPLE_POLICY);
        Assert.assertNotEquals((long)FULL_POLICY.hashCode(), (long)SIMPLE_POLICY.hashCode());
        Policy copy = SIMPLE_POLICY.toBuilder().build();
        Assert.assertEquals((Object)SIMPLE_POLICY, (Object)copy);
        Assert.assertEquals((long)SIMPLE_POLICY.hashCode(), (long)copy.hashCode());
    }

    @Test
    public void testBindings() {
        Assert.assertTrue((boolean)Policy.newBuilder().build().getBindings().isEmpty());
        Assert.assertEquals(BINDINGS, (Object)SIMPLE_POLICY.getBindings());
    }

    @Test
    public void testEtag() {
        Assert.assertNull((Object)SIMPLE_POLICY.getEtag());
        Assert.assertEquals((Object)"etag", (Object)FULL_POLICY.getEtag());
    }

    @Test
    public void testVersion() {
        Assert.assertEquals((long)0L, (long)SIMPLE_POLICY.getVersion());
        Assert.assertEquals((long)1L, (long)FULL_POLICY.getVersion());
    }

    @Test
    public void testDefaultMarshaller() {
        Policy.DefaultMarshaller marshaller = new Policy.DefaultMarshaller();
        Policy emptyPolicy = Policy.newBuilder().build();
        Assert.assertEquals((Object)emptyPolicy, (Object)marshaller.fromPb(marshaller.toPb(emptyPolicy)));
        Assert.assertEquals((Object)SIMPLE_POLICY, (Object)marshaller.fromPb(marshaller.toPb(SIMPLE_POLICY)));
        Assert.assertEquals((Object)FULL_POLICY, (Object)marshaller.fromPb(marshaller.toPb(FULL_POLICY)));
        com.google.iam.v1.Policy policyPb = com.google.iam.v1.Policy.getDefaultInstance();
        Policy policy = marshaller.fromPb(policyPb);
        Assert.assertTrue((boolean)policy.getBindings().isEmpty());
        Assert.assertNull((Object)policy.getEtag());
        Assert.assertEquals((long)0L, (long)policy.getVersion());
    }
}

