/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.Role;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import org.junit.Test;

public class RoleTest {
    private static final Role VIEWER = Role.of((String)"viewer");
    private static final Role EDITOR = Role.of((String)"editor");
    private static final Role OWNER = Role.of((String)"owner");

    @Test
    public void testOf() {
        Truth.assertThat((String)VIEWER.getValue()).isEqualTo((Object)"roles/viewer");
        Truth.assertThat((String)EDITOR.getValue()).isEqualTo((Object)"roles/editor");
        Truth.assertThat((String)OWNER.getValue()).isEqualTo((Object)"roles/owner");
        this.compareRoles(VIEWER, Role.of((String)"roles/viewer"));
        this.compareRoles(EDITOR, Role.of((String)"roles/editor"));
        this.compareRoles(OWNER, Role.of((String)"roles/owner"));
        String customRole = "projects/foo/roles/bar";
        Truth.assertThat((String)Role.of((String)customRole).getValue()).isEqualTo((Object)customRole);
    }

    @Test
    public void testViewer() {
        Truth.assertThat((String)Role.viewer().getValue()).isEqualTo((Object)"roles/viewer");
    }

    @Test
    public void testEditor() {
        Truth.assertThat((String)Role.editor().getValue()).isEqualTo((Object)"roles/editor");
    }

    @Test
    public void testOwner() {
        Truth.assertThat((String)Role.owner().getValue()).isEqualTo((Object)"roles/owner");
    }

    @Test(expected=NullPointerException.class)
    public void testOfNullValue() {
        Role.of(null);
    }

    private void compareRoles(Role expected, Role actual) {
        Truth.assertThat((Object)actual).isEqualTo((Object)expected);
        Truth.assertThat((String)actual.getValue()).isEqualTo((Object)expected.getValue());
        Truth.assertThat((Integer)actual.hashCode()).isEqualTo((Object)expected.hashCode());
        Truth.assertThat((String)actual.toString()).isEqualTo((Object)expected.toString());
    }
}

