/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.testing.http.HttpTesting;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.api.core.ApiClock;
import com.google.api.core.CurrentMillisClock;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.BaseService;
import com.google.cloud.NoCredentials;
import com.google.cloud.Service;
import com.google.cloud.ServiceDefaults;
import com.google.cloud.ServiceFactory;
import com.google.cloud.ServiceOptions;
import com.google.cloud.ServiceRpc;
import com.google.cloud.TransportOptions;
import com.google.cloud.spi.ServiceRpcFactory;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ArrayListMultimap;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Multimap;
import cz.o2.proxima.internal.shaded.com.google.common.io.Files;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;

public class ServiceOptionsTest {
    private static GoogleCredentials credentials = ServiceOptionsTest.loadCredentials("{\n  \"private_key_id\": \"somekeyid\",\n  \"private_key\": \"-----BEGIN PRIVATE KEY-----\\nMIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQC+K2hSuFpAdrJI\\nnCgcDz2M7t7bjdlsadsasad+fvRSW6TjNQZ3p5LLQY1kSZRqBqylRkzteMOyHgaR\\n0Pmxh3ILCND5men43j3h4eDbrhQBuxfEMalkG92sL+PNQSETY2tnvXryOvmBRwa/\\nQP/9dJfIkIDJ9Fw9N4Bhhhp6mCcRpdQjV38H7JsyJ7lih/oNjECgYAt\\nknddadwkwewcVxHFhcZJO+XWf6ofLUXpRwiTZakGMn8EE1uVa2LgczOjwWHGi99MFjxSer5m9\\n1tCa3/KEGKiS/YL71JvjwX3mb+cewlkcmweBKZHM2JPTk0ZednFSpVZMtycjkbLa\\ndYOS8V85AgMBewECggEBAKksaldajfDZDV6nGqbFjMiizAKJolr/M3OQw16K6o3/\\n0S31xIe3sSlgW0+UbYlF4U8KifhManD1apVSC3csafaspP4RZUHFhtBywLO9pR5c\\nr6S5aLp+gPWFyIp1pfXbWGvc5VY/v9x7ya1VEa6rXvLsKupSeWAW4tMj3eo/64ge\\nsdaceaLYw52KeBYiT6+vpsnYrEkAHO1fF/LavbLLOFJmFTMxmsNaG0tuiJHgjshB\\n82DpMCbXG9YcCgI/DbzuIjsdj2JC1cascSP//3PmefWysucBQe7Jryb6NQtASmnv\\nCdDw/0jmZTEjpe4S1lxfHplAhHFtdgYTvyYtaLZiVVkCgYEA8eVpof2rceecw/I6\\n5ng1q3Hl2usdWV/4mZMvR0fOemacLLfocX6IYxT1zA1FFJlbXSRsJMf/Qq39mOR2\\nSpW+hr4jCoHeRVYLgsbggtrevGmILAlNoqCMpGZ6vDmJpq6ECV9olliDvpPgWOP+\\nmYPDreFBGxWvQrADNbRt2dmGsrsCgYEAyUHqB2wvJHFqdmeBsaacewzV8x9WgmeX\\ngUIi9REwXlGDW0Mz50dxpxcKCAYn65+7TCnY5O/jmL0VRxU1J2mSWyWTo1C+17L0\\n3fUqjxL1pkefwecxwecvC+gFFYdJ4CQ/MHHXU81Lwl1iWdFCd2UoGddYaOF+KNeM\\nHC7cmqra+JsCgYEAlUNywzq8nUg7282E+uICfCB0LfwejuymR93CtsFgb7cRd6ak\\nECR8FGfCpH8ruWJINllbQfcHVCX47ndLZwqv3oVFKh6pAS/vVI4dpOepP8++7y1u\\ncoOvtreXCX6XqfrWDtKIvv0vjlHBhhhp6mCcRpdQjV38H7JsyJ7lih/oNjECgYAt\\nkndj5uNl5SiuVxHFhcZJO+XWf6ofLUregtevZakGMn8EE1uVa2AY7eafmoU/nZPT\\n00YB0TBATdCbn/nBSuKDESkhSg9s2GEKQZG5hBmL5uCMfo09z3SfxZIhJdlerreP\\nJ7gSidI12N+EZxYd4xIJh/HFDgp7RRO87f+WJkofMQKBgGTnClK1VMaCRbJZPriw\\nEfeFCoOX75MxKwXs6xgrw4W//AYGGUjDt83lD6AZP6tws7gJ2IwY/qP7+lyhjEqN\\nHtfPZRGFkGZsdaksdlaksd323423d+15/UvrlRSFPNj1tWQmNKkXyRDW4IG1Oa2p\\nrALStNBx5Y9t0/LQnFI4w3aG\\n-----END PRIVATE KEY-----\\n\",\n  \"client_email\": \"someclientid@developer.gserviceaccount.com\",\n  \"client_id\": \"someclientid.apps.googleusercontent.com\",\n  \"type\": \"service_account\"\n}");
    private static GoogleCredentials credentialsWithProjectId = ServiceOptionsTest.loadCredentials("{\n  \"private_key_id\": \"somekeyid\",\n  \"private_key\": \"-----BEGIN PRIVATE KEY-----\\nMIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQC+K2hSuFpAdrJI\\nnCgcDz2M7t7bjdlsadsasad+fvRSW6TjNQZ3p5LLQY1kSZRqBqylRkzteMOyHgaR\\n0Pmxh3ILCND5men43j3h4eDbrhQBuxfEMalkG92sL+PNQSETY2tnvXryOvmBRwa/\\nQP/9dJfIkIDJ9Fw9N4Bhhhp6mCcRpdQjV38H7JsyJ7lih/oNjECgYAt\\nknddadwkwewcVxHFhcZJO+XWf6ofLUXpRwiTZakGMn8EE1uVa2LgczOjwWHGi99MFjxSer5m9\\n1tCa3/KEGKiS/YL71JvjwX3mb+cewlkcmweBKZHM2JPTk0ZednFSpVZMtycjkbLa\\ndYOS8V85AgMBewECggEBAKksaldajfDZDV6nGqbFjMiizAKJolr/M3OQw16K6o3/\\n0S31xIe3sSlgW0+UbYlF4U8KifhManD1apVSC3csafaspP4RZUHFhtBywLO9pR5c\\nr6S5aLp+gPWFyIp1pfXbWGvc5VY/v9x7ya1VEa6rXvLsKupSeWAW4tMj3eo/64ge\\nsdaceaLYw52KeBYiT6+vpsnYrEkAHO1fF/LavbLLOFJmFTMxmsNaG0tuiJHgjshB\\n82DpMCbXG9YcCgI/DbzuIjsdj2JC1cascSP//3PmefWysucBQe7Jryb6NQtASmnv\\nCdDw/0jmZTEjpe4S1lxfHplAhHFtdgYTvyYtaLZiVVkCgYEA8eVpof2rceecw/I6\\n5ng1q3Hl2usdWV/4mZMvR0fOemacLLfocX6IYxT1zA1FFJlbXSRsJMf/Qq39mOR2\\nSpW+hr4jCoHeRVYLgsbggtrevGmILAlNoqCMpGZ6vDmJpq6ECV9olliDvpPgWOP+\\nmYPDreFBGxWvQrADNbRt2dmGsrsCgYEAyUHqB2wvJHFqdmeBsaacewzV8x9WgmeX\\ngUIi9REwXlGDW0Mz50dxpxcKCAYn65+7TCnY5O/jmL0VRxU1J2mSWyWTo1C+17L0\\n3fUqjxL1pkefwecxwecvC+gFFYdJ4CQ/MHHXU81Lwl1iWdFCd2UoGddYaOF+KNeM\\nHC7cmqra+JsCgYEAlUNywzq8nUg7282E+uICfCB0LfwejuymR93CtsFgb7cRd6ak\\nECR8FGfCpH8ruWJINllbQfcHVCX47ndLZwqv3oVFKh6pAS/vVI4dpOepP8++7y1u\\ncoOvtreXCX6XqfrWDtKIvv0vjlHBhhhp6mCcRpdQjV38H7JsyJ7lih/oNjECgYAt\\nkndj5uNl5SiuVxHFhcZJO+XWf6ofLUregtevZakGMn8EE1uVa2AY7eafmoU/nZPT\\n00YB0TBATdCbn/nBSuKDESkhSg9s2GEKQZG5hBmL5uCMfo09z3SfxZIhJdlerreP\\nJ7gSidI12N+EZxYd4xIJh/HFDgp7RRO87f+WJkofMQKBgGTnClK1VMaCRbJZPriw\\nEfeFCoOX75MxKwXs6xgrw4W//AYGGUjDt83lD6AZP6tws7gJ2IwY/qP7+lyhjEqN\\nHtfPZRGFkGZsdaksdlaksd323423d+15/UvrlRSFPNj1tWQmNKkXyRDW4IG1Oa2p\\nrALStNBx5Y9t0/LQnFI4w3aG\\n-----END PRIVATE KEY-----\\n\",\n  \"project_id\": \"someprojectid\",\n  \"client_email\": \"someclientid@developer.gserviceaccount.com\",\n  \"client_id\": \"someclientid.apps.googleusercontent.com\",\n  \"type\": \"service_account\"\n}");
    private static GoogleCredentials credentialsWithQuotaProject = ServiceOptionsTest.loadCredentials("{\n  \"private_key_id\": \"somekeyid\",\n  \"private_key\": \"-----BEGIN PRIVATE KEY-----\\nMIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQC+K2hSuFpAdrJI\\nnCgcDz2M7t7bjdlsadsasad+fvRSW6TjNQZ3p5LLQY1kSZRqBqylRkzteMOyHgaR\\n0Pmxh3ILCND5men43j3h4eDbrhQBuxfEMalkG92sL+PNQSETY2tnvXryOvmBRwa/\\nQP/9dJfIkIDJ9Fw9N4Bhhhp6mCcRpdQjV38H7JsyJ7lih/oNjECgYAt\\nknddadwkwewcVxHFhcZJO+XWf6ofLUXpRwiTZakGMn8EE1uVa2LgczOjwWHGi99MFjxSer5m9\\n1tCa3/KEGKiS/YL71JvjwX3mb+cewlkcmweBKZHM2JPTk0ZednFSpVZMtycjkbLa\\ndYOS8V85AgMBewECggEBAKksaldajfDZDV6nGqbFjMiizAKJolr/M3OQw16K6o3/\\n0S31xIe3sSlgW0+UbYlF4U8KifhManD1apVSC3csafaspP4RZUHFhtBywLO9pR5c\\nr6S5aLp+gPWFyIp1pfXbWGvc5VY/v9x7ya1VEa6rXvLsKupSeWAW4tMj3eo/64ge\\nsdaceaLYw52KeBYiT6+vpsnYrEkAHO1fF/LavbLLOFJmFTMxmsNaG0tuiJHgjshB\\n82DpMCbXG9YcCgI/DbzuIjsdj2JC1cascSP//3PmefWysucBQe7Jryb6NQtASmnv\\nCdDw/0jmZTEjpe4S1lxfHplAhHFtdgYTvyYtaLZiVVkCgYEA8eVpof2rceecw/I6\\n5ng1q3Hl2usdWV/4mZMvR0fOemacLLfocX6IYxT1zA1FFJlbXSRsJMf/Qq39mOR2\\nSpW+hr4jCoHeRVYLgsbggtrevGmILAlNoqCMpGZ6vDmJpq6ECV9olliDvpPgWOP+\\nmYPDreFBGxWvQrADNbRt2dmGsrsCgYEAyUHqB2wvJHFqdmeBsaacewzV8x9WgmeX\\ngUIi9REwXlGDW0Mz50dxpxcKCAYn65+7TCnY5O/jmL0VRxU1J2mSWyWTo1C+17L0\\n3fUqjxL1pkefwecxwecvC+gFFYdJ4CQ/MHHXU81Lwl1iWdFCd2UoGddYaOF+KNeM\\nHC7cmqra+JsCgYEAlUNywzq8nUg7282E+uICfCB0LfwejuymR93CtsFgb7cRd6ak\\nECR8FGfCpH8ruWJINllbQfcHVCX47ndLZwqv3oVFKh6pAS/vVI4dpOepP8++7y1u\\ncoOvtreXCX6XqfrWDtKIvv0vjlHBhhhp6mCcRpdQjV38H7JsyJ7lih/oNjECgYAt\\nkndj5uNl5SiuVxHFhcZJO+XWf6ofLUregtevZakGMn8EE1uVa2AY7eafmoU/nZPT\\n00YB0TBATdCbn/nBSuKDESkhSg9s2GEKQZG5hBmL5uCMfo09z3SfxZIhJdlerreP\\nJ7gSidI12N+EZxYd4xIJh/HFDgp7RRO87f+WJkofMQKBgGTnClK1VMaCRbJZPriw\\nEfeFCoOX75MxKwXs6xgrw4W//AYGGUjDt83lD6AZP6tws7gJ2IwY/qP7+lyhjEqN\\nHtfPZRGFkGZsdaksdlaksd323423d+15/UvrlRSFPNj1tWQmNKkXyRDW4IG1Oa2p\\nrALStNBx5Y9t0/LQnFI4w3aG\\n-----END PRIVATE KEY-----\\n\",\n  \"project_id\": \"someprojectid\",\n  \"client_email\": \"someclientid@developer.gserviceaccount.com\",\n  \"client_id\": \"someclientid.apps.googleusercontent.com\",\n  \"type\": \"service_account\",\n  \"quota_project_id\": \"some-quota-project-id\"\n}");
    private static final String JSON_KEY = "{\n  \"private_key_id\": \"somekeyid\",\n  \"private_key\": \"-----BEGIN PRIVATE KEY-----\\nMIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQC+K2hSuFpAdrJI\\nnCgcDz2M7t7bjdlsadsasad+fvRSW6TjNQZ3p5LLQY1kSZRqBqylRkzteMOyHgaR\\n0Pmxh3ILCND5men43j3h4eDbrhQBuxfEMalkG92sL+PNQSETY2tnvXryOvmBRwa/\\nQP/9dJfIkIDJ9Fw9N4Bhhhp6mCcRpdQjV38H7JsyJ7lih/oNjECgYAt\\nknddadwkwewcVxHFhcZJO+XWf6ofLUXpRwiTZakGMn8EE1uVa2LgczOjwWHGi99MFjxSer5m9\\n1tCa3/KEGKiS/YL71JvjwX3mb+cewlkcmweBKZHM2JPTk0ZednFSpVZMtycjkbLa\\ndYOS8V85AgMBewECggEBAKksaldajfDZDV6nGqbFjMiizAKJolr/M3OQw16K6o3/\\n0S31xIe3sSlgW0+UbYlF4U8KifhManD1apVSC3csafaspP4RZUHFhtBywLO9pR5c\\nr6S5aLp+gPWFyIp1pfXbWGvc5VY/v9x7ya1VEa6rXvLsKupSeWAW4tMj3eo/64ge\\nsdaceaLYw52KeBYiT6+vpsnYrEkAHO1fF/LavbLLOFJmFTMxmsNaG0tuiJHgjshB\\n82DpMCbXG9YcCgI/DbzuIjsdj2JC1cascSP//3PmefWysucBQe7Jryb6NQtASmnv\\nCdDw/0jmZTEjpe4S1lxfHplAhHFtdgYTvyYtaLZiVVkCgYEA8eVpof2rceecw/I6\\n5ng1q3Hl2usdWV/4mZMvR0fOemacLLfocX6IYxT1zA1FFJlbXSRsJMf/Qq39mOR2\\nSpW+hr4jCoHeRVYLgsbggtrevGmILAlNoqCMpGZ6vDmJpq6ECV9olliDvpPgWOP+\\nmYPDreFBGxWvQrADNbRt2dmGsrsCgYEAyUHqB2wvJHFqdmeBsaacewzV8x9WgmeX\\ngUIi9REwXlGDW0Mz50dxpxcKCAYn65+7TCnY5O/jmL0VRxU1J2mSWyWTo1C+17L0\\n3fUqjxL1pkefwecxwecvC+gFFYdJ4CQ/MHHXU81Lwl1iWdFCd2UoGddYaOF+KNeM\\nHC7cmqra+JsCgYEAlUNywzq8nUg7282E+uICfCB0LfwejuymR93CtsFgb7cRd6ak\\nECR8FGfCpH8ruWJINllbQfcHVCX47ndLZwqv3oVFKh6pAS/vVI4dpOepP8++7y1u\\ncoOvtreXCX6XqfrWDtKIvv0vjlHBhhhp6mCcRpdQjV38H7JsyJ7lih/oNjECgYAt\\nkndj5uNl5SiuVxHFhcZJO+XWf6ofLUregtevZakGMn8EE1uVa2AY7eafmoU/nZPT\\n00YB0TBATdCbn/nBSuKDESkhSg9s2GEKQZG5hBmL5uCMfo09z3SfxZIhJdlerreP\\nJ7gSidI12N+EZxYd4xIJh/HFDgp7RRO87f+WJkofMQKBgGTnClK1VMaCRbJZPriw\\nEfeFCoOX75MxKwXs6xgrw4W//AYGGUjDt83lD6AZP6tws7gJ2IwY/qP7+lyhjEqN\\nHtfPZRGFkGZsdaksdlaksd323423d+15/UvrlRSFPNj1tWQmNKkXyRDW4IG1Oa2p\\nrALStNBx5Y9t0/LQnFI4w3aG\\n-----END PRIVATE KEY-----\\n\",\n  \"client_email\": \"someclientid@developer.gserviceaccount.com\",\n  \"client_id\": \"someclientid.apps.googleusercontent.com\",\n  \"type\": \"service_account\"\n}";
    private static final String JSON_KEY_PROJECT_ID = "{\n  \"private_key_id\": \"somekeyid\",\n  \"private_key\": \"-----BEGIN PRIVATE KEY-----\\nMIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQC+K2hSuFpAdrJI\\nnCgcDz2M7t7bjdlsadsasad+fvRSW6TjNQZ3p5LLQY1kSZRqBqylRkzteMOyHgaR\\n0Pmxh3ILCND5men43j3h4eDbrhQBuxfEMalkG92sL+PNQSETY2tnvXryOvmBRwa/\\nQP/9dJfIkIDJ9Fw9N4Bhhhp6mCcRpdQjV38H7JsyJ7lih/oNjECgYAt\\nknddadwkwewcVxHFhcZJO+XWf6ofLUXpRwiTZakGMn8EE1uVa2LgczOjwWHGi99MFjxSer5m9\\n1tCa3/KEGKiS/YL71JvjwX3mb+cewlkcmweBKZHM2JPTk0ZednFSpVZMtycjkbLa\\ndYOS8V85AgMBewECggEBAKksaldajfDZDV6nGqbFjMiizAKJolr/M3OQw16K6o3/\\n0S31xIe3sSlgW0+UbYlF4U8KifhManD1apVSC3csafaspP4RZUHFhtBywLO9pR5c\\nr6S5aLp+gPWFyIp1pfXbWGvc5VY/v9x7ya1VEa6rXvLsKupSeWAW4tMj3eo/64ge\\nsdaceaLYw52KeBYiT6+vpsnYrEkAHO1fF/LavbLLOFJmFTMxmsNaG0tuiJHgjshB\\n82DpMCbXG9YcCgI/DbzuIjsdj2JC1cascSP//3PmefWysucBQe7Jryb6NQtASmnv\\nCdDw/0jmZTEjpe4S1lxfHplAhHFtdgYTvyYtaLZiVVkCgYEA8eVpof2rceecw/I6\\n5ng1q3Hl2usdWV/4mZMvR0fOemacLLfocX6IYxT1zA1FFJlbXSRsJMf/Qq39mOR2\\nSpW+hr4jCoHeRVYLgsbggtrevGmILAlNoqCMpGZ6vDmJpq6ECV9olliDvpPgWOP+\\nmYPDreFBGxWvQrADNbRt2dmGsrsCgYEAyUHqB2wvJHFqdmeBsaacewzV8x9WgmeX\\ngUIi9REwXlGDW0Mz50dxpxcKCAYn65+7TCnY5O/jmL0VRxU1J2mSWyWTo1C+17L0\\n3fUqjxL1pkefwecxwecvC+gFFYdJ4CQ/MHHXU81Lwl1iWdFCd2UoGddYaOF+KNeM\\nHC7cmqra+JsCgYEAlUNywzq8nUg7282E+uICfCB0LfwejuymR93CtsFgb7cRd6ak\\nECR8FGfCpH8ruWJINllbQfcHVCX47ndLZwqv3oVFKh6pAS/vVI4dpOepP8++7y1u\\ncoOvtreXCX6XqfrWDtKIvv0vjlHBhhhp6mCcRpdQjV38H7JsyJ7lih/oNjECgYAt\\nkndj5uNl5SiuVxHFhcZJO+XWf6ofLUregtevZakGMn8EE1uVa2AY7eafmoU/nZPT\\n00YB0TBATdCbn/nBSuKDESkhSg9s2GEKQZG5hBmL5uCMfo09z3SfxZIhJdlerreP\\nJ7gSidI12N+EZxYd4xIJh/HFDgp7RRO87f+WJkofMQKBgGTnClK1VMaCRbJZPriw\\nEfeFCoOX75MxKwXs6xgrw4W//AYGGUjDt83lD6AZP6tws7gJ2IwY/qP7+lyhjEqN\\nHtfPZRGFkGZsdaksdlaksd323423d+15/UvrlRSFPNj1tWQmNKkXyRDW4IG1Oa2p\\nrALStNBx5Y9t0/LQnFI4w3aG\\n-----END PRIVATE KEY-----\\n\",\n  \"project_id\": \"someprojectid\",\n  \"client_email\": \"someclientid@developer.gserviceaccount.com\",\n  \"client_id\": \"someclientid.apps.googleusercontent.com\",\n  \"type\": \"service_account\"\n}";
    private static final String JSON_KEY_QUOTA_PROJECT_ID = "{\n  \"private_key_id\": \"somekeyid\",\n  \"private_key\": \"-----BEGIN PRIVATE KEY-----\\nMIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQC+K2hSuFpAdrJI\\nnCgcDz2M7t7bjdlsadsasad+fvRSW6TjNQZ3p5LLQY1kSZRqBqylRkzteMOyHgaR\\n0Pmxh3ILCND5men43j3h4eDbrhQBuxfEMalkG92sL+PNQSETY2tnvXryOvmBRwa/\\nQP/9dJfIkIDJ9Fw9N4Bhhhp6mCcRpdQjV38H7JsyJ7lih/oNjECgYAt\\nknddadwkwewcVxHFhcZJO+XWf6ofLUXpRwiTZakGMn8EE1uVa2LgczOjwWHGi99MFjxSer5m9\\n1tCa3/KEGKiS/YL71JvjwX3mb+cewlkcmweBKZHM2JPTk0ZednFSpVZMtycjkbLa\\ndYOS8V85AgMBewECggEBAKksaldajfDZDV6nGqbFjMiizAKJolr/M3OQw16K6o3/\\n0S31xIe3sSlgW0+UbYlF4U8KifhManD1apVSC3csafaspP4RZUHFhtBywLO9pR5c\\nr6S5aLp+gPWFyIp1pfXbWGvc5VY/v9x7ya1VEa6rXvLsKupSeWAW4tMj3eo/64ge\\nsdaceaLYw52KeBYiT6+vpsnYrEkAHO1fF/LavbLLOFJmFTMxmsNaG0tuiJHgjshB\\n82DpMCbXG9YcCgI/DbzuIjsdj2JC1cascSP//3PmefWysucBQe7Jryb6NQtASmnv\\nCdDw/0jmZTEjpe4S1lxfHplAhHFtdgYTvyYtaLZiVVkCgYEA8eVpof2rceecw/I6\\n5ng1q3Hl2usdWV/4mZMvR0fOemacLLfocX6IYxT1zA1FFJlbXSRsJMf/Qq39mOR2\\nSpW+hr4jCoHeRVYLgsbggtrevGmILAlNoqCMpGZ6vDmJpq6ECV9olliDvpPgWOP+\\nmYPDreFBGxWvQrADNbRt2dmGsrsCgYEAyUHqB2wvJHFqdmeBsaacewzV8x9WgmeX\\ngUIi9REwXlGDW0Mz50dxpxcKCAYn65+7TCnY5O/jmL0VRxU1J2mSWyWTo1C+17L0\\n3fUqjxL1pkefwecxwecvC+gFFYdJ4CQ/MHHXU81Lwl1iWdFCd2UoGddYaOF+KNeM\\nHC7cmqra+JsCgYEAlUNywzq8nUg7282E+uICfCB0LfwejuymR93CtsFgb7cRd6ak\\nECR8FGfCpH8ruWJINllbQfcHVCX47ndLZwqv3oVFKh6pAS/vVI4dpOepP8++7y1u\\ncoOvtreXCX6XqfrWDtKIvv0vjlHBhhhp6mCcRpdQjV38H7JsyJ7lih/oNjECgYAt\\nkndj5uNl5SiuVxHFhcZJO+XWf6ofLUregtevZakGMn8EE1uVa2AY7eafmoU/nZPT\\n00YB0TBATdCbn/nBSuKDESkhSg9s2GEKQZG5hBmL5uCMfo09z3SfxZIhJdlerreP\\nJ7gSidI12N+EZxYd4xIJh/HFDgp7RRO87f+WJkofMQKBgGTnClK1VMaCRbJZPriw\\nEfeFCoOX75MxKwXs6xgrw4W//AYGGUjDt83lD6AZP6tws7gJ2IwY/qP7+lyhjEqN\\nHtfPZRGFkGZsdaksdlaksd323423d+15/UvrlRSFPNj1tWQmNKkXyRDW4IG1Oa2p\\nrALStNBx5Y9t0/LQnFI4w3aG\\n-----END PRIVATE KEY-----\\n\",\n  \"project_id\": \"someprojectid\",\n  \"client_email\": \"someclientid@developer.gserviceaccount.com\",\n  \"client_id\": \"someclientid.apps.googleusercontent.com\",\n  \"type\": \"service_account\",\n  \"quota_project_id\": \"some-quota-project-id\"\n}";
    private static final ApiClock TEST_CLOCK = new TestClock();
    private static final TestServiceOptions OPTIONS = ((TestServiceOptions.Builder)((TestServiceOptions.Builder)((TestServiceOptions.Builder)((TestServiceOptions.Builder)((TestServiceOptions.Builder)((TestServiceOptions.Builder)TestServiceOptions.access$100().setCredentials((Credentials)credentials)).setClock(TEST_CLOCK)).setHost("host")).setProjectId("project-id")).setRetrySettings(ServiceOptions.getNoRetrySettings())).setQuotaProjectId("quota-project-id")).build();
    private static final TestServiceOptions OPTIONS_NO_CREDENTIALS = ((TestServiceOptions.Builder)((TestServiceOptions.Builder)((TestServiceOptions.Builder)((TestServiceOptions.Builder)((TestServiceOptions.Builder)((TestServiceOptions.Builder)TestServiceOptions.access$100().setCredentials((Credentials)NoCredentials.getInstance())).setClock(TEST_CLOCK)).setHost("host")).setProjectId("project-id")).setRetrySettings(ServiceOptions.getNoRetrySettings())).setQuotaProjectId("quota-project-id")).build();
    private static final TestServiceOptions DEFAULT_OPTIONS = ((TestServiceOptions.Builder)TestServiceOptions.access$100().setProjectId("project-id")).build();
    private static final TestServiceOptions OPTIONS_COPY = OPTIONS.toBuilder().build();
    private static final String LIBRARY_NAME = "gcloud-java";
    private static final Pattern APPLICATION_NAME_PATTERN = Pattern.compile("gcloud-java/.*");

    static GoogleCredentials loadCredentials(String credentialFile) {
        try {
            ByteArrayInputStream keyStream = new ByteArrayInputStream(credentialFile.getBytes());
            return GoogleCredentials.fromStream((InputStream)keyStream);
        }
        catch (IOException e) {
            Assert.fail((String)"Couldn't create fake JSON credentials.");
            return null;
        }
    }

    @Test
    public void testBuilder() {
        Assert.assertSame((Object)credentials, (Object)OPTIONS.getCredentials());
        Assert.assertSame((Object)TEST_CLOCK, (Object)OPTIONS.getClock());
        Assert.assertEquals((Object)"host", (Object)OPTIONS.getHost());
        Assert.assertEquals((Object)"project-id", (Object)OPTIONS.getProjectId());
        Assert.assertSame((Object)ServiceOptions.getNoRetrySettings(), (Object)OPTIONS.getRetrySettings());
        Assert.assertSame((Object)CurrentMillisClock.getDefaultClock(), (Object)DEFAULT_OPTIONS.getClock());
        Assert.assertEquals((Object)"https://www.googleapis.com", (Object)DEFAULT_OPTIONS.getHost());
        Assert.assertSame((Object)ServiceOptions.getDefaultRetrySettings(), (Object)DEFAULT_OPTIONS.getRetrySettings());
    }

    @Test
    public void testBuilder_quotaProjectServiceOptionTakesPrecedence() {
        TestServiceOptions noCredsWithQuotaProject = ((TestServiceOptions.Builder)((TestServiceOptions.Builder)((TestServiceOptions.Builder)TestServiceOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance())).setProjectId("project-id")).setQuotaProjectId("quota-project-id")).build();
        TestServiceOptions quotaProjectCredsWithQuotaProject = ((TestServiceOptions.Builder)((TestServiceOptions.Builder)TestServiceOptions.newBuilder().setQuotaProjectId("quota-project-id")).setCredentials((Credentials)credentialsWithQuotaProject)).build();
        TestServiceOptions quotaProjectCredsWithQuotaProject2 = ((TestServiceOptions.Builder)((TestServiceOptions.Builder)TestServiceOptions.newBuilder().setCredentials((Credentials)credentialsWithQuotaProject)).setQuotaProjectId("quota-project-id")).build();
        TestServiceOptions quotaProjectCreds = ((TestServiceOptions.Builder)TestServiceOptions.newBuilder().setCredentials((Credentials)credentialsWithQuotaProject)).build();
        TestServiceOptions none = ((TestServiceOptions.Builder)((TestServiceOptions.Builder)TestServiceOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance())).setProjectId("project-id")).build();
        Assert.assertEquals((Object)"quota-project-id", (Object)noCredsWithQuotaProject.getQuotaProjectId());
        Assert.assertEquals((Object)"quota-project-id", (Object)quotaProjectCredsWithQuotaProject.getQuotaProjectId());
        Assert.assertEquals((Object)"quota-project-id", (Object)quotaProjectCredsWithQuotaProject2.getQuotaProjectId());
        Assert.assertEquals((Object)"some-quota-project-id", (Object)quotaProjectCreds.getQuotaProjectId());
        Assert.assertEquals(null, (Object)none.getQuotaProjectId());
    }

    @Test
    public void testBuilderNoCredentials() {
        Assert.assertEquals((Object)NoCredentials.getInstance(), (Object)OPTIONS_NO_CREDENTIALS.getCredentials());
        Assert.assertTrue((boolean)NoCredentials.getInstance().equals((Object)OPTIONS_NO_CREDENTIALS.getCredentials()));
        TestCase.assertFalse((boolean)NoCredentials.getInstance().equals((Object)OPTIONS.getCredentials()));
        TestCase.assertFalse((boolean)NoCredentials.getInstance().equals(null));
        Assert.assertSame((Object)TEST_CLOCK, (Object)OPTIONS_NO_CREDENTIALS.getClock());
        Assert.assertEquals((Object)"host", (Object)OPTIONS_NO_CREDENTIALS.getHost());
        Assert.assertEquals((Object)"project-id", (Object)OPTIONS_NO_CREDENTIALS.getProjectId());
        Assert.assertSame((Object)ServiceOptions.getNoRetrySettings(), (Object)OPTIONS_NO_CREDENTIALS.getRetrySettings());
        Assert.assertEquals((Object)"quota-project-id", (Object)OPTIONS.getQuotaProjectId());
    }

    @Test(expected=NullPointerException.class)
    public void testBuilderNullCredentials() {
        ((TestServiceOptions.Builder)TestServiceOptions.newBuilder().setCredentials(null)).build();
    }

    @Test
    public void testBuilderServiceAccount_setsProjectId() {
        TestServiceOptions options = ((TestServiceOptions.Builder)TestServiceOptions.newBuilder().setCredentials((Credentials)credentialsWithProjectId)).build();
        Assert.assertEquals((Object)"someprojectid", (Object)options.getProjectId());
    }

    @Test
    public void testBuilderServiceAccount_explicitSetProjectIdBefore() {
        TestServiceOptions options = ((TestServiceOptions.Builder)((TestServiceOptions.Builder)TestServiceOptions.newBuilder().setProjectId("override-project-id")).setCredentials((Credentials)credentialsWithProjectId)).build();
        Assert.assertEquals((Object)"override-project-id", (Object)options.getProjectId());
    }

    @Test
    public void testBuilderServiceAccount_explicitSetProjectIdAfter() {
        TestServiceOptions options = ((TestServiceOptions.Builder)((TestServiceOptions.Builder)TestServiceOptions.newBuilder().setCredentials((Credentials)credentialsWithProjectId)).setProjectId("override-project-id")).build();
        Assert.assertEquals((Object)"override-project-id", (Object)options.getProjectId());
    }

    @Test
    public void testGetProjectIdRequired() {
        Assert.assertTrue((boolean)OPTIONS.projectIdRequired());
    }

    @Test
    public void testService() {
        Assert.assertTrue((boolean)(OPTIONS.getService() instanceof TestServiceImpl));
    }

    @Test
    public void testRpc() {
        Assert.assertTrue((boolean)(OPTIONS.getRpc() instanceof DefaultTestServiceRpc));
    }

    @Test
    public void testBaseEquals() {
        Assert.assertEquals((Object)((Object)OPTIONS), (Object)((Object)OPTIONS_COPY));
        Assert.assertNotEquals((Object)((Object)DEFAULT_OPTIONS), (Object)((Object)OPTIONS));
    }

    @Test
    public void testLibraryName() {
        Assert.assertEquals((Object)LIBRARY_NAME, (Object)ServiceOptions.getLibraryName());
    }

    @Test
    public void testApplicationName() {
        Assert.assertTrue((boolean)APPLICATION_NAME_PATTERN.matcher(OPTIONS.getApplicationName()).matches());
    }

    @Test
    public void testBaseHashCode() {
        Assert.assertEquals((long)OPTIONS.hashCode(), (long)OPTIONS_COPY.hashCode());
        Assert.assertNotEquals((long)DEFAULT_OPTIONS.hashCode(), (long)OPTIONS.hashCode());
    }

    @Test
    public void testGetServiceAccountProjectId() throws Exception {
        File credentialsFile = File.createTempFile("credentials", ".json");
        credentialsFile.deleteOnExit();
        Files.write((byte[])"{\"project_id\":\"my-project-id\"}".getBytes(), (File)credentialsFile);
        Assert.assertEquals((Object)"my-project-id", (Object)ServiceOptions.getValueFromCredentialsFile((String)credentialsFile.getPath(), (String)"project_id"));
    }

    @Test
    public void testGetServiceAccountProjectId_badJson() throws Exception {
        File credentialsFile = File.createTempFile("credentials", ".json");
        credentialsFile.deleteOnExit();
        Files.write((byte[])"asdfghj".getBytes(StandardCharsets.UTF_8), (File)credentialsFile);
        String valueFromCredentialsFile = ServiceOptions.getValueFromCredentialsFile((String)credentialsFile.getPath(), (String)"project_id");
        Assert.assertNull((Object)valueFromCredentialsFile);
    }

    @Test
    public void testGetServiceAccountProjectId_nonExistentFile() throws Exception {
        File credentialsFile = new File("/doesnotexist");
        Assert.assertNull((Object)ServiceOptions.getValueFromCredentialsFile((String)credentialsFile.getPath(), (String)"project_id"));
    }

    @Test
    public void testResponseHeaderContainsMetaDataFlavor() throws Exception {
        ArrayListMultimap headers = ArrayListMultimap.create();
        headers.put((Object)"Metadata-Flavor", (Object)"Google");
        HttpResponse httpResponse = this.createHttpResponseWithHeader((Multimap<String, String>)headers);
        Truth.assertThat((Boolean)ServiceOptions.headerContainsMetadataFlavor((HttpResponse)httpResponse)).isTrue();
    }

    @Test
    public void testResponseHeaderDoesNotContainMetaDataFlavor() throws Exception {
        ArrayListMultimap headers = ArrayListMultimap.create();
        HttpResponse httpResponse = this.createHttpResponseWithHeader((Multimap<String, String>)headers);
        Truth.assertThat((Boolean)ServiceOptions.headerContainsMetadataFlavor((HttpResponse)httpResponse)).isFalse();
    }

    private HttpResponse createHttpResponseWithHeader(final Multimap<String, String> headers) throws Exception {
        MockHttpTransport mockHttpTransport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse response = new MockLowLevelHttpResponse();
                        for (Map.Entry entry : headers.entries()) {
                            response.addHeader((String)entry.getKey(), (String)entry.getValue());
                        }
                        return response;
                    }
                };
            }
        };
        HttpRequest request = mockHttpTransport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        return request.execute();
    }

    static class TestServiceOptions
    extends ServiceOptions<TestService, TestServiceOptions> {
        private TestServiceOptions(Builder builder) {
            super(TestServiceFactory.class, TestServiceRpcFactory.class, (ServiceOptions.Builder)builder, (ServiceDefaults)new TestServiceDefaults());
        }

        protected Set<String> getScopes() {
            return null;
        }

        public Builder toBuilder() {
            return new Builder(this);
        }

        private static Builder newBuilder() {
            return new Builder();
        }

        public boolean equals(Object obj) {
            return obj instanceof TestServiceOptions && this.baseEquals((TestServiceOptions)((Object)obj));
        }

        public int hashCode() {
            return this.baseHashCode();
        }

        private static class TestServiceDefaults
        implements ServiceDefaults<TestService, TestServiceOptions> {
            private TestServiceDefaults() {
            }

            public TestServiceFactory getDefaultServiceFactory() {
                return DefaultTestServiceFactory.INSTANCE;
            }

            public TestServiceRpcFactory getDefaultRpcFactory() {
                return DefaultTestServiceRpcFactory.INSTANCE;
            }

            public TransportOptions getDefaultTransportOptions() {
                return new TransportOptions(){};
            }
        }

        private static class Builder
        extends ServiceOptions.Builder<TestService, TestServiceOptions, Builder> {
            private Builder() {
            }

            private Builder(TestServiceOptions options) {
                super((ServiceOptions)options);
            }

            protected TestServiceOptions build() {
                return new TestServiceOptions(this);
            }
        }
    }

    private static class DefaultTestServiceRpc
    implements TestServiceRpc {
        DefaultTestServiceRpc(TestServiceOptions options) {
        }
    }

    private static interface TestServiceRpc
    extends ServiceRpc {
    }

    private static class DefaultTestServiceRpcFactory
    implements TestServiceRpcFactory {
        private static final TestServiceRpcFactory INSTANCE = new DefaultTestServiceRpcFactory();

        private DefaultTestServiceRpcFactory() {
        }

        public TestServiceRpc create(TestServiceOptions options) {
            return new DefaultTestServiceRpc(options);
        }
    }

    public static interface TestServiceRpcFactory
    extends ServiceRpcFactory<TestServiceOptions> {
    }

    private static class DefaultTestServiceFactory
    implements TestServiceFactory {
        private static final TestServiceFactory INSTANCE = new DefaultTestServiceFactory();

        private DefaultTestServiceFactory() {
        }

        public TestService create(TestServiceOptions options) {
            return new TestServiceImpl(options);
        }
    }

    public static interface TestServiceFactory
    extends ServiceFactory<TestService, TestServiceOptions> {
    }

    private static class TestServiceImpl
    extends BaseService<TestServiceOptions>
    implements TestService {
        private TestServiceImpl(TestServiceOptions options) {
            super((ServiceOptions)options);
        }
    }

    static interface TestService
    extends Service<TestServiceOptions> {
    }

    private static class TestClock
    implements ApiClock {
        private TestClock() {
        }

        public long nanoTime() {
            return 123456789000000L;
        }

        public long millisTime() {
            return 123456789L;
        }
    }
}

