/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.resourcenames.ResourceName;
import com.google.bigtable.admin.v2.AppProfile;
import com.google.bigtable.admin.v2.AppProfileName;
import com.google.bigtable.admin.v2.Cluster;
import com.google.bigtable.admin.v2.ClusterName;
import com.google.bigtable.admin.v2.CreateAppProfileRequest;
import com.google.bigtable.admin.v2.CreateClusterRequest;
import com.google.bigtable.admin.v2.CreateInstanceRequest;
import com.google.bigtable.admin.v2.DeleteAppProfileRequest;
import com.google.bigtable.admin.v2.DeleteClusterRequest;
import com.google.bigtable.admin.v2.DeleteInstanceRequest;
import com.google.bigtable.admin.v2.GetAppProfileRequest;
import com.google.bigtable.admin.v2.GetClusterRequest;
import com.google.bigtable.admin.v2.GetInstanceRequest;
import com.google.bigtable.admin.v2.HotTablet;
import com.google.bigtable.admin.v2.Instance;
import com.google.bigtable.admin.v2.InstanceName;
import com.google.bigtable.admin.v2.ListAppProfilesRequest;
import com.google.bigtable.admin.v2.ListAppProfilesResponse;
import com.google.bigtable.admin.v2.ListClustersRequest;
import com.google.bigtable.admin.v2.ListClustersResponse;
import com.google.bigtable.admin.v2.ListHotTabletsRequest;
import com.google.bigtable.admin.v2.ListHotTabletsResponse;
import com.google.bigtable.admin.v2.ListInstancesRequest;
import com.google.bigtable.admin.v2.ListInstancesResponse;
import com.google.bigtable.admin.v2.LocationName;
import com.google.bigtable.admin.v2.PartialUpdateClusterRequest;
import com.google.bigtable.admin.v2.PartialUpdateInstanceRequest;
import com.google.bigtable.admin.v2.ProjectName;
import com.google.bigtable.admin.v2.StorageType;
import com.google.bigtable.admin.v2.UpdateAppProfileRequest;
import com.google.cloud.bigtable.admin.v2.BaseBigtableInstanceAdminClient;
import com.google.cloud.bigtable.admin.v2.BaseBigtableInstanceAdminSettings;
import com.google.cloud.bigtable.admin.v2.MockBigtableInstanceAdmin;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Status;
import cz.o2.proxima.beam.io.pubsub.io.grpc.StatusRuntimeException;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class BaseBigtableInstanceAdminClientTest {
    private static MockBigtableInstanceAdmin mockBigtableInstanceAdmin;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private BaseBigtableInstanceAdminClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockBigtableInstanceAdmin = new MockBigtableInstanceAdmin();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockBigtableInstanceAdmin));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        BaseBigtableInstanceAdminSettings settings = ((BaseBigtableInstanceAdminSettings.Builder)((BaseBigtableInstanceAdminSettings.Builder)BaseBigtableInstanceAdminSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = BaseBigtableInstanceAdminClient.create((BaseBigtableInstanceAdminSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createInstanceTest() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]").toString()).setDisplayName("displayName1714148973").putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setSatisfiesPzs(true).build();
        Operation resultOperation = Operation.newBuilder().setName("createInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)resultOperation);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        String instanceId = "instanceId902024336";
        Instance instance = Instance.newBuilder().build();
        HashMap clusters = new HashMap();
        Instance actualResponse = (Instance)this.client.createInstanceAsync(parent, instanceId, instance, clusters).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateInstanceRequest actualRequest = (CreateInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)instanceId, (Object)actualRequest.getInstanceId());
        Assert.assertEquals((Object)instance, (Object)actualRequest.getInstance());
        Assert.assertEquals(clusters, (Object)actualRequest.getClustersMap());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createInstanceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            String instanceId = "instanceId902024336";
            Instance instance = Instance.newBuilder().build();
            HashMap clusters = new HashMap();
            this.client.createInstanceAsync(parent, instanceId, instance, clusters).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createInstanceTest2() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]").toString()).setDisplayName("displayName1714148973").putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setSatisfiesPzs(true).build();
        Operation resultOperation = Operation.newBuilder().setName("createInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        String instanceId = "instanceId902024336";
        Instance instance = Instance.newBuilder().build();
        HashMap clusters = new HashMap();
        Instance actualResponse = (Instance)this.client.createInstanceAsync(parent, instanceId, instance, clusters).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateInstanceRequest actualRequest = (CreateInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)instanceId, (Object)actualRequest.getInstanceId());
        Assert.assertEquals((Object)instance, (Object)actualRequest.getInstance());
        Assert.assertEquals(clusters, (Object)actualRequest.getClustersMap());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createInstanceExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            String instanceId = "instanceId902024336";
            Instance instance = Instance.newBuilder().build();
            HashMap clusters = new HashMap();
            this.client.createInstanceAsync(parent, instanceId, instance, clusters).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void getInstanceTest() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]").toString()).setDisplayName("displayName1714148973").putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setSatisfiesPzs(true).build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        Instance actualResponse = this.client.getInstance(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetInstanceRequest actualRequest = (GetInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getInstanceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            this.client.getInstance(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInstanceTest2() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]").toString()).setDisplayName("displayName1714148973").putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setSatisfiesPzs(true).build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Instance actualResponse = this.client.getInstance(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetInstanceRequest actualRequest = (GetInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getInstanceExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getInstance(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInstancesTest() throws Exception {
        ListInstancesResponse expectedResponse = ListInstancesResponse.newBuilder().addAllInstances(new ArrayList()).addAllFailedLocations(new ArrayList()).setNextPageToken("nextPageToken-1386094857").build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        ListInstancesResponse actualResponse = this.client.listInstances(parent);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListInstancesRequest actualRequest = (ListInstancesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listInstancesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            this.client.listInstances(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInstancesTest2() throws Exception {
        ListInstancesResponse expectedResponse = ListInstancesResponse.newBuilder().addAllInstances(new ArrayList()).addAllFailedLocations(new ArrayList()).setNextPageToken("nextPageToken-1386094857").build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        ListInstancesResponse actualResponse = this.client.listInstances(parent);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListInstancesRequest actualRequest = (ListInstancesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listInstancesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listInstances(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateInstanceTest() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]").toString()).setDisplayName("displayName1714148973").putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setSatisfiesPzs(true).build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        Instance request = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]").toString()).setDisplayName("displayName1714148973").putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setSatisfiesPzs(true).build();
        Instance actualResponse = this.client.updateInstance(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        Instance actualRequest = (Instance)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)request.getDisplayName(), (Object)actualRequest.getDisplayName());
        Assert.assertEquals((Object)request.getState(), (Object)actualRequest.getState());
        Assert.assertEquals((Object)request.getType(), (Object)actualRequest.getType());
        Assert.assertEquals((Object)request.getLabelsMap(), (Object)actualRequest.getLabelsMap());
        Assert.assertEquals((Object)request.getCreateTime(), (Object)actualRequest.getCreateTime());
        Assert.assertEquals((Object)request.getSatisfiesPzs(), (Object)actualRequest.getSatisfiesPzs());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateInstanceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            Instance request = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]").toString()).setDisplayName("displayName1714148973").putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setSatisfiesPzs(true).build();
            this.client.updateInstance(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void partialUpdateInstanceTest() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]").toString()).setDisplayName("displayName1714148973").putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setSatisfiesPzs(true).build();
        Operation resultOperation = Operation.newBuilder().setName("partialUpdateInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)resultOperation);
        Instance instance = Instance.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Instance actualResponse = (Instance)this.client.partialUpdateInstanceAsync(instance, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        PartialUpdateInstanceRequest actualRequest = (PartialUpdateInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)instance, (Object)actualRequest.getInstance());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void partialUpdateInstanceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            Instance instance = Instance.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.partialUpdateInstanceAsync(instance, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteInstanceTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        this.client.deleteInstance(name);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteInstanceRequest actualRequest = (DeleteInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteInstanceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            this.client.deleteInstance(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteInstanceTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteInstance(name);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteInstanceRequest actualRequest = (DeleteInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteInstanceExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteInstance(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createClusterTest() throws Exception {
        Cluster expectedResponse = Cluster.newBuilder().setName(ClusterName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]").toString()).setLocation(LocationName.of((String)"[PROJECT]", (String)"[LOCATION]").toString()).setServeNodes(-1288838783).setDefaultStorageType(StorageType.forNumber((int)0)).setEncryptionConfig(Cluster.EncryptionConfig.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)resultOperation);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        String clusterId = "clusterId561939637";
        Cluster cluster = Cluster.newBuilder().build();
        Cluster actualResponse = (Cluster)this.client.createClusterAsync(parent, clusterId, cluster).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateClusterRequest actualRequest = (CreateClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)clusterId, (Object)actualRequest.getClusterId());
        Assert.assertEquals((Object)cluster, (Object)actualRequest.getCluster());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createClusterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            String clusterId = "clusterId561939637";
            Cluster cluster = Cluster.newBuilder().build();
            this.client.createClusterAsync(parent, clusterId, cluster).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createClusterTest2() throws Exception {
        Cluster expectedResponse = Cluster.newBuilder().setName(ClusterName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]").toString()).setLocation(LocationName.of((String)"[PROJECT]", (String)"[LOCATION]").toString()).setServeNodes(-1288838783).setDefaultStorageType(StorageType.forNumber((int)0)).setEncryptionConfig(Cluster.EncryptionConfig.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        String clusterId = "clusterId561939637";
        Cluster cluster = Cluster.newBuilder().build();
        Cluster actualResponse = (Cluster)this.client.createClusterAsync(parent, clusterId, cluster).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateClusterRequest actualRequest = (CreateClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)clusterId, (Object)actualRequest.getClusterId());
        Assert.assertEquals((Object)cluster, (Object)actualRequest.getCluster());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createClusterExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            String clusterId = "clusterId561939637";
            Cluster cluster = Cluster.newBuilder().build();
            this.client.createClusterAsync(parent, clusterId, cluster).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void getClusterTest() throws Exception {
        Cluster expectedResponse = Cluster.newBuilder().setName(ClusterName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]").toString()).setLocation(LocationName.of((String)"[PROJECT]", (String)"[LOCATION]").toString()).setServeNodes(-1288838783).setDefaultStorageType(StorageType.forNumber((int)0)).setEncryptionConfig(Cluster.EncryptionConfig.newBuilder().build()).build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        ClusterName name = ClusterName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]");
        Cluster actualResponse = this.client.getCluster(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetClusterRequest actualRequest = (GetClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getClusterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            ClusterName name = ClusterName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]");
            this.client.getCluster(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getClusterTest2() throws Exception {
        Cluster expectedResponse = Cluster.newBuilder().setName(ClusterName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]").toString()).setLocation(LocationName.of((String)"[PROJECT]", (String)"[LOCATION]").toString()).setServeNodes(-1288838783).setDefaultStorageType(StorageType.forNumber((int)0)).setEncryptionConfig(Cluster.EncryptionConfig.newBuilder().build()).build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Cluster actualResponse = this.client.getCluster(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetClusterRequest actualRequest = (GetClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getClusterExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getCluster(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listClustersTest() throws Exception {
        ListClustersResponse expectedResponse = ListClustersResponse.newBuilder().addAllClusters(new ArrayList()).addAllFailedLocations(new ArrayList()).setNextPageToken("nextPageToken-1386094857").build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        ListClustersResponse actualResponse = this.client.listClusters(parent);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListClustersRequest actualRequest = (ListClustersRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listClustersExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            this.client.listClusters(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listClustersTest2() throws Exception {
        ListClustersResponse expectedResponse = ListClustersResponse.newBuilder().addAllClusters(new ArrayList()).addAllFailedLocations(new ArrayList()).setNextPageToken("nextPageToken-1386094857").build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        ListClustersResponse actualResponse = this.client.listClusters(parent);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListClustersRequest actualRequest = (ListClustersRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listClustersExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listClusters(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateClusterTest() throws Exception {
        Cluster expectedResponse = Cluster.newBuilder().setName(ClusterName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]").toString()).setLocation(LocationName.of((String)"[PROJECT]", (String)"[LOCATION]").toString()).setServeNodes(-1288838783).setDefaultStorageType(StorageType.forNumber((int)0)).setEncryptionConfig(Cluster.EncryptionConfig.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("updateClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)resultOperation);
        Cluster request = Cluster.newBuilder().setName(ClusterName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]").toString()).setLocation(LocationName.of((String)"[PROJECT]", (String)"[LOCATION]").toString()).setServeNodes(-1288838783).setDefaultStorageType(StorageType.forNumber((int)0)).setEncryptionConfig(Cluster.EncryptionConfig.newBuilder().build()).build();
        Cluster actualResponse = (Cluster)this.client.updateClusterAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        Cluster actualRequest = (Cluster)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)request.getLocation(), (Object)actualRequest.getLocation());
        Assert.assertEquals((Object)request.getState(), (Object)actualRequest.getState());
        Assert.assertEquals((long)request.getServeNodes(), (long)actualRequest.getServeNodes());
        Assert.assertEquals((Object)request.getClusterConfig(), (Object)actualRequest.getClusterConfig());
        Assert.assertEquals((Object)request.getDefaultStorageType(), (Object)actualRequest.getDefaultStorageType());
        Assert.assertEquals((Object)request.getEncryptionConfig(), (Object)actualRequest.getEncryptionConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateClusterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            Cluster request = Cluster.newBuilder().setName(ClusterName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]").toString()).setLocation(LocationName.of((String)"[PROJECT]", (String)"[LOCATION]").toString()).setServeNodes(-1288838783).setDefaultStorageType(StorageType.forNumber((int)0)).setEncryptionConfig(Cluster.EncryptionConfig.newBuilder().build()).build();
            this.client.updateClusterAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void partialUpdateClusterTest() throws Exception {
        Cluster expectedResponse = Cluster.newBuilder().setName(ClusterName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]").toString()).setLocation(LocationName.of((String)"[PROJECT]", (String)"[LOCATION]").toString()).setServeNodes(-1288838783).setDefaultStorageType(StorageType.forNumber((int)0)).setEncryptionConfig(Cluster.EncryptionConfig.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("partialUpdateClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)resultOperation);
        Cluster cluster = Cluster.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Cluster actualResponse = (Cluster)this.client.partialUpdateClusterAsync(cluster, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        PartialUpdateClusterRequest actualRequest = (PartialUpdateClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)cluster, (Object)actualRequest.getCluster());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void partialUpdateClusterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            Cluster cluster = Cluster.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.partialUpdateClusterAsync(cluster, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteClusterTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        ClusterName name = ClusterName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]");
        this.client.deleteCluster(name);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteClusterRequest actualRequest = (DeleteClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteClusterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            ClusterName name = ClusterName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]");
            this.client.deleteCluster(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteClusterTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteCluster(name);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteClusterRequest actualRequest = (DeleteClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteClusterExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteCluster(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createAppProfileTest() throws Exception {
        AppProfile expectedResponse = AppProfile.newBuilder().setName(AppProfileName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[APP_PROFILE]").toString()).setEtag("etag3123477").setDescription("description-1724546052").build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        String appProfileId = "appProfileId704923523";
        AppProfile appProfile = AppProfile.newBuilder().build();
        AppProfile actualResponse = this.client.createAppProfile(parent, appProfileId, appProfile);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateAppProfileRequest actualRequest = (CreateAppProfileRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)appProfileId, (Object)actualRequest.getAppProfileId());
        Assert.assertEquals((Object)appProfile, (Object)actualRequest.getAppProfile());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createAppProfileExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            String appProfileId = "appProfileId704923523";
            AppProfile appProfile = AppProfile.newBuilder().build();
            this.client.createAppProfile(parent, appProfileId, appProfile);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createAppProfileTest2() throws Exception {
        AppProfile expectedResponse = AppProfile.newBuilder().setName(AppProfileName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[APP_PROFILE]").toString()).setEtag("etag3123477").setDescription("description-1724546052").build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        String appProfileId = "appProfileId704923523";
        AppProfile appProfile = AppProfile.newBuilder().build();
        AppProfile actualResponse = this.client.createAppProfile(parent, appProfileId, appProfile);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateAppProfileRequest actualRequest = (CreateAppProfileRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)appProfileId, (Object)actualRequest.getAppProfileId());
        Assert.assertEquals((Object)appProfile, (Object)actualRequest.getAppProfile());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createAppProfileExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            String appProfileId = "appProfileId704923523";
            AppProfile appProfile = AppProfile.newBuilder().build();
            this.client.createAppProfile(parent, appProfileId, appProfile);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getAppProfileTest() throws Exception {
        AppProfile expectedResponse = AppProfile.newBuilder().setName(AppProfileName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[APP_PROFILE]").toString()).setEtag("etag3123477").setDescription("description-1724546052").build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        AppProfileName name = AppProfileName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[APP_PROFILE]");
        AppProfile actualResponse = this.client.getAppProfile(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetAppProfileRequest actualRequest = (GetAppProfileRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getAppProfileExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            AppProfileName name = AppProfileName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[APP_PROFILE]");
            this.client.getAppProfile(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getAppProfileTest2() throws Exception {
        AppProfile expectedResponse = AppProfile.newBuilder().setName(AppProfileName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[APP_PROFILE]").toString()).setEtag("etag3123477").setDescription("description-1724546052").build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        AppProfile actualResponse = this.client.getAppProfile(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetAppProfileRequest actualRequest = (GetAppProfileRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getAppProfileExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getAppProfile(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAppProfilesTest() throws Exception {
        AppProfile responsesElement = AppProfile.newBuilder().build();
        ListAppProfilesResponse expectedResponse = ListAppProfilesResponse.newBuilder().setNextPageToken("").addAllAppProfiles(Arrays.asList(responsesElement)).build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        BaseBigtableInstanceAdminClient.ListAppProfilesPagedResponse pagedListResponse = this.client.listAppProfiles(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getAppProfilesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListAppProfilesRequest actualRequest = (ListAppProfilesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listAppProfilesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            this.client.listAppProfiles(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAppProfilesTest2() throws Exception {
        AppProfile responsesElement = AppProfile.newBuilder().build();
        ListAppProfilesResponse expectedResponse = ListAppProfilesResponse.newBuilder().setNextPageToken("").addAllAppProfiles(Arrays.asList(responsesElement)).build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        BaseBigtableInstanceAdminClient.ListAppProfilesPagedResponse pagedListResponse = this.client.listAppProfiles(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getAppProfilesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListAppProfilesRequest actualRequest = (ListAppProfilesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listAppProfilesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listAppProfiles(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateAppProfileTest() throws Exception {
        AppProfile expectedResponse = AppProfile.newBuilder().setName(AppProfileName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[APP_PROFILE]").toString()).setEtag("etag3123477").setDescription("description-1724546052").build();
        Operation resultOperation = Operation.newBuilder().setName("updateAppProfileTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)resultOperation);
        AppProfile appProfile = AppProfile.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        AppProfile actualResponse = (AppProfile)this.client.updateAppProfileAsync(appProfile, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateAppProfileRequest actualRequest = (UpdateAppProfileRequest)actualRequests.get(0);
        Assert.assertEquals((Object)appProfile, (Object)actualRequest.getAppProfile());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateAppProfileExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            AppProfile appProfile = AppProfile.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateAppProfileAsync(appProfile, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteAppProfileTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        AppProfileName name = AppProfileName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[APP_PROFILE]");
        this.client.deleteAppProfile(name);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteAppProfileRequest actualRequest = (DeleteAppProfileRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteAppProfileExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            AppProfileName name = AppProfileName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[APP_PROFILE]");
            this.client.deleteAppProfile(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteAppProfileTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteAppProfile(name);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteAppProfileRequest actualRequest = (DeleteAppProfileRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteAppProfileExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteAppProfile(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        InstanceName resource = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        Policy actualResponse = this.client.getIamPolicy((ResourceName)resource);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetIamPolicyRequest actualRequest = (GetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource.toString(), (Object)actualRequest.getResource());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            InstanceName resource = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            this.client.getIamPolicy((ResourceName)resource);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest2() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String resource = "resource-341064690";
        Policy actualResponse = this.client.getIamPolicy(resource);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetIamPolicyRequest actualRequest = (GetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource, (Object)actualRequest.getResource());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getIamPolicyExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            String resource = "resource-341064690";
            this.client.getIamPolicy(resource);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        InstanceName resource = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        Policy policy = Policy.newBuilder().build();
        Policy actualResponse = this.client.setIamPolicy((ResourceName)resource, policy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetIamPolicyRequest actualRequest = (SetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource.toString(), (Object)actualRequest.getResource());
        Assert.assertEquals((Object)policy, (Object)actualRequest.getPolicy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            InstanceName resource = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            Policy policy = Policy.newBuilder().build();
            this.client.setIamPolicy((ResourceName)resource, policy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest2() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String resource = "resource-341064690";
        Policy policy = Policy.newBuilder().build();
        Policy actualResponse = this.client.setIamPolicy(resource, policy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetIamPolicyRequest actualRequest = (SetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource, (Object)actualRequest.getResource());
        Assert.assertEquals((Object)policy, (Object)actualRequest.getPolicy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setIamPolicyExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            String resource = "resource-341064690";
            Policy policy = Policy.newBuilder().build();
            this.client.setIamPolicy(resource, policy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        InstanceName resource = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        ArrayList permissions = new ArrayList();
        TestIamPermissionsResponse actualResponse = this.client.testIamPermissions((ResourceName)resource, permissions);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TestIamPermissionsRequest actualRequest = (TestIamPermissionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource.toString(), (Object)actualRequest.getResource());
        Assert.assertEquals(permissions, (Object)actualRequest.getPermissionsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void testIamPermissionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            InstanceName resource = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            ArrayList permissions = new ArrayList();
            this.client.testIamPermissions((ResourceName)resource, permissions);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest2() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String resource = "resource-341064690";
        ArrayList permissions = new ArrayList();
        TestIamPermissionsResponse actualResponse = this.client.testIamPermissions(resource, permissions);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TestIamPermissionsRequest actualRequest = (TestIamPermissionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource, (Object)actualRequest.getResource());
        Assert.assertEquals(permissions, (Object)actualRequest.getPermissionsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void testIamPermissionsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            String resource = "resource-341064690";
            ArrayList permissions = new ArrayList();
            this.client.testIamPermissions(resource, permissions);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listHotTabletsTest() throws Exception {
        HotTablet responsesElement = HotTablet.newBuilder().build();
        ListHotTabletsResponse expectedResponse = ListHotTabletsResponse.newBuilder().setNextPageToken("").addAllHotTablets(Arrays.asList(responsesElement)).build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]");
        BaseBigtableInstanceAdminClient.ListHotTabletsPagedResponse pagedListResponse = this.client.listHotTablets(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getHotTabletsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListHotTabletsRequest actualRequest = (ListHotTabletsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listHotTabletsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]");
            this.client.listHotTablets(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listHotTabletsTest2() throws Exception {
        HotTablet responsesElement = HotTablet.newBuilder().build();
        ListHotTabletsResponse expectedResponse = ListHotTabletsResponse.newBuilder().setNextPageToken("").addAllHotTablets(Arrays.asList(responsesElement)).build();
        mockBigtableInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        BaseBigtableInstanceAdminClient.ListHotTabletsPagedResponse pagedListResponse = this.client.listHotTablets(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getHotTabletsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockBigtableInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListHotTabletsRequest actualRequest = (ListHotTabletsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listHotTabletsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableInstanceAdmin.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listHotTablets(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

