/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.bigtable.admin.v2.BigtableInstanceAdminSettings;
import com.google.cloud.bigtable.admin.v2.stub.BigtableInstanceAdminStubSettings;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.IOException;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class BigtableInstanceAdminSettingsTest {
    static final String[] SETTINGS_LIST = new String[]{"createInstanceSettings", "createInstanceOperationSettings", "getInstanceSettings", "listInstancesSettings", "partialUpdateInstanceSettings", "partialUpdateInstanceOperationSettings", "deleteInstanceSettings", "createClusterSettings", "createClusterOperationSettings", "getClusterSettings", "listClustersSettings", "updateClusterSettings", "updateClusterOperationSettings", "deleteClusterSettings", "createAppProfileSettings", "getAppProfileSettings", "listAppProfilesSettings", "updateAppProfileSettings", "updateAppProfileOperationSettings", "deleteAppProfileSettings", "getIamPolicySettings", "setIamPolicySettings", "testIamPermissionsSettings"};

    @Test
    public void testProjectName() throws Exception {
        String projectId = "my-project";
        BigtableInstanceAdminSettings.Builder builder = BigtableInstanceAdminSettings.newBuilder().setProjectId(projectId);
        Truth.assertThat((String)builder.getProjectId()).isEqualTo((Object)projectId);
        Truth.assertThat((String)builder.build().getProjectId()).isEqualTo((Object)projectId);
        Truth.assertThat((String)builder.build().toBuilder().getProjectId()).isEqualTo((Object)projectId);
    }

    @Test
    public void testMissingProjectName() {
        Exception actualException = null;
        BigtableInstanceAdminSettings.Builder settingsBuilder = BigtableInstanceAdminSettings.newBuilder();
        Truth.assertThat((String)settingsBuilder.getProjectId()).isNull();
        try {
            settingsBuilder.build();
        }
        catch (Exception e) {
            actualException = e;
        }
        Truth.assertThat((Throwable)actualException).isInstanceOf(NullPointerException.class);
    }

    @Test
    public void testCredentials() throws IOException {
        CredentialsProvider credentialsProvider = (CredentialsProvider)Mockito.mock(CredentialsProvider.class);
        BigtableInstanceAdminSettings settings = BigtableInstanceAdminSettings.newBuilder().setProjectId("my-project").setCredentialsProvider(credentialsProvider).build();
        Truth.assertThat((Object)settings.getCredentialsProvider()).isSameInstanceAs((Object)credentialsProvider);
        Truth.assertThat((Object)settings.getStubSettings().getCredentialsProvider()).isSameInstanceAs((Object)credentialsProvider);
        Truth.assertThat((Object)settings.toBuilder().getCredentialsProvider()).isSameInstanceAs((Object)credentialsProvider);
        Truth.assertThat((Object)settings.toBuilder().build().getCredentialsProvider()).isSameInstanceAs((Object)credentialsProvider);
    }

    @Test
    public void testStubSettings() throws IOException {
        String projectId = "my-project";
        BigtableInstanceAdminSettings.Builder builder = BigtableInstanceAdminSettings.newBuilder().setProjectId(projectId);
        builder.stubSettings().createInstanceSettings().setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.INVALID_ARGUMENT});
        Truth.assertThat((Iterable)builder.build().getStubSettings().createInstanceSettings().getRetryableCodes()).containsExactly(new Object[]{StatusCode.Code.INVALID_ARGUMENT});
        Truth.assertThat((Iterable)builder.build().toBuilder().build().getStubSettings().createInstanceSettings().getRetryableCodes()).containsExactly(new Object[]{StatusCode.Code.INVALID_ARGUMENT});
    }

    @Test
    public void testToString() throws IOException {
        BigtableInstanceAdminSettings defaultSettings = BigtableInstanceAdminSettings.newBuilder().setProjectId("our-project-212").build();
        this.checkToString(defaultSettings);
        BigtableInstanceAdminSettings.Builder builder = defaultSettings.toBuilder();
        BigtableInstanceAdminStubSettings.Builder stubSettings = (BigtableInstanceAdminStubSettings.Builder)builder.stubSettings().setEndpoint("example.com:1234");
        stubSettings.getInstanceSettings().setRetrySettings(RetrySettings.newBuilder().setTotalTimeout(Duration.ofMinutes((long)812L)).build());
        BigtableInstanceAdminSettings settings = builder.build();
        this.checkToString(settings);
        Truth.assertThat((String)settings.toString()).contains((CharSequence)"endpoint=example.com:1234");
        Truth.assertThat((String)settings.toString()).contains((CharSequence)"totalTimeout=PT13H32M");
    }

    void checkToString(BigtableInstanceAdminSettings settings) {
        String projectId = settings.getProjectId();
        String toString = settings.toString();
        Truth.assertThat((String)toString).isEqualTo((Object)settings.toString());
        Truth.assertThat((String)toString).startsWith("BigtableInstanceAdminSettings{projectId=" + projectId);
        for (String subSettings : SETTINGS_LIST) {
            Truth.assertThat((String)toString).contains((CharSequence)(subSettings + "="));
        }
        Truth.assertThat((Boolean)toString.contains(settings.getStubSettings().toString()));
    }
}

