/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2;

import com.google.api.core.ApiFutures;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.longrunning.OperationFutures;
import com.google.api.gax.longrunning.OperationSnapshot;
import com.google.api.gax.rpc.NotFoundException;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.rpc.testing.FakeOperationSnapshot;
import com.google.bigtable.admin.v2.Backup;
import com.google.bigtable.admin.v2.BackupInfo;
import com.google.bigtable.admin.v2.ColumnFamily;
import com.google.bigtable.admin.v2.CreateBackupMetadata;
import com.google.bigtable.admin.v2.DeleteBackupRequest;
import com.google.bigtable.admin.v2.DeleteTableRequest;
import com.google.bigtable.admin.v2.DropRowRangeRequest;
import com.google.bigtable.admin.v2.EncryptionInfo;
import com.google.bigtable.admin.v2.GcRule;
import com.google.bigtable.admin.v2.GetBackupRequest;
import com.google.bigtable.admin.v2.GetTableRequest;
import com.google.bigtable.admin.v2.ListBackupsRequest;
import com.google.bigtable.admin.v2.ListTablesRequest;
import com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest;
import com.google.bigtable.admin.v2.RestoreSourceType;
import com.google.bigtable.admin.v2.RestoreTableMetadata;
import com.google.bigtable.admin.v2.Table;
import com.google.bigtable.admin.v2.TableName;
import com.google.cloud.Identity;
import com.google.cloud.Policy;
import com.google.cloud.Role;
import com.google.cloud.bigtable.admin.v2.BaseBigtableTableAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminClient;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.cloud.bigtable.admin.v2.models.Backup;
import com.google.cloud.bigtable.admin.v2.models.CreateBackupRequest;
import com.google.cloud.bigtable.admin.v2.models.CreateTableRequest;
import com.google.cloud.bigtable.admin.v2.models.EncryptionInfo;
import com.google.cloud.bigtable.admin.v2.models.ModifyColumnFamiliesRequest;
import com.google.cloud.bigtable.admin.v2.models.RestoreTableRequest;
import com.google.cloud.bigtable.admin.v2.models.RestoredTableResult;
import com.google.cloud.bigtable.admin.v2.models.Table;
import com.google.cloud.bigtable.admin.v2.models.UpdateBackupRequest;
import com.google.cloud.bigtable.admin.v2.stub.EnhancedBigtableTableAdminStub;
import com.google.iam.v1.Binding;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import com.google.rpc.Status;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Status;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableList;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Lists;
import cz.o2.proxima.internal.shaded.com.google.common.io.BaseEncoding;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;
import org.threeten.bp.Instant;

@RunWith(value=JUnit4.class)
public class BigtableTableAdminClientTests {
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule();
    private static final String PROJECT_ID = "my-project";
    private static final String INSTANCE_ID = "my-instance";
    private static final String TABLE_ID = "my-table";
    private static final String CLUSTER_ID = "my-cluster";
    private static final String BACKUP_ID = "my-backup";
    private static final String INSTANCE_NAME = NameUtil.formatInstanceName((String)"my-project", (String)"my-instance");
    private static final String TABLE_NAME = NameUtil.formatTableName((String)"my-project", (String)"my-instance", (String)"my-table");
    private BigtableTableAdminClient adminClient;
    @Mock
    private EnhancedBigtableTableAdminStub mockStub;
    @Mock
    private UnaryCallable<com.google.bigtable.admin.v2.CreateTableRequest, com.google.bigtable.admin.v2.Table> mockCreateTableCallable;
    @Mock
    private UnaryCallable<com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest, com.google.bigtable.admin.v2.Table> mockModifyTableCallable;
    @Mock
    private UnaryCallable<DeleteTableRequest, Empty> mockDeleteTableCallable;
    @Mock
    private UnaryCallable<GetTableRequest, com.google.bigtable.admin.v2.Table> mockGetTableCallable;
    @Mock
    private UnaryCallable<ListTablesRequest, BaseBigtableTableAdminClient.ListTablesPagedResponse> mockListTableCallable;
    @Mock
    private UnaryCallable<DropRowRangeRequest, Empty> mockDropRowRangeCallable;
    @Mock
    private UnaryCallable<TableName, Void> mockAwaitReplicationCallable;
    @Mock
    private OperationCallable<com.google.bigtable.admin.v2.CreateBackupRequest, com.google.bigtable.admin.v2.Backup, CreateBackupMetadata> mockCreateBackupOperationCallable;
    @Mock
    private UnaryCallable<GetBackupRequest, com.google.bigtable.admin.v2.Backup> mockGetBackupCallable;
    @Mock
    private UnaryCallable<com.google.bigtable.admin.v2.UpdateBackupRequest, com.google.bigtable.admin.v2.Backup> mockUpdateBackupCallable;
    @Mock
    private UnaryCallable<ListBackupsRequest, BaseBigtableTableAdminClient.ListBackupsPagedResponse> mockListBackupCallable;
    @Mock
    private UnaryCallable<DeleteBackupRequest, Empty> mockDeleteBackupCallable;
    @Mock
    private UnaryCallable<com.google.bigtable.admin.v2.RestoreTableRequest, Operation> mockRestoreTableCallable;
    @Mock
    private OperationCallable<com.google.bigtable.admin.v2.RestoreTableRequest, com.google.bigtable.admin.v2.Table, RestoreTableMetadata> mockRestoreTableOperationCallable;
    @Mock
    private UnaryCallable<GetIamPolicyRequest, com.google.iam.v1.Policy> mockGetIamPolicyCallable;
    @Mock
    private UnaryCallable<SetIamPolicyRequest, com.google.iam.v1.Policy> mockSetIamPolicyCallable;
    @Mock
    private UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> mockTestIamPermissionsCallable;

    @Before
    public void setUp() {
        this.adminClient = BigtableTableAdminClient.create((String)PROJECT_ID, (String)INSTANCE_ID, (EnhancedBigtableTableAdminStub)this.mockStub);
    }

    @Test
    public void testCreateTable() {
        Mockito.when((Object)this.mockStub.createTableCallable()).thenReturn(this.mockCreateTableCallable);
        com.google.bigtable.admin.v2.CreateTableRequest expectedRequest = com.google.bigtable.admin.v2.CreateTableRequest.newBuilder().setParent(INSTANCE_NAME).setTableId(TABLE_ID).build();
        com.google.bigtable.admin.v2.Table expectedResponse = com.google.bigtable.admin.v2.Table.newBuilder().setName(TABLE_NAME).build();
        Mockito.when((Object)this.mockCreateTableCallable.futureCall((Object)expectedRequest)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse));
        Table result = this.adminClient.createTable(CreateTableRequest.of((String)TABLE_ID));
        Truth.assertThat((Object)result).isEqualTo((Object)Table.fromProto((com.google.bigtable.admin.v2.Table)expectedResponse));
    }

    @Test
    public void testModifyFamilies() {
        Mockito.when((Object)this.mockStub.modifyColumnFamiliesCallable()).thenReturn(this.mockModifyTableCallable);
        com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest expectedRequest = com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.newBuilder().setName(TABLE_NAME).addModifications(ModifyColumnFamiliesRequest.Modification.newBuilder().setId("cf").setCreate(ColumnFamily.newBuilder().setGcRule(GcRule.getDefaultInstance()))).build();
        com.google.bigtable.admin.v2.Table fakeResponse = com.google.bigtable.admin.v2.Table.newBuilder().setName(TABLE_NAME).putColumnFamilies("cf", ColumnFamily.newBuilder().setGcRule(GcRule.getDefaultInstance()).build()).build();
        Mockito.when((Object)this.mockModifyTableCallable.futureCall((Object)expectedRequest)).thenReturn((Object)ApiFutures.immediateFuture((Object)fakeResponse));
        Table actualResult = this.adminClient.modifyFamilies(ModifyColumnFamiliesRequest.of((String)TABLE_ID).addFamily("cf"));
        Truth.assertThat((Object)actualResult).isEqualTo((Object)Table.fromProto((com.google.bigtable.admin.v2.Table)fakeResponse));
    }

    @Test
    public void testDeleteTable() {
        Mockito.when((Object)this.mockStub.deleteTableCallable()).thenReturn(this.mockDeleteTableCallable);
        DeleteTableRequest expectedRequest = DeleteTableRequest.newBuilder().setName(TABLE_NAME).build();
        AtomicBoolean wasCalled = new AtomicBoolean(false);
        Mockito.when((Object)this.mockDeleteTableCallable.futureCall((Object)expectedRequest)).thenAnswer(invocationOnMock -> {
            wasCalled.set(true);
            return ApiFutures.immediateFuture((Object)Empty.getDefaultInstance());
        });
        this.adminClient.deleteTable(TABLE_ID);
        Truth.assertThat((Boolean)wasCalled.get()).isTrue();
    }

    @Test
    public void testGetTable() {
        Mockito.when((Object)this.mockStub.getTableCallable()).thenReturn(this.mockGetTableCallable);
        GetTableRequest expectedRequest = GetTableRequest.newBuilder().setName(TABLE_NAME).setView(Table.View.SCHEMA_VIEW).build();
        com.google.bigtable.admin.v2.Table expectedResponse = com.google.bigtable.admin.v2.Table.newBuilder().setName(TABLE_NAME).build();
        Mockito.when((Object)this.mockGetTableCallable.futureCall((Object)expectedRequest)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse));
        Table actualResult = this.adminClient.getTable(TABLE_ID);
        Truth.assertThat((Object)actualResult).isEqualTo((Object)Table.fromProto((com.google.bigtable.admin.v2.Table)expectedResponse));
    }

    @Test
    public void testGetEncryptionInfos() {
        Mockito.when((Object)this.mockStub.getTableCallable()).thenReturn(this.mockGetTableCallable);
        GetTableRequest expectedRequest = GetTableRequest.newBuilder().setName(TABLE_NAME).setView(Table.View.ENCRYPTION_VIEW).build();
        com.google.bigtable.admin.v2.EncryptionInfo expectedEncryptionInfo = com.google.bigtable.admin.v2.EncryptionInfo.newBuilder().setKmsKeyVersion("some key").setEncryptionType(EncryptionInfo.EncryptionType.CUSTOMER_MANAGED_ENCRYPTION).setEncryptionStatus(Status.newBuilder().setCode(Status.Code.FAILED_PRECONDITION.value()).setMessage("something failed")).build();
        com.google.bigtable.admin.v2.Table expectedResponse = com.google.bigtable.admin.v2.Table.newBuilder().setName(TABLE_NAME).putClusterStates("cluster1", Table.ClusterState.newBuilder().addEncryptionInfo(expectedEncryptionInfo).build()).build();
        Mockito.when((Object)this.mockGetTableCallable.futureCall((Object)expectedRequest)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse));
        Map actualResult = this.adminClient.getEncryptionInfo(TABLE_ID);
        Truth.assertThat((Map)actualResult).containsExactly((Object)"cluster1", (Object)ImmutableList.of((Object)EncryptionInfo.fromProto((com.google.bigtable.admin.v2.EncryptionInfo)expectedEncryptionInfo)), new Object[0]);
    }

    @Test
    public void testListTables() {
        Mockito.when((Object)this.mockStub.listTablesPagedCallable()).thenReturn(this.mockListTableCallable);
        ListTablesRequest expectedRequest = ListTablesRequest.newBuilder().setParent(INSTANCE_NAME).build();
        ArrayList expectedProtos = Lists.newArrayList();
        for (int i = 0; i < 3; ++i) {
            expectedProtos.add(com.google.bigtable.admin.v2.Table.newBuilder().setName(TABLE_NAME + i).build());
        }
        BaseBigtableTableAdminClient.ListTablesPage page0 = (BaseBigtableTableAdminClient.ListTablesPage)Mockito.mock(BaseBigtableTableAdminClient.ListTablesPage.class);
        Mockito.when((Object)page0.getValues()).thenReturn(expectedProtos.subList(0, 2));
        Mockito.when((Object)page0.hasNextPage()).thenReturn((Object)true);
        BaseBigtableTableAdminClient.ListTablesPage page1 = (BaseBigtableTableAdminClient.ListTablesPage)Mockito.mock(BaseBigtableTableAdminClient.ListTablesPage.class);
        Mockito.when((Object)page1.getValues()).thenReturn(expectedProtos.subList(2, 3));
        Mockito.when((Object)page0.getNextPageAsync()).thenReturn((Object)ApiFutures.immediateFuture((Object)page1));
        BaseBigtableTableAdminClient.ListTablesPagedResponse response0 = (BaseBigtableTableAdminClient.ListTablesPagedResponse)Mockito.mock(BaseBigtableTableAdminClient.ListTablesPagedResponse.class);
        Mockito.when((Object)response0.getPage()).thenReturn((Object)page0);
        Mockito.when((Object)this.mockListTableCallable.futureCall((Object)expectedRequest)).thenReturn((Object)ApiFutures.immediateFuture((Object)response0));
        List actualResults = this.adminClient.listTables();
        ArrayList expectedResults = Lists.newArrayList();
        for (com.google.bigtable.admin.v2.Table expectedProto : expectedProtos) {
            expectedResults.add(TableName.parse((String)expectedProto.getName()).getTable());
        }
        Truth.assertThat((Iterable)actualResults).containsExactlyElementsIn((Iterable)expectedResults);
    }

    @Test
    public void testDropRowRange() {
        Mockito.when((Object)this.mockStub.dropRowRangeCallable()).thenReturn(this.mockDropRowRangeCallable);
        DropRowRangeRequest expectedRequest = DropRowRangeRequest.newBuilder().setName(TABLE_NAME).setRowKeyPrefix(ByteString.copyFromUtf8((String)"rowKeyPrefix")).build();
        Empty expectedResponse = Empty.getDefaultInstance();
        AtomicBoolean wasCalled = new AtomicBoolean(false);
        Mockito.when((Object)this.mockDropRowRangeCallable.futureCall((Object)expectedRequest)).thenAnswer(invocationOnMock -> {
            wasCalled.set(true);
            return ApiFutures.immediateFuture((Object)expectedResponse);
        });
        this.adminClient.dropRowRange(TABLE_ID, "rowKeyPrefix");
        Truth.assertThat((Boolean)wasCalled.get()).isTrue();
    }

    @Test
    public void testAwaitReplication() {
        Mockito.when((Object)this.mockStub.awaitReplicationCallable()).thenReturn(this.mockAwaitReplicationCallable);
        TableName expectedRequest = TableName.parse((String)TABLE_NAME);
        AtomicBoolean wasCalled = new AtomicBoolean(false);
        Mockito.when((Object)this.mockAwaitReplicationCallable.futureCall((Object)expectedRequest)).thenAnswer(invocationOnMock -> {
            wasCalled.set(true);
            return ApiFutures.immediateFuture(null);
        });
        this.adminClient.awaitReplication(TABLE_ID);
        Truth.assertThat((Boolean)wasCalled.get()).isTrue();
    }

    @Test
    public void testExistsTrue() {
        Mockito.when((Object)this.mockStub.getTableCallable()).thenReturn(this.mockGetTableCallable);
        com.google.bigtable.admin.v2.Table expectedResponse = com.google.bigtable.admin.v2.Table.newBuilder().setName(TABLE_NAME).build();
        Mockito.when((Object)this.mockGetTableCallable.futureCall(ArgumentMatchers.any(GetTableRequest.class))).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse));
        boolean found = this.adminClient.exists(TABLE_ID);
        Truth.assertThat((Boolean)found).isTrue();
    }

    @Test
    public void testExistsFalse() {
        Mockito.when((Object)this.mockStub.getTableCallable()).thenReturn(this.mockGetTableCallable);
        NotFoundException exception = new NotFoundException("fake error", null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.NOT_FOUND), false);
        Mockito.when((Object)this.mockGetTableCallable.futureCall(ArgumentMatchers.any(GetTableRequest.class))).thenReturn((Object)ApiFutures.immediateFailedFuture((Throwable)exception));
        boolean found = this.adminClient.exists(TABLE_ID);
        Truth.assertThat((Boolean)found).isFalse();
    }

    @Test
    public void testCreateBackup() {
        Mockito.when((Object)this.mockStub.createBackupOperationCallable()).thenReturn(this.mockCreateBackupOperationCallable);
        String backupName = NameUtil.formatBackupName((String)PROJECT_ID, (String)INSTANCE_ID, (String)CLUSTER_ID, (String)BACKUP_ID);
        Timestamp startTime = Timestamp.newBuilder().setSeconds(123L).build();
        Timestamp endTime = Timestamp.newBuilder().setSeconds(456L).build();
        Timestamp expireTime = Timestamp.newBuilder().setSeconds(789L).build();
        long sizeBytes = 123456789L;
        CreateBackupRequest req = CreateBackupRequest.of((String)CLUSTER_ID, (String)BACKUP_ID).setSourceTableId(TABLE_ID);
        this.mockOperationResult(this.mockCreateBackupOperationCallable, req.toProto(PROJECT_ID, INSTANCE_ID), com.google.bigtable.admin.v2.Backup.newBuilder().setName(backupName).setSourceTable(TABLE_NAME).setStartTime(startTime).setEndTime(endTime).setExpireTime(expireTime).setSizeBytes(sizeBytes).build(), CreateBackupMetadata.newBuilder().setName(backupName).setStartTime(startTime).setEndTime(endTime).setSourceTable(TABLE_NAME).build());
        Backup actualResult = this.adminClient.createBackup(req);
        Truth.assertThat((String)actualResult.getId()).isEqualTo((Object)BACKUP_ID);
        Truth.assertThat((String)actualResult.getSourceTableId()).isEqualTo((Object)TABLE_ID);
        Truth.assertThat((Comparable)actualResult.getStartTime()).isEqualTo((Object)Instant.ofEpochMilli((long)Timestamps.toMillis((Timestamp)startTime)));
        Truth.assertThat((Comparable)actualResult.getEndTime()).isEqualTo((Object)Instant.ofEpochMilli((long)Timestamps.toMillis((Timestamp)endTime)));
        Truth.assertThat((Comparable)actualResult.getExpireTime()).isEqualTo((Object)Instant.ofEpochMilli((long)Timestamps.toMillis((Timestamp)expireTime)));
        Truth.assertThat((Long)actualResult.getSizeBytes()).isEqualTo((Object)sizeBytes);
    }

    @Test
    public void testGetBackup() {
        Mockito.when((Object)this.mockStub.getBackupCallable()).thenReturn(this.mockGetBackupCallable);
        Timestamp expireTime = Timestamp.newBuilder().setSeconds(123456789L).build();
        Timestamp startTime = Timestamp.newBuilder().setSeconds(1234L).build();
        Timestamp endTime = Timestamp.newBuilder().setSeconds(5678L).build();
        Backup.State state = Backup.State.CREATING;
        long sizeBytes = 12345L;
        GetBackupRequest testRequest = GetBackupRequest.newBuilder().setName(NameUtil.formatBackupName((String)PROJECT_ID, (String)INSTANCE_ID, (String)CLUSTER_ID, (String)BACKUP_ID)).build();
        Mockito.when((Object)this.mockGetBackupCallable.futureCall((Object)testRequest)).thenReturn((Object)ApiFutures.immediateFuture((Object)com.google.bigtable.admin.v2.Backup.newBuilder().setName(NameUtil.formatBackupName((String)PROJECT_ID, (String)INSTANCE_ID, (String)CLUSTER_ID, (String)BACKUP_ID)).setSourceTable(NameUtil.formatTableName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID)).setExpireTime(expireTime).setStartTime(startTime).setEndTime(endTime).setSizeBytes(sizeBytes).setState(state).build()));
        Backup actualResult = this.adminClient.getBackup(CLUSTER_ID, BACKUP_ID);
        Truth.assertThat((String)actualResult.getId()).isEqualTo((Object)BACKUP_ID);
        Truth.assertThat((String)actualResult.getSourceTableId()).isEqualTo((Object)TABLE_ID);
        Truth.assertThat((Comparable)actualResult.getExpireTime()).isEqualTo((Object)Instant.ofEpochMilli((long)Timestamps.toMillis((Timestamp)expireTime)));
        Truth.assertThat((Comparable)actualResult.getStartTime()).isEqualTo((Object)Instant.ofEpochMilli((long)Timestamps.toMillis((Timestamp)startTime)));
        Truth.assertThat((Comparable)actualResult.getEndTime()).isEqualTo((Object)Instant.ofEpochMilli((long)Timestamps.toMillis((Timestamp)endTime)));
        Truth.assertThat((Long)actualResult.getSizeBytes()).isEqualTo((Object)sizeBytes);
        Truth.assertThat((Comparable)actualResult.getState()).isEqualTo((Object)Backup.State.fromProto((Backup.State)state));
    }

    @Test
    public void testUpdateBackup() {
        Mockito.when((Object)this.mockStub.updateBackupCallable()).thenReturn(this.mockUpdateBackupCallable);
        Timestamp expireTime = Timestamp.newBuilder().setSeconds(123456789L).build();
        long sizeBytes = 12345L;
        UpdateBackupRequest req = UpdateBackupRequest.of((String)CLUSTER_ID, (String)BACKUP_ID);
        Mockito.when((Object)this.mockUpdateBackupCallable.futureCall((Object)req.toProto(PROJECT_ID, INSTANCE_ID))).thenReturn((Object)ApiFutures.immediateFuture((Object)com.google.bigtable.admin.v2.Backup.newBuilder().setName(NameUtil.formatBackupName((String)PROJECT_ID, (String)INSTANCE_ID, (String)CLUSTER_ID, (String)BACKUP_ID)).setSourceTable(NameUtil.formatTableName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID)).setExpireTime(expireTime).setSizeBytes(sizeBytes).build()));
        Backup actualResult = this.adminClient.updateBackup(req);
        Truth.assertThat((String)actualResult.getId()).isEqualTo((Object)BACKUP_ID);
        Truth.assertThat((String)actualResult.getSourceTableId()).isEqualTo((Object)TABLE_ID);
        Truth.assertThat((Comparable)actualResult.getExpireTime()).isEqualTo((Object)Instant.ofEpochMilli((long)Timestamps.toMillis((Timestamp)expireTime)));
        Truth.assertThat((Long)actualResult.getSizeBytes()).isEqualTo((Object)sizeBytes);
    }

    @Test
    public void testRestoreTable() throws ExecutionException, InterruptedException {
        Mockito.when((Object)this.mockStub.restoreTableOperationCallable()).thenReturn(this.mockRestoreTableOperationCallable);
        Timestamp startTime = Timestamp.newBuilder().setSeconds(1234L).build();
        Timestamp endTime = Timestamp.newBuilder().setSeconds(5678L).build();
        String operationName = "my-operation";
        RestoreTableRequest req = RestoreTableRequest.of((String)CLUSTER_ID, (String)BACKUP_ID).setTableId(TABLE_ID);
        this.mockOperationResult(this.mockRestoreTableOperationCallable, req.toProto(PROJECT_ID, INSTANCE_ID), com.google.bigtable.admin.v2.Table.newBuilder().setName(TABLE_NAME).build(), RestoreTableMetadata.newBuilder().setName(NameUtil.formatTableName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID)).setOptimizeTableOperationName(operationName).setSourceType(RestoreSourceType.BACKUP).setBackupInfo(BackupInfo.newBuilder().setBackup(BACKUP_ID).setSourceTable(NameUtil.formatTableName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID)).setStartTime(startTime).setEndTime(endTime).build()).build());
        RestoredTableResult actualResult = this.adminClient.restoreTable(req);
        Truth.assertThat((String)actualResult.getTable().getId()).isEqualTo((Object)TABLE_ID);
    }

    @Test
    public void testDeleteBackup() {
        Mockito.when((Object)this.mockStub.deleteBackupCallable()).thenReturn(this.mockDeleteBackupCallable);
        DeleteBackupRequest testRequest = DeleteBackupRequest.newBuilder().setName(NameUtil.formatBackupName((String)PROJECT_ID, (String)INSTANCE_ID, (String)CLUSTER_ID, (String)BACKUP_ID)).build();
        Mockito.when((Object)this.mockDeleteBackupCallable.futureCall((Object)testRequest)).thenReturn((Object)ApiFutures.immediateFuture((Object)Empty.getDefaultInstance()));
        this.adminClient.deleteBackup(CLUSTER_ID, BACKUP_ID);
        ((UnaryCallable)Mockito.verify(this.mockDeleteBackupCallable, (VerificationMode)Mockito.times((int)1))).futureCall((Object)testRequest);
    }

    @Test
    public void testListBackups() {
        Mockito.when((Object)this.mockStub.listBackupsPagedCallable()).thenReturn(this.mockListBackupCallable);
        ListBackupsRequest testRequest = ListBackupsRequest.newBuilder().setParent(NameUtil.formatClusterName((String)PROJECT_ID, (String)INSTANCE_ID, (String)CLUSTER_ID)).build();
        ArrayList expectedProtos = Lists.newArrayList();
        for (int i = 0; i < 3; ++i) {
            expectedProtos.add(com.google.bigtable.admin.v2.Backup.newBuilder().setName(NameUtil.formatBackupName((String)PROJECT_ID, (String)INSTANCE_ID, (String)CLUSTER_ID, (String)(BACKUP_ID + i))).build());
        }
        BaseBigtableTableAdminClient.ListBackupsPage page0 = (BaseBigtableTableAdminClient.ListBackupsPage)Mockito.mock(BaseBigtableTableAdminClient.ListBackupsPage.class);
        Mockito.when((Object)page0.getValues()).thenReturn(expectedProtos.subList(0, 2));
        Mockito.when((Object)page0.hasNextPage()).thenReturn((Object)true);
        BaseBigtableTableAdminClient.ListBackupsPage page1 = (BaseBigtableTableAdminClient.ListBackupsPage)Mockito.mock(BaseBigtableTableAdminClient.ListBackupsPage.class);
        Mockito.when((Object)page1.getValues()).thenReturn(expectedProtos.subList(2, 3));
        Mockito.when((Object)page0.getNextPageAsync()).thenReturn((Object)ApiFutures.immediateFuture((Object)page1));
        BaseBigtableTableAdminClient.ListBackupsPagedResponse response0 = (BaseBigtableTableAdminClient.ListBackupsPagedResponse)Mockito.mock(BaseBigtableTableAdminClient.ListBackupsPagedResponse.class);
        Mockito.when((Object)response0.getPage()).thenReturn((Object)page0);
        Mockito.when((Object)this.mockListBackupCallable.futureCall((Object)testRequest)).thenReturn((Object)ApiFutures.immediateFuture((Object)response0));
        List actualResults = this.adminClient.listBackups(CLUSTER_ID);
        ArrayList expectedResults = Lists.newArrayList();
        for (com.google.bigtable.admin.v2.Backup expectedProto : expectedProtos) {
            expectedResults.add(NameUtil.extractBackupIdFromBackupName((String)expectedProto.getName()));
        }
        Truth.assertThat((Iterable)actualResults).containsExactlyElementsIn((Iterable)expectedResults);
    }

    @Test
    public void testGetBackupIamPolicy() {
        Mockito.when((Object)this.mockStub.getIamPolicyCallable()).thenReturn(this.mockGetIamPolicyCallable);
        GetIamPolicyRequest expectedRequest = GetIamPolicyRequest.newBuilder().setResource(NameUtil.formatBackupName((String)PROJECT_ID, (String)INSTANCE_ID, (String)CLUSTER_ID, (String)BACKUP_ID)).build();
        com.google.iam.v1.Policy expectedResponse = com.google.iam.v1.Policy.newBuilder().addBindings(Binding.newBuilder().setRole("roles/bigtable.viewer").addMembers("user:someone@example.com")).setEtag(ByteString.copyFromUtf8((String)"my-etag")).build();
        Mockito.when((Object)this.mockGetIamPolicyCallable.futureCall((Object)expectedRequest)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse));
        Policy actualResult = this.adminClient.getBackupIamPolicy(CLUSTER_ID, BACKUP_ID);
        Truth.assertThat((Object)actualResult).isEqualTo((Object)Policy.newBuilder().addIdentity(Role.of((String)"bigtable.viewer"), Identity.user((String)"someone@example.com"), new Identity[0]).setEtag(BaseEncoding.base64().encode("my-etag".getBytes())).build());
    }

    @Test
    public void testSetIamPolicy() {
        Mockito.when((Object)this.mockStub.setIamPolicyCallable()).thenReturn(this.mockSetIamPolicyCallable);
        SetIamPolicyRequest expectedRequest = SetIamPolicyRequest.newBuilder().setResource(NameUtil.formatBackupName((String)PROJECT_ID, (String)INSTANCE_ID, (String)CLUSTER_ID, (String)BACKUP_ID)).setPolicy(com.google.iam.v1.Policy.newBuilder().addBindings(Binding.newBuilder().setRole("roles/bigtable.viewer").addMembers("user:someone@example.com"))).build();
        com.google.iam.v1.Policy expectedResponse = com.google.iam.v1.Policy.newBuilder().addBindings(Binding.newBuilder().setRole("roles/bigtable.viewer").addMembers("user:someone@example.com")).setEtag(ByteString.copyFromUtf8((String)"my-etag")).build();
        Mockito.when((Object)this.mockSetIamPolicyCallable.futureCall((Object)expectedRequest)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse));
        Policy actualResult = this.adminClient.setBackupIamPolicy(CLUSTER_ID, BACKUP_ID, Policy.newBuilder().addIdentity(Role.of((String)"bigtable.viewer"), Identity.user((String)"someone@example.com"), new Identity[0]).build());
        Truth.assertThat((Object)actualResult).isEqualTo((Object)Policy.newBuilder().addIdentity(Role.of((String)"bigtable.viewer"), Identity.user((String)"someone@example.com"), new Identity[0]).setEtag(BaseEncoding.base64().encode("my-etag".getBytes())).build());
    }

    @Test
    public void testTestIamPermissions() {
        Mockito.when((Object)this.mockStub.testIamPermissionsCallable()).thenReturn(this.mockTestIamPermissionsCallable);
        TestIamPermissionsRequest expectedRequest = TestIamPermissionsRequest.newBuilder().setResource(NameUtil.formatBackupName((String)PROJECT_ID, (String)INSTANCE_ID, (String)CLUSTER_ID, (String)BACKUP_ID)).addPermissions("bigtable.backups.get").build();
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addPermissions("bigtable.backups.get").build();
        Mockito.when((Object)this.mockTestIamPermissionsCallable.futureCall((Object)expectedRequest)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse));
        List actualResult = this.adminClient.testBackupIamPermission(CLUSTER_ID, BACKUP_ID, new String[]{"bigtable.backups.get"});
        Truth.assertThat((Iterable)actualResult).containsExactly(new Object[]{"bigtable.backups.get"});
    }

    private <ReqT, RespT, MetaT> void mockOperationResult(OperationCallable<ReqT, RespT, MetaT> callable, ReqT request, RespT response, MetaT metadata) {
        FakeOperationSnapshot operationSnapshot = FakeOperationSnapshot.newBuilder().setDone(true).setErrorCode((StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.OK)).setName("fake-name").setResponse(response).setMetadata(metadata).build();
        OperationFuture operationFuture = OperationFutures.immediateOperationFuture((OperationSnapshot)operationSnapshot);
        Mockito.when((Object)callable.futureCall(request)).thenReturn((Object)operationFuture);
    }
}

