/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminSettings;
import com.google.cloud.bigtable.admin.v2.stub.BigtableTableAdminStubSettings;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class BigtableTableAdminSettingsTest {
    static final String[] SETTINGS_LIST = new String[]{"createTableSettings", "createTableFromSnapshotSettings", "createTableFromSnapshotOperationSettings", "listTablesSettings", "getTableSettings", "deleteTableSettings", "modifyColumnFamiliesSettings", "dropRowRangeSettings", "generateConsistencyTokenSettings", "checkConsistencySettings", "getIamPolicySettings", "setIamPolicySettings", "testIamPermissionsSettings", "snapshotTableSettings", "snapshotTableOperationSettings", "getSnapshotSettings", "listSnapshotsSettings", "deleteSnapshotSettings", "createBackupSettings", "createBackupOperationSettings", "getBackupSettings", "listBackupsSettings", "updateBackupSettings", "deleteBackupSettings", "restoreTableSettings", "restoreTableOperationSettings", "undeleteTableSettings", "undeleteTableOperationSettings", "updateTableSettings", "updateTableOperationSettings"};

    @Test
    public void testInstanceName() throws IOException {
        BigtableTableAdminSettings.Builder builder = BigtableTableAdminSettings.newBuilder().setProjectId("my-project").setInstanceId("my-instance");
        Truth.assertThat((String)builder.getProjectId()).isEqualTo((Object)"my-project");
        Truth.assertThat((String)builder.getInstanceId()).isEqualTo((Object)"my-instance");
        Truth.assertThat((String)builder.build().getProjectId()).isEqualTo((Object)"my-project");
        Truth.assertThat((String)builder.build().getInstanceId()).isEqualTo((Object)"my-instance");
        Truth.assertThat((String)builder.build().toBuilder().getProjectId()).isEqualTo((Object)"my-project");
        Truth.assertThat((String)builder.build().toBuilder().getInstanceId()).isEqualTo((Object)"my-instance");
    }

    @Test
    public void testMissingInstanceName() {
        Exception actualException = null;
        try {
            BigtableTableAdminSettings.newBuilder().build();
        }
        catch (Exception e) {
            actualException = e;
        }
        Truth.assertThat((Throwable)actualException).isInstanceOf(NullPointerException.class);
    }

    @Test
    public void testCredentials() throws IOException {
        CredentialsProvider credentialsProvider = (CredentialsProvider)Mockito.mock(CredentialsProvider.class);
        BigtableTableAdminSettings settings = BigtableTableAdminSettings.newBuilder().setProjectId("my-project").setInstanceId("my-instance").setCredentialsProvider(credentialsProvider).build();
        Truth.assertThat((Object)settings.getCredentialsProvider()).isSameInstanceAs((Object)credentialsProvider);
        Truth.assertThat((Object)settings.getStubSettings().getCredentialsProvider()).isSameInstanceAs((Object)credentialsProvider);
        Truth.assertThat((Object)settings.toBuilder().getCredentialsProvider()).isSameInstanceAs((Object)credentialsProvider);
        Truth.assertThat((Object)settings.toBuilder().build().getCredentialsProvider()).isSameInstanceAs((Object)credentialsProvider);
    }

    @Test
    public void testStubSettings() throws IOException {
        BigtableTableAdminSettings.Builder builder = BigtableTableAdminSettings.newBuilder().setProjectId("my-project").setInstanceId("my-instance");
        builder.stubSettings().createTableSettings().setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.INVALID_ARGUMENT});
        Truth.assertThat((Iterable)builder.build().getStubSettings().createTableSettings().getRetryableCodes()).containsExactly(new Object[]{StatusCode.Code.INVALID_ARGUMENT});
        Truth.assertThat((Iterable)builder.build().toBuilder().build().getStubSettings().createTableSettings().getRetryableCodes()).containsExactly(new Object[]{StatusCode.Code.INVALID_ARGUMENT});
    }

    @Test
    public void testToString() throws IOException {
        BigtableTableAdminSettings defaultSettings = BigtableTableAdminSettings.newBuilder().setProjectId("our-project-85").setInstanceId("our-instance-06").build();
        this.checkToString(defaultSettings);
        BigtableTableAdminSettings.Builder builder = defaultSettings.toBuilder();
        BigtableTableAdminStubSettings.Builder stubSettings = (BigtableTableAdminStubSettings.Builder)builder.stubSettings().setEndpoint("example.com:1234");
        stubSettings.getBackupSettings().setRetrySettings(RetrySettings.newBuilder().setTotalTimeout(Duration.ofMinutes((long)812L)).build());
        BigtableTableAdminSettings settings = builder.build();
        this.checkToString(settings);
        Truth.assertThat((String)defaultSettings.toString()).doesNotContain((CharSequence)"endpoint=example.com:1234");
        Truth.assertThat((String)settings.toString()).contains((CharSequence)"endpoint=example.com:1234");
        Truth.assertThat((String)defaultSettings.toString()).doesNotContain((CharSequence)"totalTimeout=PT13H32M");
        Truth.assertThat((String)settings.toString()).contains((CharSequence)"totalTimeout=PT13H32M");
        List nonStaticFields = Arrays.stream(BigtableTableAdminStubSettings.class.getDeclaredFields()).filter(field -> !Modifier.isStatic(field.getModifiers())).map(Field::getName).collect(Collectors.toList());
        Truth.assertThat(nonStaticFields).containsExactlyElementsIn((Object[])SETTINGS_LIST);
    }

    void checkToString(BigtableTableAdminSettings settings) {
        String projectId = settings.getProjectId();
        String instanceId = settings.getInstanceId();
        String toString = settings.toString();
        Truth.assertThat((String)toString).isEqualTo((Object)settings.toString());
        Truth.assertThat((String)toString).startsWith("BigtableTableAdminSettings{projectId=" + projectId + ", instanceId=" + instanceId);
        for (String subSettings : SETTINGS_LIST) {
            Truth.assertThat((String)toString).contains((CharSequence)(subSettings + "="));
        }
        Truth.assertThat((String)toString).contains((CharSequence)settings.getStubSettings().toString());
    }
}

