/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.internal;

import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class NameUtilTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void extractBackupIdFromBackupNameTest() {
        String testBackupName = "projects/my-project/instances/my-instance/clusters/my-cluster/backups/my-backup";
        Truth.assertThat((String)NameUtil.extractBackupIdFromBackupName((String)testBackupName)).isEqualTo((Object)"my-backup");
        this.exception.expect(IllegalArgumentException.class);
        NameUtil.extractBackupIdFromBackupName((String)"bad-format");
    }

    @Test
    public void formatBackupNameTest() {
        String testBackupName = "projects/my-project/instances/my-instance/clusters/my-cluster/backups/my-backup";
        Truth.assertThat((String)NameUtil.formatBackupName((String)"my-project", (String)"my-instance", (String)"my-cluster", (String)"my-backup")).isEqualTo((Object)testBackupName);
    }
}

