/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.it;

import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.FailedPreconditionException;
import com.google.cloud.bigtable.admin.v2.BigtableInstanceAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminSettings;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.cloud.bigtable.admin.v2.models.Backup;
import com.google.cloud.bigtable.admin.v2.models.Cluster;
import com.google.cloud.bigtable.admin.v2.models.CreateBackupRequest;
import com.google.cloud.bigtable.admin.v2.models.CreateClusterRequest;
import com.google.cloud.bigtable.admin.v2.models.CreateInstanceRequest;
import com.google.cloud.bigtable.admin.v2.models.CreateTableRequest;
import com.google.cloud.bigtable.admin.v2.models.EncryptionInfo;
import com.google.cloud.bigtable.admin.v2.models.StorageType;
import com.google.cloud.bigtable.common.Status;
import com.google.cloud.bigtable.test_helpers.env.EmulatorEnv;
import com.google.cloud.bigtable.test_helpers.env.PrefixGenerator;
import com.google.cloud.bigtable.test_helpers.env.TestEnvRule;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableSet;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Sets;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import cz.o2.proxima.internal.shaded.com.google.common.truth.TruthJUnit;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Instant;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.TemporalUnit;

@RunWith(value=JUnit4.class)
public class BigtableCmekIT {
    private static final int[] BACKOFF_DURATION = new int[]{5, 10, 50, 100, 150, 200, 250, 300};
    private static final Logger LOGGER = Logger.getLogger(BigtableCmekIT.class.getName());
    private static final String TEST_TABLE_ID = "test-table-for-cmek-it";
    private static final String BACKUP_ID = "test-table-for-cmek-it-backup";
    @ClassRule
    public static TestEnvRule testEnvRule = new TestEnvRule();
    @Rule
    public final PrefixGenerator prefixGenerator = new PrefixGenerator();
    private static String instanceId;
    private static String clusterId1;
    private static String clusterId2;
    private static String clusterId3;
    private static String kmsKeyName;
    private static List<String> zones;
    private static String otherZone;
    private static BigtableInstanceAdminClient instanceAdmin;
    private static BigtableTableAdminClient tableAdmin;

    @BeforeClass
    public static void validatePlatform() throws IOException {
        TruthJUnit.assume().withMessage("Emulator doesn't support CMEK").that((Object)testEnvRule.env()).isNotInstanceOf(EmulatorEnv.class);
        kmsKeyName = testEnvRule.env().getKmsKeyName();
        Truth.assertThat((String)kmsKeyName).isNotNull();
        Truth.assertThat((String)kmsKeyName).isNotEmpty();
        instanceId = PrefixGenerator.newPrefix("BigtableCmekIT#validatePlatform");
        clusterId1 = instanceId + "-c1";
        clusterId2 = instanceId + "-c2";
        clusterId3 = instanceId + "-c3";
        zones = testEnvRule.env().getMultipleZonesInSameRegion();
        otherZone = (String)Sets.difference((Set)ImmutableSet.of((Object)testEnvRule.env().getPrimaryZone(), (Object)testEnvRule.env().getSecondaryZone()), (Set)ImmutableSet.of(zones)).iterator().next();
        instanceAdmin = testEnvRule.env().getInstanceAdminClient();
        tableAdmin = BigtableTableAdminClient.create((BigtableTableAdminSettings)testEnvRule.env().getTableAdminSettings().toBuilder().setInstanceId(instanceId).build());
        LOGGER.info("Creating cluster in zone: " + zones.get(0));
        instanceAdmin.createInstance(CreateInstanceRequest.of((String)instanceId).addCmekCluster(clusterId1, zones.get(0), 1, StorageType.SSD, kmsKeyName));
        tableAdmin.createTable(CreateTableRequest.of((String)TEST_TABLE_ID).addFamily("cf"));
    }

    @AfterClass
    public static void teardown() {
        if (tableAdmin != null) {
            tableAdmin.deleteBackup(clusterId1, BACKUP_ID);
            tableAdmin.deleteTable(TEST_TABLE_ID);
            tableAdmin.close();
        }
        if (instanceAdmin != null) {
            instanceAdmin.deleteInstance(instanceId);
            instanceAdmin.close();
        }
    }

    @Test
    public void instanceAndClusterTest() {
        Cluster cluster = instanceAdmin.getCluster(instanceId, clusterId1);
        Truth.assertThat((String)cluster.getKmsKeyName()).isEqualTo((Object)kmsKeyName);
        LOGGER.info("Creating cluster in zone: " + zones.get(1));
        instanceAdmin.createCluster(CreateClusterRequest.of((String)instanceId, (String)clusterId2).setZone(zones.get(1)).setServeNodes(1).setStorageType(StorageType.SSD).setKmsKeyName(kmsKeyName));
        Cluster secondCluster = instanceAdmin.getCluster(instanceId, clusterId2);
        Truth.assertThat((String)secondCluster.getKmsKeyName()).isEqualTo((Object)kmsKeyName);
        LOGGER.info("Trying to create cluster in zone: " + otherZone);
        try {
            instanceAdmin.createCluster(CreateClusterRequest.of((String)instanceId, (String)clusterId3).setZone(otherZone).setServeNodes(1).setStorageType(StorageType.SSD).setKmsKeyName(kmsKeyName));
            Assert.fail((String)"should have thrown an error");
        }
        catch (FailedPreconditionException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)("FAILED_PRECONDITION: Error in field 'cluster' : Error in field 'encryption_config.kms_key_name' : CMEK key " + kmsKeyName + " cannot be used to protect a cluster in zone " + NameUtil.formatLocationName((String)testEnvRule.env().getProjectId(), (String)otherZone)));
        }
    }

    @Test
    public void tableTest() throws Exception {
        if (testEnvRule.env().shouldWaitForCmekKeyStatusUpdate()) {
            this.waitForCmekStatus(TEST_TABLE_ID, clusterId1);
        }
        Map encryptionInfos = tableAdmin.getEncryptionInfo(TEST_TABLE_ID);
        Truth.assertThat((Map)encryptionInfos).hasSize(1);
        Truth.assertThat((Iterable)((Iterable)encryptionInfos.get(clusterId1))).hasSize(1);
        EncryptionInfo encryptionInfo = (EncryptionInfo)((List)encryptionInfos.get(clusterId1)).get(0);
        Truth.assertThat((Comparable)encryptionInfo.getType()).isEqualTo((Object)EncryptionInfo.Type.CUSTOMER_MANAGED_ENCRYPTION);
        Truth.assertThat((Comparable)encryptionInfo.getStatus().getCode()).isAnyOf((Object)Status.Code.OK, (Object)Status.Code.UNKNOWN, new Object[0]);
        if (testEnvRule.env().shouldWaitForCmekKeyStatusUpdate()) {
            Truth.assertThat((Comparable)encryptionInfo.getStatus().getCode()).isEqualTo((Object)Status.Code.OK);
        }
        if (encryptionInfo.getStatus().getCode() == Status.Code.UNKNOWN) {
            Truth.assertThat((String)encryptionInfo.getKmsKeyVersion()).isEmpty();
            Truth.assertThat((String)encryptionInfo.getStatus().getMessage()).isEqualTo((Object)"Key version is not yet known.");
        } else {
            Truth.assertThat((String)encryptionInfo.getKmsKeyVersion()).startsWith(kmsKeyName);
            Truth.assertThat((String)encryptionInfo.getStatus().getMessage()).isEqualTo((Object)"");
        }
    }

    @Test
    public void backupTest() {
        tableAdmin.createBackup(CreateBackupRequest.of((String)clusterId1, (String)BACKUP_ID).setExpireTime(Instant.now().plus(6L, (TemporalUnit)ChronoUnit.HOURS)).setSourceTableId(TEST_TABLE_ID));
        Backup backup = tableAdmin.getBackup(clusterId1, BACKUP_ID);
        Truth.assertThat((String)backup.getEncryptionInfo().getKmsKeyVersion()).startsWith(kmsKeyName);
        Truth.assertThat((Comparable)backup.getEncryptionInfo().getStatus().getCode()).isEqualTo((Object)Status.Code.UNKNOWN);
        Truth.assertThat((Comparable)backup.getEncryptionInfo().getType()).isEqualTo((Object)EncryptionInfo.Type.CUSTOMER_MANAGED_ENCRYPTION);
        Truth.assertThat((String)backup.getEncryptionInfo().getStatus().getMessage()).isEqualTo((Object)"Status of the associated key version is not tracked.");
    }

    private void waitForCmekStatus(String tableId, String clusterId) throws InterruptedException {
        for (int i = 0; i < BACKOFF_DURATION.length; ++i) {
            try {
                EncryptionInfo encryptionInfo = (EncryptionInfo)((List)tableAdmin.getEncryptionInfo(tableId).get(clusterId)).get(0);
                if (encryptionInfo.getStatus().getCode() == Status.Code.OK) {
                    return;
                }
            }
            catch (ApiException ex) {
                LOGGER.info("Wait for " + BACKOFF_DURATION[i] + " seconds for key status for table " + tableId + " and cluster " + clusterId);
            }
            Thread.sleep(BACKOFF_DURATION[i] * 1000);
        }
        Assert.fail((String)"CMEK key status failed to return");
    }
}

