/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.it;

import com.google.cloud.Policy;
import com.google.cloud.bigtable.admin.v2.BigtableInstanceAdminClient;
import com.google.cloud.bigtable.admin.v2.models.AppProfile;
import com.google.cloud.bigtable.admin.v2.models.Cluster;
import com.google.cloud.bigtable.admin.v2.models.ClusterAutoscalingConfig;
import com.google.cloud.bigtable.admin.v2.models.CreateAppProfileRequest;
import com.google.cloud.bigtable.admin.v2.models.CreateClusterRequest;
import com.google.cloud.bigtable.admin.v2.models.CreateInstanceRequest;
import com.google.cloud.bigtable.admin.v2.models.Instance;
import com.google.cloud.bigtable.admin.v2.models.StaticClusterSize;
import com.google.cloud.bigtable.admin.v2.models.StorageType;
import com.google.cloud.bigtable.admin.v2.models.UpdateAppProfileRequest;
import com.google.cloud.bigtable.admin.v2.models.UpdateInstanceRequest;
import com.google.cloud.bigtable.test_helpers.env.EmulatorEnv;
import com.google.cloud.bigtable.test_helpers.env.PrefixGenerator;
import com.google.cloud.bigtable.test_helpers.env.TestEnvRule;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import cz.o2.proxima.internal.shaded.com.google.common.truth.TruthJUnit;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigtableInstanceAdminClientIT {
    @ClassRule
    public static TestEnvRule testEnvRule = new TestEnvRule();
    @Rule
    public final PrefixGenerator prefixGenerator = new PrefixGenerator();
    private String instanceId = testEnvRule.env().getInstanceId();
    private BigtableInstanceAdminClient client;

    @BeforeClass
    public static void validatePlatform() {
        TruthJUnit.assume().withMessage("BigtableInstanceAdminClient doesn't support on Emulator").that((Object)testEnvRule.env()).isNotInstanceOf(EmulatorEnv.class);
    }

    @Before
    public void setUp() {
        this.client = testEnvRule.env().getInstanceAdminClient();
    }

    @Test
    public void appProfileTest() {
        String testAppProfile = this.prefixGenerator.newPrefix();
        AppProfile newlyCreatedAppProfile = this.client.createAppProfile(CreateAppProfileRequest.of((String)this.instanceId, (String)testAppProfile).setRoutingPolicy((AppProfile.RoutingPolicy)AppProfile.MultiClusterRoutingPolicy.of()).setDescription("This is to test app profile"));
        AppProfile updated = this.client.updateAppProfile(UpdateAppProfileRequest.of((AppProfile)newlyCreatedAppProfile).setDescription("This is to app profile operation"));
        AppProfile freshAppProfile = this.client.getAppProfile(this.instanceId, testAppProfile);
        Truth.assertThat((String)freshAppProfile.getDescription()).isEqualTo((Object)updated.getDescription());
        Truth.assertThat((Iterable)this.client.listAppProfiles(this.instanceId)).contains((Object)freshAppProfile);
        Exception actualEx = null;
        try {
            this.client.deleteAppProfile(this.instanceId, testAppProfile, true);
        }
        catch (Exception ex) {
            actualEx = ex;
        }
        Truth.assertThat((Throwable)actualEx).isNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void appProfileTestMultiClusterWithIds() {
        String newInstanceId = this.prefixGenerator.newPrefix();
        String newClusterId = newInstanceId + "-c1";
        String newClusterId2 = newInstanceId + "-c2";
        this.client.createInstance(CreateInstanceRequest.of((String)newInstanceId).addCluster(newClusterId, testEnvRule.env().getPrimaryZone(), 1, StorageType.SSD).addCluster(newClusterId2, testEnvRule.env().getSecondaryZone(), 1, StorageType.SSD).setDisplayName("Multi-Cluster-Instance-Test").addLabel("state", "readytodelete").setType(Instance.Type.PRODUCTION));
        try {
            Truth.assertThat((Boolean)this.client.exists(newInstanceId)).isTrue();
            String testAppProfile = "test-app-profile";
            CreateAppProfileRequest request = CreateAppProfileRequest.of((String)newInstanceId, (String)testAppProfile).setRoutingPolicy((AppProfile.RoutingPolicy)AppProfile.MultiClusterRoutingPolicy.of((String[])new String[]{newClusterId})).setDescription("This is to test app profile");
            AppProfile newlyCreatedAppProfile = this.client.createAppProfile(request);
            AppProfile updated = this.client.updateAppProfile(UpdateAppProfileRequest.of((AppProfile)newlyCreatedAppProfile).setDescription("new description"));
            AppProfile freshAppProfile = this.client.getAppProfile(newInstanceId, testAppProfile);
            Truth.assertThat((String)freshAppProfile.getDescription()).isEqualTo((Object)updated.getDescription());
            AppProfile.MultiClusterRoutingPolicy freshAppProfilePolicy = (AppProfile.MultiClusterRoutingPolicy)freshAppProfile.getPolicy();
            AppProfile.MultiClusterRoutingPolicy updatedAppProfilePolicy = (AppProfile.MultiClusterRoutingPolicy)updated.getPolicy();
            Truth.assertThat((Iterable)freshAppProfilePolicy.getClusterIds()).containsExactly(new Object[]{newClusterId});
            Truth.assertThat((Iterable)freshAppProfilePolicy.getClusterIds()).isEqualTo((Object)updatedAppProfilePolicy.getClusterIds());
            Truth.assertThat((Object)freshAppProfilePolicy).isEqualTo((Object)updatedAppProfilePolicy);
            Truth.assertThat((Iterable)this.client.listAppProfiles(newInstanceId)).contains((Object)freshAppProfile);
            AppProfile updated2 = this.client.updateAppProfile(UpdateAppProfileRequest.of((AppProfile)updated).setRoutingPolicy((AppProfile.RoutingPolicy)AppProfile.MultiClusterRoutingPolicy.of((String[])new String[]{newClusterId2})));
            AppProfile freshAppProfile2 = this.client.getAppProfile(newInstanceId, testAppProfile);
            Truth.assertThat((String)freshAppProfile2.getDescription()).isEqualTo((Object)updated2.getDescription());
            AppProfile.MultiClusterRoutingPolicy freshAppProfilePolicy2 = (AppProfile.MultiClusterRoutingPolicy)freshAppProfile2.getPolicy();
            AppProfile.MultiClusterRoutingPolicy updatedAppProfilePolicy2 = (AppProfile.MultiClusterRoutingPolicy)updated2.getPolicy();
            Truth.assertThat((Iterable)freshAppProfilePolicy2.getClusterIds()).containsExactly(new Object[]{newClusterId2});
            Truth.assertThat((Iterable)freshAppProfilePolicy2.getClusterIds()).isEqualTo((Object)updatedAppProfilePolicy2.getClusterIds());
            Truth.assertThat((Object)freshAppProfilePolicy2).isEqualTo((Object)updatedAppProfilePolicy2);
            Truth.assertThat((Iterable)this.client.listAppProfiles(newInstanceId)).contains((Object)freshAppProfile2);
            AppProfile updated3 = this.client.updateAppProfile(UpdateAppProfileRequest.of((AppProfile)updated).setRoutingPolicy((AppProfile.RoutingPolicy)AppProfile.SingleClusterRoutingPolicy.of((String)newClusterId)));
            AppProfile freshAppProfile3 = this.client.getAppProfile(newInstanceId, testAppProfile);
            Truth.assertThat((String)freshAppProfile3.getDescription()).isEqualTo((Object)updated3.getDescription());
            AppProfile.SingleClusterRoutingPolicy freshAppProfilePolicy3 = (AppProfile.SingleClusterRoutingPolicy)freshAppProfile3.getPolicy();
            AppProfile.SingleClusterRoutingPolicy updatedAppProfilePolicy3 = (AppProfile.SingleClusterRoutingPolicy)updated3.getPolicy();
            Truth.assertThat((String)freshAppProfilePolicy3.getClusterId()).isEqualTo((Object)newClusterId);
            Truth.assertThat((String)freshAppProfilePolicy3.getClusterId()).isEqualTo((Object)updatedAppProfilePolicy3.getClusterId());
            Truth.assertThat((Object)freshAppProfilePolicy3).isEqualTo((Object)updatedAppProfilePolicy3);
            Truth.assertThat((Iterable)this.client.listAppProfiles(newInstanceId)).contains((Object)freshAppProfile3);
        }
        finally {
            if (this.client.exists(newInstanceId)) {
                this.client.deleteInstance(newInstanceId);
            }
        }
    }

    @Test
    public void iamUpdateTest() {
        Policy policy = this.client.getIamPolicy(this.instanceId);
        Truth.assertThat((Object)policy).isNotNull();
        Exception actualEx = null;
        try {
            Truth.assertThat((Object)this.client.setIamPolicy(this.instanceId, policy)).isNotNull();
        }
        catch (Exception iamException) {
            actualEx = iamException;
        }
        Truth.assertThat((Throwable)actualEx).isNull();
        List permissions = this.client.testIamPermission(this.instanceId, new String[]{"bigtable.tables.readRows", "bigtable.tables.mutateRows"});
        Truth.assertThat((Iterable)permissions).hasSize(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void instanceAndClusterCreationDeletionTest() {
        String newInstanceId;
        String newClusterId = newInstanceId = this.prefixGenerator.newPrefix();
        this.client.createInstance(CreateInstanceRequest.of((String)newInstanceId).addCluster(newClusterId, testEnvRule.env().getPrimaryZone(), 3, StorageType.SSD).setDisplayName("Fresh-Instance-Name").addLabel("state", "readytodelete").setType(Instance.Type.PRODUCTION));
        try {
            Truth.assertThat((Boolean)this.client.exists(newInstanceId)).isTrue();
            this.client.updateInstance(UpdateInstanceRequest.of((String)newInstanceId).setDisplayName("Test-Instance-Name"));
            Instance instance = this.client.getInstance(newInstanceId);
            Truth.assertThat((String)instance.getDisplayName()).isEqualTo((Object)"Test-Instance-Name");
            Truth.assertThat((Iterable)this.client.listInstances()).contains((Object)instance);
            this.clusterCreationDeletionTestHelper(newInstanceId);
            this.basicClusterOperationTestHelper(newInstanceId, newClusterId);
            this.client.deleteInstance(newInstanceId);
            Truth.assertThat((Boolean)this.client.exists(newInstanceId)).isFalse();
        }
        finally {
            if (this.client.exists(newInstanceId)) {
                this.client.deleteInstance(newInstanceId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clusterCreationDeletionTestHelper(String newInstanceId) {
        String newClusterId = this.prefixGenerator.newPrefix();
        boolean isClusterDeleted = false;
        this.client.createCluster(CreateClusterRequest.of((String)newInstanceId, (String)newClusterId).setZone(testEnvRule.env().getSecondaryZone()).setStorageType(StorageType.SSD).setServeNodes(3));
        try {
            Truth.assertThat((Object)this.client.getCluster(newInstanceId, newClusterId)).isNotNull();
            this.client.deleteCluster(newInstanceId, newClusterId);
            isClusterDeleted = true;
        }
        finally {
            if (!isClusterDeleted) {
                this.client.deleteCluster(newInstanceId, newClusterId);
            }
        }
    }

    @Test
    public void basicInstanceOperationTest() {
        Truth.assertThat((Boolean)this.client.exists(this.instanceId)).isTrue();
        this.client.updateInstance(UpdateInstanceRequest.of((String)this.instanceId).setDisplayName("Updated-Instance-Name"));
        Instance instance = this.client.getInstance(this.instanceId);
        Truth.assertThat((String)instance.getDisplayName()).isEqualTo((Object)"Updated-Instance-Name");
        Truth.assertThat((Iterable)this.client.listInstances()).contains((Object)instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createClusterWithAutoscalingTest() {
        String newInstanceId = this.prefixGenerator.newPrefix();
        String newClusterId = newInstanceId + "-c1";
        try {
            this.client.createInstance(CreateInstanceRequest.of((String)newInstanceId).addCluster(newClusterId, testEnvRule.env().getPrimaryZone(), 1, StorageType.HDD).setDisplayName("Multi-Cluster-Instance-Test").addLabel("state", "readytodelete").setType(Instance.Type.PRODUCTION));
            String clusterId = this.prefixGenerator.newPrefix();
            CreateClusterRequest createClusterRequest = CreateClusterRequest.of((String)newInstanceId, (String)clusterId).setZone(testEnvRule.env().getSecondaryZone()).setStorageType(StorageType.HDD).setScalingMode(ClusterAutoscalingConfig.of((String)newInstanceId, (String)clusterId).setMaxNodes(4).setMinNodes(1).setCpuUtilizationTargetPercent(20).setStorageUtilizationGibPerNode(9200));
            Cluster cluster = this.client.createCluster(createClusterRequest);
            Truth.assertThat((String)cluster.getId()).contains((CharSequence)clusterId);
            Truth.assertThat((Integer)cluster.getServeNodes()).isEqualTo((Object)0);
            Truth.assertThat((Integer)cluster.getAutoscalingMinServeNodes()).isEqualTo((Object)1);
            Truth.assertThat((Integer)cluster.getAutoscalingMaxServeNodes()).isEqualTo((Object)4);
            Truth.assertThat((Integer)cluster.getAutoscalingCpuPercentageTarget()).isEqualTo((Object)20);
            Truth.assertThat((Integer)cluster.getStorageUtilizationGibPerNode()).isEqualTo((Object)9200);
        }
        catch (Exception e) {
            Assert.fail((String)("error in the test" + e.getMessage()));
        }
        finally {
            this.client.deleteInstance(newInstanceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createClusterWithAutoscalingAndPartialUpdateTest() {
        String newInstanceId = this.prefixGenerator.newPrefix();
        String newClusterId = newInstanceId + "-c1";
        try {
            this.client.createInstance(CreateInstanceRequest.of((String)newInstanceId).addCluster(newClusterId, testEnvRule.env().getPrimaryZone(), 1, StorageType.SSD).setDisplayName("Multi-Cluster-Instance-Test").addLabel("state", "readytodelete").setType(Instance.Type.PRODUCTION));
            String clusterId = this.prefixGenerator.newPrefix();
            CreateClusterRequest createClusterRequest = CreateClusterRequest.of((String)newInstanceId, (String)clusterId).setZone(testEnvRule.env().getSecondaryZone()).setScalingMode(ClusterAutoscalingConfig.of((String)"ignored", (String)clusterId).setMaxNodes(4).setMinNodes(1).setStorageUtilizationGibPerNode(2561).setCpuUtilizationTargetPercent(20));
            Cluster cluster = this.client.createCluster(createClusterRequest);
            Truth.assertThat((String)cluster.getId()).contains((CharSequence)clusterId);
            Truth.assertThat((Integer)cluster.getServeNodes()).isEqualTo((Object)0);
            Truth.assertThat((Integer)cluster.getAutoscalingMinServeNodes()).isEqualTo((Object)1);
            Truth.assertThat((Integer)cluster.getAutoscalingMaxServeNodes()).isEqualTo((Object)4);
            Truth.assertThat((Integer)cluster.getAutoscalingCpuPercentageTarget()).isEqualTo((Object)20);
            Truth.assertThat((Integer)cluster.getStorageUtilizationGibPerNode()).isEqualTo((Object)2561);
            Cluster retrievedCluster = this.client.getCluster(newInstanceId, clusterId);
            Truth.assertThat((String)retrievedCluster.getId()).contains((CharSequence)clusterId);
            Truth.assertThat((Integer)retrievedCluster.getAutoscalingMinServeNodes()).isEqualTo((Object)1);
            Truth.assertThat((Integer)retrievedCluster.getAutoscalingMaxServeNodes()).isEqualTo((Object)4);
            Truth.assertThat((Integer)retrievedCluster.getAutoscalingCpuPercentageTarget()).isEqualTo((Object)20);
            Truth.assertThat((Integer)retrievedCluster.getStorageUtilizationGibPerNode()).isEqualTo((Object)2561);
            Cluster updatedCluster = this.client.updateClusterAutoscalingConfig(ClusterAutoscalingConfig.of((String)newInstanceId, (String)clusterId).setMaxNodes(3));
            Truth.assertThat((Integer)updatedCluster.getAutoscalingMinServeNodes()).isEqualTo((Object)1);
            Truth.assertThat((Integer)updatedCluster.getAutoscalingMaxServeNodes()).isEqualTo((Object)3);
            Truth.assertThat((Integer)updatedCluster.getAutoscalingCpuPercentageTarget()).isEqualTo((Object)20);
            Truth.assertThat((Integer)updatedCluster.getStorageUtilizationGibPerNode()).isEqualTo((Object)2561);
            Cluster retrievedUpdatedCluster = this.client.getCluster(newInstanceId, clusterId);
            Truth.assertThat((Integer)retrievedUpdatedCluster.getAutoscalingMinServeNodes()).isEqualTo((Object)1);
            Truth.assertThat((Integer)retrievedUpdatedCluster.getAutoscalingMaxServeNodes()).isEqualTo((Object)3);
            Truth.assertThat((Integer)retrievedUpdatedCluster.getAutoscalingCpuPercentageTarget()).isEqualTo((Object)20);
            Truth.assertThat((Integer)retrievedUpdatedCluster.getStorageUtilizationGibPerNode()).isEqualTo((Object)2561);
            updatedCluster = this.client.updateClusterAutoscalingConfig(ClusterAutoscalingConfig.of((String)newInstanceId, (String)clusterId).setMinNodes(2));
            Truth.assertThat((Integer)updatedCluster.getAutoscalingMinServeNodes()).isEqualTo((Object)2);
            Truth.assertThat((Integer)updatedCluster.getAutoscalingMaxServeNodes()).isEqualTo((Object)3);
            Truth.assertThat((Integer)updatedCluster.getAutoscalingCpuPercentageTarget()).isEqualTo((Object)20);
            Truth.assertThat((Integer)updatedCluster.getStorageUtilizationGibPerNode()).isEqualTo((Object)2561);
            retrievedUpdatedCluster = this.client.getCluster(newInstanceId, clusterId);
            Truth.assertThat((Integer)retrievedUpdatedCluster.getAutoscalingMinServeNodes()).isEqualTo((Object)2);
            Truth.assertThat((Integer)retrievedUpdatedCluster.getAutoscalingMaxServeNodes()).isEqualTo((Object)3);
            Truth.assertThat((Integer)retrievedUpdatedCluster.getAutoscalingCpuPercentageTarget()).isEqualTo((Object)20);
            Truth.assertThat((Integer)retrievedUpdatedCluster.getStorageUtilizationGibPerNode()).isEqualTo((Object)2561);
            updatedCluster = this.client.updateClusterAutoscalingConfig(ClusterAutoscalingConfig.of((String)newInstanceId, (String)clusterId).setCpuUtilizationTargetPercent(40));
            Truth.assertThat((Integer)updatedCluster.getAutoscalingMinServeNodes()).isEqualTo((Object)2);
            Truth.assertThat((Integer)updatedCluster.getAutoscalingMaxServeNodes()).isEqualTo((Object)3);
            Truth.assertThat((Integer)updatedCluster.getAutoscalingCpuPercentageTarget()).isEqualTo((Object)40);
            Truth.assertThat((Integer)updatedCluster.getStorageUtilizationGibPerNode()).isEqualTo((Object)2561);
            retrievedUpdatedCluster = this.client.getCluster(newInstanceId, clusterId);
            Truth.assertThat((Integer)retrievedUpdatedCluster.getAutoscalingMinServeNodes()).isEqualTo((Object)2);
            Truth.assertThat((Integer)retrievedUpdatedCluster.getAutoscalingMaxServeNodes()).isEqualTo((Object)3);
            Truth.assertThat((Integer)retrievedUpdatedCluster.getAutoscalingCpuPercentageTarget()).isEqualTo((Object)40);
            Truth.assertThat((Integer)retrievedUpdatedCluster.getStorageUtilizationGibPerNode()).isEqualTo((Object)2561);
            updatedCluster = this.client.updateClusterAutoscalingConfig(ClusterAutoscalingConfig.of((String)newInstanceId, (String)clusterId).setCpuUtilizationTargetPercent(45).setMaxNodes(5));
            Truth.assertThat((Integer)updatedCluster.getAutoscalingMinServeNodes()).isEqualTo((Object)2);
            Truth.assertThat((Integer)updatedCluster.getAutoscalingMaxServeNodes()).isEqualTo((Object)5);
            Truth.assertThat((Integer)updatedCluster.getAutoscalingCpuPercentageTarget()).isEqualTo((Object)45);
            Truth.assertThat((Integer)updatedCluster.getStorageUtilizationGibPerNode()).isEqualTo((Object)2561);
            retrievedUpdatedCluster = this.client.getCluster(newInstanceId, clusterId);
            Truth.assertThat((Integer)retrievedUpdatedCluster.getAutoscalingMinServeNodes()).isEqualTo((Object)2);
            Truth.assertThat((Integer)retrievedUpdatedCluster.getAutoscalingMaxServeNodes()).isEqualTo((Object)5);
            Truth.assertThat((Integer)retrievedUpdatedCluster.getAutoscalingCpuPercentageTarget()).isEqualTo((Object)45);
            Truth.assertThat((Integer)retrievedUpdatedCluster.getStorageUtilizationGibPerNode()).isEqualTo((Object)2561);
            updatedCluster = this.client.updateClusterAutoscalingConfig(ClusterAutoscalingConfig.of((String)newInstanceId, (String)clusterId).setStorageUtilizationGibPerNode(2777));
            Truth.assertThat((Integer)updatedCluster.getAutoscalingMinServeNodes()).isEqualTo((Object)2);
            Truth.assertThat((Integer)updatedCluster.getAutoscalingMaxServeNodes()).isEqualTo((Object)5);
            Truth.assertThat((Integer)updatedCluster.getAutoscalingCpuPercentageTarget()).isEqualTo((Object)45);
            Truth.assertThat((Integer)updatedCluster.getStorageUtilizationGibPerNode()).isEqualTo((Object)2777);
            retrievedUpdatedCluster = this.client.getCluster(newInstanceId, clusterId);
            Truth.assertThat((Integer)retrievedUpdatedCluster.getAutoscalingMinServeNodes()).isEqualTo((Object)2);
            Truth.assertThat((Integer)retrievedUpdatedCluster.getAutoscalingMaxServeNodes()).isEqualTo((Object)5);
            Truth.assertThat((Integer)retrievedUpdatedCluster.getAutoscalingCpuPercentageTarget()).isEqualTo((Object)45);
            Truth.assertThat((Integer)retrievedUpdatedCluster.getStorageUtilizationGibPerNode()).isEqualTo((Object)2777);
            updatedCluster = this.client.updateClusterAutoscalingConfig(ClusterAutoscalingConfig.of((String)newInstanceId, (String)clusterId).setStorageUtilizationGibPerNode(0));
            Truth.assertThat((Integer)updatedCluster.getAutoscalingMinServeNodes()).isEqualTo((Object)2);
            Truth.assertThat((Integer)updatedCluster.getAutoscalingMaxServeNodes()).isEqualTo((Object)5);
            Truth.assertThat((Integer)updatedCluster.getAutoscalingCpuPercentageTarget()).isEqualTo((Object)45);
            Truth.assertThat((Integer)updatedCluster.getStorageUtilizationGibPerNode()).isEqualTo((Object)2560);
            retrievedUpdatedCluster = this.client.getCluster(newInstanceId, clusterId);
            Truth.assertThat((Integer)retrievedUpdatedCluster.getAutoscalingMinServeNodes()).isEqualTo((Object)2);
            Truth.assertThat((Integer)retrievedUpdatedCluster.getAutoscalingMaxServeNodes()).isEqualTo((Object)5);
            Truth.assertThat((Integer)retrievedUpdatedCluster.getAutoscalingCpuPercentageTarget()).isEqualTo((Object)45);
            Truth.assertThat((Integer)retrievedUpdatedCluster.getStorageUtilizationGibPerNode()).isEqualTo((Object)2560);
        }
        catch (Exception e) {
            Assert.fail((String)("error in the test: " + e.getMessage()));
        }
        finally {
            this.client.deleteInstance(newInstanceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createClusterWithManualScalingTest() {
        String newInstanceId = this.prefixGenerator.newPrefix();
        String newClusterId = newInstanceId + "-c1";
        try {
            this.client.createInstance(CreateInstanceRequest.of((String)newInstanceId).addCluster(newClusterId, testEnvRule.env().getPrimaryZone(), 1, StorageType.SSD).setDisplayName("Multi-Cluster-Instance-Test").addLabel("state", "readytodelete").setType(Instance.Type.PRODUCTION));
            String clusterId = this.prefixGenerator.newPrefix();
            CreateClusterRequest createClusterRequest = CreateClusterRequest.of((String)newInstanceId, (String)clusterId).setZone(testEnvRule.env().getSecondaryZone()).setScalingMode(StaticClusterSize.of((int)5));
            Cluster cluster = this.client.createCluster(createClusterRequest);
            Truth.assertThat((String)cluster.getId()).contains((CharSequence)clusterId);
            Truth.assertThat((Integer)cluster.getServeNodes()).isEqualTo((Object)5);
            Truth.assertThat((Integer)cluster.getAutoscalingMaxServeNodes()).isEqualTo((Object)0);
            Truth.assertThat((Integer)cluster.getAutoscalingMinServeNodes()).isEqualTo((Object)0);
            Truth.assertThat((Integer)cluster.getAutoscalingCpuPercentageTarget()).isEqualTo((Object)0);
            Truth.assertThat((Integer)cluster.getStorageUtilizationGibPerNode()).isEqualTo((Object)0);
        }
        catch (Exception e) {
            Assert.fail((String)("error in the test: " + e.getMessage()));
        }
        finally {
            this.client.deleteInstance(newInstanceId);
        }
    }

    private void basicClusterOperationTestHelper(String targetInstanceId, String targetClusterId) {
        List clusters = this.client.listClusters(targetInstanceId);
        Cluster targetCluster = null;
        for (Cluster cluster : clusters) {
            if (!cluster.getId().equals(targetClusterId)) continue;
            targetCluster = cluster;
        }
        Truth.assertWithMessage((String)"Failed to find target cluster id in listClusters").that(targetCluster).isNotNull();
        Truth.assertThat((Object)this.client.getCluster(targetInstanceId, targetClusterId)).isEqualTo((Object)targetCluster);
        int freshNumOfNodes = targetCluster.getServeNodes() + 1;
        Cluster resizeCluster = this.client.resizeCluster(targetInstanceId, targetClusterId, freshNumOfNodes);
        Truth.assertThat((Integer)resizeCluster.getServeNodes()).isEqualTo((Object)freshNumOfNodes);
        ClusterAutoscalingConfig autoscalingConfig = ClusterAutoscalingConfig.of((String)targetInstanceId, (String)targetClusterId).setMinNodes(1).setMaxNodes(4).setStorageUtilizationGibPerNode(2877).setCpuUtilizationTargetPercent(40);
        Cluster cluster = this.client.updateClusterAutoscalingConfig(autoscalingConfig);
        Truth.assertThat((Integer)cluster.getAutoscalingMaxServeNodes()).isEqualTo((Object)4);
        Truth.assertThat((Integer)cluster.getAutoscalingMinServeNodes()).isEqualTo((Object)1);
        Truth.assertThat((Integer)cluster.getAutoscalingCpuPercentageTarget()).isEqualTo((Object)40);
        Truth.assertThat((Integer)cluster.getStorageUtilizationGibPerNode()).isEqualTo((Object)2877);
        Cluster updatedCluster = this.client.disableClusterAutoscaling(targetInstanceId, targetClusterId, 3);
        Truth.assertThat((Integer)updatedCluster.getServeNodes()).isEqualTo((Object)3);
        Truth.assertThat((Integer)updatedCluster.getAutoscalingMaxServeNodes()).isEqualTo((Object)0);
        Truth.assertThat((Integer)updatedCluster.getAutoscalingMinServeNodes()).isEqualTo((Object)0);
        Truth.assertThat((Integer)updatedCluster.getAutoscalingCpuPercentageTarget()).isEqualTo((Object)0);
        Truth.assertThat((Integer)updatedCluster.getStorageUtilizationGibPerNode()).isEqualTo((Object)0);
    }
}

