/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.admin.v2.AppProfile;
import com.google.bigtable.admin.v2.AppProfileName;
import com.google.cloud.bigtable.admin.v2.models.AppProfile;
import com.google.cloud.bigtable.admin.v2.models.UpdateAppProfileRequest;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableList;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AppProfileTest {
    private static final com.google.bigtable.admin.v2.AppProfile TEST_PROTO = com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(AppProfileName.of((String)"my-project", (String)"my-instance", (String)"my-profile").toString()).setDescription("my description").setSingleClusterRouting(AppProfile.SingleClusterRouting.newBuilder().setClusterId("my-cluster").setAllowTransactionalWrites(true).build()).setEtag("my-etag").build();

    @Test
    public void testFromProto() {
        AppProfile profile = AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)TEST_PROTO);
        Truth.assertThat((String)profile.getInstanceId()).isEqualTo((Object)"my-instance");
        Truth.assertThat((String)profile.getId()).isEqualTo((Object)"my-profile");
        Truth.assertThat((String)profile.getDescription()).isEqualTo((Object)"my description");
        Truth.assertThat((Object)profile.getPolicy()).isEqualTo((Object)AppProfile.SingleClusterRoutingPolicy.of((String)"my-cluster", (boolean)true));
    }

    @Test
    public void testFromProtoWithMultiCluster() {
        AppProfile profile = AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(AppProfileName.of((String)"my-project", (String)"my-instance", (String)"my-profile").toString()).setDescription("my description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.newBuilder().build()).setEtag("my-etag").build());
        Truth.assertThat((String)profile.getInstanceId()).isEqualTo((Object)"my-instance");
        Truth.assertThat((String)profile.getId()).isEqualTo((Object)"my-profile");
        Truth.assertThat((String)profile.getDescription()).isEqualTo((Object)"my description");
        Truth.assertThat((Object)profile.getPolicy()).isEqualTo((Object)AppProfile.MultiClusterRoutingPolicy.of());
    }

    @Test
    public void testFromProtoWithMultiClusterWithIds() {
        AppProfile profile = AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(AppProfileName.of((String)"my-project", (String)"my-instance", (String)"my-profile").toString()).setDescription("my description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.newBuilder().addAllClusterIds((Iterable)ImmutableList.of((Object)"cluster-id-1", (Object)"cluster-id-2")).build()).setEtag("my-etag").build());
        Truth.assertThat((String)profile.getInstanceId()).isEqualTo((Object)"my-instance");
        Truth.assertThat((String)profile.getId()).isEqualTo((Object)"my-profile");
        Truth.assertThat((String)profile.getDescription()).isEqualTo((Object)"my description");
        Truth.assertThat((Object)profile.getPolicy()).isEqualTo((Object)AppProfile.MultiClusterRoutingPolicy.of((String[])new String[]{"cluster-id-1", "cluster-id-2"}));
    }

    @Test
    public void testNoNameError() {
        Exception actualException = null;
        try {
            AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)TEST_PROTO.toBuilder().setName("").build());
        }
        catch (Exception e) {
            actualException = e;
        }
        Truth.assertThat((Throwable)actualException).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testNoPolicyError() {
        Exception actualException = null;
        try {
            AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)TEST_PROTO.toBuilder().clearSingleClusterRouting().build());
        }
        catch (Exception e) {
            actualException = e;
        }
        Truth.assertThat((Throwable)actualException).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testEquals() {
        AppProfile profile = AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(AppProfileName.of((String)"my-project", (String)"my-instance", (String)"my-profile").toString()).setDescription("my description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.newBuilder().addAllClusterIds((Iterable)ImmutableList.of((Object)"cluster-id-1", (Object)"cluster-id-2")).build()).setEtag("my-etag").build());
        UpdateAppProfileRequest updateAppProfileRequest = UpdateAppProfileRequest.of((AppProfile)profile);
        UpdateAppProfileRequest updateAppProfileRequest2 = UpdateAppProfileRequest.of((AppProfile)profile);
        Truth.assertThat((Object)updateAppProfileRequest).isEqualTo((Object)updateAppProfileRequest2);
        AppProfile profile2 = AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(AppProfileName.of((String)"my-project-2", (String)"my-instance", (String)"my-profile").toString()).setDescription("my description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.newBuilder().addAllClusterIds((Iterable)ImmutableList.of((Object)"cluster-id-1", (Object)"cluster-id-2")).build()).setEtag("my-etag").build());
        UpdateAppProfileRequest updateAppProfileRequest3 = UpdateAppProfileRequest.of((AppProfile)profile2);
        Truth.assertThat((Object)updateAppProfileRequest).isNotEqualTo((Object)updateAppProfileRequest3);
    }

    @Test
    public void testHashCode() {
        AppProfile profile = AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(AppProfileName.of((String)"my-project", (String)"my-instance", (String)"my-profile").toString()).setDescription("my description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.newBuilder().addAllClusterIds((Iterable)ImmutableList.of((Object)"cluster-id-1", (Object)"cluster-id-2")).build()).setEtag("my-etag").build());
        UpdateAppProfileRequest updateAppProfileRequest = UpdateAppProfileRequest.of((AppProfile)profile);
        UpdateAppProfileRequest updateAppProfileRequest2 = UpdateAppProfileRequest.of((AppProfile)profile);
        Truth.assertThat((Integer)updateAppProfileRequest.hashCode()).isEqualTo((Object)updateAppProfileRequest2.hashCode());
        AppProfile profile2 = AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(AppProfileName.of((String)"my-project-2", (String)"my-instance", (String)"my-profile").toString()).setDescription("my description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.newBuilder().addAllClusterIds((Iterable)ImmutableList.of((Object)"cluster-id-1", (Object)"cluster-id-2")).build()).setEtag("my-etag").build());
        UpdateAppProfileRequest updateAppProfileRequest3 = UpdateAppProfileRequest.of((AppProfile)profile2);
        Truth.assertThat((Integer)updateAppProfileRequest.hashCode()).isNotEqualTo((Object)updateAppProfileRequest3.hashCode());
    }
}

