/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.admin.v2.Backup;
import com.google.bigtable.admin.v2.EncryptionInfo;
import com.google.cloud.bigtable.admin.v2.models.Backup;
import com.google.cloud.bigtable.admin.v2.models.EncryptionInfo;
import com.google.cloud.bigtable.common.Status;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import com.google.rpc.Code;
import com.google.rpc.Status;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Lists;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.ArrayList;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Instant;

@RunWith(value=JUnit4.class)
public class BackupTest {
    @Test
    public void testBackupStateEnumUpToDate() {
        ArrayList validProtoValues = Lists.newArrayList((Object[])Backup.State.values());
        ArrayList validModelValues = Lists.newArrayList((Object[])Backup.State.values());
        ArrayList actualModelValues = Lists.newArrayList();
        for (Backup.State protoValue : validProtoValues) {
            Backup.State modelValue = Backup.State.fromProto((Backup.State)protoValue);
            actualModelValues.add(modelValue);
        }
        Truth.assertThat((Iterable)actualModelValues).containsExactlyElementsIn((Iterable)validModelValues);
    }

    @Test
    public void testFromProto() {
        Timestamp expireTime = Timestamp.newBuilder().setSeconds(1234L).build();
        Timestamp startTime = Timestamp.newBuilder().setSeconds(1234L).build();
        Timestamp endTime = Timestamp.newBuilder().setSeconds(1234L).build();
        com.google.bigtable.admin.v2.Backup proto = com.google.bigtable.admin.v2.Backup.newBuilder().setName("projects/my-project/instances/instance1/clusters/cluster1/backups/backup1").setSourceTable("projects/my-project/instances/instance1/tables/table1").setExpireTime(expireTime).setStartTime(startTime).setEndTime(endTime).setSizeBytes(123456L).setState(Backup.State.READY).build();
        Backup result = Backup.fromProto((com.google.bigtable.admin.v2.Backup)proto);
        Truth.assertThat((String)result.getId()).isEqualTo((Object)"backup1");
        Truth.assertThat((String)result.getSourceTableId()).isEqualTo((Object)"table1");
        Truth.assertThat((Comparable)result.getExpireTime()).isEqualTo((Object)Instant.ofEpochMilli((long)Timestamps.toMillis((Timestamp)expireTime)));
        Truth.assertThat((Comparable)result.getStartTime()).isEqualTo((Object)Instant.ofEpochMilli((long)Timestamps.toMillis((Timestamp)startTime)));
        Truth.assertThat((Comparable)result.getEndTime()).isEqualTo((Object)Instant.ofEpochMilli((long)Timestamps.toMillis((Timestamp)endTime)));
        Truth.assertThat((Long)result.getSizeBytes()).isEqualTo((Object)123456);
        Truth.assertThat((Comparable)result.getState()).isEqualTo((Object)Backup.State.READY);
    }

    @Test
    public void testFromProtoCmek() {
        com.google.bigtable.admin.v2.Backup proto = com.google.bigtable.admin.v2.Backup.newBuilder().setName("projects/my-project/instances/instance1/clusters/cluster1/backups/backup1").setSourceTable("projects/my-project/instances/instance1/tables/table1").setExpireTime(Timestamp.newBuilder().setSeconds(1234L)).setStartTime(Timestamp.newBuilder().setSeconds(1234L)).setEndTime(Timestamp.newBuilder().setSeconds(1234L)).setSizeBytes(123456L).setState(Backup.State.READY).setEncryptionInfo(EncryptionInfo.newBuilder().setEncryptionType(EncryptionInfo.EncryptionType.CUSTOMER_MANAGED_ENCRYPTION).setKmsKeyVersion("some key version").setEncryptionStatus(Status.newBuilder().setCode(Code.OK.getNumber()).build()).build()).build();
        Backup result = Backup.fromProto((com.google.bigtable.admin.v2.Backup)proto);
        Truth.assertThat((Comparable)result.getEncryptionInfo().getType()).isEqualTo((Object)EncryptionInfo.Type.CUSTOMER_MANAGED_ENCRYPTION);
        Truth.assertThat((String)result.getEncryptionInfo().getKmsKeyVersion()).isEqualTo((Object)"some key version");
        Truth.assertThat((Comparable)result.getEncryptionInfo().getStatus().getCode()).isEqualTo((Object)Status.Code.OK);
    }

    @Test
    public void testRequiresName() {
        com.google.bigtable.admin.v2.Backup proto = com.google.bigtable.admin.v2.Backup.newBuilder().setSourceTable("projects/my-project/instances/instance1/tables/table1").setExpireTime(Timestamp.newBuilder().setSeconds(1234L).build()).setStartTime(Timestamp.newBuilder().setSeconds(123L).build()).setEndTime(Timestamp.newBuilder().setSeconds(456L).build()).setSizeBytes(123456L).setState(Backup.State.READY).build();
        Exception actualException = null;
        try {
            Backup.fromProto((com.google.bigtable.admin.v2.Backup)proto);
        }
        catch (Exception e) {
            actualException = e;
        }
        Truth.assertThat((Throwable)actualException).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testRequiresSourceTable() {
        com.google.bigtable.admin.v2.Backup proto = com.google.bigtable.admin.v2.Backup.newBuilder().setName("projects/my-project/instances/instance1/clusters/cluster1/backups/backup1").setExpireTime(Timestamp.newBuilder().setSeconds(1234L).build()).setStartTime(Timestamp.newBuilder().setSeconds(123L).build()).setEndTime(Timestamp.newBuilder().setSeconds(456L).build()).setSizeBytes(123456L).setState(Backup.State.READY).build();
        Exception actualException = null;
        try {
            Backup.fromProto((com.google.bigtable.admin.v2.Backup)proto);
        }
        catch (Exception e) {
            actualException = e;
        }
        Truth.assertThat((Throwable)actualException).isInstanceOf(IllegalArgumentException.class);
    }
}

