/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.admin.v2.Backup;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.cloud.bigtable.admin.v2.models.CreateBackupRequest;
import com.google.protobuf.util.Timestamps;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;
import org.threeten.bp.Instant;
import org.threeten.bp.temporal.TemporalAmount;

@RunWith(value=JUnit4.class)
public class CreateBackupRequestTest {
    private static final String TABLE_ID = "my-table";
    private static final String BACKUP_ID = "my-backup";
    private static final String PROJECT_ID = "my-project";
    private static final String INSTANCE_ID = "my-instance";
    private static final String CLUSTER_ID = "my-cluster";
    private static final Instant EXPIRE_TIME = Instant.now().plus((TemporalAmount)Duration.ofDays((long)15L));

    @Test
    public void testToProto() {
        CreateBackupRequest request = CreateBackupRequest.of((String)CLUSTER_ID, (String)BACKUP_ID).setSourceTableId(TABLE_ID).setExpireTime(EXPIRE_TIME);
        com.google.bigtable.admin.v2.CreateBackupRequest requestProto = com.google.bigtable.admin.v2.CreateBackupRequest.newBuilder().setBackupId(BACKUP_ID).setBackup(Backup.newBuilder().setSourceTable(NameUtil.formatTableName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID)).setExpireTime(Timestamps.fromMillis((long)EXPIRE_TIME.toEpochMilli())).build()).setParent(NameUtil.formatClusterName((String)PROJECT_ID, (String)INSTANCE_ID, (String)CLUSTER_ID)).build();
        Truth.assertThat((Object)request.toProto(PROJECT_ID, INSTANCE_ID)).isEqualTo((Object)requestProto);
    }

    @Test
    public void testEquality() {
        CreateBackupRequest request = CreateBackupRequest.of((String)CLUSTER_ID, (String)BACKUP_ID).setSourceTableId(TABLE_ID).setExpireTime(EXPIRE_TIME);
        Truth.assertThat((Object)request).isEqualTo((Object)CreateBackupRequest.of((String)CLUSTER_ID, (String)BACKUP_ID).setSourceTableId(TABLE_ID).setExpireTime(EXPIRE_TIME));
        Truth.assertThat((Object)request).isNotEqualTo((Object)CreateBackupRequest.of((String)CLUSTER_ID, (String)BACKUP_ID).setSourceTableId("another-table").setExpireTime(EXPIRE_TIME));
    }

    @Test
    public void testHashCode() {
        CreateBackupRequest request = CreateBackupRequest.of((String)CLUSTER_ID, (String)BACKUP_ID).setSourceTableId(TABLE_ID).setExpireTime(EXPIRE_TIME);
        Truth.assertThat((Integer)request.hashCode()).isEqualTo((Object)CreateBackupRequest.of((String)CLUSTER_ID, (String)BACKUP_ID).setSourceTableId(TABLE_ID).setExpireTime(EXPIRE_TIME).hashCode());
        Truth.assertThat((Integer)request.hashCode()).isNotEqualTo((Object)CreateBackupRequest.of((String)CLUSTER_ID, (String)BACKUP_ID).setSourceTableId("another-table").setExpireTime(EXPIRE_TIME).hashCode());
    }
}

