/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.admin.v2.Instance;
import com.google.cloud.bigtable.admin.v2.models.Instance;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Lists;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Map;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class InstanceTest {
    @Test
    public void testFromProto() {
        com.google.bigtable.admin.v2.Instance proto = com.google.bigtable.admin.v2.Instance.newBuilder().setName("projects/my-project/instances/my-instance").setDisplayName("my display name").setType(Instance.Type.PRODUCTION).setState(Instance.State.READY).putLabels("label1", "value1").putLabels("label2", "value2").build();
        Instance result = Instance.fromProto((com.google.bigtable.admin.v2.Instance)proto);
        Truth.assertThat((String)result.getId()).isEqualTo((Object)"my-instance");
        Truth.assertThat((String)result.getDisplayName()).isEqualTo((Object)"my display name");
        Truth.assertThat((Comparable)result.getType()).isEqualTo((Object)Instance.Type.PRODUCTION);
        Truth.assertThat((Comparable)result.getState()).isEqualTo((Object)Instance.State.READY);
        Truth.assertThat((Map)result.getLabels()).containsExactly((Object)"label1", (Object)"value1", new Object[]{"label2", "value2"});
    }

    @Test
    public void testRequiresName() {
        com.google.bigtable.admin.v2.Instance proto = com.google.bigtable.admin.v2.Instance.newBuilder().setDisplayName("my display name").setType(Instance.Type.PRODUCTION).setState(Instance.State.READY).putLabels("label1", "value1").putLabels("label2", "value2").build();
        Exception actualException = null;
        try {
            Instance.fromProto((com.google.bigtable.admin.v2.Instance)proto);
        }
        catch (Exception e) {
            actualException = e;
        }
        Truth.assertThat((Throwable)actualException).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testTypeEnumUpToDate() {
        ArrayList validProtoValues = Lists.newArrayList((Object[])Instance.Type.values());
        validProtoValues.remove(Instance.Type.TYPE_UNSPECIFIED);
        Exception actualError = null;
        try {
            Instance.Type.fromProto((Instance.Type)Instance.Type.TYPE_UNSPECIFIED);
        }
        catch (Exception e) {
            actualError = e;
        }
        Truth.assertThat((Throwable)actualError).isInstanceOf(IllegalArgumentException.class);
        ArrayList validModelValues = Lists.newArrayList((Object[])Instance.Type.values());
        ArrayList actualModelValues = Lists.newArrayList();
        for (Instance.Type protoValue : validProtoValues) {
            actualModelValues.add(Instance.Type.fromProto((Instance.Type)protoValue));
        }
        Truth.assertThat((Iterable)actualModelValues).containsExactlyElementsIn((Iterable)validModelValues);
    }

    @Test
    public void testStateEnumUpToDate() {
        ArrayList validProtoValues = Lists.newArrayList((Object[])Instance.State.values());
        ArrayList validModelValues = Lists.newArrayList((Object[])Instance.State.values());
        ArrayList actualModelValues = Lists.newArrayList();
        for (Instance.State protoValue : validProtoValues) {
            Instance.State modelValue = Instance.State.fromProto((Instance.State)protoValue);
            actualModelValues.add(modelValue);
        }
        Truth.assertThat((Iterable)actualModelValues).containsExactlyElementsIn((Iterable)validModelValues);
    }
}

