/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.cloud.bigtable.admin.v2.models.RestoreTableRequest;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RestoreTableRequestTest {
    private static final String TABLE_ID = "my-table";
    private static final String BACKUP_ID = "my-backup";
    private static final String PROJECT_ID = "my-project";
    private static final String INSTANCE_ID = "my-instance";
    private static final String CLUSTER_ID = "my-cluster";
    private static final String SOURCE_INSTANCE_ID = "source-instance-id";

    @Test
    public void testToProto() {
        RestoreTableRequest request = RestoreTableRequest.of((String)CLUSTER_ID, (String)BACKUP_ID).setTableId(TABLE_ID);
        com.google.bigtable.admin.v2.RestoreTableRequest requestProto = com.google.bigtable.admin.v2.RestoreTableRequest.newBuilder().setParent(NameUtil.formatInstanceName((String)PROJECT_ID, (String)INSTANCE_ID)).setBackup(NameUtil.formatBackupName((String)PROJECT_ID, (String)INSTANCE_ID, (String)CLUSTER_ID, (String)BACKUP_ID)).setTableId(TABLE_ID).build();
        Truth.assertThat((Object)request.toProto(PROJECT_ID, INSTANCE_ID)).isEqualTo((Object)requestProto);
    }

    @Test
    public void testToProtoCrossInstance() {
        RestoreTableRequest request = RestoreTableRequest.of((String)SOURCE_INSTANCE_ID, (String)CLUSTER_ID, (String)BACKUP_ID).setTableId(TABLE_ID);
        com.google.bigtable.admin.v2.RestoreTableRequest requestProto = com.google.bigtable.admin.v2.RestoreTableRequest.newBuilder().setParent(NameUtil.formatInstanceName((String)PROJECT_ID, (String)INSTANCE_ID)).setBackup(NameUtil.formatBackupName((String)PROJECT_ID, (String)SOURCE_INSTANCE_ID, (String)CLUSTER_ID, (String)BACKUP_ID)).setTableId(TABLE_ID).build();
        Truth.assertThat((Object)request.toProto(PROJECT_ID, INSTANCE_ID)).isEqualTo((Object)requestProto);
    }

    @Test
    public void testEquality() {
        RestoreTableRequest request = RestoreTableRequest.of((String)CLUSTER_ID, (String)BACKUP_ID).setTableId(TABLE_ID);
        Truth.assertThat((Object)request).isEqualTo((Object)RestoreTableRequest.of((String)CLUSTER_ID, (String)BACKUP_ID).setTableId(TABLE_ID));
        Truth.assertThat((Object)request).isNotEqualTo((Object)RestoreTableRequest.of((String)CLUSTER_ID, (String)BACKUP_ID).setTableId("another-table"));
    }

    @Test
    public void testEqualityCrossInstance() {
        RestoreTableRequest request = RestoreTableRequest.of((String)SOURCE_INSTANCE_ID, (String)CLUSTER_ID, (String)BACKUP_ID).setTableId(TABLE_ID);
        Truth.assertThat((Object)request).isEqualTo((Object)RestoreTableRequest.of((String)SOURCE_INSTANCE_ID, (String)CLUSTER_ID, (String)BACKUP_ID).setTableId(TABLE_ID));
        Truth.assertThat((Object)request).isNotEqualTo((Object)RestoreTableRequest.of((String)CLUSTER_ID, (String)BACKUP_ID).setTableId(TABLE_ID));
        Truth.assertThat((Object)request).isNotEqualTo((Object)RestoreTableRequest.of((String)SOURCE_INSTANCE_ID, (String)CLUSTER_ID, (String)BACKUP_ID).setTableId("another-table"));
    }

    @Test
    public void testHashCode() {
        RestoreTableRequest request = RestoreTableRequest.of((String)CLUSTER_ID, (String)BACKUP_ID).setTableId(TABLE_ID);
        Truth.assertThat((Integer)request.hashCode()).isEqualTo((Object)RestoreTableRequest.of((String)CLUSTER_ID, (String)BACKUP_ID).setTableId(TABLE_ID).hashCode());
        Truth.assertThat((Integer)request.hashCode()).isNotEqualTo((Object)RestoreTableRequest.of((String)CLUSTER_ID, (String)BACKUP_ID).setTableId("another-table").hashCode());
    }

    @Test
    public void testHashCodeCrossInstance() {
        RestoreTableRequest request = RestoreTableRequest.of((String)SOURCE_INSTANCE_ID, (String)CLUSTER_ID, (String)BACKUP_ID).setTableId(TABLE_ID);
        Truth.assertThat((Integer)request.hashCode()).isEqualTo((Object)RestoreTableRequest.of((String)SOURCE_INSTANCE_ID, (String)CLUSTER_ID, (String)BACKUP_ID).setTableId(TABLE_ID).hashCode());
        Truth.assertThat((Integer)request.hashCode()).isNotEqualTo((Object)RestoreTableRequest.of((String)CLUSTER_ID, (String)BACKUP_ID).setTableId(TABLE_ID).hashCode());
        Truth.assertThat((Integer)request.hashCode()).isNotEqualTo((Object)RestoreTableRequest.of((String)SOURCE_INSTANCE_ID, (String)CLUSTER_ID, (String)BACKUP_ID).setTableId("another-table").hashCode());
    }
}

