/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.admin.v2.ColumnFamily;
import com.google.bigtable.admin.v2.CreateTableRequest;
import com.google.bigtable.admin.v2.GcRule;
import com.google.bigtable.admin.v2.InstanceName;
import com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest;
import com.google.bigtable.admin.v2.Table;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.cloud.bigtable.admin.v2.models.CreateTableRequest;
import com.google.cloud.bigtable.admin.v2.models.GCRules;
import com.google.cloud.bigtable.admin.v2.models.ModifyColumnFamiliesRequest;
import com.google.protobuf.ByteString;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TableAdminRequestsTest {
    private final String PROJECT_ID = "project";
    private final String INSTANCE_ID = "instance";

    @Test
    public void createTable() {
        com.google.bigtable.admin.v2.CreateTableRequest actual = CreateTableRequest.of((String)"tableId").addFamily("cf1").addFamily("cf2", (GCRules.GCRule)GCRules.GCRULES.maxVersions(1)).addSplit(ByteString.copyFromUtf8((String)"c")).toProto("project", "instance");
        com.google.bigtable.admin.v2.CreateTableRequest expected = com.google.bigtable.admin.v2.CreateTableRequest.newBuilder().setTableId("tableId").setParent(InstanceName.of((String)"project", (String)"instance").toString()).addInitialSplits(CreateTableRequest.Split.newBuilder().setKey(ByteString.copyFromUtf8((String)"c"))).setTable(Table.newBuilder().putColumnFamilies("cf1", ColumnFamily.newBuilder().build()).putColumnFamilies("cf2", ColumnFamily.newBuilder().setGcRule(GCRules.GCRULES.maxVersions(1).toProto()).build())).build();
        Truth.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test(expected=NullPointerException.class)
    public void createTableRequiredTableId() {
        CreateTableRequest.of(null);
    }

    @Test(expected=NullPointerException.class)
    public void createTableRequiredParent() {
        CreateTableRequest.of((String)"tableId").toProto(null, null);
    }

    @Test
    public void modifyFamilies() {
        com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest actual = ModifyColumnFamiliesRequest.of((String)"tableId").addFamily("cf1").addFamily("cf2", (GCRules.GCRule)GCRules.GCRULES.maxVersions(1)).addFamily("cf3").updateFamily("cf1", (GCRules.GCRule)GCRules.GCRULES.maxVersions(5)).dropFamily("cf3").toProto("project", "instance");
        com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest expected = com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.newBuilder().setName(NameUtil.formatTableName((String)"project", (String)"instance", (String)"tableId")).addModifications(ModifyColumnFamiliesRequest.Modification.newBuilder().setId("cf1").setCreate(ColumnFamily.newBuilder().setGcRule(GcRule.getDefaultInstance()))).addModifications(ModifyColumnFamiliesRequest.Modification.newBuilder().setId("cf2").setCreate(ColumnFamily.newBuilder().setGcRule(GCRules.GCRULES.maxVersions(1).toProto()))).addModifications(ModifyColumnFamiliesRequest.Modification.newBuilder().setId("cf3").setCreate(ColumnFamily.newBuilder().setGcRule(GcRule.getDefaultInstance()))).addModifications(ModifyColumnFamiliesRequest.Modification.newBuilder().setId("cf1").setUpdate(ColumnFamily.newBuilder().setGcRule(GCRules.GCRULES.maxVersions(5).toProto()))).addModifications(ModifyColumnFamiliesRequest.Modification.newBuilder().setId("cf3").setDrop(true)).build();
        Truth.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test(expected=NullPointerException.class)
    public void modifyFamiliesRequiredTableId() {
        ModifyColumnFamiliesRequest.of(null).toProto("project", "instance");
    }

    @Test(expected=NullPointerException.class)
    public void modifyFamiliesRequiredParent() {
        ModifyColumnFamiliesRequest.of((String)"tableId").toProto(null, null);
    }
}

