/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.admin.v2.GcRule;
import com.google.bigtable.admin.v2.Table;
import com.google.bigtable.admin.v2.TableName;
import com.google.cloud.bigtable.admin.v2.models.ColumnFamily;
import com.google.cloud.bigtable.admin.v2.models.Table;
import com.google.protobuf.Duration;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Lists;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Map;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TableTest {
    @Test
    public void testFromProto() {
        TableName testName = TableName.of((String)"my-project", (String)"my-instance", (String)"my-table");
        com.google.bigtable.admin.v2.Table proto = com.google.bigtable.admin.v2.Table.newBuilder().setName(testName.toString()).setGranularity(Table.TimestampGranularity.MILLIS).putClusterStates("cluster1", Table.ClusterState.newBuilder().setReplicationState(Table.ClusterState.ReplicationState.READY).build()).putClusterStates("cluster2", Table.ClusterState.newBuilder().setReplicationState(Table.ClusterState.ReplicationState.INITIALIZING).build()).putColumnFamilies("cf1", com.google.bigtable.admin.v2.ColumnFamily.newBuilder().build()).putColumnFamilies("cf2", com.google.bigtable.admin.v2.ColumnFamily.newBuilder().setGcRule(GcRule.newBuilder().setMaxNumVersions(1)).build()).putColumnFamilies("cf3", com.google.bigtable.admin.v2.ColumnFamily.newBuilder().setGcRule(GcRule.newBuilder().setMaxAge(Duration.newBuilder().setSeconds(1L).setNanos(99))).build()).build();
        Table result = Table.fromProto((com.google.bigtable.admin.v2.Table)proto);
        Truth.assertThat((String)result.getInstanceId()).isEqualTo((Object)"my-instance");
        Truth.assertThat((String)result.getId()).isEqualTo((Object)"my-table");
        Truth.assertThat((Map)result.getReplicationStatesByClusterId()).containsExactly((Object)"cluster1", (Object)Table.ReplicationState.READY, new Object[]{"cluster2", Table.ReplicationState.INITIALIZING});
        Truth.assertThat((Iterable)result.getColumnFamilies()).hasSize(3);
        for (Map.Entry entry : proto.getColumnFamiliesMap().entrySet()) {
            Truth.assertThat((Iterable)result.getColumnFamilies()).contains((Object)ColumnFamily.fromProto((String)((String)entry.getKey()), (com.google.bigtable.admin.v2.ColumnFamily)((com.google.bigtable.admin.v2.ColumnFamily)entry.getValue())));
        }
    }

    @Test
    public void testReplicationStateEnumUpToDate() {
        ArrayList validProtoValues = Lists.newArrayList((Object[])Table.ClusterState.ReplicationState.values());
        ArrayList validModelValues = Lists.newArrayList((Object[])Table.ReplicationState.values());
        ArrayList actualModelValues = Lists.newArrayList();
        for (Table.ClusterState.ReplicationState protoValue : validProtoValues) {
            Table.ReplicationState modelValue = Table.ReplicationState.fromProto((Table.ClusterState.ReplicationState)protoValue);
            actualModelValues.add(modelValue);
        }
        Truth.assertThat((Iterable)actualModelValues).containsExactlyElementsIn((Iterable)validModelValues);
    }
}

