/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.admin.v2.Backup;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.cloud.bigtable.admin.v2.models.UpdateBackupRequest;
import com.google.protobuf.FieldMask;
import com.google.protobuf.util.Timestamps;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;
import org.threeten.bp.Instant;
import org.threeten.bp.temporal.TemporalAmount;

@RunWith(value=JUnit4.class)
public class UpdateBackupRequestTest {
    private static final String TABLE_ID = "my-table";
    private static final String BACKUP_ID = "my-backup";
    private static final String PROJECT_ID = "my-project";
    private static final String INSTANCE_ID = "my-instance";
    private static final String CLUSTER_ID = "my-cluster";
    private static final Instant EXPIRE_TIME = Instant.now().plus((TemporalAmount)Duration.ofDays((long)15L));
    private static final Instant EXPIRE_TIME_2 = Instant.now().plus((TemporalAmount)Duration.ofDays((long)20L));

    @Test
    public void testToProto() {
        UpdateBackupRequest request = UpdateBackupRequest.of((String)CLUSTER_ID, (String)BACKUP_ID).setExpireTime(EXPIRE_TIME);
        com.google.bigtable.admin.v2.UpdateBackupRequest requestProto = com.google.bigtable.admin.v2.UpdateBackupRequest.newBuilder().setBackup(Backup.newBuilder().setName(NameUtil.formatBackupName((String)PROJECT_ID, (String)INSTANCE_ID, (String)CLUSTER_ID, (String)BACKUP_ID)).setExpireTime(Timestamps.fromMillis((long)EXPIRE_TIME.toEpochMilli())).build()).setUpdateMask(FieldMask.newBuilder().addPaths("expire_time").build()).build();
        Truth.assertThat((Object)request.toProto(PROJECT_ID, INSTANCE_ID)).isEqualTo((Object)requestProto);
    }

    @Test
    public void testEquality() {
        UpdateBackupRequest request = UpdateBackupRequest.of((String)CLUSTER_ID, (String)BACKUP_ID).setExpireTime(EXPIRE_TIME);
        Truth.assertThat((Object)request).isEqualTo((Object)UpdateBackupRequest.of((String)CLUSTER_ID, (String)BACKUP_ID).setExpireTime(EXPIRE_TIME));
        Truth.assertThat((Object)request).isNotEqualTo((Object)UpdateBackupRequest.of((String)CLUSTER_ID, (String)BACKUP_ID).setExpireTime(EXPIRE_TIME_2));
    }

    @Test
    public void testHashCode() {
        UpdateBackupRequest request = UpdateBackupRequest.of((String)CLUSTER_ID, (String)BACKUP_ID).setExpireTime(EXPIRE_TIME);
        Truth.assertThat((Integer)request.hashCode()).isEqualTo((Object)UpdateBackupRequest.of((String)CLUSTER_ID, (String)BACKUP_ID).setExpireTime(EXPIRE_TIME).hashCode());
        Truth.assertThat((Integer)request.hashCode()).isNotEqualTo((Object)UpdateBackupRequest.of((String)CLUSTER_ID, (String)BACKUP_ID).setExpireTime(EXPIRE_TIME_2).hashCode());
    }
}

