/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.admin.v2.Instance;
import com.google.bigtable.admin.v2.PartialUpdateInstanceRequest;
import com.google.cloud.bigtable.admin.v2.models.UpdateInstanceRequest;
import com.google.protobuf.FieldMask;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableMap;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.Map;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class UpdateInstanceRequestTest {
    @Test
    public void testEmpty() {
        UpdateInstanceRequest input = UpdateInstanceRequest.of((String)"my-instance");
        Exception actualError = null;
        try {
            input.toProto("my-project");
        }
        catch (Exception e) {
            actualError = e;
        }
        Truth.assertThat((Throwable)actualError).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void testDisplayName() {
        UpdateInstanceRequest input = UpdateInstanceRequest.of((String)"my-instance").setDisplayName("my display name");
        PartialUpdateInstanceRequest actual = input.toProto("my-project");
        PartialUpdateInstanceRequest expected = PartialUpdateInstanceRequest.newBuilder().setUpdateMask(FieldMask.newBuilder().addPaths("display_name")).setInstance(Instance.newBuilder().setName("projects/my-project/instances/my-instance").setDisplayName("my display name")).build();
        Truth.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    public void testLabels() {
        UpdateInstanceRequest input = UpdateInstanceRequest.of((String)"my-instance").setAllLabels((Map)ImmutableMap.of((Object)"label1", (Object)"value1", (Object)"label2", (Object)"value2"));
        PartialUpdateInstanceRequest actual = input.toProto("my-project");
        PartialUpdateInstanceRequest expected = PartialUpdateInstanceRequest.newBuilder().setUpdateMask(FieldMask.newBuilder().addPaths("labels")).setInstance(Instance.newBuilder().setName("projects/my-project/instances/my-instance").putLabels("label1", "value1").putLabels("label2", "value2")).build();
        Truth.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    public void testType() {
        UpdateInstanceRequest input = UpdateInstanceRequest.of((String)"my-instance").setProductionType();
        PartialUpdateInstanceRequest actual = input.toProto("my-project");
        PartialUpdateInstanceRequest expected = PartialUpdateInstanceRequest.newBuilder().setUpdateMask(FieldMask.newBuilder().addPaths("type")).setInstance(Instance.newBuilder().setName("projects/my-project/instances/my-instance").setType(Instance.Type.PRODUCTION)).build();
        Truth.assertThat((Object)actual).isEqualTo((Object)expected);
    }
}

