/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.stub;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.retrying.PollException;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.rpc.testing.FakeApiException;
import com.google.api.gax.rpc.testing.FakeCallContext;
import com.google.bigtable.admin.v2.CheckConsistencyRequest;
import com.google.bigtable.admin.v2.CheckConsistencyResponse;
import com.google.bigtable.admin.v2.GenerateConsistencyTokenRequest;
import com.google.bigtable.admin.v2.GenerateConsistencyTokenResponse;
import com.google.bigtable.admin.v2.TableName;
import com.google.cloud.bigtable.admin.v2.stub.AwaitReplicationCallable;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class AwaitReplicationCallableTest {
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule().strictness(Strictness.WARN);
    private static final TableName TABLE_NAME = TableName.of((String)"my-project", (String)"my-instance", (String)"my-table");
    private static final ApiCallContext CALL_CONTEXT = FakeCallContext.createDefault();
    @Mock
    private UnaryCallable<GenerateConsistencyTokenRequest, GenerateConsistencyTokenResponse> mockGenerateConsistencyTokenCallable;
    @Mock
    private UnaryCallable<CheckConsistencyRequest, CheckConsistencyResponse> mockCheckConsistencyCallable;
    private AwaitReplicationCallable callable;

    @Before
    public void setUp() {
        ClientContext clientContext = ClientContext.newBuilder().setDefaultCallContext(CALL_CONTEXT).build();
        RetrySettings retrySettings = RetrySettings.newBuilder().setTotalTimeout(Duration.ofMillis((long)100L)).setInitialRetryDelay(Duration.ofMillis((long)1L)).setMaxRetryDelay(Duration.ofMillis((long)1L)).setRetryDelayMultiplier(1.0).setInitialRpcTimeout(Duration.ofSeconds((long)1L)).setMaxRpcTimeout(Duration.ofSeconds((long)1L)).setRpcTimeoutMultiplier(1.0).build();
        this.callable = AwaitReplicationCallable.create(this.mockGenerateConsistencyTokenCallable, this.mockCheckConsistencyCallable, (ClientContext)clientContext, (RetrySettings)retrySettings);
    }

    @Test
    public void testGenerateFailure() throws Exception {
        GenerateConsistencyTokenRequest expectedRequest = GenerateConsistencyTokenRequest.newBuilder().setName(TABLE_NAME.toString()).build();
        FakeApiException fakeError = new FakeApiException("fake", null, StatusCode.Code.INTERNAL, false);
        Mockito.when((Object)this.mockGenerateConsistencyTokenCallable.futureCall((Object)expectedRequest, CALL_CONTEXT)).thenReturn((Object)ApiFutures.immediateFailedFuture((Throwable)fakeError));
        ApiFuture future = this.callable.futureCall(TABLE_NAME, CALL_CONTEXT);
        Throwable actualError = null;
        try {
            future.get();
        }
        catch (ExecutionException e) {
            actualError = e.getCause();
        }
        Truth.assertThat((Throwable)actualError).isSameInstanceAs((Object)fakeError);
    }

    @Test
    public void testCheckFailure() throws Exception {
        GenerateConsistencyTokenRequest expectedRequest = GenerateConsistencyTokenRequest.newBuilder().setName(TABLE_NAME.toString()).build();
        GenerateConsistencyTokenResponse expectedResponse = GenerateConsistencyTokenResponse.newBuilder().setConsistencyToken("fake-token").build();
        Mockito.when((Object)this.mockGenerateConsistencyTokenCallable.futureCall((Object)expectedRequest, CALL_CONTEXT)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse));
        CheckConsistencyRequest expectedRequest2 = CheckConsistencyRequest.newBuilder().setName(TABLE_NAME.toString()).setConsistencyToken("fake-token").build();
        FakeApiException expectedError = new FakeApiException("fake", null, StatusCode.Code.INTERNAL, false);
        Mockito.when((Object)this.mockCheckConsistencyCallable.futureCall((Object)expectedRequest2, CALL_CONTEXT)).thenReturn((Object)ApiFutures.immediateFailedFuture((Throwable)expectedError));
        ApiFuture future = this.callable.futureCall(TABLE_NAME, CALL_CONTEXT);
        Throwable actualError = null;
        try {
            future.get();
        }
        catch (ExecutionException e) {
            actualError = e.getCause();
        }
        Truth.assertThat((Throwable)actualError).isSameInstanceAs((Object)expectedError);
    }

    @Test
    public void testImmediatelyConsistent() throws Exception {
        GenerateConsistencyTokenRequest expectedRequest = GenerateConsistencyTokenRequest.newBuilder().setName(TABLE_NAME.toString()).build();
        GenerateConsistencyTokenResponse expectedResponse = GenerateConsistencyTokenResponse.newBuilder().setConsistencyToken("fake-token").build();
        Mockito.when((Object)this.mockGenerateConsistencyTokenCallable.futureCall((Object)expectedRequest, CALL_CONTEXT)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse));
        CheckConsistencyRequest expectedRequest2 = CheckConsistencyRequest.newBuilder().setName(TABLE_NAME.toString()).setConsistencyToken("fake-token").build();
        CheckConsistencyResponse expectedResponse2 = CheckConsistencyResponse.newBuilder().setConsistent(true).build();
        Mockito.when((Object)this.mockCheckConsistencyCallable.futureCall((Object)expectedRequest2, CALL_CONTEXT)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse2));
        ApiFuture consistentFuture = this.callable.futureCall(TABLE_NAME, CALL_CONTEXT);
        consistentFuture.get(1L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testPolling() throws Exception {
        GenerateConsistencyTokenRequest expectedRequest = GenerateConsistencyTokenRequest.newBuilder().setName(TABLE_NAME.toString()).build();
        GenerateConsistencyTokenResponse expectedResponse = GenerateConsistencyTokenResponse.newBuilder().setConsistencyToken("fake-token").build();
        Mockito.when((Object)this.mockGenerateConsistencyTokenCallable.futureCall((Object)expectedRequest, CALL_CONTEXT)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse));
        CheckConsistencyRequest expectedRequest2 = CheckConsistencyRequest.newBuilder().setName(TABLE_NAME.toString()).setConsistencyToken("fake-token").build();
        CheckConsistencyResponse expectedResponse2 = CheckConsistencyResponse.newBuilder().setConsistent(false).build();
        CheckConsistencyResponse expectedResponse3 = CheckConsistencyResponse.newBuilder().setConsistent(true).build();
        Mockito.when((Object)this.mockCheckConsistencyCallable.futureCall((Object)expectedRequest2, CALL_CONTEXT)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse2)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse3));
        ApiFuture consistentFuture = this.callable.futureCall(TABLE_NAME, CALL_CONTEXT);
        consistentFuture.get(1L, TimeUnit.SECONDS);
    }

    @Test
    public void testPollingTimeout() throws Exception {
        GenerateConsistencyTokenRequest expectedRequest = GenerateConsistencyTokenRequest.newBuilder().setName(TABLE_NAME.toString()).build();
        GenerateConsistencyTokenResponse expectedResponse = GenerateConsistencyTokenResponse.newBuilder().setConsistencyToken("fake-token").build();
        Mockito.when((Object)this.mockGenerateConsistencyTokenCallable.futureCall((Object)expectedRequest, CALL_CONTEXT)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse));
        CheckConsistencyRequest expectedRequest2 = CheckConsistencyRequest.newBuilder().setName(TABLE_NAME.toString()).setConsistencyToken("fake-token").build();
        CheckConsistencyResponse expectedResponse2 = CheckConsistencyResponse.newBuilder().setConsistent(false).build();
        Mockito.when((Object)this.mockCheckConsistencyCallable.futureCall((Object)expectedRequest2, CALL_CONTEXT)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse2));
        ApiFuture consistentFuture = this.callable.futureCall(TABLE_NAME, CALL_CONTEXT);
        Throwable actualError = null;
        try {
            consistentFuture.get(1L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            actualError = e.getCause();
        }
        Truth.assertThat((Throwable)actualError).isInstanceOf(PollException.class);
    }
}

