/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.common;

import com.google.cloud.bigtable.common.Status;
import com.google.rpc.Code;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class StatusTest {
    @Test
    public void testAllCodes() {
        for (Code protoValue : Code.values()) {
            Status.Code modelValue = Status.Code.fromProto((Code)protoValue);
            Truth.assertWithMessage((String)"proto enum value %s should be wrapped", (Object[])new Object[]{protoValue.toString()}).that(modelValue.toString()).isEqualTo((Object)protoValue.toString());
        }
        com.google.rpc.Status randomProto = com.google.rpc.Status.newBuilder().setCode(49).setMessage("some message").build();
        Truth.assertWithMessage((String)"Unrecognized proto value should be wrapped").that((Comparable)Status.Code.fromProto((Code)Code.forNumber((int)randomProto.getCode()))).isEqualTo((Object)Status.Code.UNRECOGNIZED);
    }

    @Test
    public void testAllCodeNumbers() {
        for (Code protoValue : Code.values()) {
            if (protoValue == Code.UNRECOGNIZED) continue;
            Status.Code modelValue = Status.Code.fromCodeNumber((int)protoValue.getNumber());
            Truth.assertWithMessage((String)"proto enum value %s should be wrapped", (Object[])new Object[]{protoValue.toString()}).that(modelValue.toString()).isEqualTo((Object)protoValue.toString());
        }
        Truth.assertWithMessage((String)"Unrecognized proto enum value should be wrapped").that((Comparable)Status.Code.fromCodeNumber((int)-1)).isEqualTo((Object)Status.Code.UNRECOGNIZED);
    }

    @Test
    public void testFromProto() {
        com.google.rpc.Status proto = com.google.rpc.Status.newBuilder().setCode(Code.UNAVAILABLE.getNumber()).setMessage("some message").build();
        Status model = Status.fromProto((com.google.rpc.Status)proto);
        Truth.assertThat((Comparable)model.getCode()).isEqualTo((Object)Status.Code.UNAVAILABLE);
        Truth.assertThat((String)model.getMessage()).isEqualTo((Object)"some message");
    }

    @Test
    public void testToProto() {
        Code code = Code.UNAVAILABLE;
        com.google.rpc.Status proto = com.google.rpc.Status.newBuilder().setCode(code.getNumber()).setMessage("some message").build();
        Status model = Status.fromProto((com.google.rpc.Status)proto);
        Truth.assertThat((Comparable)model.getCode().toProto()).isEqualTo((Object)code);
        Truth.assertThat((Object)model.toProto()).isEqualTo((Object)proto);
        Truth.assertThat((String)model.toString()).isEqualTo((Object)proto.toString());
    }
}

