/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.batching.Batcher;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStub;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableList;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class BigtableDataClientTests {
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule().strictness(Strictness.WARN);
    @Mock
    private EnhancedBigtableStub mockStub;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ServerStreamingCallable<Query, Row> mockReadRowsCallable;
    @Mock
    private UnaryCallable<Query, Row> mockReadRowCallable;
    @Mock
    private UnaryCallable<String, List<KeyOffset>> mockSampleRowKeysCallable;
    @Mock
    private UnaryCallable<RowMutation, Void> mockMutateRowCallable;
    @Mock
    private UnaryCallable<ConditionalRowMutation, Boolean> mockCheckAndMutateRowCallable;
    @Mock
    private UnaryCallable<ReadModifyWriteRow, Row> mockReadModifyWriteRowCallable;
    @Mock
    private UnaryCallable<BulkMutation, Void> mockBulkMutateRowsCallable;
    @Mock
    private Batcher<RowMutationEntry, Void> mockBulkMutationBatcher;
    @Mock
    private Batcher<ByteString, Row> mockBulkReadRowsBatcher;
    private BigtableDataClient bigtableDataClient;

    @Before
    public void setUp() {
        this.bigtableDataClient = new BigtableDataClient(this.mockStub);
    }

    @Test
    public void proxyCloseTest() {
        this.bigtableDataClient.close();
        ((EnhancedBigtableStub)Mockito.verify((Object)this.mockStub)).close();
    }

    @Test
    public void existsTest() {
        Mockito.when((Object)this.mockStub.readRowCallable()).thenReturn(this.mockReadRowCallable);
        Query expectedQuery = Query.create((String)"fake-table").rowKey("fake-row-key").filter((Filters.Filter)Filters.FILTERS.chain().filter(Filters.FILTERS.limit().cellsPerRow(1)).filter(Filters.FILTERS.value().strip()));
        Row row = Row.create((ByteString)ByteString.copyFromUtf8((String)"fake-row-key"), (List)ImmutableList.of());
        Mockito.when((Object)this.mockReadRowCallable.futureCall((Object)expectedQuery)).thenReturn((Object)ApiFutures.immediateFuture((Object)row)).thenReturn((Object)ApiFutures.immediateFuture(null));
        boolean result = this.bigtableDataClient.exists("fake-table", "fake-row-key");
        boolean anotherResult = this.bigtableDataClient.exists("fake-table", ByteString.copyFromUtf8((String)"fake-row-key"));
        Truth.assertThat((Boolean)result).isTrue();
        Truth.assertThat((Boolean)anotherResult).isFalse();
        ((UnaryCallable)Mockito.verify(this.mockReadRowCallable, (VerificationMode)Mockito.times((int)2))).futureCall((Object)expectedQuery);
    }

    @Test
    public void existsAsyncTest() throws Exception {
        Mockito.when((Object)this.mockStub.readRowCallable()).thenReturn(this.mockReadRowCallable);
        Query expectedQuery = Query.create((String)"fake-table").rowKey("fake-row-key").filter((Filters.Filter)Filters.FILTERS.chain().filter(Filters.FILTERS.limit().cellsPerRow(1)).filter(Filters.FILTERS.value().strip()));
        Row row = Row.create((ByteString)ByteString.copyFromUtf8((String)"fake-row-key"), (List)ImmutableList.of());
        Mockito.when((Object)this.mockReadRowCallable.futureCall((Object)expectedQuery)).thenReturn((Object)ApiFutures.immediateFuture((Object)row)).thenReturn((Object)ApiFutures.immediateFuture(null));
        ApiFuture result = this.bigtableDataClient.existsAsync("fake-table", ByteString.copyFromUtf8((String)"fake-row-key"));
        Truth.assertThat((Boolean)((Boolean)result.get())).isTrue();
        ApiFuture anotherResult = this.bigtableDataClient.existsAsync("fake-table", "fake-row-key");
        Truth.assertThat((Boolean)((Boolean)anotherResult.get())).isFalse();
        ((UnaryCallable)Mockito.verify(this.mockReadRowCallable, (VerificationMode)Mockito.times((int)2))).futureCall((Object)expectedQuery);
    }

    @Test
    public void proxyReadRowsCallableTest() {
        Mockito.when((Object)this.mockStub.readRowsCallable()).thenReturn(this.mockReadRowsCallable);
        Truth.assertThat((Object)this.bigtableDataClient.readRowsCallable()).isSameInstanceAs(this.mockReadRowsCallable);
    }

    @Test
    public void proxyReadRowAsyncTest() {
        Mockito.when((Object)this.mockStub.readRowCallable()).thenReturn(this.mockReadRowCallable);
        this.bigtableDataClient.readRowAsync("fake-table", ByteString.copyFromUtf8((String)"fake-row-key"));
        ((UnaryCallable)Mockito.verify(this.mockReadRowCallable)).futureCall((Object)Query.create((String)"fake-table").rowKey("fake-row-key"));
    }

    @Test
    public void proxyReadRowStrAsyncTest() {
        Mockito.when((Object)this.mockStub.readRowCallable()).thenReturn(this.mockReadRowCallable);
        this.bigtableDataClient.readRowAsync("fake-table", "fake-row-key");
        ((UnaryCallable)Mockito.verify(this.mockReadRowCallable)).futureCall((Object)Query.create((String)"fake-table").rowKey("fake-row-key"));
    }

    @Test
    public void readRowFilterAsyncTest() {
        Mockito.when((Object)this.mockStub.readRowCallable()).thenReturn(this.mockReadRowCallable);
        Filters.ChainFilter filter = Filters.FILTERS.chain().filter(Filters.FILTERS.qualifier().regex("prefix.*")).filter(Filters.FILTERS.limit().cellsPerRow(10));
        this.bigtableDataClient.readRowAsync("fake-table", ByteString.copyFromUtf8((String)"fake-row-key"), (Filters.Filter)filter);
        ((UnaryCallable)Mockito.verify(this.mockReadRowCallable)).futureCall((Object)Query.create((String)"fake-table").rowKey("fake-row-key").filter((Filters.Filter)filter));
    }

    @Test
    public void readRowFilterStrAsyncTest() {
        Mockito.when((Object)this.mockStub.readRowCallable()).thenReturn(this.mockReadRowCallable);
        Filters.ChainFilter filter = Filters.FILTERS.chain().filter(Filters.FILTERS.qualifier().regex("prefix.*")).filter(Filters.FILTERS.limit().cellsPerRow(10));
        this.bigtableDataClient.readRowAsync("fake-table", "fake-row-key", (Filters.Filter)filter);
        ((UnaryCallable)Mockito.verify(this.mockReadRowCallable)).futureCall((Object)Query.create((String)"fake-table").rowKey("fake-row-key").filter((Filters.Filter)filter));
    }

    @Test
    public void readRowTest() {
        Mockito.when((Object)this.mockStub.readRowCallable()).thenReturn(this.mockReadRowCallable);
        Row expectedRow = Row.create((ByteString)ByteString.copyFromUtf8((String)"fake-row-key"), (List)ImmutableList.of());
        Mockito.when((Object)this.mockReadRowCallable.futureCall((Object)Query.create((String)"fake-table").rowKey("fake-row-key"))).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedRow));
        Row actualRow = this.bigtableDataClient.readRow("fake-table", ByteString.copyFromUtf8((String)"fake-row-key"));
        Truth.assertThat((Object)actualRow).isEqualTo((Object)expectedRow);
    }

    @Test
    public void readRowStrTest() {
        Mockito.when((Object)this.mockStub.readRowCallable()).thenReturn(this.mockReadRowCallable);
        Row expectedRow = Row.create((ByteString)ByteString.copyFromUtf8((String)"fake-row-key"), (List)ImmutableList.of());
        Mockito.when((Object)this.mockReadRowCallable.futureCall((Object)Query.create((String)"fake-table").rowKey("fake-row-key"))).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedRow));
        Row actualRow = this.bigtableDataClient.readRow("fake-table", "fake-row-key");
        Truth.assertThat((Object)actualRow).isEqualTo((Object)expectedRow);
    }

    @Test
    public void readRowFilterTest() {
        Mockito.when((Object)this.mockStub.readRowCallable()).thenReturn(this.mockReadRowCallable);
        Filters.ChainFilter filter = Filters.FILTERS.chain().filter(Filters.FILTERS.qualifier().regex("prefix.*")).filter(Filters.FILTERS.limit().cellsPerRow(10));
        Row expectedRow = Row.create((ByteString)ByteString.copyFromUtf8((String)"fake-row-key"), (List)ImmutableList.of());
        Mockito.when((Object)this.mockReadRowCallable.futureCall((Object)Query.create((String)"fake-table").rowKey("fake-row-key").filter((Filters.Filter)filter))).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedRow));
        Row actualRow = this.bigtableDataClient.readRow("fake-table", ByteString.copyFromUtf8((String)"fake-row-key"), (Filters.Filter)filter);
        Truth.assertThat((Object)actualRow).isEqualTo((Object)expectedRow);
    }

    @Test
    public void readRowStrFilterTest() {
        Mockito.when((Object)this.mockStub.readRowCallable()).thenReturn(this.mockReadRowCallable);
        Filters.ChainFilter filter = Filters.FILTERS.chain().filter(Filters.FILTERS.qualifier().regex("prefix.*")).filter(Filters.FILTERS.limit().cellsPerRow(10));
        Row expectedRow = Row.create((ByteString)ByteString.copyFromUtf8((String)"fake-row-key"), (List)ImmutableList.of());
        Mockito.when((Object)this.mockReadRowCallable.futureCall((Object)Query.create((String)"fake-table").rowKey("fake-row-key").filter((Filters.Filter)filter))).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedRow));
        Row actualRow = this.bigtableDataClient.readRow("fake-table", "fake-row-key", (Filters.Filter)filter);
        Truth.assertThat((Object)actualRow).isEqualTo((Object)expectedRow);
    }

    @Test
    public void proxyReadRowsSyncTest() {
        Mockito.when((Object)this.mockStub.readRowsCallable()).thenReturn(this.mockReadRowsCallable);
        Query query = Query.create((String)"fake-table");
        this.bigtableDataClient.readRows(query);
        ((ServerStreamingCallable)Mockito.verify(this.mockReadRowsCallable)).call((Object)query);
    }

    @Test
    public void proxyReadRowsAsyncTest() {
        Mockito.when((Object)this.mockStub.readRowsCallable()).thenReturn(this.mockReadRowsCallable);
        Query query = Query.create((String)"fake-table");
        ResponseObserver mockObserver = (ResponseObserver)Mockito.mock(ResponseObserver.class);
        this.bigtableDataClient.readRowsAsync(query, mockObserver);
        ((ServerStreamingCallable)Mockito.verify(this.mockReadRowsCallable)).call((Object)query, mockObserver);
    }

    @Test
    public void proxySampleRowKeysCallableTest() {
        Mockito.when((Object)this.mockStub.sampleRowKeysCallable()).thenReturn(this.mockSampleRowKeysCallable);
        Truth.assertThat((Object)this.bigtableDataClient.sampleRowKeysCallable()).isSameInstanceAs(this.mockSampleRowKeysCallable);
    }

    @Test
    public void proxySampleRowKeysTest() {
        Mockito.when((Object)this.mockStub.sampleRowKeysCallable()).thenReturn(this.mockSampleRowKeysCallable);
        this.bigtableDataClient.sampleRowKeysAsync("fake-table");
        ((UnaryCallable)Mockito.verify(this.mockSampleRowKeysCallable)).futureCall((Object)"fake-table");
    }

    @Test
    public void sampleRowKeysTest() {
        Mockito.when((Object)this.mockStub.sampleRowKeysCallable()).thenReturn(this.mockSampleRowKeysCallable);
        Mockito.when((Object)this.mockSampleRowKeysCallable.futureCall(ArgumentMatchers.any(String.class))).thenReturn((Object)ApiFutures.immediateFuture(Collections.emptyList()));
        this.bigtableDataClient.sampleRowKeys("fake-table");
        ((UnaryCallable)Mockito.verify(this.mockSampleRowKeysCallable)).futureCall((Object)"fake-table");
    }

    @Test
    public void proxyMutateRowCallableTest() {
        Mockito.when((Object)this.mockStub.mutateRowCallable()).thenReturn(this.mockMutateRowCallable);
        Truth.assertThat((Object)this.bigtableDataClient.mutateRowCallable()).isSameInstanceAs(this.mockMutateRowCallable);
    }

    @Test
    public void proxyMutateRowTest() {
        Mockito.when((Object)this.mockStub.mutateRowCallable()).thenReturn(this.mockMutateRowCallable);
        RowMutation request = RowMutation.create((String)"fake-table", (String)"some-key").setCell("some-family", "fake-qualifier", "fake-value");
        this.bigtableDataClient.mutateRowAsync(request);
        ((UnaryCallable)Mockito.verify(this.mockMutateRowCallable)).futureCall((Object)request);
    }

    @Test
    public void mutateRowTest() {
        Mockito.when((Object)this.mockStub.mutateRowCallable()).thenReturn(this.mockMutateRowCallable);
        Mockito.when((Object)this.mockMutateRowCallable.futureCall(ArgumentMatchers.any(RowMutation.class))).thenAnswer(invocationOnMock -> ApiFutures.immediateFuture((Object)Empty.getDefaultInstance()));
        RowMutation request = RowMutation.create((String)"fake-table", (String)"some-key").setCell("some-family", "fake-qualifier", "fake-value");
        this.bigtableDataClient.mutateRow(request);
        ((UnaryCallable)Mockito.verify(this.mockMutateRowCallable)).futureCall((Object)request);
    }

    @Test
    public void proxyBulkMutatesRowTest() {
        Mockito.when((Object)this.mockStub.bulkMutateRowsCallable()).thenReturn(this.mockBulkMutateRowsCallable);
        BulkMutation request = BulkMutation.create((String)"fake-table").add("fake-key", Mutation.create().setCell("fake-family", "fake-qualifier", "fake-value"));
        this.bigtableDataClient.bulkMutateRowsAsync(request);
        ((UnaryCallable)Mockito.verify(this.mockBulkMutateRowsCallable)).futureCall((Object)request);
    }

    @Test
    public void bulkMutatesRowTest() {
        Mockito.when((Object)this.mockStub.bulkMutateRowsCallable()).thenReturn(this.mockBulkMutateRowsCallable);
        Mockito.when((Object)this.mockBulkMutateRowsCallable.futureCall(ArgumentMatchers.any(BulkMutation.class))).thenAnswer(invocationOnMock -> ApiFutures.immediateFuture((Object)Empty.getDefaultInstance()));
        BulkMutation request = BulkMutation.create((String)"fake-table").add("fake-key", Mutation.create().setCell("fake-family", "fake-qualifier", "fake-value"));
        this.bigtableDataClient.bulkMutateRows(request);
        ((UnaryCallable)Mockito.verify(this.mockBulkMutateRowsCallable)).futureCall((Object)request);
    }

    @Test
    public void proxyNewBulkMutationBatcherTest() {
        Mockito.when((Object)this.mockStub.newMutateRowsBatcher((String)Mockito.any(String.class), (GrpcCallContext)Mockito.any())).thenReturn(this.mockBulkMutationBatcher);
        ApiFuture expectedResponse = ApiFutures.immediateFuture(null);
        Batcher batcher = this.bigtableDataClient.newBulkMutationBatcher("fake-table");
        RowMutationEntry request = RowMutationEntry.create((String)"some-key").setCell("some-family", "fake-qualifier", "fake-value");
        Mockito.when((Object)this.mockBulkMutationBatcher.add((Object)request)).thenReturn((Object)expectedResponse);
        ApiFuture actualRes = batcher.add((Object)request);
        Truth.assertThat((Object)actualRes).isSameInstanceAs((Object)expectedResponse);
        ((EnhancedBigtableStub)Mockito.verify((Object)this.mockStub)).newMutateRowsBatcher((String)Mockito.any(String.class), (GrpcCallContext)Mockito.any());
    }

    @Test
    public void proxyNewBulkReadRowsTest() {
        Mockito.when((Object)this.mockStub.newBulkReadRowsBatcher((Query)Mockito.any(Query.class), (GrpcCallContext)Mockito.any())).thenReturn(this.mockBulkReadRowsBatcher);
        ApiFuture expectedResponse = ApiFutures.immediateFuture((Object)Row.create((ByteString)ByteString.copyFromUtf8((String)"fake-row-key"), Collections.emptyList()));
        ByteString request = ByteString.copyFromUtf8((String)"fake-row-key");
        Batcher batcher = this.bigtableDataClient.newBulkReadRowsBatcher("fake-table");
        Mockito.when((Object)this.mockBulkReadRowsBatcher.add((Object)request)).thenReturn((Object)expectedResponse);
        ApiFuture actualResponse = batcher.add((Object)request);
        Truth.assertThat((Object)actualResponse).isSameInstanceAs((Object)expectedResponse);
        ((EnhancedBigtableStub)Mockito.verify((Object)this.mockStub)).newBulkReadRowsBatcher((Query)Mockito.any(Query.class), (GrpcCallContext)Mockito.any());
    }

    @Test
    public void proxyNewBulkReadRowsWithFilterTest() {
        Mockito.when((Object)this.mockStub.newBulkReadRowsBatcher((Query)Mockito.any(Query.class), (GrpcCallContext)Mockito.any())).thenReturn(this.mockBulkReadRowsBatcher);
        ApiFuture expectedResponse = ApiFutures.immediateFuture((Object)Row.create((ByteString)ByteString.copyFromUtf8((String)"fake-row-key"), Collections.emptyList()));
        ByteString request = ByteString.copyFromUtf8((String)"fake-row-key");
        Batcher batcher = this.bigtableDataClient.newBulkReadRowsBatcher("fake-table", Filters.FILTERS.key().regex("fake-row"));
        Mockito.when((Object)this.mockBulkReadRowsBatcher.add((Object)request)).thenReturn((Object)expectedResponse);
        ApiFuture actualResponse = batcher.add((Object)request);
        Truth.assertThat((Object)actualResponse).isSameInstanceAs((Object)expectedResponse);
        ((EnhancedBigtableStub)Mockito.verify((Object)this.mockStub)).newBulkReadRowsBatcher((Query)Mockito.any(Query.class), (GrpcCallContext)Mockito.any());
    }

    @Test
    public void proxyCheckAndMutateRowCallableTest() {
        Truth.assertThat((Object)this.bigtableDataClient.checkAndMutateRowCallable()).isSameInstanceAs((Object)this.mockStub.checkAndMutateRowCallable());
    }

    @Test
    public void proxyCheckAndMutateRowTest() {
        Mockito.when((Object)this.mockStub.checkAndMutateRowCallable()).thenReturn(this.mockCheckAndMutateRowCallable);
        ConditionalRowMutation mutation = ConditionalRowMutation.create((String)"fake-table", (String)"fake-key").then(Mutation.create().setCell("fake-family", "fake-qualifier", "fake-value"));
        this.bigtableDataClient.checkAndMutateRowAsync(mutation);
        ((UnaryCallable)Mockito.verify(this.mockCheckAndMutateRowCallable)).futureCall((Object)mutation);
    }

    @Test
    public void checkAndMutateRowTest() {
        Mockito.when((Object)this.mockStub.checkAndMutateRowCallable()).thenReturn(this.mockCheckAndMutateRowCallable);
        Mockito.when((Object)this.mockCheckAndMutateRowCallable.futureCall(ArgumentMatchers.any(ConditionalRowMutation.class))).thenReturn((Object)ApiFutures.immediateFuture((Object)Boolean.TRUE));
        ConditionalRowMutation mutation = ConditionalRowMutation.create((String)"fake-table", (String)"fake-key").then(Mutation.create().setCell("fake-family", "fake-qualifier", "fake-value"));
        this.bigtableDataClient.checkAndMutateRow(mutation);
        ((UnaryCallable)Mockito.verify(this.mockCheckAndMutateRowCallable)).futureCall((Object)mutation);
    }

    @Test
    public void proxyReadModifyWriteRowTest() {
        Mockito.when((Object)this.mockStub.readModifyWriteRowCallable()).thenReturn(this.mockReadModifyWriteRowCallable);
        ReadModifyWriteRow request = ReadModifyWriteRow.create((String)"fake-table", (String)"some-key").append("fake-family", "fake-qualifier", "suffix");
        this.bigtableDataClient.readModifyWriteRowAsync(request);
        ((UnaryCallable)Mockito.verify(this.mockReadModifyWriteRowCallable)).futureCall((Object)request);
    }

    @Test
    public void readModifyWriteRowTest() {
        Mockito.when((Object)this.mockStub.readModifyWriteRowCallable()).thenReturn(this.mockReadModifyWriteRowCallable);
        Mockito.when((Object)this.mockReadModifyWriteRowCallable.futureCall(ArgumentMatchers.any(ReadModifyWriteRow.class))).thenReturn((Object)ApiFutures.immediateFuture((Object)Row.create((ByteString)ByteString.copyFromUtf8((String)"fake-row-key"), Collections.emptyList())));
        ReadModifyWriteRow request = ReadModifyWriteRow.create((String)"fake-table", (String)"some-key").append("fake-family", "fake-qualifier", "suffix");
        this.bigtableDataClient.readModifyWriteRow(request);
        ((UnaryCallable)Mockito.verify(this.mockReadModifyWriteRowCallable)).futureCall((Object)request);
    }

    @Test
    public void proxyReadModifyWriterRowCallableTest() {
        Mockito.when((Object)this.mockStub.readModifyWriteRowCallable()).thenReturn(this.mockReadModifyWriteRowCallable);
        Truth.assertThat((Object)this.bigtableDataClient.readModifyWriteRowCallable()).isSameInstanceAs(this.mockReadModifyWriteRowCallable);
    }
}

