/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2;

import cz.o2.proxima.beam.io.pubsub.io.grpc.BindableService;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Server;
import cz.o2.proxima.beam.io.pubsub.io.grpc.ServerBuilder;
import cz.o2.proxima.beam.io.pubsub.io.grpc.ServerInterceptor;
import cz.o2.proxima.beam.io.pubsub.io.grpc.ServerTransportFilter;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;

public class FakeServiceBuilder {
    private final List<ServerInterceptor> interceptors = new ArrayList<ServerInterceptor>();
    private final List<BindableService> services = new ArrayList<BindableService>();
    private final List<ServerTransportFilter> transportFilters = new ArrayList<ServerTransportFilter>();

    public static FakeServiceBuilder create(BindableService ... services) {
        return new FakeServiceBuilder(services);
    }

    private FakeServiceBuilder(BindableService[] services) {
        for (BindableService service : services) {
            this.addService(service);
        }
    }

    public FakeServiceBuilder intercept(ServerInterceptor interceptor) {
        this.interceptors.add(interceptor);
        return this;
    }

    public FakeServiceBuilder addService(BindableService service) {
        this.services.add(service);
        return this;
    }

    public FakeServiceBuilder addTransportFilter(ServerTransportFilter transportFilter) {
        this.transportFilters.add(transportFilter);
        return this;
    }

    public Server start() throws IOException {
        IOException lastError = null;
        for (int i = 0; i < 10; ++i) {
            try {
                return this.startWithoutRetries();
            }
            catch (IOException e) {
                lastError = e;
                if (!(e.getCause() instanceof BindException)) break;
                continue;
            }
        }
        throw lastError;
    }

    private Server startWithoutRetries() throws IOException {
        int port;
        try (ServerSocket ss = new ServerSocket(0);){
            port = ss.getLocalPort();
        }
        ServerBuilder builder = ServerBuilder.forPort((int)port);
        this.interceptors.forEach(arg_0 -> ((ServerBuilder)builder).intercept(arg_0));
        this.services.forEach(arg_0 -> ((ServerBuilder)builder).addService(arg_0));
        this.transportFilters.forEach(arg_0 -> ((ServerBuilder)builder).addTransportFilter(arg_0));
        return builder.build().start();
    }
}

